/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.ui;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.testng.ui.Bundle;
import org.netbeans.modules.testng.ui.ClassMap;
import org.netbeans.modules.testng.ui.TestCreator;
import org.netbeans.modules.testng.ui.TestGeneratorSetup;
import org.netbeans.modules.testng.ui.TestMethodNameGenerator;
import org.netbeans.modules.testng.ui.TestNGSettings;
import org.netbeans.modules.testng.ui.TestUtil;
import org.netbeans.modules.testng.ui.TopClassFinder;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractTestGenerator
implements CancellableTask<WorkingCopy> {
    private static final String INSTANCE_VAR_NAME = "instance";
    private static final String RESULT_VAR_NAME = "result";
    private static final String EXP_RESULT_VAR_NAME = "expResult";
    private static final String ARTIFICAL_VAR_NAME_BASE = "arg";
    private static final String STUB_TEST_NAME = "testSomeMethod";
    private static final String CONTAINER_VAR_NAME = "container";
    private static final EnumSet<Modifier> NO_MODIFIERS = EnumSet.noneOf(Modifier.class);
    protected final TestGeneratorSetup setup;
    private final List<ElementHandle<TypeElement>> srcTopClassElemHandles;
    private final List<String> suiteMembers;
    private final boolean isNewTestClass;
    private List<String> processedClassNames;
    private String initialMainMethodBody;
    private volatile boolean cancelled = false;
    private Map<String, ExpressionTree> classIdentifiers;

    protected static EnumSet<Modifier> accessModifiers() {
        return EnumSet.copyOf(TestCreator.ACCESS_MODIFIERS);
    }

    protected static EnumSet<Modifier> noModifiers() {
        return EnumSet.copyOf(NO_MODIFIERS);
    }

    protected AbstractTestGenerator(TestGeneratorSetup setup) {
        this.setup = setup;
        this.srcTopClassElemHandles = null;
        this.suiteMembers = null;
        this.isNewTestClass = true;
    }

    protected AbstractTestGenerator(TestGeneratorSetup setup, List<ElementHandle<TypeElement>> srcTopClassHandles, List<String> suiteMembers, boolean isNewTestClass) {
        this.setup = setup;
        this.srcTopClassElemHandles = srcTopClassHandles;
        this.suiteMembers = suiteMembers;
        this.isNewTestClass = isNewTestClass;
    }

    public void run(WorkingCopy workingCopy) throws IOException {
        block5: {
            List srcTopClassElems;
            TreePath compUnitPath;
            List<ClassTree> tstTopClasses;
            block6: {
                block4: {
                    workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    CompilationUnitTree compUnit = workingCopy.getCompilationUnit();
                    tstTopClasses = TopClassFinder.findTopClasses(compUnit, workingCopy.getTreeUtilities());
                    compUnitPath = new TreePath(compUnit);
                    srcTopClassElems = this.resolveHandles((CompilationInfo)workingCopy, this.srcTopClassElemHandles);
                    if (srcTopClassElems == null || srcTopClassElems.isEmpty()) break block4;
                    ClassPath classPath = workingCopy.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
                    FileObject fileObject = workingCopy.getFileObject();
                    String className = classPath.getResourceName(fileObject, '.', false);
                    assert (className != null) : "Unknown class name. Test can't be generated. Bug #188060./nPlease, if possible, provide a sample project./n workingCopy=" + workingCopy + "/n workingCopy.getClasspathInfo()=" + workingCopy.getClasspathInfo() + "/n classPath=" + classPath + "/n fileObject=" + fileObject + "/n classPath.findOwnerRoot(fileObject)=" + classPath.findOwnerRoot(fileObject);
                    for (TypeElement srcTopClass : srcTopClassElems) {
                        this.createOrUpdateTestClass(srcTopClass, tstTopClasses, className, compUnitPath, workingCopy);
                    }
                    break block5;
                }
                if (this.suiteMembers == null) break block6;
                for (ClassTree tstClass : tstTopClasses) {
                    TreePath tstClassTreePath = new TreePath(compUnitPath, tstClass);
                    ClassTree origTstTopClass = tstClass;
                    this.classProcessed(tstClass);
                }
                break block5;
            }
            if (srcTopClassElems != null) break block5;
            Iterator<ClassTree> i$ = tstTopClasses.iterator();
            while (i$.hasNext()) {
                ClassTree tstClass;
                ClassTree origTstTopClass = tstClass = i$.next();
                ClassTree tstTopClass = this.generateMissingInitMembers(tstClass, new TreePath(compUnitPath, tstClass), workingCopy);
                if (tstTopClass == origTstTopClass) continue;
                workingCopy.rewrite((Tree)origTstTopClass, (Tree)tstTopClass);
            }
        }
    }

    private void createOrUpdateTestClass(TypeElement srcTopClass, List<ClassTree> tstTopClasses, String testClassName, TreePath compUnitPath, WorkingCopy workingCopy) {
        List<ExecutableElement> srcMethods = this.findTestableMethods(workingCopy, srcTopClass);
        boolean srcHasTestableMethods = !srcMethods.isEmpty();
        String testClassSimpleName = TestUtil.getSimpleName(testClassName);
        ClassTree tstTopClass = this.findClass(testClassSimpleName, tstTopClasses);
        if (tstTopClass != null) {
            TreePath tstTopClassTreePath = new TreePath(compUnitPath, tstTopClass);
            ClassTree origTstTopClass = tstTopClass;
            if (srcHasTestableMethods) {
                tstTopClass = this.generateMissingTestMethods(srcTopClass, srcMethods, tstTopClass, tstTopClassTreePath, this.isNewTestClass, workingCopy);
            } else if (this.isNewTestClass) {
                tstTopClass = this.generateMissingInitMembers(tstTopClass, tstTopClassTreePath, workingCopy);
                tstTopClass = this.generateStubTestMethod(tstTopClass, STUB_TEST_NAME, workingCopy);
            }
            if (tstTopClass != origTstTopClass) {
                workingCopy.rewrite((Tree)origTstTopClass, (Tree)tstTopClass);
            }
        } else if (srcHasTestableMethods) {
            tstTopClass = this.generateNewTestClass(workingCopy, testClassSimpleName, srcTopClass, srcMethods);
        }
    }

    private ExpressionStatementTree generateDefMethodBody(TreeMaker maker) throws MissingResourceException, IllegalStateException {
        String failMsg = Bundle.TestCreator_variantMethods_defaultFailMsg();
        MethodInvocationTree failMethodCall = maker.MethodInvocation(Collections.emptyList(), (ExpressionTree)maker.Identifier((CharSequence)"fail"), Collections.singletonList(maker.Literal((Object)failMsg)));
        ExpressionStatementTree exprStatement = maker.ExpressionStatement((ExpressionTree)failMethodCall);
        if (this.setup.isGenerateMethodBodyComment()) {
            Comment comment = Comment.create((Comment.Style)Comment.Style.LINE, (int)-2, (int)-2, (int)-2, (String)Bundle.TestCreator_variantMethods_defaultComment());
            maker.addComment((Tree)exprStatement, comment, true);
        }
        return exprStatement;
    }

    private ClassTree generateNewTestClass(WorkingCopy workingCopy, String name, TypeElement srcClass, List<ExecutableElement> srcMethods) {
        List<Tree> members;
        String instanceClassName = null;
        ClassTree abstractClassImpl = null;
        if (srcClass.getModifiers().contains((Object)Modifier.ABSTRACT) && AbstractTestGenerator.hasInstanceMethods(srcMethods)) {
            instanceClassName = AbstractTestGenerator.getAbstractClassImplName(srcClass.getSimpleName());
            abstractClassImpl = this.generateAbstractClassImpl(srcClass, instanceClassName, workingCopy);
        }
        List<MethodTree> testMethods = this.generateTestMethods(srcClass, instanceClassName, srcMethods, workingCopy);
        if (abstractClassImpl == null) {
            members = testMethods;
        } else if (testMethods.isEmpty()) {
            members = Collections.singletonList(abstractClassImpl);
        } else {
            members = new ArrayList<MethodTree>(testMethods.size() + 1);
            members.addAll(testMethods);
            members.add(abstractClassImpl);
        }
        return this.composeNewTestClass(workingCopy, name, members);
    }

    private ClassTree generateAbstractClassImpl(TypeElement srcClass, CharSequence name, WorkingCopy workingCopy) {
        List<Object> members;
        List<ExecutableElement> methods;
        List<ExecutableElement> abstractMethods;
        int membersCount = 0;
        MethodTree constructor = AbstractTestGenerator.generateAbstractClassImplCtor(srcClass, workingCopy);
        if (constructor != null) {
            ++membersCount;
        }
        if (!(abstractMethods = AbstractTestGenerator.findAbstractMethods(methods = ElementFilter.methodsIn(srcClass.getEnclosedElements()))).isEmpty()) {
            membersCount += abstractMethods.size();
        }
        if (membersCount == 0) {
            members = Collections.emptyList();
        } else if (membersCount == 1) {
            members = constructor != null ? Collections.singletonList(constructor) : Collections.singletonList(AbstractTestGenerator.generateAbstractMethodImpl(abstractMethods.get(0), workingCopy));
        } else {
            members = new ArrayList(membersCount);
            if (constructor != null) {
                members.add(constructor);
            }
            for (ExecutableElement abstractMethod : abstractMethods) {
                members.add(AbstractTestGenerator.generateAbstractMethodImpl(abstractMethod, workingCopy));
            }
        }
        TreeMaker maker = workingCopy.getTreeMaker();
        switch (srcClass.getKind()) {
            case INTERFACE: 
            case ANNOTATION_TYPE: {
                ArrayList<ExpressionTree> implemetnts = new ArrayList<ExpressionTree>();
                implemetnts.add(maker.QualIdent((Element)srcClass));
                return maker.Class(maker.Modifiers(Collections.singleton(Modifier.PUBLIC)), name, Collections.emptyList(), null, implemetnts, members);
            }
        }
        return maker.Class(maker.Modifiers(Collections.singleton(Modifier.PUBLIC)), name, Collections.emptyList(), (Tree)maker.QualIdent((Element)srcClass), Collections.emptyList(), members);
    }

    private static String getAbstractClassImplName(CharSequence baseName) {
        return baseName + "Impl";
    }

    private static MethodTree generateAbstractClassImplCtor(TypeElement srcClass, WorkingCopy workingCopy) {
        List<? extends VariableElement> superCtorParams;
        ExecutableElement superConstructor = AbstractTestGenerator.findAccessibleConstructor(srcClass);
        if (superConstructor == null || (superCtorParams = superConstructor.getParameters()).isEmpty() && !AbstractTestGenerator.throwsNonRuntimeExceptions((CompilationInfo)workingCopy, superConstructor)) {
            return null;
        }
        TreeMaker maker = workingCopy.getTreeMaker();
        ArrayList<? extends VariableElement> defaultCtorParams = new ArrayList<VariableElement>(superCtorParams);
        List throwsList = superConstructor != null ? AbstractTestGenerator.generateThrowsList(superConstructor, (CompilationInfo)workingCopy, maker, false) : Collections.emptyList();
        BlockTree body = maker.Block(Collections.singletonList(maker.ExpressionStatement((ExpressionTree)maker.MethodInvocation(Collections.emptyList(), (ExpressionTree)maker.Identifier((CharSequence)"super"), AbstractTestGenerator.generateDefaultParamValues(defaultCtorParams, maker)))), false);
        return maker.Constructor(maker.Modifiers(Collections.singleton(Modifier.PUBLIC)), Collections.emptyList(), Collections.emptyList(), throwsList, body);
    }

    private static List<ExpressionTree> generateDefaultParamValues(List<? extends VariableElement> params, TreeMaker maker) {
        if (params.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ExpressionTree> result = new ArrayList<ExpressionTree>(params.size());
        for (VariableElement variableElement : params) {
            result.add(AbstractTestGenerator.getDefaultValue(maker, variableElement.asType()));
        }
        return result;
    }

    private static ExecutableElement findAccessibleConstructor(TypeElement clazz) {
        List<ExecutableElement> ctors = ElementFilter.constructorsIn(clazz.getEnclosedElements());
        if (ctors.isEmpty()) {
            return null;
        }
        ExecutableElement best = null;
        int bestArgsCount = -1;
        boolean bestHasThrown = false;
        for (ExecutableElement ctor : ctors) {
            boolean hasThrown;
            if (ctor.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            List<? extends VariableElement> args = ctor.getParameters();
            if (args.isEmpty()) {
                return ctor;
            }
            int argsCount = args.size();
            boolean bl = hasThrown = !ctor.getThrownTypes().isEmpty();
            if (best != null && argsCount >= bestArgsCount && (argsCount != bestArgsCount || !bestHasThrown || hasThrown)) continue;
            best = ctor;
            bestArgsCount = argsCount;
            bestHasThrown = hasThrown;
        }
        return best;
    }

    private static MethodTree generateAbstractMethodImpl(ExecutableElement abstractMethod, WorkingCopy workingCopy) {
        TreeMaker maker = workingCopy.getTreeMaker();
        TypeMirror returnType = abstractMethod.getReturnType();
        List<Object> content = returnType.getKind() == TypeKind.VOID ? Collections.emptyList() : Collections.singletonList(maker.Return(AbstractTestGenerator.getDefaultValue(maker, returnType)));
        BlockTree body = maker.Block(content, false);
        return maker.Method(maker.Modifiers(Collections.singleton(Modifier.PUBLIC)), (CharSequence)abstractMethod.getSimpleName(), maker.Type(returnType), AbstractTestGenerator.makeTypeParamsCopy(abstractMethod.getTypeParameters(), maker), AbstractTestGenerator.makeParamsCopy(abstractMethod.getParameters(), maker), AbstractTestGenerator.makeDeclaredTypesCopy(abstractMethod.getThrownTypes(), maker), body, null);
    }

    private static List<TypeParameterTree> makeTypeParamsCopy(List<? extends TypeParameterElement> typeParams, TreeMaker maker) {
        if (typeParams.isEmpty()) {
            return Collections.emptyList();
        }
        int size = typeParams.size();
        if (size == 1) {
            return Collections.singletonList(AbstractTestGenerator.makeCopy(typeParams.get(0), maker));
        }
        ArrayList<TypeParameterTree> result = new ArrayList<TypeParameterTree>(size);
        for (TypeParameterElement typeParameterElement : typeParams) {
            result.add(AbstractTestGenerator.makeCopy(typeParameterElement, maker));
        }
        return result;
    }

    private static List<VariableTree> makeParamsCopy(List<? extends VariableElement> params, TreeMaker maker) {
        if (params.isEmpty()) {
            return Collections.emptyList();
        }
        int size = params.size();
        if (size == 1) {
            return Collections.singletonList(AbstractTestGenerator.makeCopy(params.get(0), maker));
        }
        ArrayList<VariableTree> result = new ArrayList<VariableTree>(size);
        for (VariableElement variableElement : params) {
            result.add(AbstractTestGenerator.makeCopy(variableElement, maker));
        }
        return result;
    }

    private static TypeParameterTree makeCopy(TypeParameterElement typeParamElem, TreeMaker maker) {
        return maker.TypeParameter((CharSequence)typeParamElem.getSimpleName(), AbstractTestGenerator.makeDeclaredTypesCopy(typeParamElem.getBounds(), maker));
    }

    private static List<ExpressionTree> makeDeclaredTypesCopy(List<? extends DeclaredType> typeList, TreeMaker maker) {
        if (typeList.isEmpty()) {
            return Collections.emptyList();
        }
        int size = typeList.size();
        if (size == 1) {
            DeclaredType bound = typeList.get(0);
            return AbstractTestGenerator.isRootObjectType(bound) ? Collections.emptyList() : Collections.singletonList((ExpressionTree)maker.Type((TypeMirror)bound));
        }
        ArrayList<ExpressionTree> result = new ArrayList<ExpressionTree>(size);
        for (DeclaredType declaredType : typeList) {
            result.add((ExpressionTree)maker.Type((TypeMirror)declaredType));
        }
        return result;
    }

    private static boolean isRootObjectType(DeclaredType type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return false;
        }
        TypeElement elem = (TypeElement)type.asElement();
        return elem.getKind() == ElementKind.CLASS && elem.getSuperclass().getKind() == TypeKind.NONE;
    }

    private static VariableTree makeCopy(VariableElement paramElem, TreeMaker maker) {
        return maker.Variable(maker.Modifiers(Collections.emptySet()), (CharSequence)paramElem.getSimpleName(), maker.Type(paramElem.asType()), null);
    }

    private static List<ExecutableElement> findAbstractMethods(List<ExecutableElement> methods) {
        if (methods.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ExecutableElement> result = null;
        int remainingCount = methods.size();
        for (ExecutableElement method : methods) {
            Set<Modifier> modifiers = method.getModifiers();
            if (modifiers.contains((Object)Modifier.ABSTRACT) && !modifiers.contains((Object)Modifier.STATIC)) {
                if (result == null) {
                    result = new ArrayList<ExecutableElement>(remainingCount);
                }
                result.add(method);
            }
            --remainingCount;
        }
        if (result != null) {
            result.trimToSize();
        }
        return result == null ? Collections.emptyList() : result;
    }

    protected abstract ClassTree composeNewTestClass(WorkingCopy var1, String var2, List<? extends Tree> var3);

    protected abstract List<? extends Tree> generateInitMembers(WorkingCopy var1);

    protected abstract ClassTree generateMissingInitMembers(ClassTree var1, TreePath var2, WorkingCopy var3);

    protected abstract boolean generateMissingInitMembers(List<Tree> var1, ClassMap var2, WorkingCopy var3);

    protected int getPlaceForFirstInitMethod(ClassMap clsMap) {
        int targetIndex = clsMap.containsMethods() ? clsMap.getFirstMethodIndex() : (clsMap.containsInitializers() ? clsMap.getLastInitializerIndex() + 1 : (clsMap.containsNestedClasses() ? clsMap.getFirstNestedClassIndex() : -1));
        return targetIndex;
    }

    protected ClassTree generateMissingTestMethods(TypeElement srcClass, List<ExecutableElement> srcMethods, ClassTree tstClass, TreePath tstClassTreePath, boolean generateMissingInitMembers, WorkingCopy workingCopy) {
        String prefInstanceClassName;
        if (srcMethods.isEmpty()) {
            return tstClass;
        }
        Trees trees = workingCopy.getTrees();
        ClassMap clsMap = ClassMap.forClass(tstClass, tstClassTreePath, trees);
        List<? extends Tree> tstMembersOrig = tstClass.getMembers();
        ArrayList<Tree> tstMembers = new ArrayList<Tree>(tstMembersOrig.size() + 4);
        tstMembers.addAll(tstMembersOrig);
        if (generateMissingInitMembers) {
            this.generateMissingInitMembers(tstMembers, clsMap, workingCopy);
        }
        this.generateMissingPostInitMethods(tstClassTreePath, tstMembers, clsMap, workingCopy);
        List<String> testMethodNames = TestMethodNameGenerator.getTestMethodNames(srcMethods, null, null, workingCopy);
        Iterator<ExecutableElement> srcMethodsIt = srcMethods.iterator();
        Iterator<String> tstMethodNamesIt = testMethodNames.iterator();
        Object instanceClassName = null;
        ClassTree newAbstractClassImpl = null;
        if (srcClass.getModifiers().contains((Object)Modifier.ABSTRACT) && AbstractTestGenerator.hasInstanceMethods(srcMethods) && (instanceClassName = AbstractTestGenerator.findAbstractClassImplName(srcClass, tstClass, tstClassTreePath, clsMap, prefInstanceClassName = AbstractTestGenerator.getAbstractClassImplName(srcClass.getSimpleName()), trees, workingCopy.getTypes())) == null) {
            instanceClassName = prefInstanceClassName;
            newAbstractClassImpl = this.generateAbstractClassImpl(srcClass, (CharSequence)instanceClassName, workingCopy);
        }
        while (srcMethodsIt.hasNext()) {
            assert (tstMethodNamesIt.hasNext());
            ExecutableElement srcMethod = srcMethodsIt.next();
            String testMethodName = tstMethodNamesIt.next();
            int testMethodIndex = clsMap.findNoArgMethod(testMethodName);
            if (testMethodIndex != -1) continue;
            MethodTree newTestMethod = this.generateTestMethod(srcClass, srcMethod, testMethodName, (CharSequence)instanceClassName, workingCopy);
            tstMembers.add(newTestMethod);
            clsMap.addNoArgMethod(newTestMethod.getName().toString());
        }
        assert (!tstMethodNamesIt.hasNext());
        if (newAbstractClassImpl != null) {
            tstMembers.add(newAbstractClassImpl);
            clsMap.addNestedClass(instanceClassName.toString());
        }
        if (tstMembers.size() == tstMembersOrig.size()) {
            return tstClass;
        }
        ClassTree newClass = workingCopy.getTreeMaker().Class(tstClass.getModifiers(), (CharSequence)tstClass.getSimpleName(), tstClass.getTypeParameters(), tstClass.getExtendsClause(), tstClass.getImplementsClause(), tstMembers);
        return newClass;
    }

    protected abstract void generateMissingPostInitMethods(TreePath var1, List<Tree> var2, ClassMap var3, WorkingCopy var4);

    private List<MethodTree> generateTestMethods(TypeElement srcClass, CharSequence instanceClsName, List<ExecutableElement> srcMethods, WorkingCopy workingCopy) {
        if (srcMethods.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> testMethodNames = TestMethodNameGenerator.getTestMethodNames(srcMethods, null, null, workingCopy);
        Iterator<ExecutableElement> srcMethodsIt = srcMethods.iterator();
        Iterator<String> tstMethodNamesIt = testMethodNames.iterator();
        ArrayList<MethodTree> testMethods = new ArrayList<MethodTree>(srcMethods.size());
        while (srcMethodsIt.hasNext()) {
            assert (tstMethodNamesIt.hasNext());
            ExecutableElement srcMethod = srcMethodsIt.next();
            String testMethodName = tstMethodNamesIt.next();
            testMethods.add(this.generateTestMethod(srcClass, srcMethod, testMethodName, instanceClsName, workingCopy));
        }
        assert (!tstMethodNamesIt.hasNext());
        return testMethods;
    }

    protected MethodTree generateTestMethod(TypeElement srcClass, ExecutableElement srcMethod, String testMethodName, CharSequence instanceClsName, WorkingCopy workingCopy) {
        TreeMaker maker = workingCopy.getTreeMaker();
        MethodTree method = this.composeNewTestMethod(testMethodName, this.generateTestMethodBody(srcClass, srcMethod, instanceClsName, workingCopy), AbstractTestGenerator.generateThrowsList(srcMethod, (CompilationInfo)workingCopy, maker, AbstractTestGenerator.isClassEjb31Bean(workingCopy, srcClass)), workingCopy);
        if (this.setup.isGenerateMethodJavadoc()) {
            String commentText = Bundle.TestCreator_variantMethods_JavaDoc_comment(srcMethod.getSimpleName().toString(), srcClass.getSimpleName().toString());
            Comment javadoc = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)commentText);
            maker.addComment((Tree)method, javadoc, true);
        }
        return method;
    }

    protected ClassTree generateStubTestMethod(ClassTree tstClass, String testMethodName, WorkingCopy workingCopy) {
        List<? extends Tree> tstMembersOrig = tstClass.getMembers();
        ArrayList<? extends Tree> tstMembers = new ArrayList<Tree>(tstMembersOrig.size() + 4);
        tstMembers.addAll(tstMembersOrig);
        List<ExpressionTree> throwsList = Collections.emptyList();
        MethodTree method = this.composeNewTestMethod(STUB_TEST_NAME, this.generateStubTestMethodBody(workingCopy), throwsList, workingCopy);
        tstMembers.add(method);
        ClassTree newClass = workingCopy.getTreeMaker().Class(tstClass.getModifiers(), (CharSequence)tstClass.getSimpleName(), tstClass.getTypeParameters(), tstClass.getExtendsClause(), tstClass.getImplementsClause(), tstMembers);
        return newClass;
    }

    private static List<ExpressionTree> generateThrowsList(ExecutableElement execElem, CompilationInfo compInfo, TreeMaker maker, boolean forceThrowsClause) {
        if (forceThrowsClause || AbstractTestGenerator.throwsNonRuntimeExceptions(compInfo, execElem)) {
            return Collections.singletonList(maker.Identifier((CharSequence)"Exception"));
        }
        return Collections.emptyList();
    }

    protected abstract MethodTree composeNewTestMethod(String var1, BlockTree var2, List<ExpressionTree> var3, WorkingCopy var4);

    private MethodTree createMainMethod(TreeMaker maker) {
        String initialMainMethodBody = this.getInitialMainMethodBody();
        if (initialMainMethodBody.length() == 0) {
            return null;
        }
        ModifiersTree modifiers = maker.Modifiers(AbstractTestGenerator.createModifierSet(Modifier.PUBLIC, Modifier.STATIC));
        VariableTree param = maker.Variable(maker.Modifiers(Collections.emptySet()), (CharSequence)"argList", (Tree)maker.Identifier((CharSequence)"String[]"), null);
        MethodTree mainMethod = maker.Method(modifiers, (CharSequence)"main", (Tree)maker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.singletonList(param), Collections.emptyList(), '{' + initialMainMethodBody + '}', null);
        return mainMethod;
    }

    protected BlockTree generateTestMethodBody(TypeElement srcClass, ExecutableElement srcMethod, CharSequence instanceClsName, WorkingCopy workingCopy) {
        TreeMaker maker = workingCopy.getTreeMaker();
        ExecutableType srcMethodExType = (ExecutableType)srcMethod.asType();
        try {
            srcMethodExType = (ExecutableType)workingCopy.getTypes().asMemberOf((DeclaredType)srcClass.asType(), srcMethod);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        boolean isStatic = srcMethod.getModifiers().contains((Object)Modifier.STATIC);
        ArrayList<StatementTree> statements = new ArrayList<StatementTree>(8);
        if (this.setup.isGenerateDefMethodBody()) {
            StatementTree sout = this.generateSystemOutPrintln(maker, srcMethod.getSimpleName().toString());
            List<VariableTree> paramVariables = this.generateParamVariables(workingCopy, srcMethodExType, this.getTestSkeletonVarNames(srcMethod.getParameters()));
            statements.add(sout);
            statements.addAll(paramVariables);
            if (!isStatic) {
                boolean useNoArgConstructor = this.hasAccessibleNoArgConstructor(srcClass);
                if (AbstractTestGenerator.isClassEjb31Bean(workingCopy, srcClass) && AbstractTestGenerator.isMethodInContainerLookup(srcClass, srcMethod)) {
                    statements.addAll(this.generateEJBLookupCode(maker, srcClass, srcMethod));
                } else {
                    VariableTree instanceVarInit = maker.Variable(maker.Modifiers(Collections.emptySet()), (CharSequence)INSTANCE_VAR_NAME, (Tree)maker.QualIdent((Element)srcClass), useNoArgConstructor ? this.generateNoArgConstructorCall(maker, srcClass, instanceClsName) : maker.Literal(null));
                    statements.add(instanceVarInit);
                }
            }
            MethodInvocationTree methodCall = maker.MethodInvocation(Collections.emptyList(), (ExpressionTree)maker.MemberSelect(isStatic ? maker.QualIdent((Element)srcClass) : maker.Identifier((CharSequence)INSTANCE_VAR_NAME), (CharSequence)srcMethod.getSimpleName()), this.createIdentifiers(maker, paramVariables));
            TypeMirror retType = srcMethodExType.getReturnType();
            TypeKind retTypeKind = retType.getKind();
            switch (retTypeKind) {
                case VOID: 
                case ERROR: {
                    ExpressionStatementTree methodCallStmt = maker.ExpressionStatement((ExpressionTree)methodCall);
                    statements.add(methodCallStmt);
                    break;
                }
                case TYPEVAR: {
                    retType = this.getSuperType(workingCopy, retType);
                    retTypeKind = retType.getKind();
                }
                default: {
                    retType = workingCopy.getTypes().erasure(retType);
                    retTypeKind = retType.getKind();
                    Tree retTypeTree = maker.Type(retType);
                    VariableTree expectedValue = maker.Variable(maker.Modifiers(NO_MODIFIERS), (CharSequence)EXP_RESULT_VAR_NAME, retTypeTree, AbstractTestGenerator.getDefaultValue(maker, retType));
                    VariableTree actualValue = maker.Variable(maker.Modifiers(NO_MODIFIERS), (CharSequence)RESULT_VAR_NAME, retTypeTree, (ExpressionTree)methodCall);
                    ArrayList<IdentifierTree> comparisonArgs = new ArrayList<IdentifierTree>(2);
                    comparisonArgs.add(maker.Identifier((CharSequence)actualValue.getName().toString()));
                    comparisonArgs.add(maker.Identifier((CharSequence)expectedValue.getName().toString()));
                    if (retTypeKind == TypeKind.DOUBLE || retTypeKind == TypeKind.FLOAT) {
                        comparisonArgs.add(maker.Identifier((CharSequence)new Double(0.0).toString()));
                    }
                    MethodInvocationTree comparison = maker.MethodInvocation(Collections.emptyList(), (ExpressionTree)maker.Identifier((CharSequence)"assertEquals"), comparisonArgs);
                    ExpressionStatementTree comparisonStmt = maker.ExpressionStatement((ExpressionTree)comparison);
                    statements.add(expectedValue);
                    statements.add(actualValue);
                    statements.add(comparisonStmt);
                }
            }
            if (AbstractTestGenerator.isClassEjb31Bean(workingCopy, srcClass) && AbstractTestGenerator.isMethodInContainerLookup(srcClass, srcMethod)) {
                statements.add(this.generateEJBCleanUpCode(maker));
            }
        }
        if (this.setup.isGenerateDefMethodBody()) {
            ExpressionStatementTree exprStatementTree = this.generateDefMethodBody(maker);
            statements.add(exprStatementTree);
        }
        return maker.Block(statements, false);
    }

    protected BlockTree generateStubTestMethodBody(WorkingCopy workingCopy) {
        TreeMaker maker = workingCopy.getTreeMaker();
        ArrayList<ExpressionStatementTree> statements = new ArrayList<ExpressionStatementTree>(8);
        if (this.setup.isGenerateDefMethodBody()) {
            ExpressionStatementTree exprStatementTree = this.generateDefMethodBody(maker);
            statements.add(exprStatementTree);
        }
        return maker.Block(statements, false);
    }

    private StatementTree generateSystemOutPrintln(TreeMaker maker, String arg) {
        MethodInvocationTree methodInvocation = maker.MethodInvocation(Collections.emptyList(), (ExpressionTree)maker.MemberSelect((ExpressionTree)maker.MemberSelect((ExpressionTree)maker.Identifier((CharSequence)"System"), (CharSequence)"out"), (CharSequence)"println"), Collections.singletonList(maker.Literal((Object)arg)));
        return maker.ExpressionStatement((ExpressionTree)methodInvocation);
    }

    /*
     * WARNING - void declaration
     */
    private List<VariableTree> generateParamVariables(WorkingCopy workingCopy, ExecutableType srcMethod, String[] varNames) {
        TreeMaker maker = workingCopy.getTreeMaker();
        List<? extends TypeMirror> params = srcMethod.getParameterTypes();
        if (params == null || params.isEmpty()) {
            return Collections.emptyList();
        }
        Set noModifiers = Collections.emptySet();
        ArrayList<VariableTree> paramVariables = new ArrayList<VariableTree>(params.size());
        int index = 0;
        for (TypeMirror typeMirror : params) {
            void var10_10;
            if (typeMirror.getKind() == TypeKind.TYPEVAR) {
                TypeMirror typeMirror2 = this.getSuperType(workingCopy, typeMirror);
            }
            paramVariables.add(maker.Variable(maker.Modifiers(noModifiers), (CharSequence)varNames[index++], maker.Type((TypeMirror)var10_10), AbstractTestGenerator.getDefaultValue(maker, (TypeMirror)var10_10)));
        }
        return paramVariables;
    }

    private TypeMirror getSuperType(WorkingCopy workingCopy, TypeMirror type) {
        List<? extends TypeMirror> superTypes = workingCopy.getTypes().directSupertypes(type);
        if (!superTypes.isEmpty()) {
            return superTypes.get(0);
        }
        return type;
    }

    private List<IdentifierTree> createIdentifiers(TreeMaker maker, List<VariableTree> variables) {
        List<IdentifierTree> identifiers;
        if (variables.isEmpty()) {
            identifiers = Collections.emptyList();
        } else {
            identifiers = new ArrayList<IdentifierTree>(variables.size());
            for (VariableTree var : variables) {
                identifiers.add(maker.Identifier((CharSequence)var.getName().toString()));
            }
        }
        return identifiers;
    }

    private String[] getTestSkeletonVarNames(List<? extends VariableElement> sourceMethodParams) {
        String paramName;
        int i;
        if (sourceMethodParams.isEmpty()) {
            return new String[0];
        }
        int count = sourceMethodParams.size();
        String[] varNames = new String[count];
        boolean[] conflicts = new boolean[count];
        boolean issueFound = false;
        HashSet<String> varNamesSet = new HashSet<String>((int)((double)(count + 2) * 1.4));
        varNamesSet.add(INSTANCE_VAR_NAME);
        varNamesSet.add(RESULT_VAR_NAME);
        varNamesSet.add(EXP_RESULT_VAR_NAME);
        Iterator<? extends VariableElement> it = sourceMethodParams.iterator();
        for (i = 0; i < count; ++i) {
            varNames[i] = paramName = it.next().getSimpleName().toString();
            if (paramName == null) {
                issueFound = true;
                continue;
            }
            if (!varNamesSet.add(paramName)) {
                conflicts[i] = true;
                issueFound = true;
                continue;
            }
            conflicts[i] = false;
        }
        if (issueFound) {
            for (i = 0; i < count; ++i) {
                if (varNames[i] == null) {
                    paramName = ARTIFICAL_VAR_NAME_BASE + i;
                    if (varNamesSet.add(paramName)) {
                        varNames[i] = paramName;
                        continue;
                    }
                    conflicts[i] = true;
                }
                if (!conflicts[i]) continue;
                String paramNamePrefix = varNames[i] + '_';
                int index = 2;
                while (!varNamesSet.add(paramName = paramNamePrefix + index++)) {
                }
                varNames[i] = paramName;
            }
        }
        return varNames;
    }

    private static ExpressionTree getDefaultValue(TreeMaker maker, TypeMirror type) {
        LiteralTree defValue;
        TypeKind typeKind = type.getKind();
        if (typeKind.isPrimitive()) {
            switch (typeKind) {
                case BOOLEAN: {
                    defValue = maker.Literal((Object)Boolean.FALSE);
                    break;
                }
                case CHAR: {
                    defValue = maker.Literal((Object)new Character(' '));
                    break;
                }
                case BYTE: {
                    defValue = maker.Literal((Object)new Byte(0));
                    break;
                }
                case SHORT: {
                    defValue = maker.Literal((Object)new Short(0));
                    break;
                }
                case INT: {
                    defValue = maker.Literal((Object)new Integer(0));
                    break;
                }
                case FLOAT: {
                    defValue = maker.Literal((Object)new Float(0.0f));
                    break;
                }
                case LONG: {
                    defValue = maker.Literal((Object)new Long(0L));
                    break;
                }
                case DOUBLE: {
                    defValue = maker.Literal((Object)new Double(0.0));
                    break;
                }
                default: {
                    assert (false) : "unknown primitive type";
                    defValue = maker.Literal((Object)new Integer(0));
                    break;
                }
            }
        } else {
            defValue = typeKind == TypeKind.DECLARED && ((Object)type).toString().equals("java.lang.String") ? maker.Literal((Object)"") : maker.Literal(null);
        }
        return defValue;
    }

    private ExpressionTree generateNoArgConstructorCall(TreeMaker maker, TypeElement cls, CharSequence instanceClsName) {
        return maker.NewClass(null, Collections.emptyList(), instanceClsName != null ? maker.Identifier(instanceClsName) : maker.QualIdent((Element)cls), Collections.emptyList(), null);
    }

    private List<ExecutableElement> findTestableMethods(WorkingCopy wc, TypeElement classElem) {
        Iterable<Element> elements;
        boolean isEJB = AbstractTestGenerator.isClassEjb31Bean(wc, classElem);
        final Types types = wc.getTypes();
        if (isEJB) {
            final TypeMirror typeObject = wc.getElements().getTypeElement("java.lang.Object").asType();
            ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                public boolean accept(Element e, TypeMirror type) {
                    return !types.isSameType(typeObject, e.getEnclosingElement().asType());
                }
            };
            elements = wc.getElementUtilities().getMembers(classElem.asType(), acceptor);
        } else {
            elements = classElem.getEnclosedElements();
        }
        List<ExecutableElement> methods = ElementFilter.methodsIn(elements);
        if (methods.isEmpty()) {
            return Collections.emptyList();
        }
        List<ExecutableElement> testableMethods = null;
        int skippedCount = 0;
        for (ExecutableElement method : methods) {
            if (this.isTestableMethod(method) && (!isEJB || isEJB && this.isTestableEJBMethod(method))) {
                if (testableMethods == null) {
                    testableMethods = new ArrayList<ExecutableElement>(methods.size() - skippedCount);
                }
                testableMethods.add(method);
                continue;
            }
            ++skippedCount;
        }
        return testableMethods != null ? testableMethods : Collections.emptyList();
    }

    private boolean isTestableMethod(ExecutableElement method) {
        if (method.getKind() != ElementKind.METHOD) {
            throw new IllegalArgumentException();
        }
        return this.setup.isMethodTestable(method);
    }

    private boolean isTestableEJBMethod(ExecutableElement method) {
        Set<Modifier> modifiers = method.getModifiers();
        return !modifiers.isEmpty() && EnumSet.copyOf(modifiers).removeAll(TestCreator.ACCESS_MODIFIERS) && !modifiers.contains((Object)Modifier.PROTECTED);
    }

    private static CharSequence findAbstractClassImplName(TypeElement srcClass, ClassTree tstClass, TreePath tstClassPath, ClassMap tstClassMap, String preferredName, Trees trees, Types types) {
        if (!tstClassMap.containsNestedClasses()) {
            return null;
        }
        boolean mayContainPreferred = tstClassMap.getNestedClasses().contains(preferredName);
        List<? extends Tree> tstClassMembers = tstClass.getMembers();
        TypeMirror srcClassType = null;
        Name firstFound = null;
        for (int index : tstClassMap.getNestedClassIndexes()) {
            Tree member = tstClassMembers.get(index);
            assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)member.getKind()));
            ClassTree nestedClass = (ClassTree)member;
            if (nestedClass.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT)) continue;
            TreePath nestedClassPath = new TreePath(tstClassPath, nestedClass);
            TypeMirror nestedClassType = trees.getElement(nestedClassPath).asType();
            if (srcClassType == null) {
                srcClassType = srcClass.asType();
            }
            if (!types.isSubtype(nestedClassType, srcClassType)) continue;
            Name name = nestedClass.getSimpleName();
            if (!mayContainPreferred || name.contentEquals(preferredName)) {
                return name;
            }
            if (firstFound != null) continue;
            firstFound = name;
        }
        return firstFound;
    }

    private static boolean hasInstanceMethods(List<ExecutableElement> methods) {
        if (methods.isEmpty()) {
            return false;
        }
        for (ExecutableElement method : methods) {
            if (method.getModifiers().contains((Object)Modifier.STATIC)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasAccessibleNoArgConstructor(TypeElement srcClass) {
        boolean answer;
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(srcClass.getEnclosedElements());
        if (constructors.isEmpty()) {
            answer = true;
        } else {
            answer = false;
            for (ExecutableElement constructor : constructors) {
                if (!constructor.getParameters().isEmpty()) continue;
                answer = !constructor.getModifiers().contains((Object)Modifier.PRIVATE);
                break;
            }
        }
        return answer;
    }

    private static boolean throwsNonRuntimeExceptions(CompilationInfo compInfo, ExecutableElement method) {
        List<? extends TypeMirror> thrownTypes = method.getThrownTypes();
        if (thrownTypes.isEmpty()) {
            return false;
        }
        String runtimeExcName = "java.lang.RuntimeException";
        TypeElement runtimeExcElement = compInfo.getElements().getTypeElement(runtimeExcName);
        if (runtimeExcElement == null) {
            Logger.getLogger("testng").log(Level.WARNING, "Could not find TypeElement for " + runtimeExcName);
            return true;
        }
        Types types = compInfo.getTypes();
        TypeMirror runtimeExcType = runtimeExcElement.asType();
        for (TypeMirror typeMirror : thrownTypes) {
            if (types.isSubtype(typeMirror, runtimeExcType)) continue;
            return true;
        }
        return false;
    }

    private <T extends Element> List<T> resolveHandles(CompilationInfo compInfo, List<ElementHandle<T>> handles) {
        if (handles == null) {
            return null;
        }
        if (handles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>(handles.size());
        for (ElementHandle<T> handle : handles) {
            Element element = handle.resolve(compInfo);
            if (element != null) {
                elements.add(element);
                continue;
            }
            ErrorManager.getDefault().log(16, "TestNG: Could not resolve element handle " + handle.getBinaryName());
        }
        return elements;
    }

    public void cancel() {
        this.cancelled = true;
    }

    private void classProcessed(ClassTree cls) {
        if (this.processedClassNames == null) {
            this.processedClassNames = new ArrayList<String>(4);
        }
        this.processedClassNames.add(cls.getSimpleName().toString());
    }

    List<String> getProcessedClassNames() {
        return this.processedClassNames != null ? this.processedClassNames : Collections.emptyList();
    }

    private String getInitialMainMethodBody() {
        if (this.initialMainMethodBody == null) {
            this.initialMainMethodBody = TestNGSettings.getDefault().getGenerateMainMethodBody();
            if (this.initialMainMethodBody == null) {
                this.initialMainMethodBody = "";
            }
        }
        return this.initialMainMethodBody;
    }

    protected ModifiersTree createModifiersTree(String annotationClassName, Set<Modifier> modifiers, WorkingCopy workingCopy) {
        TreeMaker maker = workingCopy.getTreeMaker();
        AnnotationTree annotation = maker.Annotation((Tree)this.getClassIdentifierTree(annotationClassName, workingCopy), Collections.emptyList());
        return maker.Modifiers(modifiers, Collections.singletonList(annotation));
    }

    protected ExpressionTree getClassIdentifierTree(String className, WorkingCopy workingCopy) {
        ExpressionTree classIdentifier;
        if (this.classIdentifiers == null) {
            classIdentifier = null;
            this.classIdentifiers = new HashMap<String, ExpressionTree>(13);
        } else {
            classIdentifier = this.classIdentifiers.get(className);
        }
        if (classIdentifier == null) {
            TypeElement typeElement = AbstractTestGenerator.getElemForClassName(className, workingCopy.getElements());
            TreeMaker maker = workingCopy.getTreeMaker();
            classIdentifier = typeElement != null ? maker.QualIdent((Element)typeElement) : maker.Identifier((CharSequence)className);
            this.classIdentifiers.put(className, classIdentifier);
        }
        return classIdentifier;
    }

    protected static TypeElement getElemForClassName(String className, Elements elements) {
        TypeElement elem = elements.getTypeElement(className);
        if (elem == null) {
            ErrorManager.getDefault().log(65536, "Could not find TypeElement for " + className);
        }
        return elem;
    }

    static Set<Modifier> createModifierSet(Modifier ... modifiers) {
        EnumSet<Modifier> modifierSet = EnumSet.noneOf(Modifier.class);
        for (Modifier m : modifiers) {
            modifierSet.add(m);
        }
        return modifierSet;
    }

    private static boolean isClassEjb31Bean(WorkingCopy wc, TypeElement srcClass) {
        ClassPath cp = wc.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
        if (cp == null || cp.findResource("javax/ejb/embeddable/EJBContainer.class") == null) {
            return false;
        }
        List<? extends AnnotationMirror> annotations = wc.getElements().getAllAnnotationMirrors(srcClass);
        for (AnnotationMirror annotationMirror : annotations) {
            String annotation = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
            if (!annotation.equals("javax.ejb.Singleton") && !annotation.equals("javax.ejb.Stateless") && !annotation.equals("javax.ejb.Stateful")) continue;
            return true;
        }
        return false;
    }

    private static boolean isMethodInContainerLookup(TypeElement srcClass, ExecutableElement srcMethod) {
        List<? extends AnnotationMirror> annotations = srcClass.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            String annotation = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
            if (!annotation.equals("javax.ejb.LocalBean")) continue;
            return true;
        }
        List<? extends TypeMirror> interfaces = srcClass.getInterfaces();
        return interfaces.isEmpty() || AbstractTestGenerator.areAllowedInterfacesForLocalBean(interfaces) || AbstractTestGenerator.getEjbInterfaceDeclaringMethod(srcMethod, interfaces) != null;
    }

    private static boolean areAllowedInterfacesForLocalBean(List<? extends TypeMirror> interfaces) {
        for (TypeMirror typeMirror : interfaces) {
            TypeElement interfaceElement;
            String interfaceClassName;
            if (!(typeMirror instanceof DeclaredType) || (interfaceClassName = (interfaceElement = (TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().toString()).equals("java.io.Serializable") || interfaceClassName.equals("java.io.Externalizable") || interfaceClassName.startsWith("javax.ejb.")) continue;
            return false;
        }
        return true;
    }

    private List<VariableTree> generateEJBLookupCode(TreeMaker maker, TypeElement srcClass, ExecutableElement srcMethod) {
        String ejbContainerPackage = "javax.ejb.embeddable.EJBContainer";
        ArrayList<VariableTree> trees = new ArrayList<VariableTree>();
        IdentifierTree container = maker.Identifier((CharSequence)"javax.ejb.embeddable.EJBContainer");
        MethodInvocationTree invocation = maker.MethodInvocation(Collections.emptyList(), (ExpressionTree)maker.MemberSelect((ExpressionTree)container, (CharSequence)"createEJBContainer"), Collections.emptyList());
        VariableTree containerVarInit = maker.Variable(maker.Modifiers(Collections.emptySet()), (CharSequence)CONTAINER_VAR_NAME, (Tree)maker.QualIdent("javax.ejb.embeddable.EJBContainer"), (ExpressionTree)invocation);
        trees.add(containerVarInit);
        String className = AbstractTestGenerator.getBeanInterfaceOrImplementationClassName(srcClass, srcMethod);
        IdentifierTree bean = maker.Identifier((CharSequence)("(" + className + ")" + CONTAINER_VAR_NAME));
        MethodInvocationTree contextInvocation = maker.MethodInvocation(Collections.emptyList(), (ExpressionTree)maker.MemberSelect((ExpressionTree)bean, (CharSequence)"getContext"), Collections.emptyList());
        contextInvocation = maker.MethodInvocation(Collections.emptyList(), (ExpressionTree)maker.MemberSelect((ExpressionTree)contextInvocation, (CharSequence)"lookup"), Collections.singletonList(maker.Literal((Object)("java:global/classes/" + srcClass.getSimpleName()))));
        VariableTree beanVarInit = maker.Variable(maker.Modifiers(Collections.emptySet()), (CharSequence)INSTANCE_VAR_NAME, (Tree)maker.QualIdent(className), (ExpressionTree)contextInvocation);
        trees.add(beanVarInit);
        return trees;
    }

    private static String getBeanInterfaceOrImplementationClassName(TypeElement srcClass, ExecutableElement srcMethod) {
        String interfaceClassName = AbstractTestGenerator.getEjbInterfaceDeclaringMethod(srcMethod, srcClass.getInterfaces());
        if (interfaceClassName != null) {
            return interfaceClassName;
        }
        return srcClass.getSimpleName().toString();
    }

    private static String getEjbInterfaceDeclaringMethod(ExecutableElement srcMethod, List<? extends TypeMirror> interfaces) {
        for (TypeMirror typeMirror : interfaces) {
            DeclaredType declaredType;
            TypeElement interfaceElement;
            if (!(typeMirror instanceof DeclaredType) || !AbstractTestGenerator.isLocalOrRemoteInterface(interfaceElement = (TypeElement)(declaredType = (DeclaredType)typeMirror).asElement()) || !AbstractTestGenerator.isMethodDeclaredByInterface(interfaceElement, srcMethod)) continue;
            return interfaceElement.getSimpleName().toString();
        }
        return null;
    }

    private static boolean isLocalOrRemoteInterface(TypeElement trgInterface) {
        List<? extends AnnotationMirror> annotations = trgInterface.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            String annotation = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
            if (!annotation.equals("javax.ejb.Local") && !annotation.equals("javax.ejb.Remote")) continue;
            return true;
        }
        return false;
    }

    private static boolean isMethodDeclaredByInterface(TypeElement trgInterface, ExecutableElement srcMethod) {
        List<? extends Element> enclosedElements = trgInterface.getEnclosedElements();
        List<? extends VariableElement> methodParameters = srcMethod.getParameters();
        for (Element element : enclosedElements) {
            if (!(element instanceof ExecutableElement)) continue;
            ExecutableElement exElement = (ExecutableElement)element;
            List<? extends VariableElement> elementParameters = exElement.getParameters();
            if (srcMethod.getSimpleName() != exElement.getSimpleName() || methodParameters.size() != elementParameters.size()) continue;
            for (int i = 0; i < methodParameters.size(); ++i) {
                if (((Object)methodParameters.get(i).asType()).toString().equals(((Object)elementParameters.get(i).asType()).toString())) continue;
            }
            return true;
        }
        return false;
    }

    private StatementTree generateEJBCleanUpCode(TreeMaker maker) {
        IdentifierTree container = maker.Identifier((CharSequence)CONTAINER_VAR_NAME);
        MethodInvocationTree invocation = maker.MethodInvocation(Collections.emptyList(), (ExpressionTree)maker.MemberSelect((ExpressionTree)container, (CharSequence)"close"), Collections.emptyList());
        return maker.ExpressionStatement((ExpressionTree)invocation);
    }

    private ClassTree findClass(String simpleName, List<ClassTree> classes) {
        if (simpleName == null) {
            return null;
        }
        for (ClassTree cls : classes) {
            if (!cls.getSimpleName().contentEquals(simpleName)) continue;
            return cls;
        }
        return null;
    }
}

