/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.output;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.UnsupportedCharsetException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntSession;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.OutputLine;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.testng.output.AntSessionInfo;
import org.netbeans.modules.testng.output.RegexpUtils;
import org.netbeans.modules.testng.output.TestNGExecutionManager;
import org.netbeans.modules.testng.output.TestNGTestNodeFactory;
import org.netbeans.modules.testng.output.TestNGTestSession;
import org.netbeans.modules.testng.output.TestNGTestSuite;
import org.netbeans.modules.testng.output.TestNGTestcase;
import org.netbeans.modules.testng.output.XmlOutputParser;
import org.netbeans.modules.testng.output.XmlResult;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TestNGOutputReader {
    private static final Logger LOG = Logger.getLogger(TestNGOutputReader.class.getName());
    private static final Logger progressLogger = Logger.getLogger("org.netbeans.modules.testng.outputreader.progress");
    private final NumberFormat numberFormat = NumberFormat.getInstance();
    private final TestSession.SessionType sessionType;
    private boolean offline;
    private boolean noresults = true;
    private final File antScript;
    private final long timeOfSessionStart;
    private long lastSuiteTime = 0L;
    private final Manager manager = Manager.getInstance();
    private ClassPath platformSources;
    private TestNGTestSession testSession;
    private Project project;
    private File resultsDir;
    private Map<String, Report> reports;
    private int successPercentage;
    private int passedWithErrorsFailure;
    private boolean descriptionInPassedWithErrors;
    private String suiteName;
    private String testCase;
    private String parameters;
    private String values;
    private String duration;
    private int msDuration;
    private boolean failedInConfigurationMethod;
    private boolean failedInAfterClass;
    private boolean failedInBeforeClass;
    private boolean failedInAfterMethod;
    private boolean failedInBeforeMethod;
    private boolean canAddToStackTrace;
    private long currentTime;
    private String currentSuitename;
    private boolean suiteSummary = false;
    private long elapsedTime = 0L;
    private SuiteStats suiteStat;
    private List<String> txt = new ArrayList<String>();
    private static int x = 0;

    TestNGOutputReader(AntSession session, AntSessionInfo sessionInfo, Project project, Properties props) {
        this.manager.setTestingFramework("testng");
        this.project = project;
        this.sessionType = sessionInfo.getSessionType();
        this.antScript = FileUtil.normalizeFile((File)session.getOriginatingScript());
        this.timeOfSessionStart = sessionInfo.getTimeOfTestTaskStart();
        if (project == null) {
            FileObject fileObj = FileUtil.toFileObject((File)this.antScript);
            this.project = FileOwnerQuery.getOwner((FileObject)fileObj);
        }
        this.testSession = new TestNGTestSession(sessionInfo.getSessionName(), this.project, this.sessionType, new TestNGTestNodeFactory());
        this.testSession.setRerunHandler(new TestNGExecutionManager(session, this.testSession, props));
        this.reports = new HashMap<String, Report>();
    }

    TestNGOutputReader(TestNGTestSession session) {
        this.testSession = session;
        this.sessionType = session.getSessionType();
        this.antScript = null;
        this.timeOfSessionStart = System.currentTimeMillis();
        this.project = session.getProject();
        this.reports = new HashMap<String, Report>();
    }

    Project getProject() {
        return this.project;
    }

    TestSession getTestSession() {
        return this.testSession;
    }

    void verboseMessageLogged(AntEvent event) {
        String msg = event.getMessage();
        if (msg == null) {
            return;
        }
        if (!msg.startsWith("[VerboseTestNG] ") || this.offline) {
            return;
        }
        if (this.noresults) {
            this.noresults = false;
        }
        this.verboseMessageLogged(msg);
    }

    private void handleInvocationCount(int invocationCount) {
        double actual = (double)(invocationCount - this.passedWithErrorsFailure) / (double)invocationCount;
        double expected = (double)this.successPercentage / 100.0;
        this.duration = Integer.toString(this.msDuration);
        if (actual == 100.0) {
            this.testFinished("PASSED", this.suiteName, this.testCase, this.parameters, this.values, this.duration);
        } else if (actual < expected) {
            this.testFinished("FAILED", this.suiteName, this.testCase, this.parameters, this.values, this.duration);
        } else {
            this.testFinished("PASSED with failures", this.suiteName, this.testCase, this.parameters, this.values, this.duration);
        }
    }

    synchronized void verboseMessageLogged(String msg) {
        String in = this.getMessage(msg);
        if (this.descriptionInPassedWithErrors) {
            Matcher m = Pattern.compile("(.)*( \\((\\d+) of (\\d+)\\))$").matcher(in);
            if (m.matches()) {
                int invocationCount;
                int currentInvocation = Integer.parseInt(m.group(3));
                if (currentInvocation == (invocationCount = Integer.parseInt(m.group(4)))) {
                    this.handleInvocationCount(invocationCount);
                }
            } else assert (false) : "Cannot match: '" + in + "'.";
            this.descriptionInPassedWithErrors = false;
            this.addDescription(in.substring(0, in.lastIndexOf(40)).trim());
            return;
        }
        if (in.startsWith("RUNNING: ")) {
            this.passedWithErrorsFailure = 0;
            this.successPercentage = -1;
            this.msDuration = 0;
            this.descriptionInPassedWithErrors = false;
            this.failedInAfterClass = false;
            this.failedInBeforeClass = false;
            this.failedInAfterMethod = false;
            this.failedInBeforeMethod = false;
            this.failedInConfigurationMethod = false;
            this.canAddToStackTrace = true;
            Matcher m = Pattern.compile("[^\"]*\"([^\"]+)\" [a-z]+ \"(\\d+)\"[^:]*: ([^\\)]*)\\)").matcher(in);
            if (m.matches()) {
                this.suiteStarted(m.group(1), Integer.valueOf(m.group(2)), m.group(3));
            } else assert (false) : "Cannot match: '" + in + "'.";
            return;
        }
        if (in.equals("===============================================")) {
            boolean bl = this.suiteSummary = !this.suiteSummary;
            if (this.txt.size() > 0 && this.failedInAfterClass) {
                this.testStarted(this.suiteName, this.testCase, this.parameters, this.values);
                this.addStackTrace(this.txt);
                this.txt.clear();
                this.testFinished("FAILED", this.suiteName, this.testCase, this.parameters, this.values, this.duration);
            }
            if (this.suiteSummary) {
                this.suiteStat = new SuiteStats();
            } else {
                this.suiteFinished(this.suiteStat);
                this.suiteStat = null;
            }
            if (this.txt.size() > 0) {
                this.addStackTrace(this.txt);
                this.txt.clear();
            }
            return;
        }
        if (this.suiteSummary) {
            if (this.suiteStat.name != null) {
                Matcher m = Pattern.compile("\\D+(\\d+)\\D+(\\d+)(\\D+(\\d+))?").matcher(in);
                if (this.suiteStat.testRun < 0) {
                    if (m.matches()) {
                        this.suiteStat.testRun = Integer.valueOf(m.group(1));
                        this.suiteStat.testFail = Integer.valueOf(m.group(2));
                        this.suiteStat.testSkip = Integer.valueOf(m.group(4));
                    } else assert (false) : "Cannot match: '" + in + "'.";
                } else if (m.matches()) {
                    this.suiteStat.confFail = Integer.valueOf(m.group(1));
                    this.suiteStat.confSkip = Integer.valueOf(m.group(2));
                } else assert (false) : "Cannot match: '" + in + "'.";
            } else {
                this.suiteStat.name = in.trim();
            }
            return;
        }
        if (in.startsWith("INVOKING: ")) {
            Matcher m;
            if (this.txt.size() > 0 && this.failedInBeforeMethod) {
                this.testStarted(this.suiteName, this.testCase, this.parameters, this.values);
                this.addStackTrace(this.txt);
                this.txt.clear();
                this.testFinished("FAILED", this.suiteName, this.testCase, this.parameters, this.values, this.duration);
            }
            this.failedInAfterMethod = false;
            this.failedInBeforeMethod = false;
            if (this.failedInBeforeClass) {
                return;
            }
            if (this.failedInConfigurationMethod) {
                this.canAddToStackTrace = false;
            }
            if (this.txt.size() > 0 && !this.failedInConfigurationMethod) {
                this.addStackTrace(this.txt);
                this.txt.clear();
            }
            if ((m = Pattern.compile("[^\"]*\"([^\"]+)\" - ([^\\(]+)(\\(([^\\)]*)\\)([^:]+: (.*)\\))?( finished in (\\d+) ms)?)?( \\((\\d+) of (\\d+)\\))?( success: (\\d+)%)?").matcher(in)).matches()) {
                this.testStarted(m.group(1), m.group(2), m.group(4), m.group(6));
                String percent = m.group(12);
                if (percent != null) {
                    percent = percent.substring(percent.indexOf(": ") + 2, percent.length() - 1);
                    this.successPercentage = Integer.parseInt(percent);
                }
            } else {
                Matcher m2 = Pattern.compile("[^\"]*\"([^\"]+)\" - ([^\\(]+)(\\(([^\\)]*)\\))(.)*").matcher(in);
                if (m2.matches()) {
                    this.testStarted(m2.group(1), m2.group(2), m2.group(4), "UNKNOWN#" + ++x);
                } else assert (false) : "Cannot match: '" + in + "'.";
            }
            return;
        }
        Matcher m = Pattern.compile("[^\"]*\"([^\"]+)\" - ([^\\(]+)(\\(([^\\)]*)\\)([^:]+: (.*)\\))?( finished in (\\d+) ms)?)?( \\((\\d+) of (\\d+)\\))?( success: (\\d+)%)?").matcher(in);
        if (in.startsWith("PASSED: ")) {
            if (m.matches()) {
                if (this.successPercentage == -1) {
                    this.testFinished("PASSED", m.group(1), m.group(2), m.group(4), m.group(6), m.group(8));
                } else {
                    int invocationCount;
                    int currentInvocation;
                    try {
                        int dur = Integer.parseInt(m.group(8));
                        currentInvocation = Integer.parseInt(m.group(10));
                        invocationCount = Integer.parseInt(m.group(11));
                        this.msDuration += dur;
                    }
                    catch (NumberFormatException ex) {
                        return;
                    }
                    if (currentInvocation == invocationCount) {
                        this.testFinished("PASSED", m.group(1), m.group(2), m.group(4), m.group(6), Integer.toString(this.msDuration));
                        this.successPercentage = -1;
                    }
                }
            } else {
                Matcher m2 = Pattern.compile("[^\"]*\"([^\"]+)\" - ([^\\(]+)(\\(([^\\)]*)\\))(.)*").matcher(in);
                if (m2.matches()) {
                    this.testFinished("PASSED", m2.group(1), m2.group(2), m2.group(4), "UNKNOWN#" + x, "0");
                } else assert (false) : "Cannot match: '" + in + "'.";
            }
            return;
        }
        if (in.startsWith("PASSED with failures: ")) {
            if (m.matches()) {
                int invocationCount;
                int currentInvocation;
                ++this.passedWithErrorsFailure;
                this.suiteName = m.group(1);
                this.testCase = m.group(2);
                this.parameters = m.group(4);
                this.values = m.group(6);
                this.duration = m.group(8);
                try {
                    int dur = Integer.parseInt(this.duration);
                    currentInvocation = Integer.parseInt(m.group(10));
                    invocationCount = Integer.parseInt(m.group(11));
                    this.msDuration += dur;
                }
                catch (NumberFormatException ex) {
                    this.descriptionInPassedWithErrors = true;
                    return;
                }
                if (currentInvocation == invocationCount) {
                    this.handleInvocationCount(invocationCount);
                    this.successPercentage = -1;
                }
            } else {
                Matcher m2 = Pattern.compile("[^\"]*\"([^\"]+)\" - ([^\\(]+)(\\(([^\\)]*)\\))(.)*").matcher(in);
                if (m2.matches()) {
                    this.testFinished("PASSED with failures", m2.group(1), m2.group(2), m2.group(4), "UNKNOWN#" + x, "0");
                } else assert (false) : "Cannot match: '" + in + "'.";
            }
            return;
        }
        if (in.startsWith("SKIPPED: ")) {
            if (m.matches()) {
                if (this.failedInConfigurationMethod && this.txt.size() > 0) {
                    this.addStackTrace(this.txt);
                }
                this.testFinished("SKIPPED", m.group(1), m.group(2), m.group(4), m.group(6), m.group(8));
            } else {
                Matcher m2 = Pattern.compile("[^\"]*\"([^\"]+)\" - ([^\\(]+)(\\(([^\\)]*)\\))(.)*").matcher(in);
                if (m2.matches()) {
                    this.testFinished("SKIPPED", m2.group(1), m2.group(2), m2.group(4), "UNKNOWN#" + x, "0");
                } else assert (false) : "Cannot match: '" + in + "'.";
            }
            return;
        }
        if (in.startsWith("FAILED: ")) {
            if (m.matches()) {
                if (this.successPercentage == -1) {
                    this.testFinished("FAILED", m.group(1), m.group(2), m.group(4), m.group(6), m.group(8));
                } else {
                    int invocationCount;
                    int currentInvocation;
                    try {
                        int dur = Integer.parseInt(m.group(8));
                        currentInvocation = Integer.parseInt(m.group(10));
                        invocationCount = Integer.parseInt(m.group(11));
                        this.msDuration += dur;
                    }
                    catch (NumberFormatException ex) {
                        return;
                    }
                    if (currentInvocation == invocationCount) {
                        this.testFinished("FAILED", m.group(1), m.group(2), m.group(4), m.group(6), Integer.toString(this.msDuration));
                        this.successPercentage = -1;
                    }
                }
            } else {
                Matcher m2 = Pattern.compile("[^\"]*\"([^\"]+)\" - ([^\\(]+)(\\(([^\\)]*)\\))(.)*").matcher(in);
                if (m2.matches()) {
                    this.testFinished("FAILED", m2.group(1), m2.group(2), m2.group(4), "UNKNOWN#" + x, "0");
                } else assert (false) : "Cannot match: '" + in + "'.";
            }
            return;
        }
        if (in.startsWith("FAILED CONFIGURATION: ")) {
            if (m.matches()) {
                this.suiteName = m.group(1);
                this.testCase = m.group(2);
                this.parameters = m.group(4);
                this.values = m.group(6);
                this.duration = m.group(8);
            }
            if (in.contains(" - @AfterClass")) {
                this.failedInAfterClass = true;
                if (this.txt.size() > 0) {
                    this.addStackTrace(this.txt);
                }
            }
            if (in.contains(" - @BeforeClass")) {
                this.failedInBeforeClass = true;
            }
            if (in.contains(" - @AfterMethod")) {
                this.failedInAfterMethod = true;
            }
            if (in.contains(" - @BeforeMethod")) {
                this.failedInBeforeMethod = true;
            }
            this.failedInConfigurationMethod = true;
            this.txt.clear();
            return;
        }
        if (in.startsWith("SKIPPED CONFIGURATION: ")) {
            if (this.failedInAfterMethod && this.txt.size() > 0) {
                this.testStarted(this.suiteName, this.testCase, this.parameters, this.values);
                this.addStackTrace(this.txt);
                this.txt.clear();
                this.testFinished("FAILED", this.suiteName, this.testCase, this.parameters, this.values, this.duration);
            }
            if (!this.failedInBeforeClass && this.txt.size() > 0) {
                this.addStackTrace(this.txt);
                this.txt.clear();
            }
            if (this.failedInBeforeClass && this.txt.size() > 0) {
                this.testStarted(this.suiteName, this.testCase, this.parameters, this.values);
                this.addStackTrace(this.txt);
                this.txt.clear();
                this.testFinished("FAILED", this.suiteName, this.testCase, this.parameters, this.values, this.duration);
            }
            return;
        }
        if (in.startsWith("PASSED CONFIGURATION: ")) {
            if (this.txt.size() > 0) {
                this.addStackTrace(this.txt);
                this.txt.clear();
            }
            return;
        }
        if (in.contains(" CONFIGURATION: ")) {
            if (this.txt.size() > 0 && this.failedInAfterClass) {
                this.testStarted(this.suiteName, this.testCase, this.parameters, this.values);
                this.addStackTrace(this.txt);
                this.txt.clear();
                this.testFinished("FAILED", this.suiteName, this.testCase, this.parameters, this.values, this.duration);
            }
            if (this.txt.size() > 0) {
                this.addStackTrace(this.txt);
                this.txt.clear();
            }
            return;
        }
        Matcher m1 = Pattern.compile("[^\"]*\"([^\"]+)\" [a-z]+ \"(\\d+)\"[^:]*: ([^\\)]*)\\)").matcher(in);
        if (!m.matches() && !m1.matches()) {
            if (this.txt.isEmpty() && in.startsWith("       ")) {
                this.addDescription(in.trim());
            } else if (in.trim().length() > 0 && (this.canAddToStackTrace || this.failedInConfigurationMethod)) {
                this.txt.add(in);
            }
        }
    }

    synchronized void messageLogged(AntEvent event) {
        String msg = event.getMessage();
        if (msg == null) {
            return;
        }
        Testcase tc = this.testSession.getCurrentTestCase();
        if (tc != null) {
            tc.getOutput().add(new OutputLine(msg, false));
        }
        if (!this.offline) {
            if (!msg.startsWith("[VerboseTestNG] ")) {
                this.displayOutput(msg, event.getLogLevel() == 1);
            }
            this.verboseMessageLogged(event);
        }
    }

    private int parseTime(String timeString) {
        int timeMillis;
        try {
            double seconds = this.numberFormat.parse(timeString).doubleValue();
            timeMillis = Math.round((float)(seconds * 1000.0));
        }
        catch (ParseException ex) {
            timeMillis = -1;
        }
        return timeMillis;
    }

    private static File determineResultsDir(AntEvent event) {
        File resultsDir = null;
        String taskName = event.getTaskName();
        if (taskName != null) {
            if (taskName.equals("testng")) {
                resultsDir = TestNGOutputReader.determineTestNGTaskResultsDir(event);
            } else if (taskName.equals("java")) {
                resultsDir = TestNGOutputReader.determineJavaTaskResultsDir(event);
            } else assert (false) : "Unexpected task: " + taskName;
        }
        if (resultsDir != null && resultsDir.exists() && resultsDir.isDirectory()) {
            return resultsDir;
        }
        return null;
    }

    private static File determineTestNGTaskResultsDir(AntEvent event) {
        TaskStructure taskStruct = event.getTaskStructure();
        if (taskStruct == null) {
            return null;
        }
        String todirAttr = taskStruct.getAttribute("outputdir") != null ? taskStruct.getAttribute("outputdir") : (taskStruct.getAttribute("workingDir") != null ? taskStruct.getAttribute("workingDir") + "test-output" : "test-output");
        File resultsDir = new File(event.evaluate(todirAttr));
        return TestNGOutputReader.findAbsolutePath(resultsDir, taskStruct, event);
    }

    private static File determineJavaTaskResultsDir(AntEvent event) {
        TaskStructure taskStruct = event.getTaskStructure();
        if (taskStruct == null) {
            return null;
        }
        String todirPath = null;
        for (TaskStructure taskChild : taskStruct.getChildren()) {
            int index;
            String taskChildName = taskChild.getName();
            if (!taskChildName.equals("arg")) continue;
            String valueAttr = taskChild.getAttribute("value");
            if (valueAttr == null) {
                valueAttr = taskChild.getAttribute("line");
            }
            if (valueAttr == null || -1 >= (index = (valueAttr = event.evaluate(valueAttr)).indexOf("-d ")) || !(todirPath = valueAttr.substring(index + 3)).contains(" ")) continue;
            index = todirPath.startsWith("\"") ? todirPath.indexOf("\"", 1) + 1 : todirPath.indexOf(" ");
            todirPath = todirPath.substring(0, index);
            break;
        }
        if (todirPath == null) {
            String dir = taskStruct.getAttribute("dir");
            todirPath = dir != null ? event.evaluate(dir) + "/test-output" : "test-output";
        }
        File resultsDir = new File(event.evaluate(todirPath));
        return TestNGOutputReader.findAbsolutePath(resultsDir, taskStruct, event);
    }

    private static File findAbsolutePath(File path, TaskStructure taskStruct, AntEvent event) {
        if (TestNGOutputReader.isAbsolute(path)) {
            return path;
        }
        return TestNGOutputReader.combine(TestNGOutputReader.getBaseDir(event), path);
    }

    private static File combine(File parentPath, File path) {
        return path != null ? new File(parentPath, path.getPath()) : parentPath;
    }

    private static boolean isAbsolute(File path) {
        return path != null && path.isAbsolute();
    }

    private static File getFile(String attrValue, AntEvent event) {
        return new File(event.evaluate(attrValue));
    }

    private static File getBaseDir(AntEvent event) {
        return new File(event.getProperty("basedir"));
    }

    private ClassPath findPlatformSources(String javaExecutable) {
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
        for (int i = 0; i < platforms.length; ++i) {
            File f;
            String path;
            FileObject fo = platforms[i].findTool("java");
            if (fo == null || !(path = (f = FileUtil.toFile((FileObject)fo)).getAbsolutePath()).startsWith(javaExecutable) && !javaExecutable.startsWith(path.substring(0, path.length() - 8))) continue;
            return platforms[i].getSourceFolders();
        }
        return null;
    }

    void testTaskStarted(boolean expectXmlOutput, AntEvent event) {
        this.offline = expectXmlOutput;
        if (!this.offline) {
            this.manager.testStarted((TestSession)this.testSession);
        }
        this.resultsDir = TestNGOutputReader.determineResultsDir(event);
    }

    void testTaskFinished() {
        File reportFile;
        if (this.offline) {
            this.manager.testStarted((TestSession)this.testSession);
        }
        if ((this.offline || this.noresults) && this.resultsDir != null && (reportFile = this.findReportFile()) != null && this.isValidReportFile(reportFile)) {
            XmlResult reportSuite = TestNGOutputReader.parseReportFile(reportFile, this.testSession);
            for (TestNGTestSuite ts : reportSuite.getTestSuites()) {
                this.manager.displaySuiteRunning((TestSession)this.testSession, (TestSuite)ts);
                this.testSession.setCurrentSuite(ts.getName());
                this.testSession.addSuite(ts);
                Report report = this.testSession.getReport(ts.getElapsedTime());
                this.manager.displayReport((TestSession)this.testSession, report, true);
            }
        }
        x = 0;
    }

    void buildFinished(AntEvent event) {
        this.manager.sessionFinished((TestSession)this.testSession);
    }

    private void displayOutput(String text, boolean error) {
        this.manager.displayOutput((TestSession)this.testSession, text, error);
    }

    private File findReportFile() {
        File file = new File(this.resultsDir, "testng-results.xml");
        return file.isFile() ? file : null;
    }

    private boolean isValidReportFile(File reportFile) {
        Level logLevel;
        if (!reportFile.canRead()) {
            return false;
        }
        if (reportFile.canRead()) {
            return true;
        }
        long lastModified = reportFile.lastModified();
        long timeDelta = lastModified - this.timeOfSessionStart;
        Logger logger = Logger.getLogger("org.netbeans.modules.testng.outputreader.timestamps");
        if (logger.isLoggable(logLevel = Level.FINER)) {
            logger.log(logLevel, "Report file: " + reportFile.getPath());
            GregorianCalendar timeStamp = new GregorianCalendar();
            timeStamp.setTimeInMillis(this.timeOfSessionStart);
            logger.log(logLevel, "Session start:    " + String.format("%1$tT.%2$03d", timeStamp, timeStamp.get(14)));
            timeStamp.setTimeInMillis(lastModified);
            logger.log(logLevel, "Report timestamp: " + String.format("%1$tT.%2$03d", timeStamp, timeStamp.get(14)));
        }
        if (timeDelta >= 0L) {
            return true;
        }
        return -timeDelta <= this.timeOfSessionStart % 1000L;
    }

    private static XmlResult parseReportFile(File reportFile, TestSession session) {
        XmlResult reports = null;
        try {
            reports = XmlOutputParser.parseXmlOutput(new InputStreamReader((InputStream)new FileInputStream(reportFile), "UTF-8"), session);
        }
        catch (UnsupportedCharsetException ex) {
            assert (false);
        }
        catch (SAXException ex) {
        }
        catch (IOException ex) {
            Logger.getLogger(TestNGOutputReader.class.getName()).log(Level.INFO, "I/O exception while reading TestNG XML report file from TestNG: ", ex);
        }
        return reports;
    }

    private void suiteStarted(String name, int expectedTCases, String config) {
        name = this.testSession.getSuiteName(name);
        TestNGTestSuite suite = new TestNGTestSuite(name, this.testSession, expectedTCases, config);
        this.testSession.addSuite(suite);
        this.testSession.setCurrentSuite(name);
        this.manager.displaySuiteRunning((TestSession)this.testSession, (TestSuite)suite);
        this.platformSources = null;
        this.reports.put(name, new Report(name, this.project));
    }

    private void suiteFinished(SuiteStats stats) {
        stats.name = this.testSession.getCurrentSuite().getName();
        this.testSession.setCurrentSuite(stats.name);
        TestNGTestSuite s = (TestNGTestSuite)this.testSession.getCurrentSuite();
        s.setElapsedTime(this.elapsedTime);
        s.finish(stats.testRun, stats.testFail, stats.testSkip, stats.confFail, stats.confSkip);
        Report r = this.reports.get(stats.name);
        r.setElapsedTimeMillis(this.elapsedTime);
        this.manager.displayReport((TestSession)this.testSession, r, true);
        this.elapsedTime = 0L;
    }

    private void testStarted(String suiteName, String testCase, String parameters, String values) {
        suiteName = this.testSession.getCurrentSuite().getName();
        this.testSession.setCurrentSuite(suiteName);
        TestNGTestcase tc = ((TestNGTestSuite)this.testSession.getCurrentSuite()).getTestCase(testCase, values);
        if (tc == null) {
            tc = new TestNGTestcase(testCase, parameters, values, this.testSession);
            this.testSession.addTestCase(tc);
            this.manager.testStarted((TestSession)this.testSession);
        } else {
            tc.addValues(values);
        }
    }

    private void testFinished(String st, String suiteName, String testCase, String parameters, String values, String duration) {
        suiteName = this.testSession.getCurrentSuite().getName();
        this.testSession.setCurrentSuite(suiteName);
        TestNGTestcase tc = ((TestNGTestSuite)this.testSession.getCurrentSuite()).getTestCase(testCase, values);
        if (tc == null) {
            tc = new TestNGTestcase(testCase, parameters, values, this.testSession);
            this.testSession.addTestCase(tc);
            this.manager.testStarted((TestSession)this.testSession);
        }
        assert (tc != null);
        if ("PASSED".equals(st)) {
            tc.setStatus(Status.PASSED);
        } else if ("PASSED with failures".equals(st)) {
            tc.setStatus(Status.PASSEDWITHERRORS);
        } else if ("FAILED".equals(st)) {
            tc.setStatus(Status.FAILED);
        } else if ("SKIPPED".equals(st)) {
            tc.setStatus(Status.SKIPPED);
        }
        long dur = 0L;
        if (duration != null) {
            dur = Long.valueOf(duration);
        }
        tc.setTimeMillis(dur);
        this.elapsedTime += dur;
        if ("FAILED".equals(st)) {
            this.currentTime = dur;
            this.currentSuitename = suiteName;
        } else {
            this.currentTime = -1L;
            this.currentSuitename = null;
            Report r = this.reports.get(suiteName);
            r.update(this.testSession.getReport(dur));
            this.manager.displayReport((TestSession)this.testSession, r, false);
        }
    }

    private String getMessage(String msg) {
        int prefixLength = "[VerboseTestNG] ".length();
        return msg.substring(prefixLength);
    }

    private void addDescription(String in) {
        Testcase tc = this.testSession.getCurrentTestCase();
        if (tc != null) {
            ((TestNGTestcase)tc).setDescription(in);
        }
    }

    private void addStackTrace(List<String> txt) {
        Trouble t = new Trouble(false);
        Matcher matcher = RegexpUtils.getInstance().getComparisonPattern().matcher(txt.get(0));
        if (matcher.matches()) {
            t.setComparisonFailure(new Trouble.ComparisonFailure(matcher.group(1) + matcher.group(2) + matcher.group(3), matcher.group(4) + matcher.group(5) + matcher.group(6)));
        } else {
            matcher = RegexpUtils.getInstance().getComparisonHiddenPattern().matcher(txt.get(0));
            if (matcher.matches()) {
                t.setComparisonFailure(new Trouble.ComparisonFailure(matcher.group(1), matcher.group(2)));
            }
        }
        t.setStackTrace(txt.toArray(new String[txt.size()]));
        this.testSession.getCurrentTestCase().setTrouble(t);
        if (this.currentTime != -1L && this.currentSuitename != null) {
            Report r = this.reports.get(this.currentSuitename);
            r.update(this.testSession.getReport(this.currentTime));
            this.manager.displayReport((TestSession)this.testSession, r, false);
        }
    }

    private class SuiteStats {
        private String name = null;
        private int testRun = -1;
        private int testFail = -1;
        private int testSkip = -1;
        private int confFail = 0;
        private int confSkip = 0;

        private SuiteStats() {
        }
    }
}

