/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.DiffViewAction;
import org.netbeans.modules.gsf.testrunner.api.TestMethodNode;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.testng.output.JumpAction;
import org.netbeans.modules.testng.output.TestMethodNodeAction;
import org.netbeans.modules.testng.output.TestNGTestcase;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

final class TestNGMethodNode
extends TestMethodNode {
    private InstanceContent ic;

    public TestNGMethodNode(Testcase testcase, Project project) {
        this(testcase, project, new InstanceContent());
    }

    private TestNGMethodNode(Testcase tc, Project p, InstanceContent ic) {
        super(tc, p, (Lookup)new AbstractLookup((AbstractLookup.Content)ic));
        this.ic = ic;
    }

    public Action[] getActions(boolean context) {
        SingleMethod sm = new SingleMethod(this.getTestcase().getClassFileObject(), this.getTestcase().getTestName());
        this.ic.add((Object)sm);
        this.ic.add((Object)this.getTestcase());
        ArrayList<Action> actions = new ArrayList<Action>();
        Action preferred = this.getPreferredAction();
        if (preferred != null) {
            actions.add(preferred);
        }
        if (this.testcase.getTrouble() != null && this.testcase.getTrouble().getComparisonFailure() != null) {
            actions.add((Action)new DiffViewAction(this.testcase));
        }
        for (ActionProvider ap : Lookup.getDefault().lookupAll(ActionProvider.class)) {
            List<String> supportedActions = Arrays.asList(ap.getSupportedActions());
            if (!this.getTestcase().isConfigMethod() && supportedActions.contains("run.single.method")) {
                actions.add(new TestMethodNodeAction(ap, Lookups.singleton((Object)sm), "run.single.method", "LBL_RerunTest"));
            }
            if (this.getTestcase().isConfigMethod() || !supportedActions.contains("debug.single.method")) continue;
            actions.add(new TestMethodNodeAction(ap, Lookups.singleton((Object)sm), "debug.single.method", "LBL_DebugTest"));
        }
        return actions.toArray(new Action[actions.size()]);
    }

    public Action getPreferredAction() {
        return new JumpAction((Node)this, null);
    }

    public TestNGTestcase getTestcase() {
        return (TestNGTestcase)this.testcase;
    }

    public String getHtmlDisplayName() {
        return !this.getTestcase().isConfigMethod() ? super.getHtmlDisplayName() : "<i>" + super.getHtmlDisplayName() + "</i>";
    }
}

