/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.output;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.testng.output.AntSessionInfo;
import org.netbeans.modules.testng.output.TestNGOutputReader;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestNGAntLogger
extends AntLogger {
    private static final int[] LEVELS_OF_INTEREST = new int[]{2, 1, 3, 0};
    public static final String TASK_JAVA = "java";
    public static final String TASK_TESTNG = "testng";
    private static final String[] INTERESTING_TASKS = new String[]{"java", "testng"};
    private static final String ANT_TEST_RUNNER_CLASS_NAME = "org.testng.TestNG";

    public boolean interestedInSession(AntSession session) {
        return true;
    }

    public String[] interestedInTargets(AntSession session) {
        return AntLogger.ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession session) {
        return INTERESTING_TASKS;
    }

    private static TestSession.SessionType detectSessionType(AntEvent event) {
        String taskName = event.getTaskName();
        if (taskName == null) {
            return null;
        }
        if (taskName.equals(TASK_TESTNG)) {
            return TestSession.SessionType.TEST;
        }
        if (taskName.equals(TASK_JAVA)) {
            TaskStructure taskStructure = event.getTaskStructure();
            String className = taskStructure.getAttribute("classname");
            if (className == null) {
                return null;
            }
            if ((className = event.evaluate(className)).equals(ANT_TEST_RUNNER_CLASS_NAME)) {
                TaskStructure[] nestedElems;
                for (TaskStructure ts : nestedElems = taskStructure.getChildren()) {
                    if (!ts.getName().equals("jvmarg")) continue;
                    String a = ts.getAttribute("value");
                    if (a != null) {
                        if (!event.evaluate(a).equals("-Xdebug")) continue;
                        return TestSession.SessionType.DEBUG;
                    }
                    a = ts.getAttribute("line");
                    if (a == null) continue;
                    for (String part : TestNGAntLogger.parseCmdLine(event.evaluate(a))) {
                        if (!part.equals("-Xdebug")) continue;
                        return TestSession.SessionType.DEBUG;
                    }
                }
                return TestSession.SessionType.TEST;
            }
            return null;
        }
        assert (false) : "Unhandled task name";
        return null;
    }

    private static List<String> parseCmdLine(String cmdLine) {
        if ((cmdLine = cmdLine.trim()).length() == 0) {
            return Collections.emptyList();
        }
        char[] chars = cmdLine.toCharArray();
        boolean simple = true;
        for (char c : chars) {
            if (c != ' ' && c != '\"' && c != '\'') continue;
            simple = false;
            break;
        }
        if (simple) {
            return Collections.singletonList(cmdLine);
        }
        ArrayList<String> result = new ArrayList<String>(4);
        StringBuilder buf = new StringBuilder(20);
        boolean stateBeforeWord = false;
        boolean stateAfterWord = true;
        int stateInSingleQuote = 2;
        int stateInDoubleQuote = 3;
        int state = 0;
        block7: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (state) {
                case 0: {
                    if (c == '\"') {
                        state = 3;
                        continue block7;
                    }
                    if (c == '\'') {
                        state = 2;
                        continue block7;
                    }
                    if (c == ' ') continue block7;
                    buf.append(c);
                    state = 1;
                    continue block7;
                }
                case 3: {
                    if (c == '\"') {
                        state = 1;
                        continue block7;
                    }
                    buf.append(c);
                    continue block7;
                }
                case 2: {
                    if (c == '\'') {
                        state = 1;
                        continue block7;
                    }
                    buf.append(c);
                    continue block7;
                }
                case 1: {
                    if (c == '\"') {
                        state = 3;
                        continue block7;
                    }
                    if (c == '\'') {
                        state = 2;
                        continue block7;
                    }
                    if (c != ' ') continue block7;
                    result.add(buf.toString());
                    buf = new StringBuilder(20);
                    state = 0;
                    continue block7;
                }
                default: {
                    assert (false);
                    continue block7;
                }
            }
        }
        assert (state != 0);
        result.add(buf.toString());
        return result;
    }

    private static boolean isTestSessionType(TestSession.SessionType sessionType) {
        return sessionType != null;
    }

    public boolean interestedInScript(File script, AntSession session) {
        return true;
    }

    public int[] interestedInLogLevels(AntSession session) {
        return LEVELS_OF_INTEREST;
    }

    public void messageLogged(AntEvent event) {
        if (this.isTestTaskRunning(event)) {
            if (event.getLogLevel() != 3) {
                this.getOutputReader(event).messageLogged(event);
            } else {
                this.getOutputReader(event).verboseMessageLogged(event);
            }
        }
    }

    private boolean isTestTaskRunning(AntEvent event) {
        return TestNGAntLogger.isTestSessionType(this.getSessionInfo(event.getSession()).getCurrentSessionType());
    }

    public void taskStarted(AntEvent event) {
        TestSession.SessionType sessionType = TestNGAntLogger.detectSessionType(event);
        if (TestNGAntLogger.isTestSessionType(sessionType)) {
            AntSessionInfo sessionInfo = this.getSessionInfo(event.getSession());
            assert (!TestNGAntLogger.isTestSessionType(sessionInfo.getCurrentSessionType()));
            sessionInfo.setTimeOfTestTaskStart(System.currentTimeMillis());
            sessionInfo.setCurrentSessionType(sessionType);
            if (sessionInfo.getSessionType() == null) {
                sessionInfo.setSessionType(sessionType);
            }
            String suiteName = null;
            String logLevel = null;
            TaskStructure struct = event.getTaskStructure();
            if (TASK_TESTNG.equals(struct.getName())) {
                suiteName = struct.getAttribute("suitename");
                logLevel = struct.getAttribute("verbose");
                if (logLevel == null) {
                    logLevel = struct.getAttribute("log");
                }
            } else if (TASK_JAVA.equals(struct.getName())) {
                TaskStructure[] nestedElems;
                for (TaskStructure ts : nestedElems = struct.getChildren()) {
                    String a;
                    if (!ts.getName().equals("arg") || (a = ts.getAttribute("line")) == null) continue;
                    String[] args = event.evaluate(a).split(" ");
                    int size = args.length;
                    for (int i = 0; i < size; ++i) {
                        String curr = args[i];
                        if ("-suitename".equals(curr)) {
                            suiteName = i + 1 < size ? args[i + 1] : null;
                            ++i;
                            continue;
                        }
                        if (!"-log".equals(curr) && !"-verbose".equals(curr)) continue;
                        logLevel = i + 1 < size ? args[i + 1] : null;
                        ++i;
                    }
                }
            } else assert (false) : "Unexpeted task " + struct.getName();
            if (suiteName != null) {
                sessionInfo.setSessionName(event.evaluate(suiteName));
            }
            boolean offline = false;
            if (logLevel != null) {
                int lvl;
                try {
                    lvl = Integer.valueOf(event.evaluate(logLevel));
                }
                catch (NumberFormatException nfe) {
                    lvl = -1;
                }
                offline = lvl == 0;
            }
            this.getOutputReader(event).testTaskStarted(offline, event);
        }
    }

    public void taskFinished(AntEvent event) {
        AntSessionInfo sessionInfo = this.getSessionInfo(event.getSession());
        if (TestNGAntLogger.isTestSessionType(sessionInfo.getCurrentSessionType())) {
            this.getOutputReader(event).testTaskFinished();
            sessionInfo.setCurrentSessionType(null);
        }
    }

    public void buildFinished(AntEvent event) {
        AntSession session = event.getSession();
        AntSessionInfo sessionInfo = this.getSessionInfo(session);
        if (TestNGAntLogger.isTestSessionType(sessionInfo.getSessionType())) {
            this.getOutputReader(event).buildFinished(event);
        }
        session.putCustomData((AntLogger)this, null);
    }

    private TestNGOutputReader getOutputReader(AntEvent event) {
        assert (TestNGAntLogger.isTestSessionType(this.getSessionInfo(event.getSession()).getSessionType()));
        AntSession session = event.getSession();
        AntSessionInfo sessionInfo = this.getSessionInfo(session);
        TestNGOutputReader outputReader = sessionInfo.outputReader;
        if (outputReader == null) {
            String[] propsOfInterest;
            String projectDir = null;
            Project project = null;
            try {
                projectDir = event.getProperty("work.dir");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (projectDir == null) {
                    projectDir = event.getProperty("basedir");
                }
                if (projectDir != null && projectDir.length() != 0) {
                    File f = FileUtil.normalizeFile((File)new File(projectDir));
                    project = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)f));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            Properties props = new Properties();
            for (String prop : propsOfInterest = new String[]{"javac.includes", "classname", "methodname", "work.dir", "classpath", "platform.java", "test.includes"}) {
                String val = event.getProperty(prop);
                if (val == null) continue;
                props.setProperty(prop, val);
            }
            sessionInfo.outputReader = outputReader = new TestNGOutputReader(session, sessionInfo, project, props);
        }
        return outputReader;
    }

    private AntSessionInfo getSessionInfo(AntSession session) {
        AntSessionInfo sessionInfo;
        Object o = session.getCustomData((AntLogger)this);
        assert (o == null || o instanceof AntSessionInfo);
        if (o != null) {
            sessionInfo = (AntSessionInfo)o;
        } else {
            sessionInfo = new AntSessionInfo();
            session.putCustomData((AntLogger)this, (Object)sessionInfo);
        }
        return sessionInfo;
    }
}

