/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.output;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.testng.output.CallstackFrameNode;
import org.netbeans.modules.testng.output.OutputUtils;
import org.netbeans.modules.testng.output.TestNGMethodNode;
import org.netbeans.modules.testng.output.TestNGSuiteNode;
import org.netbeans.modules.testng.output.TestNGTestSuite;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

final class JumpAction
extends AbstractAction {
    private final Node node;
    private final String callstackFrameInfo;

    public JumpAction(Node node, String callstackFrameInfo) {
        this.node = node;
        this.callstackFrameInfo = callstackFrameInfo;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.node instanceof TestNGSuiteNode) {
            OutputUtils.openTestsuite((TestNGSuiteNode)this.node);
        } else if (this.node instanceof CallstackFrameNode) {
            OutputUtils.openCallstackFrame(this.node, this.callstackFrameInfo);
        } else if (this.node instanceof TestNGMethodNode) {
            OutputUtils.openTestMethod((TestNGMethodNode)this.node);
        }
    }

    public boolean isEnabled() {
        TestSuite suite;
        if (this.node instanceof TestNGSuiteNode && (suite = ((TestNGSuiteNode)this.node).getSuite()) != null && suite instanceof TestNGTestSuite) {
            return ((TestNGTestSuite)suite).getSuiteFO() != null;
        }
        return super.isEnabled();
    }

    public Object getValue(String key) {
        if (key.equals("Name")) {
            return NbBundle.getMessage(JumpAction.class, (String)"LBL_GotoSource");
        }
        return super.getValue(key);
    }
}

