/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.actions;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.testng.actions.TestConfigAccessor;
import org.netbeans.modules.testng.api.TestNGSupport;
import org.netbeans.modules.testng.spi.TestConfig;
import org.netbeans.modules.testng.spi.TestNGSupportImplementation;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class RerunFailedTestsAction
extends NodeAction {
    private static final Logger LOGGER = Logger.getLogger(RerunFailedTestsAction.class.getName());

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        Lookup l = activatedNodes[0].getLookup();
        Project p = (Project)l.lookup(Project.class);
        if (p == null) {
            DataObject dataObject = (DataObject)l.lookup(DataObject.class);
            if (dataObject != null && dataObject.getPrimaryFile() != null) {
                p = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
            } else {
                return false;
            }
        }
        if (TestNGSupport.isActionSupported(TestNGSupport.Action.RUN_FAILED, p)) {
            return TestNGSupport.findTestNGSupport(p).createExecutor(p).hasFailedTests();
        }
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        DataObject dataObject;
        Lookup l = activatedNodes[0].getLookup();
        Project p = (Project)l.lookup(Project.class);
        if (p == null && (dataObject = (DataObject)l.lookup(DataObject.class)) != null) {
            p = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
        }
        TestNGSupportImplementation.TestExecutor exec = TestNGSupport.findTestNGSupport(p).createExecutor(p);
        assert (exec.hasFailedTests());
        TestConfig conf = TestConfigAccessor.getDefault().createTestConfig(p.getProjectDirectory(), true, null, null, null);
        try {
            exec.execute(TestNGSupport.Action.RUN_FAILED, conf);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    public String getName() {
        return NbBundle.getMessage(RerunFailedTestsAction.class, (String)"CTL_RerunFailedTestsAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

