/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system.launchers.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.helper.JavaCompatibleProperties;
import org.netbeans.installer.utils.helper.Version;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.utils.system.launchers.LauncherProperties;
import org.netbeans.installer.utils.system.launchers.LauncherResource;
import org.netbeans.installer.utils.system.launchers.impl.CommonLauncher;

public class ExeLauncher
extends CommonLauncher {
    private static final String EXE_EXT = ".exe";
    private static final int EXE_STUB_FILL_SIZE = 450000;
    private static final long MAXDWORD = 0x100000000L;
    public static final String DEFAULT_WINDOWS_RESOURCE_SUFFIX = "native/launcher/windows/";
    public static final String I18N = "i18n";
    public static final String EXE_LAUNCHER_STUB_NAME = "nlw.exe";
    public static final String EXE_LAUNCHER_STUB = "native/launcher/windows/nlw.exe";
    public static final String DEFAULT_WINDOWS_RESOURCE_I18N = "native/launcher/windows/i18n/";
    public static final String DEFAULT_WINDOWS_RESOURCE_I18N_BUNDLE_NAME = "launcher";
    public static final String MIN_JAVA_VERSION_WINDOWS_ALL = "1.6.0";
    public static final String MIN_JAVA_VERSION_WINDOWS = "1.5.0_03";
    public static final String MIN_JAVA_VERSION_WINDOWS_VISTA = "1.5.0_11";
    public static final String MIN_JAVA_VERSION_WINDOWS_2K8 = "1.5.0_17";
    public static final String MIN_JAVA_VERSION_WINDOWS_7 = "1.5.0_19";
    public static final String MIN_IBM_JAVA_VERSION = "1.5.0";
    public static final String OSNAME_WINDOWS = "Windows";
    public static final String OSNAME_WINDOWS_XP = "XP";
    public static final String OSNAME_WINDOWS_VISTA = "Vista";
    public static final String OSNAME_WINDOWS_2K = "2000";
    public static final String OSNAME_WINDOWS_2K3 = "2003";
    public static final String OSNAME_WINDOWS_2K8 = "2008";
    public static final String OSNAME_WINDOWS_7 = "Windows 7";

    public ExeLauncher(LauncherProperties props) {
        super(props);
    }

    @Override
    public void initialize() throws IOException {
        LogManager.log("Checking EXE launcher parameters...");
        this.checkAllParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File create(Progress progress) throws IOException {
        FileOutputStream fos = null;
        try {
            long bundledSize;
            progress.setPercentage(0);
            fos = new FileOutputStream(this.outputFile, false);
            long total = bundledSize = this.getBundledFilesSize();
            if (this.stubFile != null) {
                total += FileUtils.getSize(this.stubFile);
            }
            this.addExeInitialStub(fos, progress, total);
            LogManager.log("Adding i18n...");
            this.addI18NStrings(fos);
            this.addData(fos, this.jvmArguments, true);
            LogManager.log("JVM Arguments: " + (this.jvmArguments != null ? StringUtils.asString(this.jvmArguments, " ") : ""));
            this.addData(fos, this.appArguments, true);
            LogManager.log("App Arguments: " + (this.appArguments != null ? StringUtils.asString(this.appArguments, " ") : ""));
            this.addData(fos, this.mainClass, true);
            LogManager.log("Main Class : " + this.mainClass);
            this.addData(fos, this.testJVMClass, true);
            LogManager.log("TestJVM Class : " + this.testJVMClass);
            this.addNumber(fos, new Long("" + this.compatibleJava.size()));
            this.addJavaCompatibleProperties(fos);
            this.addNumber(fos, this.getBundledFilesNumber());
            this.addNumber(fos, bundledSize, true);
            this.addFileSection(fos, this.testJVMFile, progress, total);
            LogManager.log("Adding JVM external locations and bundled files");
            this.addData(fos, this.jvms, progress, total);
            LogManager.log("Adding bundled and external jars");
            this.addData(fos, this.jars, progress, total);
            LogManager.log("Adding other resources");
            this.addData(fos, this.otherResources, progress, total);
        }
        catch (IOException ex) {
            LogManager.log(ex);
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                LogManager.log(e);
            }
            try {
                FileUtils.deleteFile(this.outputFile);
            }
            catch (IOException e) {
                LogManager.log(e);
            }
            fos = null;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    LogManager.log(ex.toString());
                    throw ex;
                }
            }
            progress.setPercentage(100);
        }
        return this.outputFile;
    }

    @Override
    public String[] getExecutionCommand() {
        return new String[]{this.outputFile.getAbsolutePath()};
    }

    @Override
    public List<JavaCompatibleProperties> getDefaultCompatibleJava(Version version) {
        if (version.equals(Version.getVersion("1.5"))) {
            ArrayList<JavaCompatibleProperties> list = new ArrayList<JavaCompatibleProperties>();
            list.add(new JavaCompatibleProperties(MIN_JAVA_VERSION_WINDOWS_VISTA, null, null, OSNAME_WINDOWS_VISTA, null));
            list.add(new JavaCompatibleProperties(MIN_JAVA_VERSION_WINDOWS, null, null, OSNAME_WINDOWS_XP, null));
            list.add(new JavaCompatibleProperties(MIN_JAVA_VERSION_WINDOWS, null, null, OSNAME_WINDOWS_2K, null));
            list.add(new JavaCompatibleProperties(MIN_JAVA_VERSION_WINDOWS, null, null, OSNAME_WINDOWS_2K3, null));
            list.add(new JavaCompatibleProperties(MIN_JAVA_VERSION_WINDOWS_2K8, null, null, OSNAME_WINDOWS_2K8, null));
            list.add(new JavaCompatibleProperties(MIN_JAVA_VERSION_WINDOWS_7, null, null, OSNAME_WINDOWS_7, null));
            list.add(new JavaCompatibleProperties(MIN_IBM_JAVA_VERSION, null, "IBM Corporation", null, null));
            list.add(new JavaCompatibleProperties(MIN_JAVA_VERSION_WINDOWS_ALL, null, null, OSNAME_WINDOWS, null));
            return list;
        }
        return super.getDefaultCompatibleJava(version);
    }

    private String changeJavaPropertyCounter(String string) {
        String str = string;
        if (str != null) {
            int counter = 0;
            while (str.indexOf(this.getJavaCounter(counter)) != -1) {
                str = str.replace(this.getJavaCounter(counter++), "%s");
            }
        }
        return str;
    }

    private void addExeInitialStub(FileOutputStream fos, Progress progress, long total) throws IOException {
        long stubSize;
        if (this.stubFile != null) {
            this.checkParameter("stub file", this.stubFile);
            stubSize = this.addData(fos, this.stubFile, progress, total);
        } else {
            stubSize = this.addData(fos, ResourceUtils.getResource(EXE_LAUNCHER_STUB), progress, 0L);
        }
        long length = 450000L - stubSize;
        for (long i = 0L; i < length; ++i) {
            this.addData(fos);
        }
    }

    private void addI18NStrings(FileOutputStream fos) throws IOException {
        this.addNumber(fos, this.i18nMap.size());
        PropertyResourceBundle defaultBundle = (PropertyResourceBundle)this.i18nMap.get("");
        LinkedList<String> props = new LinkedList<String>();
        Enumeration<String> en = defaultBundle.getKeys();
        long numberOfProperties = 0L;
        while (en.hasMoreElements()) {
            en.nextElement();
            ++numberOfProperties;
        }
        this.addNumber(fos, numberOfProperties);
        en = defaultBundle.getKeys();
        while (en.hasMoreElements()) {
            String propertyName = en.nextElement();
            props.add(propertyName);
            this.addData(fos, propertyName, false);
        }
        this.addData(fos, defaultBundle, null, "", props);
        this.i18nMap.remove("");
        Object[] locales = this.i18nMap.keySet().toArray();
        for (int i = 0; i < locales.length; ++i) {
            this.addData(fos, (PropertyResourceBundle)this.i18nMap.get(locales[i]), defaultBundle, (String)locales[i], props);
        }
    }

    private void addJavaCompatibleProperties(FileOutputStream fos) throws IOException {
        LogManager.log("Total compatible java properties : " + this.compatibleJava.size());
        LogManager.indent();
        for (int i = 0; i < this.compatibleJava.size(); ++i) {
            JavaCompatibleProperties prop = (JavaCompatibleProperties)this.compatibleJava.get(i);
            LogManager.log("... adding compatible jvm [" + i + "] : " + prop.toString());
            this.addData(fos, prop.getMinVersion(), false);
            this.addData(fos, prop.getMaxVersion(), false);
            this.addData(fos, prop.getVendor(), false);
            this.addData(fos, prop.getOsName(), false);
            this.addData(fos, prop.getOsArch(), false);
        }
        LogManager.unindent();
    }

    private void addNumber(FileOutputStream fos, long number) throws IOException {
        fos.write(Long.toString(number).getBytes());
        fos.write(0);
    }

    private void addNumber(FileOutputStream fos, long number, boolean separateBits) throws IOException {
        if (separateBits) {
            this.addNumber(fos, number % 0x100000000L);
            this.addNumber(fos, (number - number % 0x100000000L) / 0x100000000L);
        } else {
            this.addNumber(fos, number);
        }
    }

    private void addData(FileOutputStream fos, boolean isTrue) throws IOException {
        this.addNumber(fos, isTrue ? 1L : 0L);
    }

    private void addData(FileOutputStream fos, List<LauncherResource> list, Progress progress, long total) throws IOException {
        this.addNumber(fos, list.size());
        LogManager.log("... overall number of files : " + list.size());
        for (LauncherResource file : list) {
            LogManager.log("    adding file " + file.getPath());
            this.addFileSection(fos, file, progress, total);
        }
    }

    private void addData(FileOutputStream fos, List<String> strings, boolean isUnicode) throws IOException {
        this.addData(fos, strings.toArray(new String[0]), isUnicode);
    }

    private void addData(FileOutputStream fos, String[] strings, boolean isUnicode) throws IOException {
        if (strings != null) {
            this.addNumber(fos, new Integer(strings.length).longValue());
            for (String s : strings) {
                this.addData(fos, s, isUnicode);
            }
        } else {
            this.addNumber(fos, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileSection(FileOutputStream fos, LauncherResource file, Progress progress, long total) throws IOException {
        this.addNumber(fos, file.getPathType().toLong());
        String path = file.isBasedOnResource() ? file.getPathType().getPathString(ResourceUtils.getResourceFileName(file.getPath())) : file.getAbsolutePath();
        this.addData(fos, path, true);
        if (file.isBundled()) {
            this.addNumber(fos, file.getSize(), true);
            InputStream is = null;
            try {
                is = file.getInputStream();
                this.addNumber(fos, FileUtils.getCrc32(is), false);
                is.close();
                is = file.getInputStream();
                this.addData(fos, is, progress, total);
                is.close();
                is = null;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LogManager.log(e);
                    }
                }
            }
        }
    }

    private void addData(FileOutputStream fos, PropertyResourceBundle bundle, PropertyResourceBundle backupBundle, String localeName, List<String> propertiesNames) throws IOException {
        this.addData(fos, localeName, true);
        Enumeration<String> en = bundle.getKeys();
        for (int i = 0; i < propertiesNames.size(); ++i) {
            String str;
            block3: {
                str = null;
                try {
                    str = bundle.getString(propertiesNames.get(i));
                }
                catch (MissingResourceException e) {
                    if (backupBundle == null) break block3;
                    str = backupBundle.getString(propertiesNames.get(i));
                }
            }
            str = this.changeJavaPropertyCounter(str);
            this.addData(fos, str, true);
        }
    }

    private void addData(FileOutputStream fos, Version version, boolean isUnicode) throws IOException {
        this.addData(fos, version == null ? null : version.toJdkStyle(), isUnicode);
    }

    private void addData(FileOutputStream fos, String str, boolean isUnicode) throws IOException {
        if (str != null) {
            this.addString(fos, str, isUnicode);
        }
        if (isUnicode) {
            fos.write(0);
        }
        fos.write(0);
    }

    @Override
    public String getExtension() {
        return EXE_EXT;
    }

    @Override
    public String getI18NResourcePrefix() {
        return this.i18nPrefix != null ? this.i18nPrefix : DEFAULT_WINDOWS_RESOURCE_I18N;
    }

    @Override
    public String getI18NBundleBaseName() {
        return this.i18nBundleBaseName != null ? this.i18nBundleBaseName : DEFAULT_WINDOWS_RESOURCE_I18N_BUNDLE_NAME;
    }
}

