/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.netbeans.installer.Installer;
import org.netbeans.installer.utils.EngineUtils;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.NativeException;
import org.netbeans.installer.utils.helper.ApplicationDescriptor;
import org.netbeans.installer.utils.helper.EnvironmentScope;
import org.netbeans.installer.utils.helper.FilesList;
import org.netbeans.installer.utils.helper.Platform;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.utils.system.cleaner.JavaOnExitCleanerHandler;
import org.netbeans.installer.utils.system.cleaner.OnExitCleanerHandler;
import org.netbeans.installer.utils.system.cleaner.SystemPropertyOnExitCleanerHandler;
import org.netbeans.installer.utils.system.launchers.Launcher;
import org.netbeans.installer.utils.system.launchers.LauncherProperties;
import org.netbeans.installer.utils.system.launchers.LauncherResource;
import org.netbeans.installer.utils.system.shortcut.LocationType;
import org.netbeans.installer.utils.system.shortcut.Shortcut;

public abstract class NativeUtils {
    protected static boolean nativeLibraryLoaded;
    private static HashSet<File> forbiddenDeletingFiles;
    private static List<LauncherResource> uninstallerJVMs;
    private static Platform currentPlatform;
    public static final String NATIVE_RESOURCE_SUFFIX = "native/";
    public static final String NATIVE_JNILIB_RESOURCE_SUFFIX = "native/jnilib/";
    public static final String NATIVE_LAUNCHER_RESOURCE_SUFFIX = "native/launcher/";
    public static final String NATIVE_CLEANER_RESOURCE_SUFFIX = "native/cleaner/";
    private static OnExitCleanerHandler cleanerHandler;
    public static final int FA_MODE_SET = 1;
    public static final int FA_MODE_ADD = 2;
    public static final int FA_MODE_REMOVE = 4;

    protected abstract Platform getPlatform();

    public final Platform getCurrentPlatform() {
        if (currentPlatform == null) {
            currentPlatform = this.getPlatform();
        }
        return currentPlatform;
    }

    protected NativeUtils() {
    }

    public abstract boolean isCurrentUserAdmin() throws NativeException;

    public abstract File getDefaultApplicationsLocation() throws NativeException;

    public abstract long getFreeSpace(File var1) throws NativeException;

    public abstract boolean isPathValid(String var1);

    public abstract boolean isUNCPath(String var1);

    public File getRoot(File file) {
        File parent = file;
        while (parent.getParentFile() != null) {
            parent = parent.getParentFile();
        }
        return parent;
    }

    public abstract File getShortcutLocation(Shortcut var1, LocationType var2) throws NativeException;

    public abstract File createShortcut(Shortcut var1, LocationType var2) throws NativeException;

    public abstract void removeShortcut(Shortcut var1, LocationType var2, boolean var3) throws NativeException;

    public void addUninstallerJVM(LauncherResource jvm) {
        if (jvm != null && !uninstallerJVMs.contains(jvm)) {
            uninstallerJVMs.add(jvm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Launcher createUninstaller(ApplicationDescriptor descriptor, boolean uninstall, Progress progress) throws IOException {
        LogManager.log("creating uninstaller...");
        File engine = new File(descriptor.getInstallPath(), "uninstall.jar");
        try {
            EngineUtils.cacheEngine(engine, new Progress());
            LauncherProperties props = new LauncherProperties();
            props.addJVM(new LauncherResource(false, SystemUtils.getCurrentJavaHome()));
            for (LauncherResource jvm : uninstallerJVMs) {
                props.addJVM(jvm);
            }
            props.addJar(new LauncherResource(true, engine));
            props.setJvmArguments(new String[]{"-Xmx256m", "-Xms64m", "-Dnbi.local.directory.path=" + Installer.getInstance().getLocalDirectory()});
            props.setMainClass(EngineUtils.getEngineMainClass().getName());
            if (uninstall) {
                props.setAppArguments(descriptor.getUninstallCommand());
                props.setOutput(new File(descriptor.getInstallPath(), "uninstall"), true);
            } else {
                props.setAppArguments(descriptor.getModifyCommand());
                props.setOutput(new File(descriptor.getInstallPath(), "modify-install"), true);
            }
            Launcher launcher = SystemUtils.createLauncher(props, progress);
            return launcher;
        }
        finally {
            FileUtils.deleteFile(engine);
        }
    }

    public abstract boolean openBrowser(URI var1);

    public abstract boolean isBrowseSupported();

    public abstract FilesList addComponentToSystemInstallManager(ApplicationDescriptor var1) throws NativeException;

    public abstract void removeComponentFromSystemInstallManager(ApplicationDescriptor var1) throws NativeException;

    public abstract String getEnvironmentVariable(String var1, EnvironmentScope var2, boolean var3) throws NativeException;

    public abstract void setEnvironmentVariable(String var1, String var2, EnvironmentScope var3, boolean var4) throws NativeException;

    public abstract List<File> findIrrelevantFiles(File var1) throws IOException;

    public abstract List<File> findExecutableFiles(File var1) throws IOException;

    public abstract void correctFilesPermissions(File var1) throws IOException;

    public abstract void setPermissions(File var1, int var2, int var3) throws IOException;

    public abstract int getPermissions(File var1) throws IOException;

    public boolean checkFileAccess(File file, boolean isReadNotModify) throws NativeException {
        return true;
    }

    public final void addDeleteOnExitFile(File file) {
        this.getDeleteOnExitHandler().addDeleteOnExitFile(file);
    }

    public final void removeDeleteOnExitFile(File file) {
        this.getDeleteOnExitHandler().removeDeleteOnExitFile(file);
    }

    protected OnExitCleanerHandler newDeleteOnExitCleanerHandler() {
        return new JavaOnExitCleanerHandler();
    }

    protected OnExitCleanerHandler getDeleteOnExitHandler() {
        if (cleanerHandler == null) {
            if (SystemPropertyOnExitCleanerHandler.isSet()) {
                cleanerHandler = new SystemPropertyOnExitCleanerHandler();
            } else {
                cleanerHandler = this.newDeleteOnExitCleanerHandler();
                Runtime.getRuntime().addShutdownHook(cleanerHandler);
            }
        }
        return cleanerHandler;
    }

    public abstract List<File> getFileSystemRoots(String ... var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadNativeLibrary(String path) throws NativeException {
        block19: {
            LogManager.logIndent("loading jni library");
            LogManager.log("library resource path: " + path);
            try {
                if (path == null) break block19;
                File tempDir = SystemUtils.getTempDirectory();
                if (!tempDir.exists() && !tempDir.mkdirs()) {
                    throw new NativeException("Cannot create temporary directory " + tempDir.getAbsolutePath());
                }
                File file = null;
                try {
                    file = FileUtils.createTempFile(tempDir);
                }
                catch (IOException e) {
                    throw new NativeException("Cannot create temporary file for native library at " + tempDir.getAbsolutePath(), e);
                }
                InputStream input = this.getClass().getClassLoader().getResourceAsStream(path);
                if (input == null) {
                    throw new NativeException("Cannot find native library at resource " + path);
                }
                try {
                    LogManager.log("library file path: " + file.getAbsolutePath());
                    FileUtils.writeFile(file, input);
                }
                catch (IOException e) {
                    file.delete();
                    throw new NativeException("Cannot write native library (" + path + ") to temporary file " + file.getAbsolutePath(), e);
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (IOException e) {}
                }
                try {
                    System.load(file.getAbsolutePath());
                    LogManager.log("... successfully loaded the library");
                    nativeLibraryLoaded = true;
                    this.addDeleteOnExitFile(file);
                }
                catch (UnsatisfiedLinkError e) {
                    LogManager.log("... failed loading the library", (Throwable)e);
                    String message = e.getMessage();
                    if (message != null && message.contains("failed to map segment from shared object")) {
                        throw new NativeException("Could not load library from temporary directory which is located on the filesystem mounted with \"noexec\" option:\n" + tempDir.getAbsolutePath() + "\n\nTry to use other temporary directory.", e);
                    }
                    throw new NativeException("Cannot load native library from path: " + path, e);
                }
            }
            finally {
                LogManager.unindent();
            }
        }
    }

    protected void initializeForbiddenFiles(String ... filepaths) {
        for (String path : filepaths) {
            File file;
            if (path == null || !(file = new File(path)).exists() || forbiddenDeletingFiles.contains(file)) continue;
            forbiddenDeletingFiles.add(file);
        }
    }

    public boolean isDeletingAllowed(File file) {
        return !forbiddenDeletingFiles.contains(file);
    }

    static {
        forbiddenDeletingFiles = new HashSet();
        uninstallerJVMs = new ArrayList<LauncherResource>();
    }
}

