/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.tools.ant.module.api.support.AntScriptUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class BasicProjectInfoPanel
extends JPanel
implements HelpCtx.Provider {
    private DocumentListener documentListener;
    private ChangeListener listener;
    private boolean antScriptTouched = false;
    private boolean projectFolderTouched = false;
    private boolean projectNameTouched = false;
    private boolean antScriptValidityChecked;
    private boolean ignoreEvent = false;
    private JTextField antScript;
    private JButton browseAntScript;
    private JButton browseProjectFolder;
    private JButton browseProjectLocation;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JTextArea jTextArea2;
    private JTextField projectFolder;
    private JTextField projectLocation;
    private JTextField projectName;

    public BasicProjectInfoPanel(String projectLocation, String antScript, String projectName, String projectFolder, ChangeListener listener) {
        this.initComponents();
        this.projectLocation.setText(projectLocation);
        this.antScript.setText(antScript);
        this.projectName.setText(projectName);
        this.projectFolder.setText(projectFolder);
        this.listener = listener;
        this.documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                BasicProjectInfoPanel.this.update(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                BasicProjectInfoPanel.this.update(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BasicProjectInfoPanel.this.update(e);
            }
        };
        this.projectLocation.getDocument().addDocumentListener(this.documentListener);
        this.antScript.getDocument().addDocumentListener(this.documentListener);
        this.projectName.getDocument().addDocumentListener(this.documentListener);
        this.projectFolder.getDocument().addDocumentListener(this.documentListener);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(BasicProjectInfoPanel.class);
    }

    public File getProjectLocation() {
        return this.getAsFile(this.projectLocation.getText());
    }

    public File getAntScript() {
        return this.getAsFile(this.antScript.getText());
    }

    public String getProjectName() {
        return this.projectName.getText();
    }

    public File getProjectFolder() {
        return this.getAsFile(this.projectFolder.getText());
    }

    public String[] getError() {
        if (this.projectLocation.getText().length() == 0) {
            return new String[]{NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_1"), "WizardPanel_infoMessage"};
        }
        if (!this.getProjectLocation().exists()) {
            return new String[]{NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_2"), "WizardPanel_errorMessage"};
        }
        if (this.antScript.getText().length() == 0) {
            return new String[]{NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_3"), "WizardPanel_infoMessage"};
        }
        if (!this.getAntScript().exists()) {
            return new String[]{NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_4"), "WizardPanel_errorMessage"};
        }
        if (!this.antScriptValidityChecked) {
            FileObject fo = FileUtil.toFileObject((File)this.getAntScript());
            if (fo != null) {
                try {
                    AntScriptUtils.getCallableTargetNames((FileObject)fo);
                    this.antScriptValidityChecked = true;
                }
                catch (IOException x) {
                    // empty catch block
                }
            }
            if (!this.antScriptValidityChecked) {
                return new String[]{NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_5"), "WizardPanel_errorMessage"};
            }
        }
        if (this.getProjectName().length() == 0) {
            return new String[]{NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_6"), "WizardPanel_infoMessage"};
        }
        if (this.projectFolder.getText().length() == 0) {
            return new String[]{NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_7"), "WizardPanel_infoMessage"};
        }
        if (this.getAsFile(this.projectFolder.getText() + File.separatorChar + "nbproject").exists()) {
            return new String[]{NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_8"), "WizardPanel_errorMessage"};
        }
        File prjFolder = this.getProjectFolder();
        assert (prjFolder != null);
        Project p = FileOwnerQuery.getOwner((URI)Utilities.toURI((File)prjFolder));
        if (p != null && prjFolder.equals(FileUtil.toFile((FileObject)p.getProjectDirectory()))) {
            ProjectInformation pi = (ProjectInformation)p.getLookup().lookup(ProjectInformation.class);
            String displayName = pi == null ? "" : pi.getDisplayName();
            return new String[]{MessageFormat.format(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_9"), displayName), "WizardPanel_errorMessage"};
        }
        File prjLocation = this.getProjectLocation();
        assert (prjLocation != null);
        p = FileOwnerQuery.getOwner((URI)Utilities.toURI((File)prjLocation));
        if (p != null && prjLocation.equals(FileUtil.toFile((FileObject)p.getProjectDirectory()))) {
            ProjectInformation pi = (ProjectInformation)p.getLookup().lookup(ProjectInformation.class);
            String displayName = pi == null ? "" : pi.getDisplayName();
            return new String[]{MessageFormat.format(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_Error_10"), displayName), "WizardPanel_errorMessage"};
        }
        return null;
    }

    private File getAsFile(String filename) {
        return FileUtil.normalizeFile((File)new File(filename));
    }

    private void update(DocumentEvent e) {
        if (this.ignoreEvent) {
            return;
        }
        this.ignoreEvent = true;
        if (this.projectLocation.getDocument() == e.getDocument()) {
            this.antScriptValidityChecked = false;
            this.updateAntScriptLocation();
            this.updateProjectName();
            this.updateProjectFolder();
        }
        if (this.antScript.getDocument() == e.getDocument()) {
            this.antScriptValidityChecked = false;
            this.updateProjectName();
        }
        this.ignoreEvent = false;
        if (this.projectFolder.getDocument() == e.getDocument()) {
            boolean bl = this.projectFolderTouched = !"".equals(this.projectFolder.getText());
        }
        if (this.antScript.getDocument() == e.getDocument()) {
            boolean bl = this.antScriptTouched = !"".equals(this.antScript.getText());
        }
        if (this.projectName.getDocument() == e.getDocument()) {
            this.projectNameTouched = !"".equals(this.projectName.getText());
        }
        this.listener.stateChanged(null);
    }

    private boolean isValidProjectLocation() {
        return this.getProjectLocation().exists() && this.getProjectLocation().isDirectory() && this.projectLocation.getText().length() > 0 && !this.projectLocation.getText().endsWith(":");
    }

    private void updateAntScriptLocation() {
        File as;
        if (this.antScriptTouched) {
            return;
        }
        if (this.isValidProjectLocation() && (as = new File(this.getProjectLocation().getAbsolutePath() + File.separatorChar + "build.xml")).exists()) {
            this.antScript.setText(as.getAbsolutePath());
            return;
        }
        this.antScript.setText("");
    }

    private void updateProjectName() {
        File as;
        if (this.projectNameTouched) {
            return;
        }
        if (this.getAntScript().exists() && (as = new File(this.getAntScript().getAbsolutePath())).exists()) {
            FileObject fo = FileUtil.toFileObject((File)as);
            assert (fo != null) : as;
            String name = AntScriptUtils.getAntScriptName((FileObject)fo);
            if (name != null) {
                this.projectName.setText(name);
                return;
            }
        }
        this.projectName.setText("");
    }

    private void updateProjectFolder() {
        if (this.projectFolderTouched) {
            return;
        }
        if (this.isValidProjectLocation()) {
            this.projectFolder.setText(this.getProjectLocation().getAbsolutePath());
        } else {
            this.projectFolder.setText("");
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.antScript = new JTextField();
        this.projectName = new JTextField();
        this.projectFolder = new JTextField();
        this.browseAntScript = new JButton();
        this.browseProjectFolder = new JButton();
        this.projectLocation = new JTextField();
        this.jLabel6 = new JLabel();
        this.browseProjectLocation = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanel2 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jTextArea2 = new JTextArea();
        this.setPreferredSize(new Dimension(400, 360));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_jLabel1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_jLabel1"));
        this.jLabel2.setLabelFor(this.antScript);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_jLabel2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_jLabel2"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_jLabel3"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(16, 0, 10, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_jLabel3"));
        this.jLabel4.setLabelFor(this.projectName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_jLabel4"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_jLabel4"));
        this.jLabel5.setLabelFor(this.projectFolder);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_jLabel5"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_jLabel5"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.add((Component)this.antScript, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.projectName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.add((Component)this.projectFolder, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseAntScript, (String)NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"BTN_BasicProjectInfoPanel_browseAntScript"));
        this.browseAntScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicProjectInfoPanel.this.browseAntScriptActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.browseAntScript, gridBagConstraints);
        this.browseAntScript.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_browseAntScript"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseProjectFolder, (String)NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"BTN_BasicProjectInfoPanel_browseProjectFolder"));
        this.browseProjectFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicProjectInfoPanel.this.browseProjectFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.browseProjectFolder, gridBagConstraints);
        this.browseProjectFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_browseProjectFolder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.projectLocation, gridBagConstraints);
        this.jLabel6.setLabelFor(this.projectLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_BasicProjectInfoPanel_jLabel6"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel6.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_jLabel6"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseProjectLocation, (String)NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"BTN_BasicProjectInfoPanel_browseProjectLocation"));
        this.browseProjectLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicProjectInfoPanel.this.browseProjectLocationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.browseProjectLocation, gridBagConstraints);
        this.browseProjectLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSD_BasicProjectInfoPanel_browseProjectLocation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 10, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Label.disabledForeground")));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel7.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/ant/freeform/resources/alert_32.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 8, 8, 0);
        this.jPanel2.add((Component)this.jLabel7, gridBagConstraints);
        this.jTextArea2.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setText(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"Freeform_Warning_Message"));
        this.jTextArea2.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 10, 4, 4);
        this.jPanel2.add((Component)this.jTextArea2, gridBagConstraints);
        this.jTextArea2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSN_Freeform_Warning_Message"));
        this.jTextArea2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"ACSD_Freeform_Warning_Message"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void browseProjectLocationActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        if (this.projectLocation.getText().length() > 0 && this.getProjectLocation().exists()) {
            chooser.setSelectedFile(this.getProjectLocation());
        } else {
            chooser.setSelectedFile(ProjectChooser.getProjectsFolder());
        }
        chooser.setDialogTitle(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_Browse_Location"));
        if (0 == chooser.showOpenDialog(this)) {
            File projectLoc = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.projectLocation.setText(projectLoc.getAbsolutePath());
        }
    }

    private void browseProjectFolderActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        if (this.projectFolder.getText().length() > 0 && this.getProjectFolder().exists()) {
            chooser.setSelectedFile(this.getProjectFolder());
        } else if (this.projectLocation.getText().length() > 0 && this.getProjectLocation().exists()) {
            chooser.setSelectedFile(this.getProjectLocation());
        } else {
            chooser.setSelectedFile(ProjectChooser.getProjectsFolder());
        }
        chooser.setDialogTitle(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_Browse_Project_Folder"));
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.projectFolder.setText(projectDir.getAbsolutePath());
        }
    }

    private void browseAntScriptActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(0);
        if (this.antScript.getText().length() > 0 && this.getAntScript().exists()) {
            chooser.setSelectedFile(this.getAntScript());
        } else if (this.projectLocation.getText().length() > 0 && this.getProjectLocation().exists()) {
            chooser.setSelectedFile(this.getProjectLocation());
        } else {
            chooser.setSelectedFile(ProjectChooser.getProjectsFolder());
        }
        chooser.setDialogTitle(NbBundle.getMessage(BasicProjectInfoPanel.class, (String)"LBL_Browse_Build_Script"));
        if (0 == chooser.showOpenDialog(this)) {
            File script = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.antScript.setText(script.getAbsolutePath());
        }
    }
}

