/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.wizard;

import com.sun.javacard.AID;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.javacard.api.PlatformAndDevicePanel;
import org.netbeans.modules.javacard.common.Utils;
import org.netbeans.modules.javacard.project.JCProjectProperties;
import org.netbeans.modules.javacard.spi.Card;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.netbeans.modules.javacard.spi.PlatformAndDeviceProvider;
import org.netbeans.modules.javacard.spi.ProjectKind;
import org.netbeans.modules.javacard.wizard.ProjectDefinitionWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class ProjectDefinitionPanel
extends JPanel
implements DocumentListener,
FocusListener,
LookupListener,
ActionListener {
    private final ChangeSupport supp = new ChangeSupport((Object)this);
    private final ProjectKind kind;
    private final Lookup.Result<JavacardPlatform> platformRes;
    private final Lookup.Result<Card> serverRes;
    private JButton browseButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JPanel gridbagSludge;
    private JLabel jLabel1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextField packageNameTextField;
    private PlatformAndDevicePanel platformAndDevicePanel1;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JTextField servletMappingField;
    private JLabel servletMappingLabel;
    private JTextField webContextPathField;
    private JLabel webContextPathLabel;
    private static final String PREF_LAST_PACKAGE = "package";
    boolean dontUpdateWcp;
    boolean dontUpdateServletMapping;
    boolean inUpdate;

    public ProjectDefinitionPanel(ProjectDefinitionWizardPanel panel) {
        String key;
        this.kind = panel.kind();
        this.initComponents();
        this.projectNameTextField.setText(this.kind.prototypeProjectName());
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        this.packageNameTextField.getDocument().addDocumentListener(this);
        this.webContextPathField.getDocument().addDocumentListener(this);
        this.servletMappingField.getDocument().addDocumentListener(this);
        JCProjectProperties props = new JCProjectProperties();
        props.setPlatformName("javacard_default");
        this.platformAndDevicePanel1.setPlatformAndCard((PlatformAndDeviceProvider)props);
        switch (this.kind) {
            case CLASSIC_APPLET: 
            case EXTENDED_APPLET: {
                key = "APPLET_AID";
                break;
            }
            default: {
                key = "WEB_CONTEXT_PATH";
            }
        }
        this.webContextPathLabel.setText(NbBundle.getMessage(ProjectDefinitionPanel.class, (String)key));
        for (Component c : this.getComponents()) {
            if (!(c instanceof JTextComponent)) continue;
            c.addFocusListener(this);
        }
        this.inUpdate = false;
        this.dontUpdateWcp = false;
        this.serverRes = this.platformAndDevicePanel1.getLookup().lookupResult(Card.class);
        this.platformRes = this.platformAndDevicePanel1.getLookup().lookupResult(JavacardPlatform.class);
        this.serverRes.addLookupListener((LookupListener)this);
        this.platformRes.addLookupListener((LookupListener)this);
        this.serverRes.allInstances();
        this.platformRes.allInstances();
        HelpCtx.setHelpIDString((JComponent)this, (String)"org.netbeans.modules.javacard.CreateProject");
    }

    public String getProjectName() {
        return this.projectNameTextField.getText();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.packageNameTextField = new JTextField();
        this.webContextPathLabel = new JLabel();
        this.webContextPathField = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.servletMappingLabel = new JLabel();
        this.servletMappingField = new JTextField();
        this.gridbagSludge = new JPanel();
        this.platformAndDevicePanel1 = new PlatformAndDevicePanel();
        this.setLayout(new GridBagLayout());
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"PROJECT_NAME"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.add((Component)this.projectNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.projectNameTextField, gridBagConstraints);
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"PROJECT_LOCATION"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.projectLocationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 150;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.projectLocationTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"BROWSE"));
        this.browseButton.setActionCommand("BROWSE");
        this.browseButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"PROJECT_FOLDER"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.createdFolderLabel, gridBagConstraints);
        this.createdFolderTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.createdFolderTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 5, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.packageNameTextField.setText(NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"yourpackagename"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.packageNameTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.webContextPathLabel, (String)NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"WEB_CONTEXT_PATH"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.webContextPathLabel, gridBagConstraints);
        this.webContextPathField.setText(NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"INITIAL_PATH"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 120;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.webContextPathField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.add((Component)this.jSeparator2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"BASE_PACKAGE_NAME"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.servletMappingLabel.setLabelFor(this.servletMappingField);
        Mnemonics.setLocalizedText((JLabel)this.servletMappingLabel, (String)"Servlet Mapping");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.servletMappingLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.servletMappingField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.gridbagSludge, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.platformAndDevicePanel1, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.browseButton) {
            this.browseButtonActionPerformed(evt);
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if ("BROWSE".equals(command)) {
            File f;
            String title = NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"Select_Project_Location");
            JFileChooser chooser = new FileChooserBuilder(ProjectDefinitionPanel.class).setTitle(title).setDirectoriesOnly(true).createFileChooser();
            chooser.setMultiSelectionEnabled(true);
            String path = this.projectLocationTextField.getText();
            if (path.length() > 0 && (f = new File(path)).exists()) {
                chooser.setSelectedFile(f);
            }
            if (0 == chooser.showOpenDialog(this)) {
                File projectDir = chooser.getSelectedFile();
                this.projectLocationTextField.setText(FileUtil.normalizeFile((File)projectDir).getAbsolutePath());
            }
            this.fireChange();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    public boolean valid(WizardDescriptor wizardDescriptor) {
        if (wizardDescriptor != null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        }
        return this.areProjectNameAndLocationValid(wizardDescriptor) && this.isPlatformSelectedOK(wizardDescriptor) && this.isJCServerInstanceSelectedOK(wizardDescriptor) && this.isBasePackageNameValid(wizardDescriptor) && this.isDisplayNameValid(wizardDescriptor) && this.isWebContextPathValid(wizardDescriptor) && this.isSrcTgzURLValid(wizardDescriptor) && this.isServletMappingValid(wizardDescriptor) && this.isAppletAIDValid(wizardDescriptor) && this.isTargetFolderValid(wizardDescriptor);
    }

    private boolean isAppletAIDValid(WizardDescriptor wizardDescriptor) {
        if (!this.kind.isApplet()) {
            return true;
        }
        String s = this.webContextPathField.getText();
        if (s.trim().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"ERR_EMPTY_AID"));
            return false;
        }
        try {
            AID.parse((String)s);
        }
        catch (IllegalArgumentException e) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    private boolean isServletMappingValid(WizardDescriptor wizardDescriptor) {
        if (this.kind != ProjectKind.WEB) {
            return true;
        }
        if (this.servletMappingField.getText().trim().length() == 0 || !this.servletMappingField.getText().startsWith("/")) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"LBL_servletMappingInvalid"));
            return false;
        }
        return true;
    }

    private boolean areProjectNameAndLocationValid(WizardDescriptor wizardDescriptor) {
        File destFolder;
        File projLoc;
        ResourceBundle bundle = NbBundle.getBundle(ProjectDefinitionPanel.class);
        if (this.projectNameTextField.getText().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)bundle.getString("LBL_project_name_invalid"));
            return false;
        }
        String location = this.projectLocationTextField.getText();
        if (location.length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)bundle.getString("LBL_project_folder_invalid"));
            return false;
        }
        File f = FileUtil.normalizeFile((File)new File(location).getAbsoluteFile());
        if (!f.exists()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)bundle.getString("LBL_project_location_not_exist"));
        } else if (!f.isDirectory()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)bundle.getString("LBL_project_folder_invalid"));
            return false;
        }
        for (projLoc = destFolder = FileUtil.normalizeFile((File)new File(this.createdFolderTextField.getText()).getAbsoluteFile()); projLoc != null && !projLoc.exists(); projLoc = projLoc.getParentFile()) {
        }
        if (projLoc == null || !projLoc.canWrite()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)bundle.getString("LBL_project_folder_cannot_create"));
            return false;
        }
        if (FileUtil.toFileObject((File)projLoc) == null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)bundle.getString("LBL_project_folder_path_invalid"));
            return false;
        }
        File[] kids = destFolder.listFiles();
        if (destFolder.exists() && kids != null && kids.length > 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)bundle.getString("LBL_project_folder_exists"));
            return false;
        }
        return true;
    }

    private boolean isBasePackageNameValid(WizardDescriptor wizardDescriptor) {
        String packageName = this.packageNameTextField.getText();
        try {
            ProjectDefinitionPanel.parsePackageName(packageName);
        }
        catch (IllegalArgumentException e) {
            if (wizardDescriptor != null) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"LBL_package_name_invalid"));
            }
            return false;
        }
        return true;
    }

    private boolean isDisplayNameValid(WizardDescriptor wizardDescriptor) {
        return true;
    }

    private boolean isWebContextPathValid(WizardDescriptor wizardDescriptor) {
        if (this.kind != ProjectKind.WEB) {
            return true;
        }
        String val = this.webContextPathField.getText();
        if (val.length() < 2 || val.charAt(0) != '/') {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"LBL_web_context_path_invalid"));
            return false;
        }
        for (int i = 0; i < val.length(); ++i) {
            if (!Character.isWhitespace(val.charAt(i))) continue;
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"LBL_web_context_path_invalid_Spaces"));
            return false;
        }
        return true;
    }

    private boolean isTargetFolderValid(WizardDescriptor wizardDescriptor) {
        boolean result = new File(this.projectLocationTextField.getText()).exists();
        if (!result) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"ERR_BAD_LOCATION", (Object)this.projectLocationTextField.getText()));
        }
        return result;
    }

    private boolean isSrcTgzURLValid(WizardDescriptor wizardDescriptor) {
        return true;
    }

    private boolean isJCServerInstanceSelectedOK(WizardDescriptor wizardDescriptor) {
        boolean result;
        boolean bl = result = this.serverRes.allItems().size() > 0;
        if (!result) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"NO_SERVER_SELECTED"));
            return false;
        }
        return true;
    }

    private boolean isPlatformSelectedOK(WizardDescriptor wizardDescriptor) {
        boolean result;
        boolean bl = result = this.platformRes.allItems().size() > 0;
        if (!result) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"NO_PLATFORM_SELECTED"));
            return false;
        }
        JavacardPlatform p = (JavacardPlatform)this.platformRes.allInstances().iterator().next();
        if (!p.isValid()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"PLATFORM_INVALID", (Object)p.getDisplayName()));
            return false;
        }
        if (this.kind != null && !p.supportedProjectKinds().contains(this.kind)) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"PLATFORM_DOES_NOT_SUPPORT_PROJECT_KIND", (Object)p.getDisplayName(), (Object)this.kind.getDisplayName()));
            return false;
        }
        return true;
    }

    public void store(WizardDescriptor d) {
        boolean invalidPlatform;
        String name = this.projectNameTextField.getText().trim();
        String folder = this.createdFolderTextField.getText().trim();
        Collection platformColl = this.platformRes.allInstances();
        if (!platformColl.isEmpty()) {
            JavacardPlatform platform = (JavacardPlatform)platformColl.iterator().next();
            invalidPlatform = !platform.isValid();
            d.putProperty("platform.active", (Object)platform.getSystemName());
            d.putProperty("activeplatform", (Object)platform.getSystemName());
            boolean usePreprocessor = Utils.canUseCompilationPreprocessor((SpecificationVersion)platform.getJavacardVersion()) && (this.kind == ProjectKind.CLASSIC_APPLET || this.kind == ProjectKind.CLASSIC_LIBRARY);
            d.putProperty("compile.use.preprocessor", (Object)String.valueOf(usePreprocessor));
        } else {
            invalidPlatform = true;
            d.putProperty("platform.active", (Object)"javacard_default");
            d.putProperty("activeplatform", (Object)"javacard_default");
        }
        if (!invalidPlatform) {
            Collection cards = this.serverRes.allInstances();
            if (!cards.isEmpty()) {
                d.putProperty("active.device", (Object)((Card)cards.iterator().next()).getSystemId());
                d.putProperty("activedevice", (Object)((Card)cards.iterator().next()).getSystemId());
            }
        } else {
            d.putProperty("active.device", (Object)"Default Device");
            d.putProperty("activedevice", (Object)"Default Device");
        }
        d.putProperty("projdir", (Object)new File(folder));
        d.putProperty("projectname", (Object)name);
        d.putProperty("basepackagename", (Object)this.packageNameTextField.getText());
        d.putProperty("mainclassname", (Object)name.replaceAll("[\\p{Punct}\\s]+", "_"));
        d.putProperty("displayname", (Object)this.projectNameTextField.getText());
        switch (this.kind) {
            case CLASSIC_APPLET: 
            case EXTENDED_APPLET: {
                d.putProperty("applet_aid", (Object)this.webContextPathField.getText());
                break;
            }
            default: {
                d.putProperty("webcontextpath", (Object)this.webContextPathField.getText());
                d.putProperty("servletmapping", (Object)this.servletMappingField.getText());
            }
        }
    }

    public void read(WizardDescriptor settings) {
        this.inUpdate = true;
        String activePlatform = (String)settings.getProperty("platform.active");
        String activeDevice = (String)settings.getProperty("active.device");
        this.platformAndDevicePanel1.setPlatformAndCard(activePlatform, activeDevice);
        File projectLocation = (File)settings.getProperty("projdir");
        projectLocation = projectLocation == null || projectLocation.getParentFile() == null || !projectLocation.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : projectLocation.getParentFile();
        this.projectLocationTextField.setText(projectLocation.getAbsolutePath());
        String projectName = (String)settings.getProperty("projectname");
        if (projectName == null) {
            projectName = NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"DEFAULT_PROJECT_NAME");
        }
        this.projectNameTextField.setText(projectName);
        this.projectNameTextField.selectAll();
        String servletMapping = (String)settings.getProperty("servletmapping");
        this.servletMappingField.setText(servletMapping);
        String packageName = (String)settings.getProperty("basepackagename");
        this.packageNameTextField.setText(packageName);
        switch (this.kind) {
            case WEB: 
            case EXTENSION_LIBRARY: 
            case CLASSIC_LIBRARY: {
                this.webContextPathField.setText((String)settings.getProperty("webcontextpath"));
                break;
            }
            case CLASSIC_APPLET: 
            case EXTENDED_APPLET: {
                this.webContextPathField.setText((String)settings.getProperty("applet_aid"));
            }
        }
        if (activePlatform == null && activeDevice == null && servletMapping == null && packageName == null) {
            this.setSomeDefaults();
        }
        this.inUpdate = false;
        this.dontUpdateWcp = false;
        this.dontUpdateServletMapping = false;
        if (this.kind != ProjectKind.WEB) {
            this.remove(this.servletMappingField);
            this.remove(this.servletMappingLabel);
        }
        if (this.kind.isLibrary()) {
            this.remove(this.webContextPathField);
            this.remove(this.webContextPathLabel);
        }
    }

    private void setSomeDefaults() {
        File f;
        int i;
        String prefix = this.kind.prototypeProjectName();
        for (i = 1; i < Integer.MAX_VALUE && (f = new File(this.projectLocationTextField.getText(), prefix + i)).exists(); ++i) {
        }
        this.projectNameTextField.setText(prefix + i);
        this.packageNameTextField.setText((prefix + i).toLowerCase());
        String lastPkg = NbPreferences.forModule(ProjectDefinitionPanel.class).get(PREF_LAST_PACKAGE, null);
        if (lastPkg != null) {
            this.packageNameTextField.setText(lastPkg);
        }
        switch (this.kind) {
            case CLASSIC_APPLET: 
            case EXTENDED_APPLET: {
                this.webContextPathField.setText(Utils.generateAppletAID((String)this.packageNameTextField.getText(), (String)this.projectNameTextField.getText()).toString());
                break;
            }
            default: {
                this.webContextPathField.setText("/" + prefix.toLowerCase() + i);
            }
        }
        this.servletMappingField.setText('/' + this.projectNameTextField.getText().toLowerCase());
        this.updateOtherProperties();
    }

    public void validate(WizardDescriptor d) throws WizardValidationException {
    }

    private void documentChanged(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange("projectname", null, this.projectNameTextField.getText());
            this.updateOtherProperties();
        } else if (!(this.inUpdate || this.kind != ProjectKind.CLASSIC_APPLET && this.kind != ProjectKind.EXTENDED_APPLET || e.getDocument() != this.packageNameTextField.getDocument())) {
            this.updateOtherProperties();
        }
        if (!this.inUpdate && this.isShowing()) {
            this.maybeTurnOffAutogeneration(e);
            if (e.getDocument() == this.packageNameTextField.getDocument() && this.isBasePackageNameValid(null)) {
                NbPreferences.forModule(ProjectDefinitionPanel.class).put(PREF_LAST_PACKAGE, this.packageNameTextField.getText().trim());
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    private void maybeTurnOffAutogeneration(DocumentEvent e) {
        if (e.getDocument() == this.projectNameTextField.getDocument()) {
            return;
        }
        if (e.getDocument() == this.webContextPathField.getDocument()) {
            this.dontUpdateWcp = true;
        }
        if (e.getDocument() == this.servletMappingField.getDocument()) {
            this.dontUpdateServletMapping = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOtherProperties() {
        this.inUpdate = true;
        try {
            String proposedName;
            String projectname = this.projectNameTextField.getText();
            if (this.kind == ProjectKind.WEB && !this.dontUpdateWcp) {
                proposedName = '/' + projectname.toLowerCase();
                while (proposedName.length() > 1 && Character.isDigit(proposedName.charAt(proposedName.length() - 1))) {
                    proposedName = proposedName.substring(0, proposedName.length() - 1);
                }
                this.webContextPathField.setText(proposedName);
            } else if (this.kind.isApplet() && !this.dontUpdateWcp) {
                String packageName = this.packageNameTextField.getText();
                String className = this.projectNameTextField.getText();
                this.webContextPathField.setText(Utils.generateAppletAID((String)packageName, (String)className).toString());
            } else if (!(this.dontUpdateWcp || this.kind != ProjectKind.CLASSIC_APPLET && this.kind != ProjectKind.EXTENDED_APPLET)) {
                String proposedText = Utils.generateAppletAID((String)this.packageNameTextField.getText(), (String)projectname).toString();
                this.webContextPathField.setText(proposedText);
            }
            if (this.kind == ProjectKind.WEB && !this.dontUpdateServletMapping) {
                proposedName = "/" + projectname.toLowerCase();
                while (proposedName.length() > 1 && Character.isDigit(proposedName.charAt(proposedName.length() - 1))) {
                    proposedName = proposedName.substring(0, proposedName.length() - 1);
                }
                this.servletMappingField.setText(proposedName);
            }
        }
        finally {
            this.inUpdate = false;
        }
    }

    private void updateTexts(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.projectNameTextField.getDocument() || doc == this.projectLocationTextField.getDocument()) {
            String projectName = this.projectNameTextField.getText();
            String projectFolder = this.projectLocationTextField.getText();
            this.createdFolderTextField.setText(projectFolder + File.separatorChar + projectName);
        }
        this.fireChange();
    }

    private static String parsePackageName(String rawName) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(rawName, ".", true);
        StringBuilder packageName = new StringBuilder();
        boolean expectDelimeter = false;
        while (st.hasMoreTokens()) {
            String id = st.nextToken();
            if (expectDelimeter) {
                if (!id.equals(".")) {
                    throw new IllegalArgumentException(NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"Not_a_valid_class_name."));
                }
                expectDelimeter = false;
                continue;
            }
            expectDelimeter = true;
            if (id.length() == 0) {
                throw new IllegalArgumentException(NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"Not_a_valid_class_name."));
            }
            if (!Utilities.isJavaIdentifier((String)id)) {
                throw new IllegalArgumentException(NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"Not_a_valid_class_name."));
            }
            if (packageName.length() > 0) {
                packageName.append('.');
            }
            packageName.append(id);
        }
        if (!expectDelimeter) {
            throw new IllegalArgumentException(NbBundle.getMessage(ProjectDefinitionPanel.class, (String)"Not_a_valid_package_name."));
        }
        return packageName.toString();
    }

    public void removeChangeListener(ChangeListener arg0) {
        this.supp.removeChangeListener(arg0);
    }

    public void fireChange() {
        this.supp.fireChange();
    }

    public void addChangeListener(ChangeListener arg0) {
        this.supp.addChangeListener(arg0);
    }

    @Override
    public void focusGained(FocusEvent e) {
        ((JTextComponent)e.getComponent()).selectAll();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void resultChanged(LookupEvent arg0) {
        this.fireChange();
    }
}

