/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javacard.JCUtil;
import org.netbeans.modules.javacard.api.RunMode;
import org.netbeans.modules.javacard.common.NodeRefresher;
import org.netbeans.modules.javacard.common.Utils;
import org.netbeans.modules.javacard.project.JCCustomizerProvider;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.JCProjectProperties;
import org.netbeans.modules.javacard.project.customizer.ClassicAppletProjectProperties;
import org.netbeans.modules.javacard.spi.Card;
import org.netbeans.modules.javacard.spi.CardState;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.netbeans.modules.javacard.spi.capabilities.AntTarget;
import org.netbeans.modules.javacard.spi.capabilities.AntTargetInterceptor;
import org.netbeans.modules.javacard.spi.capabilities.CardInfo;
import org.netbeans.modules.javacard.spi.capabilities.DebugCapability;
import org.netbeans.modules.javacard.spi.capabilities.PortKind;
import org.netbeans.modules.javacard.spi.capabilities.PortProvider;
import org.netbeans.modules.javacard.spi.capabilities.StartCapability;
import org.netbeans.modules.javacard.spi.capabilities.StopCapability;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class JCProjectActionProvider
implements ActionProvider {
    private static final String[] webOrExtAppSupportedActions = new String[]{"build", "clean", "run", "debug", "rebuild", "delete", "copy", "move", "rename", "JCLoad", "JCCreate", "JCDelete", "JCUnload"};
    private static final String[] classicAppSupportedActions = new String[]{"build", "clean", "run", "debug", "rebuild", "delete", "copy", "move", "rename", "JCLoad", "JCCreate", "JCDelete", "JCUnload", "JCGenProxy"};
    private static final String[] extLibSupportedActions = new String[]{"build", "clean", "rebuild", "delete", "copy", "move", "rename", "JCLoad", "JCUnload"};
    private static final String[] classicLibSupportedActions = new String[]{"build", "clean", "rebuild", "delete", "copy", "move", "rename", "JCLoad", "JCUnload", "JCGenProxy"};
    private final Set<String> supportedActionsSet;
    private JCProject project;

    public JCProjectActionProvider(JCProject project) {
        this.project = project;
        this.supportedActionsSet = new HashSet<String>();
        this.supportedActionsSet.addAll(Arrays.asList(this.getSupportedActions()));
    }

    public String[] getSupportedActions() {
        String[] sa = null;
        sa = this.project.kind().isApplication() ? (this.project.kind().isClassic() ? classicAppSupportedActions : webOrExtAppSupportedActions) : (this.project.kind().isClassic() ? classicLibSupportedActions : extLibSupportedActions);
        return sa;
    }

    public void invokeAction(final String command, Lookup context) throws IllegalArgumentException {
        block21: {
            if ("delete".equals(command)) {
                FileObject dir = this.project.getProjectDirectory();
                DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
                if (dir.isValid()) {
                    try {
                        FileObject fo = dir.getFileObject("html");
                        if (fo != null) {
                            fo.delete();
                        }
                        if ((fo = dir.getFileObject("scripts")) != null) {
                            fo.delete();
                        }
                        if (dir.getChildren().length == 0) {
                            dir.delete();
                        }
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                }
                return;
            }
            if ("copy".equals(command)) {
                DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
                return;
            }
            if ("move".equals(command)) {
                DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
                return;
            }
            if ("rename".equals(command)) {
                DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
                return;
            }
            final boolean debug = "debug".equals(command) || "debug.single".equals(command) || "debug.stepinto".equals(command) || "debug.test.single".equals(command);
            Properties props = new Properties();
            String[] targetNames = this.getTargetNames(command, context, props);
            if (targetNames == null) {
                return;
            }
            if (targetNames.length == 0) {
                targetNames = null;
            }
            if (props.keySet().size() == 0) {
                props = null;
            }
            try {
                AntTargetInterceptor icept;
                boolean run;
                Card card;
                FileObject buildFo;
                block22: {
                    StartCapability starter;
                    buildFo = JCUtil.findBuildXml(this.project);
                    if (buildFo == null || !buildFo.isValid()) {
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JCProjectActionProvider.class, (String)"LBL_No_Build_XML_Found"), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                        break block21;
                    }
                    card = this.project.getCard();
                    boolean start = "JCCreate".equals(command) || "JCDelete".equals(command) || "JCLoad".equals(command) || "JCUnload".equals(command);
                    CardState state = card.getState();
                    CardInfo info = (CardInfo)card.getCapability(CardInfo.class);
                    if (!debug && (starter = (StartCapability)card.getCapability(StartCapability.class)) != null && start && state.isNotRunning()) {
                        try {
                            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JCProjectActionProvider.class, (String)"MSG_STARTING_SERVER", (Object)(info == null ? card.toString() : info.getDisplayName())));
                            starter.start(debug ? RunMode.DEBUG : RunMode.RUN, (Project)this.project).await();
                        }
                        catch (InterruptedException ex) {
                            if (card.getState().isRunning()) break block22;
                            String name = card.getCapability(CardInfo.class) == null ? card.toString() : ((CardInfo)card.getCapability(CardInfo.class)).getDisplayName();
                            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JCProjectActionProvider.class, (String)"MSG_WAIT_FAILED", (Object)name));
                            return;
                        }
                    }
                }
                boolean bl = run = (icept = (AntTargetInterceptor)card.getCapability(AntTargetInterceptor.class)) == null;
                if (!run) {
                    AntTarget target = AntTarget.forName((String)command);
                    run = icept.onBeforeInvokeTarget((Project)this.project, target, props);
                }
                if (run) {
                    final String[] tNames = targetNames;
                    final Properties p = props;
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                PropertyEvaluator eval;
                                String useProxiesProp;
                                OnAntProcessFinishedListener l = new OnAntProcessFinishedListener(JCProjectActionProvider.this.project.getPlatform(), card);
                                if (debug) {
                                    new DebugProxyProcessLauncher(l).run();
                                }
                                ExecutorTask task = ActionUtils.runTarget((FileObject)buildFo, (String[])tNames, (Properties)p);
                                task.addTaskListener((TaskListener)l);
                                if ("JCGenProxy".equals(command) && !Boolean.valueOf(useProxiesProp = (eval = JCProjectActionProvider.this.project.evaluator()).evaluate("{use.my.proxies}")).booleanValue()) {
                                    task.addTaskListener((TaskListener)new EnsureUseProxiesSetAfterProxyGeneration(JCProjectActionProvider.this.project));
                                }
                                task.getInputOutput().select();
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        if (!this.supportedActionsSet.contains(command)) {
            throw new IllegalArgumentException("Command not supported by Java Card project: " + command);
        }
        boolean debug = "debug".equals(command) || "debug.single".equals(command) || "debug.stepinto".equals(command) || "debug.test.single".equals(command);
        JavacardPlatform pform = this.project.getPlatform();
        Card card = this.project.getCard();
        if (this.actionRequiresValidPlatform(command)) {
            boolean result;
            boolean bl = result = pform != null && pform.isValid() && card != null && card.isValid();
            if (result && debug) {
                result &= card.getCapability(DebugCapability.class) != null;
            }
            return result;
        }
        return true;
    }

    private boolean actionRequiresValidPlatform(String command) {
        return "build".equals(command) || "debug".equals(command) || "rebuild".equals(command) || "clean".equals(command) || "debug.single".equals(command) || "debug.stepinto".equals(command) || "debug.test.single".equals(command) || "run".equals(command) || "run.single".equals(command) || "test".equals(command) || "test.single".equals(command) || "JCCreate".equals(command) || "JCDelete".equals(command) || "JCGenProxy".equals(command) || "JCLoad".equals(command) || "JCUnload".equals(command);
    }

    public String[] getTargetNames(String command, Lookup context, Properties props) {
        ArrayList<String> targets = new ArrayList<String>();
        if ("clean".equals(command)) {
            targets.add("clean");
        } else if ("build".equals(command)) {
            targets.add("build");
        } else if ("rebuild".equals(command)) {
            targets.add("clean");
            targets.add("build");
        } else if ("debug".equals(command)) {
            targets.add("run-for-debug");
        } else if ("run".equals(command)) {
            StartCapability starter;
            Card card = this.project.getCard();
            if (card == null) {
                return new String[0];
            }
            StopCapability stopper = (StopCapability)card.getCapability(StopCapability.class);
            if (stopper != null && card.getState() == CardState.RUNNING_IN_DEBUG_MODE) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JCProjectActionProvider.class, (String)"MSG_STOPPING_SERVER"));
                Condition c = stopper.stop();
                if (c != null) {
                    try {
                        c.await(30000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            if ((starter = (StartCapability)card.getCapability(StartCapability.class)) != null && card.getState().isNotRunning()) {
                Condition c = starter.start(RunMode.RUN, (Project)this.project);
                assert (c != null);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JCProjectActionProvider.class, (String)"MSG_WAIT_FOR_SERVER"));
                try {
                    c.await(30000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            targets.add("run");
        } else if ("JCLoad".equals(command)) {
            targets.add("build");
            targets.add("load-bundle");
        } else if (this.project.kind().isApplication() && "JCCreate".equals(command)) {
            targets.add("create-instance");
        } else if (this.project.kind().isApplication() && "JCDelete".equals(command)) {
            targets.add("delete-instance");
        } else if ("JCUnload".equals(command)) {
            targets.add("unload-bundle");
        } else if ("JCGenProxy".equals(command)) {
            targets.add("generate-sio-proxies");
            props.setProperty("use.my.proxies", Boolean.TRUE.toString());
            props.setProperty("src.proxies.dir", "proxies");
        }
        String[] result = targets.toArray(new String[targets.size()]);
        return result;
    }

    class OnAntProcessFinishedListener
    implements TaskListener,
    PropertyChangeListener {
        private final JavacardPlatform platform;
        private final Card card;
        private JPDADebugger debugger;
        private volatile boolean finished;

        OnAntProcessFinishedListener(JavacardPlatform platform, Card card) {
            this.platform = platform;
            this.card = card;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setDebuggerSession(JPDADebugger debugger) {
            OnAntProcessFinishedListener onAntProcessFinishedListener = this;
            synchronized (onAntProcessFinishedListener) {
                this.debugger = debugger;
            }
            if (!this.finished) {
                debugger.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            StopCapability stopper;
            String name = evt.getPropertyName();
            String nv = String.valueOf(evt.getNewValue());
            if ("state".equals(name) && "4".equals(nv) && this.card.isValid() && this.card.getState().isRunning() && (stopper = (StopCapability)this.card.getCapability(StopCapability.class)) != null) {
                stopper.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopListeningToDebugger() {
            JPDADebugger de;
            OnAntProcessFinishedListener onAntProcessFinishedListener = this;
            synchronized (onAntProcessFinishedListener) {
                de = this.debugger;
            }
            if (de != null) {
                de.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void taskFinished(Task task) {
            this.finished = true;
            this.stopListeningToDebugger();
            String platformName = this.platform.getSystemName();
            CardInfo info = (CardInfo)this.card.getCapability(CardInfo.class);
            String cardName = info == null ? this.card.toString() : info.getSystemId();
            DataObject dob = Utils.findDeviceForPlatform((String)platformName, (String)cardName);
            if (dob.isValid()) {
                NodeRefresher n;
                NodeRefresher nodeRefresher = n = dob == null ? null : (NodeRefresher)dob.getLookup().lookup(NodeRefresher.class);
                if (n != null) {
                    n.refreshNode();
                }
            }
        }
    }

    static final class EnsureUseProxiesSetAfterProxyGeneration
    implements TaskListener {
        private final JCProject project;

        EnsureUseProxiesSetAfterProxyGeneration(JCProject project) {
            this.project = project;
            assert (project.kind().isClassic());
        }

        public void taskFinished(Task task) {
            JCCustomizerProvider prov = (JCCustomizerProvider)this.project.getLookup().lookup(JCCustomizerProvider.class);
            Parameters.notNull((CharSequence)"prov", (Object)prov);
            JCProjectProperties p = JCCustomizerProvider.createProjectProperties(this.project.kind(), this.project, this.project.evaluator(), this.project.getAntProjectHelper());
            if (p instanceof ClassicAppletProjectProperties) {
                ClassicAppletProjectProperties cp = (ClassicAppletProjectProperties)p;
                cp.setUseMyProxies(true);
                cp.storeProperties();
            }
        }
    }

    private final class DebugProxyProcessLauncher
    implements Runnable {
        private final OnAntProcessFinishedListener tl;

        DebugProxyProcessLauncher(OnAntProcessFinishedListener tl) {
            this.tl = tl;
        }

        @Override
        public void run() {
            Card card = JCProjectActionProvider.this.project.getCard();
            String host = "[NO_HOST]";
            int attachPort = -1;
            try {
                StartCapability starter;
                StopCapability stopper = (StopCapability)card.getCapability(StopCapability.class);
                if (card.getState().isRunning() && stopper != null) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JCProjectActionProvider.class, (String)"MSG_STOPPING_SERVER"));
                    stopper.stop().await();
                }
                if ((starter = (StartCapability)card.getCapability(StartCapability.class)) != null) {
                    Condition c = starter.start(RunMode.DEBUG, (Project)JCProjectActionProvider.this.project);
                    assert (c != null);
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JCProjectActionProvider.class, (String)"MSG_WAIT_FOR_SERVER"));
                    c.await(30000L, TimeUnit.MILLISECONDS);
                }
                if (card.getCapability(DebugCapability.class) != null && card.getCapability(PortProvider.class) != null) {
                    PortProvider p = (PortProvider)card.getCapability(PortProvider.class);
                    attachPort = p.getPort(PortKind.DEBUG_RUNTIME_TO_IDE_PROXY);
                    host = p.getHost();
                    String msg = null;
                    msg = this.waitForPort(host, attachPort);
                    if (msg != null) {
                        NotifyDescriptor.Message m = new NotifyDescriptor.Message((Object)msg);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)m);
                    }
                    JPDADebugger de = JPDADebugger.attach((String)host, (int)attachPort, (Object[])new Object[]{card.getSystemId() + " - [Debugger]", "SocketAttach", "dt_socket"});
                    this.tl.setDebuggerSession(de);
                }
            }
            catch (DebuggerStartException ex) {
                if (ex.getCause() instanceof ConnectException) {
                    StopCapability stopper = (StopCapability)card.getCapability(StopCapability.class);
                    if (stopper != null) {
                        try {
                            stopper.stop().await();
                        }
                        catch (InterruptedException ex1) {
                            Exceptions.printStackTrace((Throwable)ex1);
                        }
                    }
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JCProjectActionProvider.class, (String)"MSG_DEBUG_PORT_TIMEOUT", (Object)host, (Object)attachPort));
                }
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private String waitForPort(String host, int attachPort) {
            try {
                Thread.sleep(7000L);
            }
            catch (InterruptedException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            return null;
        }
    }
}

