/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.UIResource;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.JavaProjectGenerator;
import org.netbeans.modules.java.freeform.jdkselection.JdkConfiguration;
import org.netbeans.modules.java.freeform.ui.ProjectModel;
import org.netbeans.modules.java.freeform.ui.SourceFoldersPanel;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ClasspathPanel
extends JPanel
implements HelpCtx.Provider {
    private DefaultListModel listModel;
    private File lastChosenFile = null;
    private boolean isSeparateClasspath = true;
    private List<ProjectModel.CompilationUnitKey> compUnitsKeys;
    private boolean ignoreEvent;
    private ProjectModel model;
    private final JdkConfiguration jdkConf;
    private JButton addClasspath;
    private JList classpath;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    JComboBox javaPlatform;
    private JButton javaPlatformButton;
    private JTextArea javaPlatformIntro;
    private JLabel javaPlatformLabel;
    private JPanel javaPlatformPanel;
    private JButton moveDown;
    private JButton moveUp;
    private JButton removeClasspath;
    private JCheckBox separateClasspath;
    private JComboBox sourceFolder;

    public ClasspathPanel() {
        this.jdkConf = null;
        this.basicInit();
        this.javaPlatformPanel.setVisible(false);
    }

    ClasspathPanel(JdkConfiguration jdkConf) {
        this.jdkConf = jdkConf;
        this.basicInit();
        this.jTextArea1.setText(NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_ClasspathPanel_Explanation"));
        this.javaPlatformIntro.setBackground(this.getBackground());
        this.javaPlatformIntro.setDisabledTextColor(this.jLabel2.getForeground());
        this.refreshJavaPlatforms();
        this.javaPlatform.setRenderer(new JavaPlatformRenderer());
    }

    private void basicInit() {
        this.initComponents();
        this.jTextArea1.setBackground(this.getBackground());
        this.jTextArea1.setDisabledTextColor(this.jLabel2.getForeground());
        this.listModel = new DefaultListModel();
        this.classpath.setModel(this.listModel);
    }

    private void refreshJavaPlatforms() {
        TreeSet<JavaPlatform> platforms = new TreeSet<JavaPlatform>(new Comparator<JavaPlatform>(){
            Collator COLL = Collator.getInstance();

            @Override
            public int compare(JavaPlatform p1, JavaPlatform p2) {
                int res = this.COLL.compare(p1.getDisplayName(), p2.getDisplayName());
                if (res != 0) {
                    return res;
                }
                return System.identityHashCode(p1) - System.identityHashCode(p2);
            }
        });
        platforms.addAll(Arrays.asList(JavaPlatformManager.getDefault().getInstalledPlatforms()));
        this.javaPlatform.setModel(new DefaultComboBoxModel<JavaPlatform>(platforms.toArray(new JavaPlatform[platforms.size()])));
        JavaPlatform pf = this.jdkConf.getSelectedPlatform();
        if (pf == null) {
            pf = JavaPlatformManager.getDefault().getDefaultPlatform();
        }
        this.javaPlatform.setSelectedItem(pf);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ClasspathPanel.class);
    }

    void updateControls() {
        this.sourceFolder.removeAllItems();
        this.compUnitsKeys = this.model.createCompilationUnitKeys();
        this.isSeparateClasspath = !ProjectModel.isSingleCompilationUnit(this.compUnitsKeys);
        List<String> names = ClasspathPanel.createComboContent(this.compUnitsKeys, this.model.getEvaluator(), this.model.getNBProjectFolder());
        for (String nm : names) {
            this.sourceFolder.addItem(nm);
        }
        if (names.size() > 0) {
            this.ignoreEvent = true;
            this.sourceFolder.setSelectedIndex(0);
            this.ignoreEvent = false;
        }
        this.loadClasspath();
        boolean sepClasspath = this.model.canHaveSeparateClasspath();
        this.separateClasspath.setEnabled(sepClasspath);
        if (sepClasspath && this.isSeparateClasspath && !this.model.canCreateSingleCompilationUnit()) {
            this.separateClasspath.setEnabled(false);
        }
        this.jLabel2.setEnabled(sepClasspath && this.isSeparateClasspath);
        this.sourceFolder.setEnabled(sepClasspath && this.isSeparateClasspath);
        this.ignoreEvent = true;
        this.separateClasspath.setSelected(this.isSeparateClasspath);
        this.ignoreEvent = false;
        this.addClasspath.setEnabled(this.compUnitsKeys.size() > 0);
        this.classpath.setEnabled(this.compUnitsKeys.size() > 0);
    }

    static List<String> createComboContent(List<ProjectModel.CompilationUnitKey> compilationUnitKeys, PropertyEvaluator evaluator, File nbProjectFolder) {
        ArrayList<String> l = new ArrayList<String>();
        for (ProjectModel.CompilationUnitKey cul : compilationUnitKeys) {
            String name = cul.locations.size() == 1 ? (cul.label != null ? cul.label + " [" + SourceFoldersPanel.getLocationDisplayName(evaluator, nbProjectFolder, cul.locations.get(0)) + "]" : ClasspathPanel.convertListToString(cul.locations)) : ClasspathPanel.convertListToString(cul.locations);
            l.add(name);
        }
        return l;
    }

    private static String convertListToString(List<String> l) {
        StringBuffer sb = new StringBuffer();
        Iterator<String> it = l.iterator();
        while (it.hasNext()) {
            String s = it.next();
            sb.append(s);
            if (!it.hasNext()) continue;
            sb.append(File.pathSeparatorChar + " ");
        }
        return sb.toString();
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.addClasspath = new JButton();
        this.removeClasspath = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.classpath = new JList();
        this.jPanel1 = new JPanel();
        this.sourceFolder = new JComboBox();
        this.jLabel2 = new JLabel();
        this.moveUp = new JButton();
        this.moveDown = new JButton();
        this.jTextArea1 = new JTextArea();
        this.separateClasspath = new JCheckBox();
        this.javaPlatformPanel = new JPanel();
        this.javaPlatformIntro = new JTextArea();
        this.javaPlatformLabel = new JLabel();
        this.javaPlatform = new JComboBox();
        this.javaPlatformButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextArea2 = new JTextArea();
        this.setPreferredSize(new Dimension(275, 202));
        this.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.classpath);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_ClasspathPanel_jLabel3"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_ClasspathPanel_jLabel3"));
        Mnemonics.setLocalizedText((AbstractButton)this.addClasspath, (String)NbBundle.getMessage(ClasspathPanel.class, (String)"BTN_ClasspathPanel_addClasspath"));
        this.addClasspath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClasspathPanel.this.addClasspathActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 6, 0);
        this.add((Component)this.addClasspath, gridBagConstraints);
        this.addClasspath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_ClasspathPanel_addClasspath"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeClasspath, (String)NbBundle.getMessage(ClasspathPanel.class, (String)"BTN_ClasspathPanel_removeClasspath"));
        this.removeClasspath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClasspathPanel.this.removeClasspathActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 6, 0);
        this.add((Component)this.removeClasspath, gridBagConstraints);
        this.removeClasspath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_ClasspathPanel_removeClasspath"));
        this.classpath.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ClasspathPanel.this.classpathValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.classpath);
        this.classpath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_ClasspathPanel_classpath"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.sourceFolder.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ClasspathPanel.this.sourceFolderItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.sourceFolder, gridBagConstraints);
        this.jLabel2.setLabelFor(this.sourceFolder);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_ClasspathPanel_jLabel2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_ClasspathPanel_jLabel2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.moveUp, (String)NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_ClasspathPanel_Move_Up"));
        this.moveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClasspathPanel.this.moveUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 6, 0);
        this.add((Component)this.moveUp, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle");
        this.moveUp.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_ClasspathPanel_noveUp"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveDown, (String)NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_ClasspathPanel_Move_Down"));
        this.moveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClasspathPanel.this.moveDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.moveDown, gridBagConstraints);
        this.moveDown.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_ClasspathPanel_moveDown"));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setText(NbBundle.getMessage(ClasspathPanel.class, (String)"MSG_ClasspathPanel_jTextArea"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.jTextArea1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSN_ClasspathPanel_jTextArea"));
        this.jTextArea1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_ClasspathPanel_jTextArea"));
        this.separateClasspath.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.separateClasspath, (String)NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_ClasspathPanel_sepatateClasspath"));
        this.separateClasspath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClasspathPanel.this.separateClasspathActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.separateClasspath, gridBagConstraints);
        this.separateClasspath.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_ClasspathPanel_separateClasspath"));
        this.javaPlatformPanel.setLayout(new GridBagLayout());
        this.javaPlatformIntro.setEditable(false);
        this.javaPlatformIntro.setLineWrap(true);
        this.javaPlatformIntro.setText(NbBundle.getMessage(ClasspathPanel.class, (String)"ClasspathPanel.javaPlatformIntro"));
        this.javaPlatformIntro.setWrapStyleWord(true);
        this.javaPlatformIntro.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.javaPlatformPanel.add((Component)this.javaPlatformIntro, gridBagConstraints);
        this.javaPlatformIntro.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSN_ClasspathPanel_PlatformIntro"));
        this.javaPlatformIntro.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_ClasspathPanel_PlatformIntro"));
        this.javaPlatformLabel.setLabelFor(this.javaPlatform);
        Mnemonics.setLocalizedText((JLabel)this.javaPlatformLabel, (String)NbBundle.getMessage(ClasspathPanel.class, (String)"ClasspathPanel.javaPlatformLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.javaPlatformPanel.add((Component)this.javaPlatformLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.javaPlatformPanel.add((Component)this.javaPlatform, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.javaPlatformButton, (String)NbBundle.getMessage(ClasspathPanel.class, (String)"ClasspathPanel.javaPlatformButton"));
        this.javaPlatformButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClasspathPanel.this.javaPlatformButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.javaPlatformPanel.add((Component)this.javaPlatformButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.javaPlatformPanel, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Label.disabledForeground")));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/java/freeform/resources/alert_32.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 8, 8, 0);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.jTextArea2.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setText(NbBundle.getMessage(ClasspathPanel.class, (String)"Freeform_Warning_Message"));
        this.jTextArea2.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 10, 4, 4);
        this.jPanel2.add((Component)this.jTextArea2, gridBagConstraints);
        this.jTextArea2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSN_Freeform_Warning_Message"));
        this.jTextArea2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClasspathPanel.class, (String)"ACSD_Freeform_Warning_Message"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void javaPlatformButtonActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)this.jdkConf.getSelectedPlatform());
        this.refreshJavaPlatforms();
    }

    private void classpathValueChanged(ListSelectionEvent evt) {
        this.updateButtons();
    }

    private void separateClasspathActionPerformed(ActionEvent evt) {
        if (this.ignoreEvent) {
            return;
        }
        this.applyChanges();
        this.isSeparateClasspath = this.separateClasspath.isSelected();
        this.model.updateCompilationUnits(this.isSeparateClasspath);
        this.updateControls();
    }

    private void moveDownActionPerformed(ActionEvent evt) {
        int[] indices = this.classpath.getSelectedIndices();
        if (indices.length == 0 || indices[indices.length - 1] == this.listModel.getSize() - 1) {
            return;
        }
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            Object o = this.listModel.remove(index);
            this.listModel.add(++index, o);
            indices[i] = index;
        }
        this.classpath.setSelectedIndices(indices);
        this.applyChanges();
        this.updateButtons();
    }

    private void moveUpActionPerformed(ActionEvent evt) {
        int[] indices = this.classpath.getSelectedIndices();
        if (indices.length == 0 || indices[0] == 0) {
            return;
        }
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            Object o = this.listModel.remove(index);
            this.listModel.add(--index, o);
            indices[i] = index;
        }
        this.classpath.setSelectedIndices(indices);
        this.applyChanges();
        this.updateButtons();
    }

    private void sourceFolderItemStateChanged(ItemEvent evt) {
        if (this.ignoreEvent) {
            return;
        }
        if (evt.getStateChange() == 2) {
            int index = this.findIndex(evt.getItem());
            if (index != -1) {
                this.saveClasspath(index);
            }
        } else {
            this.loadClasspath();
        }
        this.updateButtons();
    }

    private int findIndex(Object o) {
        for (int i = 0; i < this.sourceFolder.getModel().getSize(); ++i) {
            if (!this.sourceFolder.getModel().getElementAt(i).equals(o)) continue;
            return i;
        }
        return -1;
    }

    private void saveClasspath(int index) {
        ProjectModel.CompilationUnitKey key = this.compUnitsKeys.get(index);
        JavaProjectGenerator.JavaCompilationUnit cu = this.model.getCompilationUnit(key, this.model.isTestSourceFolder(index));
        this.updateCompilationUnitCompileClasspath(cu);
    }

    private void loadClasspath() {
        int index;
        if (this.isSeparateClasspath) {
            index = this.sourceFolder.getSelectedIndex();
            if (index == -1) {
                return;
            }
        } else {
            index = 0;
        }
        ProjectModel.CompilationUnitKey key = this.compUnitsKeys.get(index);
        JavaProjectGenerator.JavaCompilationUnit cu = this.model.getCompilationUnit(key, this.model.isTestSourceFolder(index));
        this.updateJListClassPath(cu.classpath);
    }

    private void updateCompilationUnitCompileClasspath(JavaProjectGenerator.JavaCompilationUnit cu) {
        List<JavaProjectGenerator.JavaCompilationUnit.CP> cps = cu.classpath;
        if (cps != null) {
            Iterator<JavaProjectGenerator.JavaCompilationUnit.CP> it = cps.iterator();
            while (it.hasNext()) {
                JavaProjectGenerator.JavaCompilationUnit.CP cp = it.next();
                if (!cp.mode.equals("compile")) continue;
                it.remove();
            }
        }
        if (this.classpath.getModel().getSize() == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.classpath.getModel().getSize(); ++i) {
            String path = (String)this.classpath.getModel().getElementAt(i);
            File resolvedFile = PropertyUtils.resolveFile((File)this.model.getBaseFolder(), (String)path);
            if (CollocationQuery.areCollocated((File)this.model.getBaseFolder(), (File)resolvedFile)) {
                path = Util.relativizeLocation((File)this.model.getBaseFolder(), (File)this.model.getNBProjectFolder(), (File)resolvedFile);
            } else {
                File unresolvedFile = new File(path);
                if (!unresolvedFile.isAbsolute() && !this.model.getBaseFolder().equals(this.model.getNBProjectFolder())) {
                    path = "${project.dir}/" + path;
                }
            }
            sb.append(path);
            if (i + 1 >= this.classpath.getModel().getSize()) continue;
            sb.append(File.pathSeparatorChar);
        }
        if (sb.length() > 0) {
            if (cps == null) {
                cu.classpath = cps = new ArrayList<JavaProjectGenerator.JavaCompilationUnit.CP>();
            }
            JavaProjectGenerator.JavaCompilationUnit.CP cp = new JavaProjectGenerator.JavaCompilationUnit.CP();
            cp.mode = "compile";
            cp.classpath = sb.toString();
            cps.add(cp);
        }
    }

    private void updateJListClassPath(List<JavaProjectGenerator.JavaCompilationUnit.CP> cps) {
        this.listModel.removeAllElements();
        if (cps == null) {
            return;
        }
        for (JavaProjectGenerator.JavaCompilationUnit.CP cp : cps) {
            String v;
            if (!cp.mode.equals("compile") || (v = this.model.getEvaluator().evaluate(cp.classpath)) == null) continue;
            for (String path : PropertyUtils.tokenizePath((String)v)) {
                if (path == null) continue;
                String baseFolderPath = this.model.getBaseFolder().getAbsolutePath();
                if (path.startsWith(baseFolderPath)) {
                    path = path.substring(baseFolderPath.length() + 1);
                }
                this.listModel.addElement(path);
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        int[] indices = this.classpath.getSelectedIndices();
        this.removeClasspath.setEnabled(this.listModel.getSize() > 0 && indices.length != 0);
        this.moveUp.setEnabled(indices.length > 0 && indices[0] != 0);
        this.moveDown.setEnabled(indices.length > 0 && indices[indices.length - 1] != this.listModel.getSize() - 1);
    }

    private void removeClasspathActionPerformed(ActionEvent evt) {
        int[] entries = this.classpath.getSelectedIndices();
        for (int i = 0; i < entries.length; ++i) {
            this.listModel.remove(entries[i] - i);
        }
        this.applyChanges();
        this.updateButtons();
    }

    private void addClasspathActionPerformed(ActionEvent evt) {
        FileChooser chooser = new FileChooser(this.model.getBaseFolder(), null);
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(2);
        chooser.setMultiSelectionEnabled(true);
        chooser.setDialogTitle(NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_Browse_Classpath"));
        if (this.lastChosenFile != null) {
            chooser.setCurrentDirectory(this.lastChosenFile);
        } else {
            chooser.setCurrentDirectory(this.model.getBaseFolder());
        }
        SimpleFileFilter fileFilter = new SimpleFileFilter(NbBundle.getMessage(ClasspathPanel.class, (String)"LBL_ZipJarFolderFilter"), new String[]{"ZIP", "JAR"});
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter((FileFilter)fileFilter);
        if (0 == chooser.showOpenDialog((Component)this)) {
            String[] filePaths = null;
            try {
                filePaths = chooser.getSelectedPaths();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            for (String filePath : filePaths) {
                this.listModel.addElement(filePath);
                this.lastChosenFile = chooser.getCurrentDirectory();
            }
            this.applyChanges();
            this.updateButtons();
        }
    }

    private void applyChanges() {
        if (this.isSeparateClasspath) {
            if (this.sourceFolder.getSelectedIndex() != -1) {
                this.saveClasspath(this.sourceFolder.getSelectedIndex());
            }
        } else {
            this.saveClasspath(0);
        }
    }

    public void setModel(ProjectModel model) {
        this.model = model;
        this.updateControls();
    }

    private static final class JavaPlatformRenderer
    extends DefaultListCellRenderer
    implements UIResource {
        public JavaPlatformRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            this.setText(((JavaPlatform)value).getDisplayName());
            this.setIcon(null);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String description, String[] extensions) {
            this.description = description;
            this.extensions = Arrays.asList(extensions);
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            try {
                return FileUtil.isArchiveFile((URL)Utilities.toURI((File)f).toURL());
            }
            catch (MalformedURLException mue) {
                ErrorManager.getDefault().notify((Throwable)mue);
                return false;
            }
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

