/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.unit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.core.api.support.Strings;
import org.netbeans.modules.j2ee.persistence.provider.DefaultProvider;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSource;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourcePopulator;
import org.netbeans.modules.j2ee.persistence.util.PersistenceProviderComboboxHelper;
import org.netbeans.modules.j2ee.persistence.util.SourceLevelChecker;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizard;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardDescriptor;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanel;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class PersistenceUnitWizardPanelDS
extends PersistenceUnitWizardPanel
implements AncestorListener {
    private ButtonGroup buttonGroup1;
    private JLabel createPUWarningLabel;
    private JLabel datasourceLabel;
    private JRadioButton ddlCreate;
    private JRadioButton ddlDropCreate;
    private JRadioButton ddlUnkown;
    private JComboBox dsCombo;
    private JLabel errorMessage;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JCheckBox jtaCheckBox;
    private JLabel persistenceProviderLabel;
    private JComboBox providerCombo;
    private ButtonGroup tableCreationButtonGroup;
    private JLabel unitNameLabel;
    private JTextField unitNameTextField;
    private JPanel warnPanel;

    public PersistenceUnitWizardPanelDS(Project project, ChangeListener changeListener, boolean editName) {
        this(project, changeListener, editName, PersistenceUnitWizardPanel.TableGeneration.CREATE);
    }

    public PersistenceUnitWizardPanelDS(Project project, ChangeListener changeListener, boolean editName, PersistenceUnitWizardPanel.TableGeneration tg) {
        super(project);
        this.initComponents();
        this.setTableGeneration(tg);
        PersistenceProviderComboboxHelper comboHelper = new PersistenceProviderComboboxHelper(project);
        comboHelper.connect(this.providerCombo);
        this.unitNameTextField.setText(Util.getCandidateName(project));
        this.unitNameTextField.selectAll();
        this.unitNameTextField.setVisible(editName);
        this.unitNameLabel.setVisible(editName);
        this.unitNameTextField.getDocument().addDocumentListener(new ValidationListener());
        this.errorMessage.setForeground(Color.RED);
        this.updateWarning();
        this.addAncestorListener(this);
    }

    private void initLater() {
        if (ProviderUtil.isValidServerInstanceOrNone(this.project)) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.connectDatasources();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PersistenceUnitWizardPanelDS.this.connectDatasources();
                    }
                });
            }
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.initLater();
        this.removeAncestorListener(this);
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    private void setTableGeneration(PersistenceUnitWizardPanel.TableGeneration tg) {
        if (PersistenceUnitWizardPanel.TableGeneration.CREATE.equals((Object)tg)) {
            this.ddlCreate.setSelected(true);
        } else if (PersistenceUnitWizardPanel.TableGeneration.DROP_CREATE.equals((Object)tg)) {
            this.ddlDropCreate.setSelected(true);
        } else {
            this.ddlUnkown.setSelected(true);
        }
    }

    private void connectDatasources() {
        JPADataSourcePopulator dsPopulator = (JPADataSourcePopulator)this.project.getLookup().lookup(JPADataSourcePopulator.class);
        dsPopulator.connect(this.dsCombo);
        this.dsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PersistenceUnitWizardPanelDS.this.checkValidity();
            }
        });
        ((JTextComponent)this.dsCombo.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                PersistenceUnitWizardPanelDS.this.checkValidity();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PersistenceUnitWizardPanelDS.this.checkValidity();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PersistenceUnitWizardPanelDS.this.checkValidity();
            }
        });
    }

    private void checkValidity() {
        if (this.isValidPanel()) {
            this.firePropertyChange("PersistenceUnitWizardPanel_isValid", false, true);
        } else {
            this.firePropertyChange("PersistenceUnitWizardPanel_isValid", true, false);
        }
    }

    @Override
    public String getPersistenceUnitName() {
        return this.unitNameTextField.getText();
    }

    public String getDatasource() {
        return ((JTextComponent)this.dsCombo.getEditor().getEditorComponent()).getText();
    }

    @Override
    public void setPreselectedDB(String db) {
        boolean hasItem = false;
        for (int i = 0; i < this.dsCombo.getItemCount(); ++i) {
            JPADataSource ds;
            if (!(this.dsCombo.getItemAt(i) instanceof JPADataSource) || !(ds = (JPADataSource)this.dsCombo.getItemAt(i)).getJndiName().equals(db)) continue;
            hasItem = true;
            break;
        }
        this.dsCombo.setSelectedItem(db);
        this.dsCombo.setEnabled(!hasItem);
    }

    public boolean isNonDefaultProviderEnabled() {
        return !(this.providerCombo.getSelectedItem() instanceof DefaultProvider);
    }

    public String getNonDefaultProvider() {
        return ((Provider)this.providerCombo.getSelectedItem()).getProviderClass();
    }

    public boolean isJTA() {
        return this.jtaCheckBox.isEnabled() && this.jtaCheckBox.isSelected();
    }

    @Override
    public String getTableGeneration() {
        if (this.ddlCreate.isSelected()) {
            return "tableGenerationCreate";
        }
        if (this.ddlDropCreate.isSelected()) {
            return "tableGenerationDropCreate";
        }
        return "tableGenerationUnknown";
    }

    @Override
    public boolean isValidPanel() {
        try {
            if (!this.isNameValid()) {
                return false;
            }
        }
        catch (InvalidPersistenceXmlException ipx) {
            this.setErrorMessage(NbBundle.getMessage(PersistenceUnitWizardDescriptor.class, (String)"ERR_InvalidPersistenceXml", (Object)ipx.getPath()));
            return false;
        }
        return true;
    }

    private boolean isNameValid() throws InvalidPersistenceXmlException {
        return Strings.isEmpty((String)this.getPersistenceUnitName()) ? false : this.isNameUnique();
    }

    @Override
    public Provider getSelectedProvider() {
        return (Provider)this.providerCombo.getSelectedItem();
    }

    @Override
    public void setErrorMessage(String msg) {
        this.errorMessage.setText(msg);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.tableCreationButtonGroup = new ButtonGroup();
        this.unitNameLabel = new JLabel();
        this.unitNameTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.ddlCreate = new JRadioButton();
        this.ddlDropCreate = new JRadioButton();
        this.ddlUnkown = new JRadioButton();
        this.datasourceLabel = new JLabel();
        this.jtaCheckBox = new JCheckBox();
        this.dsCombo = new JComboBox();
        this.persistenceProviderLabel = new JLabel();
        this.providerCombo = new JComboBox();
        this.warnPanel = new JPanel();
        this.errorMessage = new JLabel();
        this.createPUWarningLabel = new ShyLabel();
        this.setName(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_Step1"));
        this.unitNameLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("MN_UnitName").charAt(0));
        this.unitNameLabel.setLabelFor(this.unitNameTextField);
        this.unitNameLabel.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_UnitName"));
        this.unitNameTextField.setColumns(40);
        this.unitNameTextField.setText("em");
        this.jLabel1.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_SpecifyPersistenceProvider"));
        this.jLabel2.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_TableGeneration"));
        this.tableCreationButtonGroup.add(this.ddlCreate);
        this.ddlCreate.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("CHB_Create_mnem").charAt(0));
        this.ddlCreate.setSelected(true);
        this.ddlCreate.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_Create"));
        this.ddlCreate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tableCreationButtonGroup.add(this.ddlDropCreate);
        this.ddlDropCreate.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("CHB_DropCreate_mnem").charAt(0));
        this.ddlDropCreate.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_DropCreate"));
        this.ddlDropCreate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tableCreationButtonGroup.add(this.ddlUnkown);
        this.ddlUnkown.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("CHB_None_mnem").charAt(0));
        this.ddlUnkown.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_None"));
        this.ddlUnkown.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.datasourceLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("MN_DatasourceName").charAt(0));
        this.datasourceLabel.setLabelFor(this.dsCombo);
        this.datasourceLabel.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_ServerDataSource"));
        this.jtaCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("CHB_JTA_mnem").charAt(0));
        this.jtaCheckBox.setSelected(true);
        this.jtaCheckBox.setText(NbBundle.getMessage(PersistenceUnitWizardPanelDS.class, (String)"LBL_JTA"));
        this.jtaCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.dsCombo.setEditable(true);
        this.persistenceProviderLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("MN_Provider").charAt(0));
        this.persistenceProviderLabel.setLabelFor(this.providerCombo);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle");
        this.persistenceProviderLabel.setText(bundle.getString("LBL_PersistenceProvider"));
        this.providerCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PersistenceUnitWizardPanelDS.this.providerComboItemStateChanged(evt);
            }
        });
        this.warnPanel.setLayout(new BorderLayout());
        this.errorMessage.setMinimumSize(new Dimension(10, 10));
        this.errorMessage.setPreferredSize(new Dimension(20, 20));
        this.warnPanel.add((Component)this.errorMessage, "North");
        this.createPUWarningLabel.setText(" ");
        this.createPUWarningLabel.setPreferredSize(new Dimension(4, 20));
        this.warnPanel.add((Component)this.createPUWarningLabel, "Last");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.unitNameLabel).addComponent(this.persistenceProviderLabel).addComponent(this.datasourceLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.unitNameTextField, -1, 380, Short.MAX_VALUE).addComponent(this.providerCombo, 0, 380, Short.MAX_VALUE).addComponent(this.dsCombo, 0, 380, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ddlCreate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ddlDropCreate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ddlUnkown)).addComponent(this.jtaCheckBox).addComponent(this.jLabel1).addComponent(this.warnPanel, -1, 560, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.unitNameLabel).addComponent(this.unitNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.persistenceProviderLabel).addComponent(this.providerCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.datasourceLabel).addComponent(this.dsCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jtaCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ddlCreate).addComponent(this.ddlDropCreate).addComponent(this.ddlUnkown).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.warnPanel, -1, -1, Short.MAX_VALUE).addContainerGap(128, Short.MAX_VALUE)));
        this.unitNameLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_UnitName"));
        this.unitNameTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_UnitName"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TableGeneration"));
        this.ddlCreate.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Create"));
        this.ddlDropCreate.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_DropCreate"));
        this.ddlUnkown.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_None"));
        this.datasourceLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_DatasourceName"));
        this.jtaCheckBox.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_JTA"));
        this.persistenceProviderLabel.getAccessibleContext().setAccessibleName(bundle.getString("ACSD_Provider"));
        this.persistenceProviderLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Provider"));
        this.providerCombo.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Provider"));
    }

    private void providerComboItemStateChanged(ItemEvent evt) {
        this.updateWarning();
    }

    private void updateWarning() {
        Object provObj = this.providerCombo.getSelectedItem();
        Provider prov = (Provider)(provObj instanceof Provider ? provObj : null);
        String warning = null;
        if (prov != null && "2.0".equals(ProviderUtil.getVersion(prov))) {
            if (Util.isJPAVersionSupported(this.project, "2.0")) {
                String sourceLevel = SourceLevelChecker.getSourceLevel(this.project);
                if (sourceLevel != null && sourceLevel.matches("1\\.[0-5]([^0-9].*)?")) {
                    warning = NbBundle.getMessage(PersistenceUnitWizard.class, (String)"ERR_WrongSourceLevel", (Object)sourceLevel);
                }
            } else {
                warning = NbBundle.getMessage(PersistenceUnitWizard.class, (String)"ERR_UnsupportedJpaVersion", (Object)"2.0");
            }
        }
        ImageIcon icon = null;
        if (warning != null) {
            icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/j2ee/persistence/ui/resources/warning.gif", (boolean)false);
        } else {
            warning = "  ";
        }
        this.createPUWarningLabel.setIcon(icon);
        this.createPUWarningLabel.setText(warning);
        this.createPUWarningLabel.setToolTipText(warning);
    }

    private static final class ShyLabel
    extends JLabel {
        private ShyLabel() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.width = 0;
            return size;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension size = super.getMinimumSize();
            size.width = 0;
            return size;
        }
    }

    private class ValidationListener
    implements DocumentListener {
        private ValidationListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            PersistenceUnitWizardPanelDS.this.checkValidity();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PersistenceUnitWizardPanelDS.this.checkValidity();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            PersistenceUnitWizardPanelDS.this.checkValidity();
        }
    }
}

