/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.library;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;

public class PersistenceLibrarySupport {
    public static final String VOLUME_TYPE_CLASSPATH = "classpath";
    public static final String VOLUME_TYPE_SRC = "src";
    public static final String VOLUME_TYPE_JAVADOC = "javadoc";
    public static final String LIBRARY_TYPE = "j2se";
    static final String[] VOLUME_TYPES = new String[]{"classpath", "src", "javadoc"};
    private static final String LIBRARIES_REPOSITORY = "org-netbeans-api-project-libraries/Libraries";
    private static int MAX_DEPTH = 3;
    private FileObject storage = null;
    private static PersistenceLibrarySupport instance;

    private PersistenceLibrarySupport() {
    }

    public static PersistenceLibrarySupport getDefault() {
        if (instance == null) {
            instance = new PersistenceLibrarySupport();
        }
        return instance;
    }

    public void addLibrary(LibraryImplementation library) {
        this.initStorage();
        assert (this.storage != null) : "Storage is not initialized";
        try {
            this.writeLibrary(this.storage, library);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static final FileObject createStorage() {
        try {
            return FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)LIBRARIES_REPOSITORY);
        }
        catch (IOException e) {
            return null;
        }
    }

    private synchronized void initStorage() {
        if (this.storage == null) {
            this.storage = PersistenceLibrarySupport.createStorage();
            if (this.storage == null) {
                return;
            }
        }
    }

    private void writeLibrary(final FileObject storage, final LibraryImplementation library) throws IOException {
        storage.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileObject fo = storage.createData(library.getName(), "xml");
                PersistenceLibrarySupport.writeLibraryDefinition(fo, library);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLibraryDefinition(FileObject definitionFile, LibraryImplementation library) throws IOException {
        FileLock lock = null;
        PrintWriter out = null;
        try {
            String localizingBundle;
            lock = definitionFile.lock();
            out = new PrintWriter(new OutputStreamWriter(definitionFile.getOutputStream(lock), "UTF-8"));
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.println("<!DOCTYPE library PUBLIC \"-//NetBeans//DTD Library Declaration 1.0//EN\" \"http://www.netbeans.org/dtds/library-declaration-1_0.dtd\">");
            out.println("<library version=\"1.0\">");
            out.println("\t<name>" + library.getName() + "</name>");
            out.println("\t<type>" + library.getType() + "</type>");
            String description = library.getDescription();
            if (description != null && description.length() > 0) {
                out.println("\t<description>" + description + "</description>");
            }
            if ((localizingBundle = library.getLocalizingBundle()) != null && localizingBundle.length() > 0) {
                out.println("\t<localizing-bundle>" + XMLUtil.toElementContent((String)localizingBundle) + "</localizing-bundle>");
            }
            String[] volumeTypes = VOLUME_TYPES;
            for (int i = 0; i < volumeTypes.length; ++i) {
                out.println("\t<volume>");
                out.println("\t\t<type>" + volumeTypes[i] + "</type>");
                List volume = library.getContent(volumeTypes[i]);
                if (volume != null) {
                    for (URL url : volume) {
                        out.println("\t\t<resource>" + XMLUtil.toElementContent((String)url.toExternalForm()) + "</resource>");
                    }
                }
                out.println("\t</volume>");
            }
            out.println("</library>");
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    public static boolean isValidLibraryJavadocRoot(URL rootURL) {
        assert (rootURL != null && rootURL.toExternalForm().endsWith("/"));
        FileObject root = URLMapper.findFileObject((URL)rootURL);
        if (root == null) {
            return false;
        }
        return PersistenceLibrarySupport.findIndexFolder(root, 1) != null;
    }

    private static FileObject findIndexFolder(FileObject fo, int depth) {
        if (depth > MAX_DEPTH) {
            return null;
        }
        if (fo.getFileObject("index-files", null) != null || fo.getFileObject("index-all.html", null) != null) {
            return fo;
        }
        FileObject[] children = fo.getChildren();
        for (int i = 0; i < children.length; ++i) {
            FileObject result;
            if (!children[i].isFolder() || (result = PersistenceLibrarySupport.findIndexFolder(children[i], depth + 1)) == null) continue;
            return result;
        }
        return null;
    }

    private static boolean containsClass(ClassPath cp, String className) {
        String classRelativePath = className.replace('.', '/') + ".class";
        return cp.findResource(classRelativePath) != null;
    }

    public static boolean containsService(Library library, String serviceName) {
        String serviceRelativePath = "META-INF/services/" + serviceName;
        return PersistenceLibrarySupport.containsPath(library.getContent(VOLUME_TYPE_CLASSPATH), serviceRelativePath);
    }

    public static boolean containsClass(LibraryImplementation library, String className) {
        String classRelativePath = className.replace('.', '/') + ".class";
        return PersistenceLibrarySupport.containsPath(library.getContent(VOLUME_TYPE_CLASSPATH), classRelativePath);
    }

    public static boolean containsService(LibraryImplementation library, String serviceName) {
        String serviceRelativePath = "META-INF/services/" + serviceName;
        return PersistenceLibrarySupport.containsPath(library.getContent(VOLUME_TYPE_CLASSPATH), serviceRelativePath);
    }

    private static boolean containsPath(List<URL> roots, String relativePath) {
        ClassPath cp = ClassPathSupport.createClassPath((URL[])roots.toArray(new URL[roots.size()]));
        return cp.findResource(relativePath) != null;
    }

    private static ClassPath getLibraryClassPath(Library library) {
        List urls = library.getContent(VOLUME_TYPE_CLASSPATH);
        URL[] result = urls.toArray(new URL[urls.size()]);
        for (int i = 0; i < result.length; ++i) {
            if (!FileUtil.isArchiveFile((URL)result[i])) continue;
            result[i] = FileUtil.getArchiveRoot((URL)result[i]);
        }
        return ClassPathSupport.createClassPath((URL[])result);
    }

    public static Library getLibrary(PersistenceUnit pu) {
        return PersistenceLibrarySupport.getLibrary(ProviderUtil.getProvider(pu));
    }

    public static Library getLibrary(Provider provider) {
        List<ProviderLibrary> libraries = PersistenceLibrarySupport.createLibraries(provider != null ? provider.getProviderClass() : null);
        for (ProviderLibrary each : libraries) {
            if (!provider.equals(each.getProvider())) continue;
            return each.getLibrary();
        }
        return null;
    }

    public static void addDriver(Project project, JDBCDriver driver) {
    }

    private static List<ProviderLibrary> createLibraries() {
        return PersistenceLibrarySupport.createLibraries(null);
    }

    private static List<ProviderLibrary> createLibraries(String providerClass) {
        ArrayList<ProviderLibrary> providerLibs = new ArrayList<ProviderLibrary>();
        for (Library each : LibraryManager.getDefault().getLibraries()) {
            ClassPath cp;
            Provider provider;
            if (!LIBRARY_TYPE.equals(each.getType()) || (provider = PersistenceLibrarySupport.extractProvider(cp = PersistenceLibrarySupport.getLibraryClassPath(each), providerClass)) == null || !PersistenceLibrarySupport.containsClass(cp, "javax.persistence.EntityManager")) continue;
            providerLibs.add(new ProviderLibrary(each, cp, provider));
        }
        Collections.sort(providerLibs, new Comparator<ProviderLibrary>(){

            @Override
            public int compare(ProviderLibrary l1, ProviderLibrary l2) {
                String name1 = l1.getLibrary().getDisplayName();
                String name2 = l2.getLibrary().getDisplayName();
                return name1.compareToIgnoreCase(name2);
            }
        });
        return providerLibs;
    }

    public static List<Provider> getProvidersFromLibraries() {
        ArrayList<Provider> providerLibs = new ArrayList<Provider>();
        for (ProviderLibrary each : PersistenceLibrarySupport.createLibraries()) {
            providerLibs.add(each.getProvider());
        }
        Collections.sort(providerLibs, new Comparator<Provider>(){

            @Override
            public int compare(Provider p1, Provider p2) {
                String name1 = p1.getDisplayName();
                String name2 = p2.getDisplayName();
                return name1.compareToIgnoreCase(name2);
            }
        });
        return providerLibs;
    }

    public static Library getFirstProviderLibrary() {
        List<ProviderLibrary> libraries = PersistenceLibrarySupport.createLibraries();
        if (!libraries.isEmpty()) {
            return libraries.get(0).getLibrary();
        }
        return null;
    }

    private static Provider extractProvider(ClassPath cp, String providerClass) {
        for (Provider each : ProviderUtil.getAllProviders()) {
            if (providerClass != null && !providerClass.equals(each.getProviderClass()) || !each.isOnClassPath(cp)) continue;
            return each;
        }
        return null;
    }

    private static class ProviderLibrary {
        private final Library library;
        private final ClassPath classPath;
        private final Provider provider;

        public ProviderLibrary(Library library, ClassPath classPath, Provider provider) {
            assert (library != null);
            assert (classPath != null);
            assert (provider != null);
            this.library = library;
            this.classPath = classPath;
            this.provider = provider;
        }

        public ClassPath getClassPath() {
            return this.classPath;
        }

        public Library getLibrary() {
            return this.library;
        }

        public Provider getProvider() {
            return this.provider;
        }
    }
}

