/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.core.api.support.wizard.Wizards;
import org.netbeans.modules.j2ee.persistence.api.PersistenceLocation;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DBSchemaManager;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DatabaseTablesPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.EntityClassesPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.MappingOptionsPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGeneratorProvider;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.ProgressPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPHelper;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RelatedCMPWizard
implements TemplateWizard.Iterator {
    private static final String PROP_HELPER = "wizard-helper";
    private static final String PROP_CMP = "wizard-is-cmp";
    private static final String TYPE_CMP = "cmp";
    private static final String TYPE_JPA = "jpa";
    private static final Lookup.Result<PersistenceGeneratorProvider> PERSISTENCE_PROVIDERS = Lookup.getDefault().lookupResult(PersistenceGeneratorProvider.class);
    private final String type;
    private WizardDescriptor.Panel[] panels;
    private int currentPanel = 0;
    private WizardDescriptor wizardDescriptor;
    private PersistenceGenerator generator;
    private RelatedCMPHelper helper;
    private ProgressPanel progressPanel;
    private Project project;
    private final RequestProcessor RP = new RequestProcessor(RelatedCMPWizard.class.getSimpleName(), 5);

    public static RelatedCMPWizard createForJPA() {
        return new RelatedCMPWizard(TYPE_JPA);
    }

    public static RelatedCMPWizard createForCMP() {
        return new RelatedCMPWizard(TYPE_CMP);
    }

    private static PersistenceGenerator createPersistenceGenerator(String type) {
        assert (type != null);
        Collection providers = PERSISTENCE_PROVIDERS.allInstances();
        for (PersistenceGeneratorProvider provider : providers) {
            if (!type.equals(provider.getGeneratorType())) continue;
            return provider.createGenerator();
        }
        throw new AssertionError((Object)("Could not find a persistence generator of type " + type));
    }

    static RelatedCMPHelper getHelper(WizardDescriptor wizardDescriptor) {
        return (RelatedCMPHelper)wizardDescriptor.getProperty(PROP_HELPER);
    }

    static boolean isCMP(WizardDescriptor wizardDescriptor) {
        return (Boolean)wizardDescriptor.getProperty(PROP_CMP);
    }

    public RelatedCMPWizard(String type) {
        this.type = type;
    }

    public String name() {
        return null;
    }

    public boolean hasPrevious() {
        return this.currentPanel > 0;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.currentPanel;
    }

    public boolean hasNext() {
        return this.currentPanel < this.panels.length - 1;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.currentPanel;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.currentPanel];
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private WizardDescriptor.Panel[] createPanels() {
        String wizardBundleKey = this.isCMP() ? "Templates/J2EE/RelatedCMP" : "Templates/Persistence/RelatedCMP";
        String wizardTitle = NbBundle.getMessage(RelatedCMPWizard.class, (String)wizardBundleKey);
        if (this.isCMP()) {
            return new WizardDescriptor.Panel[]{new DatabaseTablesPanel.WizardPanel(wizardTitle), new EntityClassesPanel.WizardPanel()};
        }
        return new WizardDescriptor.Panel[]{new DatabaseTablesPanel.WizardPanel(wizardTitle), new EntityClassesPanel.WizardPanel(), new MappingOptionsPanel.WizardPanel()};
    }

    private String[] createSteps() {
        if (this.isCMP()) {
            return new String[]{NbBundle.getMessage(RelatedCMPWizard.class, (String)"LBL_DatabaseTables"), NbBundle.getMessage(RelatedCMPWizard.class, (String)(this.isCMP() ? "LBL_EntityBeansLocation" : "LBL_EntityClasses"))};
        }
        return new String[]{NbBundle.getMessage(RelatedCMPWizard.class, (String)"LBL_DatabaseTables"), NbBundle.getMessage(RelatedCMPWizard.class, (String)"LBL_EntityClasses"), NbBundle.getMessage(RelatedCMPWizard.class, (String)"LBL_MappingOptions")};
    }

    private boolean isCMP() {
        return TYPE_CMP.equals(this.type);
    }

    public final void initialize(TemplateWizard wiz) {
        this.wizardDescriptor = wiz;
        this.project = Templates.getProject((WizardDescriptor)wiz);
        this.panels = this.createPanels();
        Wizards.mergeSteps((WizardDescriptor)this.wizardDescriptor, (WizardDescriptor.Panel[])this.panels, (String[])this.createSteps());
        this.generator = RelatedCMPWizard.createPersistenceGenerator(this.type);
        FileObject configFilesFolder = PersistenceLocation.getLocation((Project)this.project);
        this.helper = new RelatedCMPHelper(this.project, configFilesFolder, this.generator);
        wiz.putProperty(PROP_HELPER, (Object)this.helper);
        wiz.putProperty(PROP_CMP, (Object)this.isCMP());
        this.generator.init((WizardDescriptor)wiz);
    }

    public final void uninitialize(TemplateWizard wiz) {
        this.generator.uninit();
    }

    public Set<DataObject> instantiate(final TemplateWizard wiz) throws IOException {
        if (this.helper.isCreatePU()) {
            Util.addPersistenceUnitToProject(this.project, Util.buildPersistenceUnitUsingData(this.project, null, this.helper.getDatabaseConnection() != null ? this.helper.getTableSource().getName() : null, null, null));
        } else {
            Util.addPersistenceUnitToProject(this.project);
        }
        final String title = NbBundle.getMessage(RelatedCMPWizard.class, (String)(this.isCMP() ? "TXT_EjbGeneration" : "TXT_EntityClassesGeneration"));
        final ProgressContributor progressContributor = AggregateProgressFactory.createProgressContributor((String)title);
        final AggregateProgressHandle handle = AggregateProgressFactory.createHandle((String)title, (ProgressContributor[])new ProgressContributor[]{progressContributor}, null, null);
        this.progressPanel = new ProgressPanel();
        final JComponent progressComponent = AggregateProgressFactory.createProgressComponent((AggregateProgressHandle)handle);
        final Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    handle.start();
                    RelatedCMPWizard.this.createBeans(wiz, progressContributor);
                }
                catch (IOException ioe) {
                    Logger.getLogger("global").log(Level.INFO, null, ioe);
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ioe.getLocalizedMessage(), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
                finally {
                    RelatedCMPWizard.this.generator.uninit();
                    handle.finish();
                }
            }
        };
        SwingUtilities.invokeLater(new Runnable(){
            private boolean first = true;

            @Override
            public void run() {
                if (!this.first) {
                    RelatedCMPWizard.this.RP.post(r);
                    RelatedCMPWizard.this.progressPanel.open(progressComponent, title);
                } else {
                    this.first = false;
                    SwingUtilities.invokeLater(this);
                }
            }
        });
        if (this.helper.isCreatePU() && this.helper.getDBSchemaFile() != null) {
            PUDataObject dObj = null;
            try {
                dObj = ProviderUtil.getPUDataObject(this.project);
            }
            catch (InvalidPersistenceXmlException ex) {
                // empty catch block
            }
            if (dObj != null) {
                return Collections.singleton(dObj);
            }
        }
        return Collections.singleton(DataFolder.findFolder((FileObject)SourceGroups.getFolderForPackage((SourceGroup)this.helper.getLocation(), (String)this.helper.getPackageName())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void createBeans(TemplateWizard wiz, ProgressContributor handle) throws IOException {
        block5: {
            try {
                handle.start(1);
                handle.progress(NbBundle.getMessage(RelatedCMPWizard.class, (String)"TXT_SavingSchema"));
                this.progressPanel.setText(NbBundle.getMessage(RelatedCMPWizard.class, (String)"TXT_SavingSchema"));
                dbschemaFile = this.helper.getDBSchemaFile();
                if (dbschemaFile != null) ** GOTO lbl26
                configFilesFolder = RelatedCMPWizard.getHelper((WizardDescriptor)wiz).getConfigFilesFolder();
                if (configFilesFolder == null && !this.isCMP()) {
                    configFilesFolder = PersistenceLocation.createLocation((Project)this.project);
                }
                if (configFilesFolder != null) break block5;
                message = NbBundle.getMessage(RelatedCMPWizard.class, (String)"TXT_NoConfigFiles");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
            }
            catch (Throwable var6_7) {
                handle.finish();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RelatedCMPWizard.this.progressPanel.close();
                    }
                });
                throw var6_7;
            }
            handle.finish();
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            return;
        }
        projectName = ProjectUtils.getInformation((Project)this.project).getDisplayName();
        if (this.isCMP()) {
            dbschemaFile = DBSchemaManager.updateDBSchemas(this.helper.getSchemaElement(), this.helper.getDBSchemaFileList(), configFilesFolder, projectName);
        }
lbl26:
        // 4 sources

        extracting = NbBundle.getMessage(RelatedCMPWizard.class, (String)(this.isCMP() != false ? "TXT_ExtractingBeansAndRelationships" : "TXT_ExtractingEntityClassesAndRelationships"));
        handle.progress(extracting);
        this.progressPanel.setText(extracting);
        this.helper.buildBeans();
        pkg = SourceGroups.getFolderForPackage((SourceGroup)this.helper.getLocation(), (String)this.helper.getPackageName());
        this.generator.generateBeans(this.progressPanel, this.helper, dbschemaFile, handle);
        handle.finish();
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }
}

