/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.entitygenerator.DbSchemaEjbGenerator;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityClass;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityRelation;
import org.netbeans.modules.j2ee.persistence.entitygenerator.GeneratedTables;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DBSchemaFileList;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SelectedTables;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.Table;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableClosure;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableSource;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.UpdateType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class RelatedCMPHelper {
    private final Project project;
    private final FileObject configFilesFolder;
    private final PersistenceGenerator persistenceGen;
    private final DBSchemaFileList dbschemaFileList;
    private SchemaElement schemaElement;
    private DatabaseConnection dbconn;
    private FileObject dbschemaFile;
    private String datasourceName;
    private TableClosure tableClosure;
    private SelectedTables selectedTables;
    private SourceGroup location;
    private String packageName;
    private boolean cmpFieldsInInterface;
    private boolean generateFinderMethods;
    private boolean generateJAXBAnnotations;
    private boolean generateValidationConstraints;
    private boolean useColumnNamesInRelationships = true;
    private boolean generateUnresolvedRelationships = false;
    private boolean useDefaults = false;
    private DbSchemaEjbGenerator generator;
    private TableSource tableSource;
    private PersistenceUnit persistenceUnit;
    private boolean createPU = false;
    private boolean fullyQualifiedTableNames = false;
    private EntityRelation.FetchType fetchType = EntityRelation.FetchType.DEFAULT;
    private boolean regenTablesAttrs = false;
    private EntityRelation.CollectionType collectionType = EntityRelation.CollectionType.COLLECTION;

    public boolean isCreatePU() {
        return this.createPU;
    }

    public void setCreatePU(boolean createPU) {
        this.createPU = createPU;
    }

    public RelatedCMPHelper(Project project, FileObject configFilesFolder, PersistenceGenerator persistenceGen) {
        this.project = project;
        this.configFilesFolder = configFilesFolder;
        this.persistenceGen = persistenceGen;
        this.tableSource = TableSource.get(project);
        this.dbschemaFileList = new DBSchemaFileList(project, configFilesFolder);
    }

    public Project getProject() {
        return this.project;
    }

    FileObject getConfigFilesFolder() {
        return this.configFilesFolder;
    }

    PersistenceGenerator getPersistenceGenerator() {
        return this.persistenceGen;
    }

    public DBSchemaFileList getDBSchemaFileList() {
        return this.dbschemaFileList;
    }

    public void setTableClosure(TableClosure tableClosure) {
        assert (tableClosure != null);
        this.tableClosure = tableClosure;
    }

    public TableClosure getTableClosure() {
        return this.tableClosure;
    }

    public void setSelectedTables(SelectedTables selectedTables) {
        assert (selectedTables != null);
        this.selectedTables = selectedTables;
    }

    public void setTableSource(SchemaElement schemaElement, DatabaseConnection dbconn, String datasourceName) {
        this.schemaElement = schemaElement;
        this.dbconn = dbconn;
        this.dbschemaFile = null;
        this.datasourceName = datasourceName;
        this.updateTableSource();
    }

    public void setTableSource(SchemaElement schemaElement, FileObject dbschemaFile) {
        this.schemaElement = schemaElement;
        this.dbconn = null;
        this.dbschemaFile = dbschemaFile;
        this.datasourceName = null;
        this.updateTableSource();
    }

    public TableSource getTableSource() {
        return this.tableSource;
    }

    private void updateTableSource() {
        this.tableSource = this.dbconn != null ? (this.datasourceName != null ? new TableSource(this.datasourceName, TableSource.Type.DATA_SOURCE) : new TableSource(this.dbconn.getName(), TableSource.Type.CONNECTION)) : (this.dbschemaFile != null ? new TableSource(FileUtil.toFile((FileObject)this.dbschemaFile).getAbsolutePath(), TableSource.Type.SCHEMA_FILE) : null);
    }

    public SchemaElement getSchemaElement() {
        return this.schemaElement;
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.dbconn;
    }

    public FileObject getDBSchemaFile() {
        return this.dbschemaFile;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public SourceGroup getLocation() {
        return this.location;
    }

    public void setLocation(SourceGroup location) {
        this.location = location;
    }

    public boolean isCmpFieldsInInterface() {
        return this.cmpFieldsInInterface;
    }

    public void setCmpFieldsInInterface(boolean cmpFieldsInInterface) {
        this.cmpFieldsInInterface = cmpFieldsInInterface;
    }

    public boolean isUseColumnNamesInRelationships() {
        return this.useColumnNamesInRelationships;
    }

    public void setUseColumnNamesInRelationships(boolean useColumnNamesInRelationships) {
        this.useColumnNamesInRelationships = useColumnNamesInRelationships;
    }

    public boolean isGenerateFinderMethods() {
        return this.generateFinderMethods;
    }

    public void setGenerateFinderMethods(boolean generateFinderMethods) {
        this.generateFinderMethods = generateFinderMethods;
    }

    public boolean isGenerateJAXBAnnotations() {
        return this.generateJAXBAnnotations;
    }

    public void setGenerateJAXBAnnotations(boolean generateJAXBAnnotations) {
        this.generateJAXBAnnotations = generateJAXBAnnotations;
    }

    public boolean isGenerateValidationConstraints() {
        return this.generateValidationConstraints;
    }

    public void setGenerateValidationConstraints(boolean generateValidationConstraints) {
        this.generateValidationConstraints = generateValidationConstraints;
    }

    public boolean isFullyQualifiedTableNames() {
        return this.fullyQualifiedTableNames;
    }

    public void setFullyQualifiedTableNames(boolean fullyQualifiedNames) {
        this.fullyQualifiedTableNames = fullyQualifiedNames;
    }

    public EntityRelation.FetchType getFetchType() {
        return this.fetchType;
    }

    public void setFetchType(EntityRelation.FetchType fetchType) {
        this.fetchType = fetchType;
    }

    public boolean isRegenTablesAttrs() {
        return this.regenTablesAttrs;
    }

    public void setRegenTablesAttrs(boolean regenSchemaAttrs) {
        this.regenTablesAttrs = regenSchemaAttrs;
    }

    public EntityRelation.CollectionType getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(EntityRelation.CollectionType type) {
        this.collectionType = type;
    }

    public void buildBeans() {
        TableSource.put(this.project, this.tableSource);
        GenerateTablesImpl genTables = new GenerateTablesImpl();
        FileObject rootFolder = this.getLocation().getRootFolder();
        String pkgName = this.getPackageName();
        for (Table table : this.selectedTables.getTables()) {
            String pkg = pkgName;
            UpdateType ut = this.selectedTables.getUpdateType(table);
            if (ut == UpdateType.UPDATE) {
                String fqn = this.persistenceGen.getFQClassName(table.getName());
                if (fqn != null) {
                    int ind = fqn.lastIndexOf(".");
                    pkg = ind > -1 ? fqn.substring(0, ind) : "";
                } else assert (false) : "Entity for " + table.getName() + " isn't resolved";
            }
            genTables.addTable(table.getCatalog(), table.getSchema(), table.getName(), rootFolder, pkg, this.selectedTables.getClassName(table), ut, table.getUniqueConstraints());
        }
        this.generator = new DbSchemaEjbGenerator(genTables, this.schemaElement, this.collectionType, this.useColumnNamesInRelationships, this.useDefaults, this.generateUnresolvedRelationships);
    }

    public EntityClass[] getBeans() {
        return this.generator.getBeans();
    }

    public EntityRelation[] getRelations() {
        return this.generator.getRelations();
    }

    public boolean isGenerateUnresolvedRelationships() {
        return this.generateUnresolvedRelationships;
    }

    public void setGenerateUnresolvedRelationships(boolean generateUnresolvedRelationships) {
        this.generateUnresolvedRelationships = generateUnresolvedRelationships;
    }

    public boolean isUseDefaults() {
        return this.useDefaults;
    }

    public void setUseDefaults(boolean useDefaults) {
        this.useDefaults = useDefaults;
    }

    private static final class GenerateTablesImpl
    implements GeneratedTables {
        private String catalog;
        private String schema;
        private final Set<String> tableNames = new HashSet<String>();
        private final Map<String, FileObject> rootFolders = new HashMap<String, FileObject>();
        private final Map<String, String> packageNames = new HashMap<String, String>();
        private final Map<String, String> classNames = new HashMap<String, String>();
        private final Map<String, UpdateType> updateTypes = new HashMap<String, UpdateType>();
        private final Map<String, Set<List<String>>> allUniqueConstraints = new HashMap<String, Set<List<String>>>();

        private GenerateTablesImpl() {
        }

        @Override
        public Set<String> getTableNames() {
            return Collections.unmodifiableSet(this.tableNames);
        }

        private void addTable(String catalogName, String schemaName, String tableName, FileObject rootFolder, String packageName, String className, UpdateType updateType, Set<List<String>> uniqueConstraints) {
            this.tableNames.add(tableName);
            this.catalog = catalogName;
            this.schema = schemaName;
            this.rootFolders.put(tableName, rootFolder);
            this.packageNames.put(tableName, packageName);
            this.classNames.put(tableName, className);
            this.updateTypes.put(tableName, updateType);
            this.allUniqueConstraints.put(tableName, uniqueConstraints);
        }

        @Override
        public String getCatalog() {
            return this.catalog;
        }

        @Override
        public String getSchema() {
            return this.schema;
        }

        @Override
        public FileObject getRootFolder(String tableName) {
            return this.rootFolders.get(tableName);
        }

        @Override
        public String getPackageName(String tableName) {
            return this.packageNames.get(tableName);
        }

        @Override
        public String getClassName(String tableName) {
            return this.classNames.get(tableName);
        }

        @Override
        public UpdateType getUpdateType(String tableName) {
            return this.updateTypes.get(tableName);
        }

        @Override
        public Set<List<String>> getUniqueConstraints(String tableName) {
            return this.allUniqueConstraints.get(tableName);
        }
    }
}

