/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.core.api.support.classpath.ContainerClassPathModifier;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.java.SourceUtils;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Table;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.entitygenerator.CMPMappingModel;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityClass;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityMember;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityRelation;
import org.netbeans.modules.j2ee.persistence.entitygenerator.RelationshipRole;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.util.EntityMethodGenerator;
import org.netbeans.modules.j2ee.persistence.util.JPAClassPathHelper;
import org.netbeans.modules.j2ee.persistence.util.MetadataModelReadHelper;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.ProgressPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPHelper;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.UpdateType;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class JavaPersistenceGenerator
implements PersistenceGenerator {
    private final Map<String, String> entityName2TableName = new HashMap<String, String>();
    private Project initProject;
    private static boolean fieldAccess = true;
    private static boolean genNamedParams = true;
    private static boolean genSerializableEntities = true;
    private Set<FileObject> result;
    private static HashMap<String, VariableTree> variables;
    private static HashMap<String, MethodTree> setters;
    private static HashMap<String, MethodTree> getters;
    private final boolean addToAutoDiscoveredPU;
    private PersistenceUnit persistenceUnit;

    public JavaPersistenceGenerator() {
        this.persistenceUnit = null;
        this.addToAutoDiscoveredPU = true;
    }

    public JavaPersistenceGenerator(PersistenceUnit persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
        this.addToAutoDiscoveredPU = false;
    }

    @Override
    public void generateBeans(ProgressPanel progressPanel, RelatedCMPHelper helper, FileObject dbSchemaFile, ProgressContributor handle) throws IOException {
        this.generateBeans(helper.getBeans(), helper.isGenerateFinderMethods(), helper.isGenerateJAXBAnnotations(), helper.isGenerateValidationConstraints(), helper.isFullyQualifiedTableNames(), helper.isRegenTablesAttrs(), helper.isUseDefaults(), helper.getFetchType(), helper.getCollectionType(), handle, progressPanel, helper.getProject());
    }

    void generateBeans(EntityClass[] entityClasses, boolean generateNamedQueries, boolean generateJAXBAnnotations, boolean generateValidationConstraints, boolean fullyQualifiedTableNames, boolean regenTablesAttrs, EntityRelation.FetchType fetchType, EntityRelation.CollectionType collectionType, ProgressContributor progressContributor, ProgressPanel panel, Project prj) throws IOException {
        this.generateBeans(entityClasses, generateNamedQueries, generateJAXBAnnotations, generateValidationConstraints, fullyQualifiedTableNames, regenTablesAttrs, false, fetchType, collectionType, progressContributor, panel, prj);
    }

    private void generateBeans(EntityClass[] entityClasses, boolean generateNamedQueries, boolean generateJAXBAnnotations, boolean generateValidationConstraints, boolean fullyQualifiedTableNames, boolean regenTablesAttrs, boolean useDefaults, EntityRelation.FetchType fetchType, EntityRelation.CollectionType collectionType, ProgressContributor progressContributor, ProgressPanel panel, Project prj) throws IOException {
        ContainerClassPathModifier modifier;
        int progressMax = entityClasses.length * 3;
        progressContributor.start(progressMax);
        if (prj != null && (modifier = (ContainerClassPathModifier)prj.getLookup().lookup(ContainerClassPathModifier.class)) != null) {
            progressContributor.progress(NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"LBL_Progress_Adding_Classpath"));
            modifier.extendClasspath(prj.getProjectDirectory(), new String[]{"annotation", "persistence", "transaction"});
        }
        this.result = new Generator(entityClasses, generateNamedQueries, generateJAXBAnnotations, generateValidationConstraints, fullyQualifiedTableNames, regenTablesAttrs, useDefaults, fetchType, collectionType, progressContributor, panel, this).run();
        this.addToPersistenceUnit(this.result);
        progressContributor.progress(progressMax);
        PersistenceUtils.logUsage(JavaPersistenceGenerator.class, "USG_PERSISTENCE_ENTITY_DB_CREATED", new Integer[]{entityClasses.length});
    }

    private void addToPersistenceUnit(Set<FileObject> entities) {
        if (entities.isEmpty()) {
            return;
        }
        if (this.persistenceUnit == null && !this.addToAutoDiscoveredPU) {
            return;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)entities.iterator().next());
        if (!(project == null || Util.isSupportedJavaEEVersion(project) && Util.isContainerManaged(project) || ProviderUtil.getDDFile(project) == null)) {
            try {
                ClassPathProvider classPathProvider;
                PersistenceUnit[] pu;
                PUDataObject pudo = ProviderUtil.getPUDataObject(project);
                if (this.persistenceUnit == null && (pu = pudo.getPersistence().getPersistenceUnit()).length == 1) {
                    this.persistenceUnit = pu[0];
                }
                if (this.persistenceUnit != null && (classPathProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class)) != null) {
                    for (FileObject entity : entities) {
                        String entityFQN = classPathProvider.findClassPath(entity, "classpath/source").getResourceName(entity, '.', false);
                        pudo.addClass(this.persistenceUnit, entityFQN, false);
                    }
                    pudo.save();
                }
            }
            catch (InvalidPersistenceXmlException ipx) {
                Logger.getLogger(JavaPersistenceGenerator.class.getName()).log(Level.FINE, "Invalid persistence.xml: " + ipx.getPath(), ipx);
            }
        }
    }

    @Override
    public void init(WizardDescriptor wiz) {
        this.initProject = Templates.getProject((WizardDescriptor)wiz);
        EntityClassScope entityClassScope = EntityClassScope.getEntityClassScope((FileObject)this.initProject.getProjectDirectory());
        if (entityClassScope == null) {
            return;
        }
        MetadataModel entityMappingsModel = entityClassScope.getEntityMappingsModel(true);
        final MetadataModelReadHelper<EntityMappingsMetadata, Set<Entity>> readHelper = MetadataModelReadHelper.create(entityMappingsModel, new MetadataModelAction<EntityMappingsMetadata, Set<Entity>>(){

            public Set<Entity> run(EntityMappingsMetadata metadata) {
                HashSet<Entity> result = new HashSet<Entity>();
                result.addAll(Arrays.asList(metadata.getRoot().getEntity()));
                return result;
            }
        });
        readHelper.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (readHelper.getState() == MetadataModelReadHelper.State.FINISHED) {
                    try {
                        JavaPersistenceGenerator.this.processEntities((Set)readHelper.getResult());
                    }
                    catch (ExecutionException ex) {
                        Logger.getLogger(JavaPersistenceGenerator.class.getName()).log(Level.FINE, "Failed to get entity classes: ", ex);
                    }
                }
            }
        });
        readHelper.start();
    }

    private void processEntities(Set<Entity> entityClasses) {
        for (Entity entity : entityClasses) {
            Table entityTable = entity.getTable();
            if (entityTable == null) continue;
            this.entityName2TableName.put(entityTable.getName(), entity.getClass2());
        }
    }

    @Override
    public void uninit() {
        this.initProject = null;
    }

    @Override
    public String getFQClassName(String tableName) {
        return this.entityName2TableName.get(tableName);
    }

    @Override
    public String generateEntityName(String name) {
        return name;
    }

    @Override
    public Set<FileObject> createdObjects() {
        return this.result;
    }

    private static final class Generator {
        private final ProgressPanel progressPanel;
        private final ProgressContributor progressContributor;
        private final Map<String, EntityClass> beanMap = new HashMap<String, EntityClass>();
        private final EntityClass[] entityClasses;
        private final boolean generateNamedQueries;
        private final boolean generateJAXBAnnotations;
        private final boolean generateValidationConstraints;
        private final boolean fullyQualifiedTableNames;
        private final boolean regenTablesAttrs;
        private final EntityRelation.FetchType fetchType;
        private final EntityRelation.CollectionType collectionType;
        private final Set<FileObject> generatedEntityFOs;
        private final Set<FileObject> generatedFOs;
        private final PersistenceGenerator persistenceGen;
        private final boolean useDefaults;

        public Generator(EntityClass[] entityClasses, boolean generateNamedQueries, boolean generateJAXBAnnotations, boolean generateValidationConstraints, boolean fullyQualifiedTableNames, boolean regenTablesAttrs, boolean useDefaults, EntityRelation.FetchType fetchType, EntityRelation.CollectionType collectionType, ProgressContributor progressContributor, ProgressPanel progressPanel, PersistenceGenerator persistenceGen) {
            this.entityClasses = entityClasses;
            this.generateNamedQueries = generateNamedQueries;
            this.generateJAXBAnnotations = generateJAXBAnnotations;
            this.generateValidationConstraints = generateValidationConstraints;
            this.fullyQualifiedTableNames = fullyQualifiedTableNames;
            this.useDefaults = useDefaults;
            this.regenTablesAttrs = regenTablesAttrs;
            this.fetchType = fetchType;
            this.collectionType = collectionType;
            this.progressContributor = progressContributor;
            this.progressPanel = progressPanel;
            this.generatedFOs = new HashSet<FileObject>();
            this.generatedEntityFOs = new HashSet<FileObject>();
            this.persistenceGen = persistenceGen;
        }

        public Set<FileObject> run() throws IOException {
            try {
                this.runImpl();
            }
            catch (IOException e) {
                Logger.getLogger(JavaPersistenceGenerator.class.getName()).log(Level.INFO, "IOException, remove generated.");
                for (FileObject generatedFO : this.generatedFOs) {
                    generatedFO.delete();
                }
                throw e;
            }
            return this.generatedEntityFOs;
        }

        public void runImpl() throws IOException {
            JavaSource javaSource;
            FileObject pkClassFO;
            FileObject entityClassFO;
            FileObject entityClassPackageFO;
            FileObject entityClassFO0;
            String entityClassName;
            EntityClass entityClass;
            int i;
            this.beanMap.clear();
            HashSet<FileObject> generationPackageFOs = new HashSet<FileObject>();
            HashSet<String> generatedEntityClasses = new HashSet<String>();
            for (int i2 = 0; i2 < this.entityClasses.length; ++i2) {
                EntityClass entityClass2 = this.entityClasses[i2];
                String entityClassName2 = entityClass2.getClassName();
                FileObject packageFileObject = entityClass2.getPackageFileObject();
                this.beanMap.put(entityClassName2, entityClass2);
                String progressMsg = NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"TXT_GeneratingClass", (Object)entityClassName2);
                this.progressContributor.progress(progressMsg, i2);
                if (this.progressPanel != null) {
                    this.progressPanel.setText(progressMsg);
                }
                FileObject entity = packageFileObject.getFileObject(entityClassName2, "java");
                switch (entityClass2.getUpdateType()) {
                    case RECREATE: {
                        String pkClassName;
                        if (entity == null) {
                            String fqn = this.persistenceGen.getFQClassName(entityClass2.getTableName());
                            int ind = fqn.lastIndexOf(".");
                            String pkg = ind > -1 ? fqn.substring(0, ind) : "";
                            String rel = pkg.replaceAll("\\.", "/");
                            FileObject oldPackage = entityClass2.getRootFolder().getFileObject(rel);
                            entity = oldPackage.getFileObject(entityClassName2, "java");
                        }
                        if (entityClass2.isForTable() && !entityClass2.isUsePkField()) {
                            pkClassName = Generator.createPKClassName(entityClassName2);
                            FileObject pkFO = packageFileObject.getFileObject(pkClassName, "java");
                            if (pkFO == null) {
                                String fqn = this.persistenceGen.getFQClassName(entityClass2.getTableName());
                                int ind = fqn.lastIndexOf(".");
                                String pkg = ind > -1 ? fqn.substring(0, ind) : "";
                                String rel = pkg.replaceAll("\\.", "/");
                                FileObject oldPackage = entityClass2.getRootFolder().getFileObject(rel);
                                pkFO = oldPackage.getFileObject(pkClassName, "java");
                            }
                            if (pkFO != null) {
                                pkFO.delete();
                            }
                        }
                        entity.delete();
                        entity = null;
                    }
                    case NEW: {
                        String pkClassName;
                        generatedEntityClasses.add(entityClassName2);
                        try {
                            entity = GenerationUtils.createClass((FileObject)packageFileObject, (String)entityClassName2, (String)NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"MSG_Javadoc_Class"));
                        }
                        catch (RuntimeException ex) {
                            Logger.getLogger(JavaPersistenceGenerator.class.getName()).log(Level.WARNING, "Can't create class {0} from template in package {1} with package fileobject validity {2}.", new Object[]{entityClassName2, packageFileObject.getPath(), packageFileObject.isValid()});
                            throw ex;
                        }
                        this.generatedEntityFOs.add(entity);
                        this.generatedFOs.add(entity);
                        if (entityClass2.isForTable() && !entityClass2.isUsePkField() && packageFileObject.getFileObject(pkClassName = Generator.createPKClassName(entityClassName2), "java") == null) {
                            FileObject pkClass = GenerationUtils.createClass((FileObject)packageFileObject, (String)pkClassName, (String)NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"MSG_Javadoc_PKClass", (Object)pkClassName, (Object)entityClassName2));
                            this.generatedFOs.add(pkClass);
                        }
                    }
                    case UPDATE: {
                        generationPackageFOs.add(packageFileObject);
                    }
                }
            }
            Set<ClassPath> bootCPs = Generator.getAllClassPaths(generationPackageFOs, "classpath/boot");
            Set<ClassPath> compileCPs = Generator.getAllClassPaths(generationPackageFOs, "classpath/compile");
            Set<ClassPath> sourceCPs = Generator.getAllClassPaths(generationPackageFOs, "classpath/source");
            JPAClassPathHelper cpHelper = new JPAClassPathHelper(bootCPs, compileCPs, sourceCPs);
            for (i = 0; i < this.entityClasses.length; ++i) {
                entityClass = this.entityClasses[i];
                entityClassName = entityClass.getClassName();
                if (!generatedEntityClasses.contains(entityClassName) && !UpdateType.UPDATE.equals((Object)entityClass.getUpdateType())) {
                    this.progressContributor.progress(this.entityClasses.length + i);
                    continue;
                }
                String progressMsg = NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"TXT_GeneratingClass", (Object)entityClassName);
                this.progressContributor.progress(progressMsg, this.entityClasses.length + i);
                if (this.progressPanel != null) {
                    this.progressPanel.setText(progressMsg);
                }
                if ((entityClassFO0 = (entityClassPackageFO = entityClass.getPackageFileObject()).getFileObject(entityClassName, "java")) == null) {
                    entityClassPackageFO.refresh(true);
                    entityClassFO0 = entityClassPackageFO.getFileObject(entityClassName, "java");
                    if (entityClassFO0 == null) {
                        Logger.getLogger(JavaPersistenceGenerator.class.getName()).log(Level.INFO, "Can''t resolve fileobject in package {0} for entity {1}", new Object[]{entityClassPackageFO.getPath(), entityClassName});
                    }
                }
                entityClassFO = entityClassFO0;
                pkClassFO = entityClassPackageFO.getFileObject(Generator.createPKClassName(entityClassName), "java");
                try {
                    javaSource = pkClassFO != null && entityClass.getUpdateType() != UpdateType.UPDATE ? JavaSource.create((ClasspathInfo)cpHelper.createClasspathInfo(), (FileObject[])new FileObject[]{entityClassFO, pkClassFO}) : JavaSource.create((ClasspathInfo)cpHelper.createClasspathInfo(), (FileObject[])new FileObject[]{entityClassFO});
                    javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

                        public void run(WorkingCopy copy) throws IOException {
                            copy.toPhase(JavaSource.Phase.RESOLVED);
                        }
                    }).commit();
                    continue;
                }
                catch (IOException e) {
                    String message = e.getMessage();
                    String newMessage = message == null ? NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"ERR_GeneratingClass_NoExceptionMessage", (Object)entityClassName) : NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"ERR_GeneratingClass", (Object)entityClassName, (Object)message);
                    throw new IOException(newMessage, e);
                }
            }
            for (i = 0; i < this.entityClasses.length; ++i) {
                entityClass = this.entityClasses[i];
                entityClassName = entityClass.getClassName();
                if (!generatedEntityClasses.contains(entityClassName) && !UpdateType.UPDATE.equals((Object)entityClass.getUpdateType())) {
                    this.progressContributor.progress(this.entityClasses.length + i);
                    continue;
                }
                String progressMsg = NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"TXT_GeneratingClass", (Object)entityClassName);
                this.progressContributor.progress(progressMsg, 2 * this.entityClasses.length + i);
                if (this.progressPanel != null) {
                    this.progressPanel.setText(progressMsg);
                }
                entityClassPackageFO = entityClass.getPackageFileObject();
                entityClassFO = entityClassFO0 = entityClassPackageFO.getFileObject(entityClassName, "java");
                pkClassFO = entityClassPackageFO.getFileObject(Generator.createPKClassName(entityClassName), "java");
                try {
                    javaSource = pkClassFO != null && entityClass.getUpdateType() != UpdateType.UPDATE ? JavaSource.create((ClasspathInfo)cpHelper.createClasspathInfo(), (FileObject[])new FileObject[]{entityClassFO, pkClassFO}) : JavaSource.create((ClasspathInfo)cpHelper.createClasspathInfo(), (FileObject[])new FileObject[]{entityClassFO});
                    javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

                        public void run(WorkingCopy copy) throws IOException {
                            if (copy.getFileObject().equals(entityClassFO)) {
                                EntityClassGenerator clsGen = new EntityClassGenerator(copy, entityClass);
                                clsGen.run();
                            } else if (entityClass.getUpdateType() != UpdateType.UPDATE) {
                                new PKClassGenerator(copy, entityClass).run();
                            } else {
                                Logger.getLogger(JavaPersistenceGenerator.class.getName()).log(Level.INFO, "PK Class update isn't supported");
                            }
                        }
                    }).commit();
                    continue;
                }
                catch (IOException e) {
                    String message = e.getMessage();
                    String newMessage = message == null ? NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"ERR_GeneratingClass_NoExceptionMessage", (Object)entityClassName) : NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"ERR_GeneratingClass", (Object)entityClassName, (Object)message);
                    throw new IOException(newMessage, e);
                }
            }
        }

        private static String createPKClassName(String entityClassName) {
            return entityClassName + "PK";
        }

        private static Set<ClassPath> getAllClassPaths(Set<FileObject> fileObjects, String id) {
            HashSet<ClassPath> classPaths = new HashSet<ClassPath>();
            for (FileObject fileObject : fileObjects) {
                classPaths.add(ClassPath.getClassPath((FileObject)fileObject, (String)id));
            }
            return classPaths;
        }

        private final class PKClassGenerator
        extends ClassGenerator {
            public PKClassGenerator(WorkingCopy copy, EntityClass entityClass) throws IOException {
                super(copy, entityClass);
            }

            @Override
            protected void initialize() throws IOException {
                this.newClassTree = this.genUtils.ensureNoArgConstructor(this.newClassTree);
                this.newClassTree = this.genUtils.addImplementsClause(this.newClassTree, "java.io.Serializable");
                this.newClassTree = this.genUtils.addAnnotation(this.newClassTree, this.genUtils.createAnnotation("javax.persistence.Embeddable"));
            }

            @Override
            protected void generateMember(EntityMember m) throws IOException {
                if (!m.isPrimaryKey()) {
                    return;
                }
                ClassGenerator.Property property = this.createProperty(m);
                this.properties.add(property);
            }

            @Override
            protected void afterMembersGenerated() {
            }

            @Override
            protected void generateRelationship(RelationshipRole relationship) {
            }

            @Override
            protected void finish() {
                ArrayList<VariableTree> parameters = new ArrayList<VariableTree>(this.properties.size());
                for (ClassGenerator.Property property : this.properties) {
                    parameters.add(this.genUtils.removeModifiers(property.getField()));
                }
                this.constructors.add(this.genUtils.createAssignmentConstructor(this.genUtils.createModifiers(Modifier.PUBLIC), this.pkClassName, parameters));
                EntityMethodGenerator methodGenerator = new EntityMethodGenerator(this.copy, this.genUtils, this.typeElement);
                this.methods.add(methodGenerator.createHashCodeMethod(parameters));
                this.methods.add(methodGenerator.createEqualsMethod(this.pkClassName, parameters));
                this.methods.add(methodGenerator.createToStringMethod(this.pkFQClassName, parameters));
            }
        }

        private final class EntityClassGenerator
        extends ClassGenerator {
            private final String entityClassName;
            private final String entityFQClassName;
            private final List<ClassGenerator.Property> nonNullableProps;
            private final List<String> pkColumnNames;
            private final List<VariableTree> pkClassVariables;
            private final List<ExpressionTree> namedQueryAnnotations;
            private ClassGenerator.Property pkProperty;
            private String namedQueryPrefix;
            private HashMap<String, Tree> existingColumns;
            private String existingEmbeddedId;
            private HashMap<String, Tree> existingJoinColumns;
            private HashMap<TypeMirror, ArrayList<String>> existingJoinColumnss;
            private HashMap<String, ArrayList<String>> existingJoinTables;
            private HashMap<String, Tree> existingMappings;
            private final boolean useDefaults;

            public EntityClassGenerator(WorkingCopy copy, EntityClass entityClass) throws IOException {
                super(copy, entityClass);
                this.nonNullableProps = new ArrayList<ClassGenerator.Property>();
                this.pkColumnNames = new ArrayList<String>();
                this.pkClassVariables = new ArrayList<VariableTree>();
                this.namedQueryAnnotations = new ArrayList<ExpressionTree>();
                this.existingColumns = new HashMap();
                this.existingEmbeddedId = null;
                this.existingJoinColumns = new HashMap();
                this.existingJoinColumnss = new HashMap();
                this.existingJoinTables = new HashMap();
                this.existingMappings = new HashMap();
                this.entityClassName = entityClass.getClassName();
                assert (this.typeElement.getSimpleName().contentEquals(this.entityClassName));
                this.entityFQClassName = entityClass.getPackage() + "." + this.entityClassName;
                this.useDefaults = entityClass.getUseDefaults();
            }

            @Override
            protected void initialize() throws IOException {
                this.newClassTree = this.genUtils.ensureNoArgConstructor(this.newClassTree);
                if (genSerializableEntities && !UpdateType.UPDATE.equals((Object)this.updateType)) {
                    this.newClassTree = this.genUtils.addImplementsClause(this.newClassTree, "java.io.Serializable");
                }
                if (this.needsPKClass && this.existingEmbeddedId == null) {
                    String pkFieldName = this.createFieldName(this.pkClassName);
                    this.pkProperty = (ClassGenerator)this.new ClassGenerator.Property(Modifier.PROTECTED, Collections.singletonList(this.genUtils.createAnnotation("javax.persistence.EmbeddedId")), null, this.pkFQClassName, pkFieldName);
                    this.properties.add(this.pkProperty);
                }
                if (UpdateType.UPDATE.equals((Object)this.updateType)) {
                    this.collectExistingColumns();
                } else {
                    this.newClassTree = this.genUtils.addAnnotation(this.newClassTree, this.genUtils.createAnnotation("javax.persistence.Entity"));
                    ArrayList<ExpressionTree> tableAnnArgs = new ArrayList<ExpressionTree>();
                    if (!this.useDefaults || !this.entityClassName.equalsIgnoreCase(this.dbMappings.getTableName())) {
                        tableAnnArgs.add(this.genUtils.createAnnotationArgument("name", (Object)this.dbMappings.getTableName()));
                    }
                    if (Generator.this.fullyQualifiedTableNames) {
                        String schemaName = this.entityClass.getSchemaName();
                        String catalogName = this.entityClass.getCatalogName();
                        if (catalogName != null) {
                            tableAnnArgs.add(this.genUtils.createAnnotationArgument("catalog", (Object)catalogName));
                        }
                        if (schemaName != null) {
                            tableAnnArgs.add(this.genUtils.createAnnotationArgument("schema", (Object)schemaName));
                        }
                    }
                    if (Generator.this.regenTablesAttrs && this.entityClass.getUniqueConstraints() != null && !this.entityClass.getUniqueConstraints().isEmpty()) {
                        ArrayList<AnnotationTree> uniqueConstraintAnnotations = new ArrayList<AnnotationTree>();
                        for (List<String> constraintCols : this.entityClass.getUniqueConstraints()) {
                            ArrayList<ExpressionTree> colArgs = new ArrayList<ExpressionTree>();
                            for (String colName : constraintCols) {
                                colArgs.add(this.genUtils.createAnnotationArgument(null, (Object)colName));
                            }
                            ExpressionTree columnNamesArg = this.genUtils.createAnnotationArgument("columnNames", colArgs);
                            uniqueConstraintAnnotations.add(this.genUtils.createAnnotation("javax.persistence.UniqueConstraint", Collections.singletonList(columnNamesArg)));
                        }
                        tableAnnArgs.add(this.genUtils.createAnnotationArgument("uniqueConstraints", uniqueConstraintAnnotations));
                    }
                    if (!this.useDefaults || !tableAnnArgs.isEmpty()) {
                        this.newClassTree = this.genUtils.addAnnotation(this.newClassTree, this.genUtils.createAnnotation("javax.persistence.Table", tableAnnArgs));
                    }
                    if (Generator.this.generateJAXBAnnotations) {
                        this.newClassTree = this.genUtils.addAnnotation(this.newClassTree, this.genUtils.createAnnotation("javax.xml.bind.annotation.XmlRootElement"));
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            private void collectExistingColumns() {
                variables = new HashMap();
                setters = new HashMap();
                getters = new HashMap();
                for (Tree tree : this.originalClassTree.getMembers()) {
                    List<? extends AnnotationTree> annotations = null;
                    Tree memberType = null;
                    if (Tree.Kind.VARIABLE.equals((Object)tree.getKind())) {
                        VariableTree variable = (VariableTree)tree;
                        annotations = variable.getModifiers().getAnnotations();
                        memberType = variable.getType();
                        variables.put(variable.getName().toString(), variable);
                    } else if (Tree.Kind.METHOD.equals((Object)tree.getKind())) {
                        MethodTree method = (MethodTree)tree;
                        annotations = method.getModifiers().getAnnotations();
                        memberType = method.getReturnType();
                        String string = method.getName().toString();
                        if (string.length() > 3 && string.startsWith("get")) {
                            getters.put((string.substring(3, 4).toLowerCase() + (string.length() > 4 ? string.substring(4) : "")).toUpperCase(), method);
                        } else if (string.length() > 3 && string.startsWith("set")) {
                            setters.put((string.substring(3, 4).toLowerCase() + (string.length() > 4 ? string.substring(4) : "")).toUpperCase(), method);
                        } else if (string.length() > 2 && string.startsWith("is")) {
                            getters.put((string.substring(2, 3).toLowerCase() + (string.length() > 3 ? string.substring(3) : "")).toUpperCase(), method);
                        }
                    }
                    if (annotations == null) continue;
                    block1: for (AnnotationTree annotationTree : annotations) {
                        AssignmentTree aTree;
                        AssignmentTree asTree;
                        AnnotationTree aT;
                        Name aN;
                        List<? extends ExpressionTree> inis;
                        AssignmentTree aTree2;
                        TypeMirror tm;
                        if (!(annotationTree.getAnnotationType() instanceof IdentifierTree)) continue;
                        Name nm = ((IdentifierTree)annotationTree.getAnnotationType()).getName();
                        if (nm.contentEquals("Column")) {
                            for (ExpressionTree expressionTree : annotationTree.getArguments()) {
                                AssignmentTree aTree22 = (AssignmentTree)expressionTree;
                                if (!((IdentifierTree)aTree22.getVariable()).getName().contentEquals("name")) continue;
                                this.existingColumns.put((String)((LiteralTree)aTree22.getExpression()).getValue(), tree);
                                continue block1;
                            }
                            continue;
                        }
                        if (nm.contentEquals("EmbeddedId")) {
                            tm = this.copy.getTrees().getTypeMirror(TreePath.getPath(this.copy.getCompilationUnit(), memberType));
                            this.existingEmbeddedId = ((Object)tm).toString();
                            if (this.pkProperty == null) continue;
                            this.properties.remove(this.pkProperty);
                            continue;
                        }
                        if (nm.contentEquals("JoinTable")) {
                            void var9_14;
                            ArrayList<String> columns = new ArrayList<String>();
                            Object var9_13 = null;
                            for (ExpressionTree expressionTree : annotationTree.getArguments()) {
                                aTree2 = (AssignmentTree)expressionTree;
                                Name nm2 = ((IdentifierTree)aTree2.getVariable()).getName();
                                ExpressionTree value = aTree2.getExpression();
                                if (nm2.contentEquals("joinColumns")) {
                                    if (value instanceof NewArrayTree) {
                                        NewArrayTree columnsArrayTree = (NewArrayTree)value;
                                        inis = columnsArrayTree.getInitializers();
                                    } else {
                                        ArrayList<? extends ExpressionTree> one = new ArrayList<ExpressionTree>();
                                        one.add(value);
                                        inis = one;
                                    }
                                    block4: for (ExpressionTree expressionTree2 : inis) {
                                        if (!(expressionTree2 instanceof AnnotationTree) || !(aN = ((IdentifierTree)(aT = (AnnotationTree)expressionTree2).getAnnotationType()).getName()).contentEquals("JoinColumn")) continue;
                                        for (ExpressionTree expressionTree3 : aT.getArguments()) {
                                            asTree = (AssignmentTree)expressionTree3;
                                            if (!((IdentifierTree)asTree.getVariable()).getName().contentEquals("name")) continue;
                                            columns.add((String)((LiteralTree)asTree.getExpression()).getValue());
                                            continue block4;
                                        }
                                    }
                                    Collections.sort(columns);
                                    continue;
                                }
                                if (!nm2.contentEquals("name")) continue;
                                String string = ((LiteralTree)value).getValue().toString();
                            }
                            this.existingJoinTables.put((String)var9_14, columns);
                            continue;
                        }
                        if (nm.contentEquals("JoinColumns")) {
                            tm = this.copy.getTrees().getTypeMirror(TreePath.getPath(this.copy.getCompilationUnit(), memberType));
                            ArrayList<String> arrayList = new ArrayList<String>();
                            for (ExpressionTree expressionTree : annotationTree.getArguments()) {
                                aTree2 = (AssignmentTree)expressionTree;
                                ExpressionTree value = aTree2.getExpression();
                                if (!(value instanceof NewArrayTree)) continue;
                                NewArrayTree arrTree = (NewArrayTree)value;
                                inis = arrTree.getInitializers();
                                block7: for (ExpressionTree expressionTree4 : inis) {
                                    if (!(expressionTree4 instanceof AnnotationTree) || !(aN = ((IdentifierTree)(aT = (AnnotationTree)expressionTree4).getAnnotationType()).getName()).contentEquals("JoinColumn")) continue;
                                    for (ExpressionTree expressionTree5 : aT.getArguments()) {
                                        asTree = (AssignmentTree)expressionTree5;
                                        if (!((IdentifierTree)asTree.getVariable()).getName().contentEquals("name")) continue;
                                        arrayList.add((String)((LiteralTree)asTree.getExpression()).getValue());
                                        continue block7;
                                    }
                                }
                                Collections.sort(arrayList);
                                break;
                            }
                            this.existingJoinColumnss.put(tm, arrayList);
                            continue;
                        }
                        if (nm.contentEquals("JoinColumn")) {
                            for (ExpressionTree expressionTree : annotationTree.getArguments()) {
                                aTree = (AssignmentTree)expressionTree;
                                if (!((IdentifierTree)aTree.getVariable()).getName().contentEquals("name")) continue;
                                this.existingJoinColumns.put((String)((LiteralTree)aTree.getExpression()).getValue(), annotationTree);
                                continue block1;
                            }
                            continue;
                        }
                        if (!nm.contentEquals("OneToOne") && !nm.contentEquals("OneToMany") && !nm.contentEquals("ManyToMany")) continue;
                        for (ExpressionTree expressionTree : annotationTree.getArguments()) {
                            if (!(expressionTree instanceof AssignmentTree) || !(aTree = (AssignmentTree)expressionTree).getVariable().toString().equals("mappedBy")) continue;
                            TypeMirror typeMirror = this.copy.getTrees().getTypeMirror(TreePath.getPath(this.copy.getCompilationUnit(), memberType));
                            this.existingMappings.put(((Object)typeMirror).toString(), expressionTree);
                            continue block1;
                        }
                    }
                }
            }

            private <T> void wildcardListAdd(List<T> l, T add) {
                l.add(add);
            }

            @Override
            protected void generateMember(EntityMember m) throws IOException {
                Tree existingTree = UpdateType.UPDATE.equals((Object)this.updateType) ? this.existingColumns.get(m.getColumnName()) : null;
                String memberName = m.getMemberName();
                boolean isPKMember = m.isPrimaryKey();
                ClassGenerator.Property property = null;
                if (isPKMember) {
                    if (existingTree != null) {
                        return;
                    }
                    if (this.needsPKClass) {
                        if (!UpdateType.UPDATE.equals((Object)this.updateType)) {
                            this.pkClassVariables.add(this.createVariable(m));
                        }
                    } else {
                        this.pkProperty = property = this.createProperty(m);
                    }
                    String pkColumnName = this.dbMappings.getCMPFieldMapping().get(memberName);
                    this.pkColumnNames.add(pkColumnName);
                } else {
                    property = this.createProperty(m);
                    if (existingTree != null) {
                        Tree exMemberType = null;
                        if (Tree.Kind.VARIABLE.equals((Object)existingTree.getKind())) {
                            VariableTree variable = (VariableTree)existingTree;
                            exMemberType = variable.getType();
                            property.setOldField(variable);
                            property.setOldGetter((MethodTree)getters.get(m.getColumnName().toUpperCase()));
                            property.setOldSetter((MethodTree)setters.get(m.getColumnName().toUpperCase()));
                        } else if (Tree.Kind.METHOD.equals((Object)existingTree.getKind())) {
                            MethodTree method = (MethodTree)existingTree;
                            exMemberType = method.getReturnType();
                            property.setOldGetter(method);
                            property.setOldSetter((MethodTree)setters.get(m.getColumnName().toUpperCase()));
                            property.setOldField((VariableTree)variables.get(m.getColumnName().toUpperCase()));
                        }
                        TypeMirror exTm = this.copy.getTrees().getTypeMirror(TreePath.getPath(this.copy.getCompilationUnit(), exMemberType));
                        String newType = this.getMemberType(m);
                        if (((Object)exTm).toString().equals(newType)) {
                            return;
                        }
                    }
                    if (!m.isNullable()) {
                        this.nonNullableProps.add(property);
                    }
                }
                assert (property != null || property == null && isPKMember && this.needsPKClass);
                if (property != null) {
                    this.properties.add(property);
                }
                if (Generator.this.generateNamedQueries && !m.isLobType()) {
                    ArrayList<ExpressionTree> namedQueryAnnArguments = new ArrayList<ExpressionTree>();
                    namedQueryAnnArguments.add(this.genUtils.createAnnotationArgument("name", (Object)(this.entityClassName + ".findBy" + this.createCapitalizedFieldName(memberName))));
                    if (this.namedQueryPrefix == null) {
                        char firstLetter = this.entityClassName.toLowerCase().charAt(0);
                        this.namedQueryPrefix = "SELECT " + firstLetter + " FROM " + this.entityClassName + " " + firstLetter + " WHERE " + firstLetter + ".";
                    }
                    String memberAccessString = this.needsPKClass && isPKMember ? this.pkProperty.getField().getName().toString() + "." + memberName : memberName;
                    namedQueryAnnArguments.add(this.genUtils.createAnnotationArgument("query", (Object)(this.namedQueryPrefix + memberAccessString + (genNamedParams ? " = :" + memberName : "= ?1"))));
                    this.namedQueryAnnotations.add(this.genUtils.createAnnotation("javax.persistence.NamedQuery", namedQueryAnnArguments));
                }
            }

            protected void addFindAllNamedQueryAnnotation() {
                ArrayList<ExpressionTree> namedQueryAnnArguments = new ArrayList<ExpressionTree>();
                namedQueryAnnArguments.add(this.genUtils.createAnnotationArgument("name", (Object)(this.entityClassName + ".findAll")));
                char firstLetter = this.entityClassName.toLowerCase().charAt(0);
                String queryString = "SELECT " + firstLetter + " FROM " + this.entityClassName + " " + firstLetter;
                namedQueryAnnArguments.add(this.genUtils.createAnnotationArgument("query", (Object)queryString));
                this.namedQueryAnnotations.add(0, this.genUtils.createAnnotation("javax.persistence.NamedQuery", namedQueryAnnArguments));
            }

            @Override
            protected void afterMembersGenerated() {
                if (!UpdateType.UPDATE.equals((Object)this.updateType)) {
                    this.addFindAllNamedQueryAnnotation();
                    this.newClassTree = this.genUtils.addAnnotation(this.newClassTree, this.genUtils.createAnnotation("javax.persistence.NamedQueries", Collections.singletonList(this.genUtils.createAnnotationArgument(null, this.namedQueryAnnotations))));
                }
            }

            @Override
            protected void generateRelationship(RelationshipRole role) throws IOException {
                String memberName = role.getFieldName();
                if (this.existingColumns.get(memberName) != null) {
                    return;
                }
                String typeName = this.getRelationshipFieldType(role, this.entityClass.getPackage());
                TypeElement typeEl = this.copy.getElements().getTypeElement(typeName);
                if (typeEl == null) {
                    Logger.getLogger(JavaPersistenceGenerator.class.getName()).log(Level.WARNING, "Null typeelement for {0}", typeName);
                    for (FileObject fo : Generator.this.generatedFOs) {
                        Logger.getLogger(JavaPersistenceGenerator.class.getName()).log(Level.WARNING, "Next FileObject was generated: {0}, valid: {1}, can read: {2}, locked: {3}", new String[]{fo != null ? fo.getName() : "null", (fo != null ? Boolean.valueOf(fo.isValid()) : "null") + "", (fo != null ? Boolean.valueOf(fo.canRead()) : "null") + "", (fo != null ? Boolean.valueOf(fo.isLocked()) : "null") + ""});
                    }
                    Logger.getLogger(JavaPersistenceGenerator.class.getName()).log(Level.WARNING, "Member name {0}", memberName);
                    Logger.getLogger(JavaPersistenceGenerator.class.getName()).log(Level.WARNING, "Table name {0}", this.entityClass.getTableName());
                    Logger.getLogger(JavaPersistenceGenerator.class.getName()).log(Level.WARNING, "Update type {0}", (Object)this.entityClass.getUpdateType());
                }
                assert (typeEl != null) : "null TypeElement for \"" + typeName + "\"";
                TypeMirror fieldType = typeEl.asType();
                if (role.isToMany()) {
                    TypeElement collectionTypeElem = this.copy.getElements().getTypeElement(Generator.this.collectionType.className());
                    fieldType = this.copy.getTypes().getDeclaredType(collectionTypeElem, fieldType);
                }
                ArrayList<AnnotationTree> annotations = new ArrayList<AnnotationTree>();
                ArrayList<ExpressionTree> annArguments = new ArrayList<ExpressionTree>();
                if (role.isCascade()) {
                    annArguments.add(this.genUtils.createAnnotationArgument("cascade", "javax.persistence.CascadeType", "ALL"));
                }
                if (role.equals(role.getParent().getRoleB())) {
                    LiteralTree literal;
                    String value;
                    ExpressionTree expr;
                    String fName = role.getParent().getRoleA().getFieldName();
                    String fieldTypeStr = ((Object)fieldType).toString();
                    AssignmentTree aTree = (AssignmentTree)this.existingMappings.get(fieldTypeStr);
                    if (aTree == null && role.isToMany()) {
                        EntityRelation.CollectionType ct;
                        String inType = fieldTypeStr.substring(Generator.this.collectionType.className().length());
                        EntityRelation.CollectionType[] arr$ = EntityRelation.CollectionType.values();
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$ && (aTree = (AssignmentTree)this.existingMappings.get((ct = arr$[i$]).className() + inType)) == null; ++i$) {
                        }
                    }
                    if (aTree != null && (expr = aTree.getExpression()) instanceof LiteralTree && (value = (literal = (LiteralTree)expr).getValue().toString()) != null && value.length() > 0) {
                        return;
                    }
                    annArguments.add(this.genUtils.createAnnotationArgument("mappedBy", (Object)fName));
                } else if (role.isMany() && role.isToMany()) {
                    ArrayList<ExpressionTree> joinTableAnnArguments = new ArrayList<ExpressionTree>();
                    String jTN = this.dbMappings.getJoinTableMapping().get(role.getFieldName());
                    if (this.existingJoinTables.get(jTN) != null) {
                        return;
                    }
                    joinTableAnnArguments.add(this.genUtils.createAnnotationArgument("name", (Object)jTN));
                    CMPMappingModel.JoinTableColumnMapping joinColumnMap = this.dbMappings.getJoinTableColumnMppings().get(role.getFieldName());
                    ArrayList<AnnotationTree> joinCols = new ArrayList<AnnotationTree>();
                    CMPMappingModel.ColumnData[] columns = joinColumnMap.getColumns();
                    CMPMappingModel.ColumnData[] refColumns = joinColumnMap.getReferencedColumns();
                    for (int colIndex = 0; colIndex < columns.length; ++colIndex) {
                        ArrayList<ExpressionTree> attrs = new ArrayList<ExpressionTree>();
                        attrs.add(this.genUtils.createAnnotationArgument("name", (Object)columns[colIndex].getColumnName()));
                        attrs.add(this.genUtils.createAnnotationArgument("referencedColumnName", (Object)refColumns[colIndex].getColumnName()));
                        if (Generator.this.regenTablesAttrs && !columns[colIndex].isNullable()) {
                            attrs.add(this.genUtils.createAnnotationArgument("nullable", (Object)false));
                        }
                        joinCols.add(this.genUtils.createAnnotation("javax.persistence.JoinColumn", attrs));
                    }
                    joinTableAnnArguments.add(this.genUtils.createAnnotationArgument("joinColumns", joinCols));
                    ArrayList<AnnotationTree> inverseCols = new ArrayList<AnnotationTree>();
                    CMPMappingModel.ColumnData[] invColumns = joinColumnMap.getInverseColumns();
                    CMPMappingModel.ColumnData[] refInvColumns = joinColumnMap.getReferencedInverseColumns();
                    for (int colIndex = 0; colIndex < invColumns.length; ++colIndex) {
                        ArrayList<ExpressionTree> attrs = new ArrayList<ExpressionTree>();
                        attrs.add(this.genUtils.createAnnotationArgument("name", (Object)invColumns[colIndex].getColumnName()));
                        attrs.add(this.genUtils.createAnnotationArgument("referencedColumnName", (Object)refInvColumns[colIndex].getColumnName()));
                        if (Generator.this.regenTablesAttrs && !invColumns[colIndex].isNullable()) {
                            attrs.add(this.genUtils.createAnnotationArgument("nullable", (Object)false));
                        }
                        inverseCols.add(this.genUtils.createAnnotation("javax.persistence.JoinColumn", attrs));
                    }
                    joinTableAnnArguments.add(this.genUtils.createAnnotationArgument("inverseJoinColumns", inverseCols));
                    annotations.add(this.genUtils.createAnnotation("javax.persistence.JoinTable", joinTableAnnArguments));
                } else {
                    CMPMappingModel.ColumnData[] columns = this.dbMappings.getCmrFieldMapping().get(role.getFieldName());
                    CMPMappingModel relatedMappings = ((EntityClass)Generator.this.beanMap.get(role.getParent().getRoleB().getEntityName())).getCMPMapping();
                    CMPMappingModel.ColumnData[] invColumns = relatedMappings.getCmrFieldMapping().get(role.getParent().getRoleB().getFieldName());
                    if (columns.length == 1) {
                        if (this.existingJoinColumns.get(columns[0].getColumnName()) != null) {
                            return;
                        }
                        ArrayList<ExpressionTree> attrs = new ArrayList<ExpressionTree>();
                        attrs.add(this.genUtils.createAnnotationArgument("name", (Object)columns[0].getColumnName()));
                        attrs.add(this.genUtils.createAnnotationArgument("referencedColumnName", (Object)invColumns[0].getColumnName()));
                        if (Generator.this.regenTablesAttrs && !columns[0].isNullable()) {
                            attrs.add(this.genUtils.createAnnotationArgument("nullable", (Object)false));
                        }
                        this.makeReadOnlyIfNecessary(this.pkColumnNames, columns[0].getColumnName(), attrs);
                        annotations.add(this.genUtils.createAnnotation("javax.persistence.JoinColumn", attrs));
                    } else {
                        if (this.existingJoinColumnss.get(fieldType) != null) {
                            return;
                        }
                        ArrayList<AnnotationTree> joinCols = new ArrayList<AnnotationTree>();
                        for (int colIndex = 0; colIndex < columns.length; ++colIndex) {
                            ArrayList<ExpressionTree> attrs = new ArrayList<ExpressionTree>();
                            attrs.add(this.genUtils.createAnnotationArgument("name", (Object)columns[colIndex].getColumnName()));
                            attrs.add(this.genUtils.createAnnotationArgument("referencedColumnName", (Object)invColumns[colIndex].getColumnName()));
                            if (Generator.this.regenTablesAttrs && !columns[colIndex].isNullable()) {
                                attrs.add(this.genUtils.createAnnotationArgument("nullable", (Object)false));
                            }
                            this.makeReadOnlyIfNecessary(this.pkColumnNames, columns[colIndex].getColumnName(), attrs);
                            joinCols.add(this.genUtils.createAnnotation("javax.persistence.JoinColumn", attrs));
                        }
                        ExpressionTree joinColumnsNameAttrValue = this.genUtils.createAnnotationArgument(null, joinCols);
                        AnnotationTree joinColumnsAnnotation = this.genUtils.createAnnotation("javax.persistence.JoinColumns", Collections.singletonList(joinColumnsNameAttrValue));
                        annotations.add(joinColumnsAnnotation);
                    }
                }
                String relationAnn = role.isMany() && role.isToMany() ? "ManyToMany" : (role.isMany() ? "ManyToOne" : (role.isToMany() ? "OneToMany" : "OneToOne"));
                if (!role.isToMany() && !role.isOptional() && (role.isMany() || role.equals(role.getParent().getRoleA()))) {
                    annArguments.add(this.genUtils.createAnnotationArgument("optional", (Object)false));
                }
                if (Generator.this.fetchType.equals((Object)EntityRelation.FetchType.LAZY)) {
                    annArguments.add(this.genUtils.createAnnotationArgument("fetch", "javax.persistence.FetchType", "LAZY"));
                } else if (Generator.this.fetchType.equals((Object)EntityRelation.FetchType.EAGER)) {
                    annArguments.add(this.genUtils.createAnnotationArgument("fetch", "javax.persistence.FetchType", "EAGER"));
                }
                annotations.add(this.genUtils.createAnnotation("javax.persistence." + relationAnn, annArguments));
                if (Generator.this.generateJAXBAnnotations && role.isToMany()) {
                    this.properties.add(new ClassGenerator.Property(Modifier.PRIVATE, annotations, null, fieldType, memberName, true));
                } else {
                    this.properties.add((ClassGenerator)this.new ClassGenerator.Property(Modifier.PRIVATE, annotations, null, fieldType, memberName));
                }
            }

            private VariableTree createSerialVersionUID() {
                HashSet<Modifier> serialVersionUIDModifiers = new HashSet<Modifier>();
                serialVersionUIDModifiers.add(Modifier.PRIVATE);
                serialVersionUIDModifiers.add(Modifier.STATIC);
                serialVersionUIDModifiers.add(Modifier.FINAL);
                TreeMaker make = this.copy.getTreeMaker();
                VariableTree serialVersionUID = make.Variable(make.Modifiers(serialVersionUIDModifiers), (CharSequence)"serialVersionUID", this.genUtils.createType("long", this.typeElement), (ExpressionTree)make.Literal((Object)Long.valueOf("1")));
                return serialVersionUID;
            }

            @Override
            protected void finish() {
                if (this.needsPKClass && UpdateType.UPDATE.equals((Object)this.updateType)) {
                    return;
                }
                if (this.pkProperty != null) {
                    VariableTree pkFieldParam = this.genUtils.removeModifiers(this.pkProperty.getField());
                    List<VariableTree> pkFieldParams = Collections.singletonList(pkFieldParam);
                    this.constructors.add(this.genUtils.createAssignmentConstructor(this.genUtils.createModifiers(Modifier.PUBLIC), this.entityClassName, pkFieldParams));
                    if (this.nonNullableProps.size() > 0) {
                        ArrayList<VariableTree> nonNullableParams = new ArrayList<VariableTree>(this.nonNullableProps.size() + 1);
                        nonNullableParams.add(pkFieldParam);
                        for (ClassGenerator.Property property : this.nonNullableProps) {
                            nonNullableParams.add(this.genUtils.removeModifiers(property.getField()));
                        }
                        this.constructors.add(this.genUtils.createAssignmentConstructor(this.genUtils.createModifiers(Modifier.PUBLIC), this.entityClassName, nonNullableParams));
                    }
                    if (this.pkClassVariables.size() > 0) {
                        StringBuilder body = new StringBuilder(30 + 30 * this.pkClassVariables.size());
                        body.append("{");
                        body.append("this." + this.pkProperty.getField().getName() + " = new " + this.pkClassName + "(");
                        Iterator<VariableTree> i = this.pkClassVariables.iterator();
                        while (i.hasNext()) {
                            body.append(i.next().getName());
                            body.append(i.hasNext() ? ", " : ");");
                        }
                        body.append("}");
                        TreeMaker make = this.copy.getTreeMaker();
                        this.constructors.add(make.Constructor(make.Modifiers(EnumSet.of(Modifier.PUBLIC), Collections.emptyList()), Collections.emptyList(), this.pkClassVariables, Collections.emptyList(), body.toString()));
                    }
                    EntityMethodGenerator methodGenerator = new EntityMethodGenerator(this.copy, this.genUtils, this.typeElement);
                    this.methods.add(methodGenerator.createHashCodeMethod(pkFieldParams));
                    this.methods.add(methodGenerator.createEqualsMethod(this.entityClassName, pkFieldParams));
                    this.methods.add(methodGenerator.createToStringMethod(this.entityFQClassName, pkFieldParams));
                }
                if (!UpdateType.UPDATE.equals((Object)this.updateType)) {
                    this.fields.add(this.createSerialVersionUID());
                }
            }

            private String getRelationshipFieldType(RelationshipRole role, String pkg) {
                RelationshipRole otherRole;
                RelationshipRole rA = role.getParent().getRoleA();
                RelationshipRole rB = role.getParent().getRoleB();
                RelationshipRole relationshipRole = otherRole = role.equals(rA) ? rB : rA;
                if (role.getEntityPkgName() != null) {
                    return otherRole.getEntityPkgName() + "." + otherRole.getEntityName();
                }
                return pkg.length() == 0 ? otherRole.getEntityName() : pkg + "." + otherRole.getEntityName();
            }

            private void makeReadOnlyIfNecessary(List<String> pkColumnNames, String testColumnName, List<ExpressionTree> attrs) {
                if (pkColumnNames.contains(testColumnName)) {
                    attrs.add(this.genUtils.createAnnotationArgument("insertable", (Object)false));
                    attrs.add(this.genUtils.createAnnotationArgument("updatable", (Object)false));
                }
            }
        }

        private abstract class ClassGenerator {
            protected final WorkingCopy copy;
            protected final GenerationUtils genUtils;
            protected final EntityClass entityClass;
            protected final CMPMappingModel dbMappings;
            protected final boolean needsPKClass;
            protected final String pkClassName;
            protected final String pkFQClassName;
            protected final List<Property> properties = new ArrayList<Property>();
            protected final List<MethodTree> methods = new ArrayList<MethodTree>();
            protected final List<MethodTree> constructors = new ArrayList<MethodTree>();
            protected final List<VariableTree> fields = new ArrayList<VariableTree>();
            protected ClassTree originalClassTree;
            protected ClassTree newClassTree;
            protected TypeElement typeElement;
            protected UpdateType updateType;
            private boolean decimalCommentExist = false;

            public ClassGenerator(WorkingCopy copy, EntityClass entityClass) throws IOException {
                this.copy = copy;
                copy.toPhase(JavaSource.Phase.RESOLVED);
                this.entityClass = entityClass;
                this.updateType = entityClass.getUpdateType();
                this.dbMappings = entityClass.getCMPMapping();
                this.needsPKClass = entityClass.isForTable() && !entityClass.isUsePkField();
                this.pkClassName = this.needsPKClass ? Generator.createPKClassName(entityClass.getClassName()) : null;
                this.pkFQClassName = entityClass.getPackage() + "." + this.pkClassName;
                this.typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)copy);
                if (this.typeElement == null) {
                    throw new IllegalStateException("Cannot find a public top-level class named " + entityClass.getClassName() + " in " + FileUtil.getFileDisplayName((FileObject)copy.getFileObject()));
                }
                this.originalClassTree = copy.getTrees().getTree(this.typeElement);
                assert (this.originalClassTree != null);
                this.newClassTree = this.originalClassTree;
                this.genUtils = GenerationUtils.newInstance((WorkingCopy)copy);
            }

            protected String createFieldName(String capitalizedFieldName) {
                return this.createFieldNameImpl(capitalizedFieldName, false);
            }

            protected String createCapitalizedFieldName(String fieldName) {
                return this.createFieldNameImpl(fieldName, true);
            }

            private String createFieldNameImpl(String fieldName, boolean capitalized) {
                StringBuilder sb = new StringBuilder(fieldName);
                char firstChar = sb.charAt(0);
                sb.setCharAt(0, capitalized ? Character.toUpperCase(firstChar) : Character.toLowerCase(firstChar));
                return sb.toString();
            }

            protected Property createProperty(EntityMember m) throws IOException {
                String temporalType;
                boolean isLobType;
                boolean isPKMember = m.isPrimaryKey();
                ArrayList<AnnotationTree> annotations = new ArrayList<AnnotationTree>();
                if (isPKMember && !this.needsPKClass) {
                    annotations.add(this.genUtils.createAnnotation("javax.persistence.Id"));
                    if (m.isAutoIncrement()) {
                        ArrayList<ExpressionTree> annArguments = new ArrayList<ExpressionTree>();
                        annArguments.add(this.genUtils.createAnnotationArgument("strategy", "javax.persistence.GenerationType", "IDENTITY"));
                        annotations.add(this.genUtils.createAnnotation("javax.persistence.GeneratedValue", annArguments));
                    }
                }
                if (!m.isNullable()) {
                    ArrayList<ExpressionTree> basicAnnArguments = new ArrayList<ExpressionTree>();
                    basicAnnArguments.add(this.genUtils.createAnnotationArgument("optional", (Object)false));
                    annotations.add(this.genUtils.createAnnotation("javax.persistence.Basic", basicAnnArguments));
                    if (Generator.this.generateValidationConstraints && !m.isAutoIncrement()) {
                        annotations.add(this.genUtils.createAnnotation("javax.validation.constraints.NotNull"));
                    }
                }
                if (isLobType = m.isLobType()) {
                    annotations.add(this.genUtils.createAnnotation("javax.persistence.Lob"));
                }
                ArrayList<ExpressionTree> columnAnnArguments = new ArrayList<ExpressionTree>();
                String memberName = m.getMemberName();
                String memberType = this.getMemberType(m);
                String columnName = this.dbMappings.getCMPFieldMapping().get(memberName);
                if (!Generator.this.useDefaults || !memberName.equalsIgnoreCase(columnName)) {
                    columnAnnArguments.add(this.genUtils.createAnnotationArgument("name", (Object)columnName));
                }
                if (Generator.this.regenTablesAttrs && !m.isNullable()) {
                    columnAnnArguments.add(this.genUtils.createAnnotationArgument("nullable", (Object)false));
                }
                Integer length = m.getLength();
                Integer precision = m.getPrecision();
                Integer scale = m.getScale();
                Comment comment = null;
                if (length != null && this.isCharacterType(memberType) && Generator.this.generateValidationConstraints) {
                    String commentString;
                    String regexpString;
                    if (memberName.equalsIgnoreCase("email")) {
                        regexpString = "[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?";
                        commentString = NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"MSG_ANNOTATION_EMAIL_COMMENT");
                        comment = Comment.create((Comment.Style)Comment.Style.LINE, (String)("@Pattern(regexp=\"" + regexpString + "\", " + "message=\"" + NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"ERR_INVALID_EMAIL") + "\")" + commentString));
                    } else if (memberName.equalsIgnoreCase("phone") || memberName.equalsIgnoreCase("fax")) {
                        regexpString = "^\\\\(?(\\\\d{3})\\\\)?[- ]?(\\\\d{3})[- ]?(\\\\d{4})$";
                        commentString = NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"MSG_ANNOTATION_PHONE_COMMENT");
                        comment = Comment.create((Comment.Style)Comment.Style.LINE, (String)("@Pattern(regexp=\"" + regexpString + "\", " + "message=\"" + NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"ERR_INVALID_PHONE") + "\")" + commentString));
                    }
                    ArrayList<ExpressionTree> sizeAnnArguments = new ArrayList<ExpressionTree>();
                    if (!m.isNullable()) {
                        sizeAnnArguments.add(this.genUtils.createAnnotationArgument("min", (Object)1));
                    }
                    sizeAnnArguments.add(this.genUtils.createAnnotationArgument("max", (Object)length));
                    annotations.add(this.genUtils.createAnnotation("javax.validation.constraints.Size", sizeAnnArguments));
                }
                if (this.isDecimalType(memberType) && !this.decimalCommentExist) {
                    comment = Comment.create((Comment.Style)Comment.Style.LINE, (String)("@Max(value=?)  @Min(value=?)" + NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"MSG_ANNOTATION_COMMENT_DECIMAL")));
                    this.decimalCommentExist = true;
                }
                if (Generator.this.regenTablesAttrs) {
                    if (length != null && this.isCharacterType(memberType)) {
                        columnAnnArguments.add(this.genUtils.createAnnotationArgument("length", (Object)length));
                    }
                    if (precision != null && this.isDecimalType(memberType)) {
                        columnAnnArguments.add(this.genUtils.createAnnotationArgument("precision", (Object)precision));
                    }
                    if (scale != null && this.isDecimalType(memberType)) {
                        columnAnnArguments.add(this.genUtils.createAnnotationArgument("scale", (Object)scale));
                    }
                }
                if (!Generator.this.useDefaults || columnAnnArguments != null && !columnAnnArguments.isEmpty()) {
                    annotations.add(this.genUtils.createAnnotation("javax.persistence.Column", columnAnnArguments));
                }
                if ((temporalType = this.getMemberTemporalType(m)) != null) {
                    ExpressionTree temporalAnnValueArgument = this.genUtils.createAnnotationArgument(null, "javax.persistence.TemporalType", temporalType);
                    annotations.add(this.genUtils.createAnnotation("javax.persistence.Temporal", Collections.singletonList(temporalAnnValueArgument)));
                }
                return new Property(Modifier.PRIVATE, annotations, comment, memberType, memberName);
            }

            protected VariableTree createVariable(EntityMember m) {
                return this.genUtils.createVariable(this.typeElement, m.getMemberName(), this.getMemberType(m));
            }

            String getMemberType(EntityMember m) {
                String memberType = m.getMemberType();
                if ("java.sql.Date".equals(memberType)) {
                    memberType = "java.util.Date";
                } else if ("java.sql.Time".equals(memberType)) {
                    memberType = "java.util.Date";
                } else if ("java.sql.Timestamp".equals(memberType)) {
                    memberType = "java.util.Date";
                }
                return memberType;
            }

            private boolean isCharacterType(String type) {
                return "java.lang.String".equals(type);
            }

            private boolean isDecimalType(String type) {
                return "java.lang.Double".equals(type) || "java.lang.Float".equals(type) || "java.math.BigDecimal".equals(type);
            }

            private String getMemberTemporalType(EntityMember m) {
                String memberType = m.getMemberType();
                String temporalType = null;
                if ("java.sql.Date".equals(memberType)) {
                    temporalType = "DATE";
                } else if ("java.sql.Time".equals(memberType)) {
                    temporalType = "TIME";
                } else if ("java.sql.Timestamp".equals(memberType)) {
                    temporalType = "TIMESTAMP";
                }
                return temporalType;
            }

            public void run() throws IOException {
                this.initialize();
                for (EntityMember object : this.entityClass.getFields()) {
                    this.generateMember(object);
                }
                this.afterMembersGenerated();
                for (RelationshipRole roleObject : this.entityClass.getRoles()) {
                    this.generateRelationship(roleObject);
                }
                this.finish();
                TreeMaker make = this.copy.getTreeMaker();
                int position = 0;
                for (VariableTree field : this.fields) {
                    this.newClassTree = make.insertClassMember(this.newClassTree, position, (Tree)field);
                    ++position;
                }
                for (Property property : this.properties) {
                    if (property.getOldField() != null) {
                        this.newClassTree = make.removeClassMember(this.newClassTree, (Tree)property.getOldField());
                    }
                    this.newClassTree = make.insertClassMember(this.newClassTree, position, (Tree)property.getField());
                    ++position;
                }
                for (MethodTree constructor : this.constructors) {
                    this.newClassTree = make.addClassMember(this.newClassTree, (Tree)constructor);
                }
                for (Property property : this.properties) {
                    if (property.getOldGetter() != null) {
                        this.newClassTree = make.removeClassMember(this.newClassTree, (Tree)property.getOldGetter());
                    }
                    this.newClassTree = make.addClassMember(this.newClassTree, (Tree)property.getGetter());
                    if (property.getOldSetter() != null) {
                        this.newClassTree = make.removeClassMember(this.newClassTree, (Tree)property.getOldSetter());
                    }
                    this.newClassTree = make.addClassMember(this.newClassTree, (Tree)property.getSetter());
                }
                for (MethodTree method : this.methods) {
                    this.newClassTree = make.addClassMember(this.newClassTree, (Tree)method);
                }
                Logger.getLogger(JavaPersistenceGenerator.class.getName()).log(Level.FINE, "Rewrite entity tree with name: {0}", this.entityClass.getTableName());
                Logger.getLogger(JavaPersistenceGenerator.class.getName()).log(Level.FINE, "Rewrite entity tree with annotations: length = {0}, annotations = {1}", new Object[]{this.newClassTree.getModifiers().getAnnotations().size(), this.newClassTree.getModifiers().getAnnotations()});
                this.copy.rewrite((Tree)this.originalClassTree, (Tree)this.newClassTree);
            }

            protected abstract void initialize() throws IOException;

            protected abstract void generateMember(EntityMember var1) throws IOException;

            protected abstract void afterMembersGenerated() throws IOException;

            protected abstract void generateRelationship(RelationshipRole var1) throws IOException;

            protected abstract void finish() throws IOException;

            protected final class Property {
                private final VariableTree field;
                private final MethodTree getter;
                private final MethodTree setter;
                private VariableTree existingFieldTree;
                private MethodTree existingGetterTree;
                private MethodTree existingSetterTree;

                public Property(Modifier modifier, List<AnnotationTree> annotations, Comment comment, String type, String name) throws IOException {
                    this(modifier, annotations, comment, classGenerator.genUtils.createType(type, classGenerator.typeElement), name, false);
                }

                public Property(Modifier modifier, List<AnnotationTree> annotations, Comment comment, TypeMirror type, String name) throws IOException {
                    this(modifier, annotations, comment, classGenerator.copy.getTreeMaker().Type(type), name, false);
                }

                private Property(Modifier modifier, List<AnnotationTree> annotations, Comment comment, TypeMirror type, String name, boolean xmlTransient) throws IOException {
                    this(modifier, annotations, comment, classGenerator.copy.getTreeMaker().Type(type), name, xmlTransient);
                }

                private Property(Modifier modifier, List<AnnotationTree> annotations, Comment comment, Tree typeTree, String name, boolean xmlTransient) throws IOException {
                    TreeMaker make = ClassGenerator.this.copy.getTreeMaker();
                    this.field = make.Variable(make.Modifiers(EnumSet.of(modifier), fieldAccess ? annotations : Collections.emptyList()), (CharSequence)name, typeTree, null);
                    if (comment != null) {
                        make.addComment((Tree)this.field, comment, true);
                    }
                    if (xmlTransient) {
                        List<AnnotationTree> annotationTrees;
                        AnnotationTree xmlTransientAn = ClassGenerator.this.genUtils.createAnnotation("javax.xml.bind.annotation.XmlTransient");
                        TypeElement jsonIgnore = ClassGenerator.this.copy.getElements().getTypeElement("org.codehaus.jackson.annotate.JsonIgnore");
                        if (jsonIgnore == null) {
                            annotationTrees = Collections.singletonList(xmlTransientAn);
                        } else {
                            AnnotationTree jsonIgnoreAn = ClassGenerator.this.genUtils.createAnnotation(jsonIgnore.getQualifiedName().toString());
                            annotationTrees = new ArrayList<AnnotationTree>(2);
                            annotationTrees.add(xmlTransientAn);
                            annotationTrees.add(jsonIgnoreAn);
                        }
                        this.getter = ClassGenerator.this.genUtils.createPropertyGetterMethod(make.Modifiers(EnumSet.of(Modifier.PUBLIC), annotationTrees), name, typeTree);
                    } else {
                        this.getter = ClassGenerator.this.genUtils.createPropertyGetterMethod(make.Modifiers(EnumSet.of(Modifier.PUBLIC), fieldAccess ? Collections.emptyList() : annotations), name, typeTree);
                    }
                    this.setter = ClassGenerator.this.genUtils.createPropertySetterMethod(ClassGenerator.this.genUtils.createModifiers(Modifier.PUBLIC), name, typeTree);
                }

                public VariableTree getField() {
                    return this.field;
                }

                public MethodTree getGetter() {
                    return this.getter;
                }

                public MethodTree getSetter() {
                    return this.setter;
                }

                public VariableTree getOldField() {
                    return this.existingFieldTree;
                }

                public MethodTree getOldGetter() {
                    return this.existingGetterTree;
                }

                public MethodTree getOldSetter() {
                    return this.existingSetterTree;
                }

                private void setOldField(VariableTree existingTree) {
                    this.existingFieldTree = existingTree;
                }

                private void setOldGetter(MethodTree existingTree) {
                    this.existingGetterTree = existingTree;
                }

                private void setOldSetter(MethodTree existingTree) {
                    this.existingSetterTree = existingTree;
                }
            }
        }
    }
}

