/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.spi.jpql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.util.Elements;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IJPAVersion;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeVisitor;
import org.eclipse.persistence.jpa.jpql.spi.IPlatform;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappings;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.spi.jpql.Embeddable;
import org.netbeans.modules.j2ee.persistence.spi.jpql.Entity;
import org.netbeans.modules.j2ee.persistence.spi.jpql.ManagedTypeVisitor;
import org.netbeans.modules.j2ee.persistence.spi.jpql.MappedSuperclass;
import org.netbeans.modules.j2ee.persistence.spi.jpql.TypeRepository;

public class ManagedTypeProvider
implements IManagedTypeProvider {
    private final Project project;
    private Map<String, IManagedType> managedTypes;
    private ITypeRepository typeRepository;
    private final EntityMappings mappings;
    private boolean valid = true;
    private final Elements elements;

    public ManagedTypeProvider(Project project, EntityMappingsMetadata metaData, Elements elements) {
        this.project = project;
        this.mappings = metaData.getRoot();
        this.elements = elements;
    }

    public ManagedTypeProvider(Project project, EntityMappings mappings, Elements elements) {
        this.project = project;
        this.mappings = mappings;
        this.elements = elements;
    }

    public Iterable<IEntity> abstractSchemaTypes() {
        this.initializeManagedTypes();
        ManagedTypeVisitor visitor = new ManagedTypeVisitor();
        for (IManagedType managedType : this.managedTypes.values()) {
            managedType.accept((IManagedTypeVisitor)visitor);
        }
        ArrayList<IEntity> abstractSchemaTypes = visitor.getEntities();
        return Collections.unmodifiableCollection(abstractSchemaTypes);
    }

    public IManagedType getManagedType(IType itype) {
        this.initializeManagedTypes();
        for (IManagedType mt : this.managedTypes.values()) {
            if (!this.isValid() || !mt.getType().equals(itype)) continue;
            return mt;
        }
        return null;
    }

    public IManagedType getManagedType(String name) {
        this.initializeManagedTypes();
        return this.managedTypes.get(name);
    }

    public IPlatform getPlatform() {
        return IPlatform.JAVA;
    }

    public ITypeRepository getTypeRepository() {
        if (this.typeRepository == null) {
            this.typeRepository = new TypeRepository(this.project, this, this.elements);
        }
        return this.typeRepository;
    }

    public IJPAVersion getVersion() {
        String version = PersistenceUtils.getJPAVersion(this.project);
        if (version == null || version.startsWith("2")) {
            return IJPAVersion.VERSION_2_0;
        }
        return IJPAVersion.VERSION_1_0;
    }

    public Iterable<IManagedType> managedTypes() {
        this.initializeManagedTypes();
        return Collections.unmodifiableCollection(this.managedTypes.values());
    }

    public boolean isValid() {
        return this.valid;
    }

    public void invalidate() {
        this.valid = false;
        if (this.typeRepository != null) {
            ((TypeRepository)this.typeRepository).invalidate();
            this.typeRepository = null;
        }
    }

    private void initializeManagedTypes() {
        if (this.managedTypes == null) {
            String name;
            this.managedTypes = new HashMap<String, IManagedType>();
            for (org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity entity : this.mappings.getEntity()) {
                if (entity == null || this.managedTypes.containsKey(name = entity.getName())) continue;
                this.managedTypes.put(name, new Entity(entity, (IManagedTypeProvider)this));
            }
            for (org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity entity : this.mappings.getEmbeddable()) {
                if (entity == null || this.managedTypes.containsKey(name = entity.getClass2())) continue;
                this.managedTypes.put(name, new Embeddable((org.netbeans.modules.j2ee.persistence.api.metadata.orm.Embeddable)entity, (IManagedTypeProvider)this));
            }
            for (org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity entity : this.mappings.getMappedSuperclass()) {
                if (entity == null || this.managedTypes.containsKey(name = entity.getClass2())) continue;
                this.managedTypes.put(name, new MappedSuperclass((org.netbeans.modules.j2ee.persistence.api.metadata.orm.MappedSuperclass)entity, (IManagedTypeProvider)this));
            }
        }
    }
}

