/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.spi.jpql;

import java.util.List;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.eclipse.persistence.jpa.jpql.spi.IConstructor;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;
import org.netbeans.modules.j2ee.persistence.spi.jpql.Type;
import org.netbeans.modules.j2ee.persistence.spi.jpql.TypeDeclaration;

public class Constructor
implements IConstructor {
    private final ExecutableElement nbConstructor;
    private final java.lang.reflect.Constructor<?> jConstructor;
    private final IType owner;
    private ITypeDeclaration[] parameterTypes;

    public Constructor(IType owner, ExecutableElement constructor) {
        assert (constructor.getKind() == ElementKind.CONSTRUCTOR);
        this.nbConstructor = constructor;
        this.owner = owner;
        this.jConstructor = null;
    }

    public Constructor(IType owner, java.lang.reflect.Constructor<?> constructor) {
        this.owner = owner;
        this.jConstructor = constructor;
        this.nbConstructor = null;
    }

    public ITypeDeclaration[] getParameterTypes() {
        block4: {
            if (this.parameterTypes != null) break block4;
            if (this.nbConstructor != null) {
                List<? extends VariableElement> params = this.nbConstructor.getParameters();
                this.parameterTypes = new ITypeDeclaration[params.size()];
                for (int i = 0; i < params.size(); ++i) {
                    VariableElement param = params.get(i);
                    this.parameterTypes[i] = this.typeToTypeDeclaration(param.asType());
                }
            } else {
                Class<?>[] types = this.jConstructor.getParameterTypes();
                java.lang.reflect.Type[] genericTypes = this.jConstructor.getGenericParameterTypes();
                this.parameterTypes = new ITypeDeclaration[types.length];
                ITypeRepository typeRepository = ((Type)this.owner).getTypeRepository();
                int count = types.length;
                for (int index = 0; index < count; ++index) {
                    IType type = typeRepository.getType(types[index]);
                    this.parameterTypes[index] = new TypeDeclaration(typeRepository, type, genericTypes[index], types[index].isArray());
                }
            }
        }
        return this.parameterTypes;
    }

    private TypeDeclaration typeToTypeDeclaration(TypeMirror tMirror) {
        DeclaredType dType;
        List<? extends TypeMirror> parameters;
        int dimension = 0;
        TypeMirror aType = tMirror;
        ITypeDeclaration[] generics = null;
        if (tMirror.getKind() == TypeKind.ARRAY) {
            while (aType.getKind() == TypeKind.ARRAY) {
                ++dimension;
                aType = ((ArrayType)tMirror).getComponentType();
            }
        }
        if (aType.getKind() == TypeKind.DECLARED && (parameters = (dType = (DeclaredType)aType).getTypeArguments()) != null && parameters.size() > 0) {
            generics = new ITypeDeclaration[parameters.size()];
            int i = 0;
            for (TypeMirror typeMirror : parameters) {
                generics[i] = this.typeToTypeDeclaration(typeMirror);
                ++i;
            }
        }
        return new TypeDeclaration(this.owner, generics, dimension);
    }
}

