/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.provider;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.persistence.dd.common.Property;

public abstract class Provider {
    public static final String TABLE_GENERATION_CREATE = "tableGenerationCreate";
    public static final String TABLE_GENERATION_DROPCREATE = "tableGenerationDropCreate";
    public static final String TABLE_GENERATTION_UNKOWN = "tableGenerationUnknown";
    private final String providerClass;
    private final Set vendorSpecificProperties;
    private final String version;

    protected Provider(String providerClass) {
        this(providerClass, null);
    }

    protected Provider(String providerClass, String version) {
        assert (null != providerClass && !"".equals(providerClass.trim())) : "Provider class must be given!";
        this.providerClass = providerClass;
        this.version = version;
        this.vendorSpecificProperties = this.initPropertyNames();
    }

    public abstract String getDisplayName();

    public final String getProviderClass() {
        return this.providerClass;
    }

    public boolean isOnClassPath(ClassPath cp) {
        boolean ret;
        String classRelativePath = this.getProviderClass().replace('.', '/') + ".class";
        boolean bl = ret = cp.findResource(classRelativePath) != null;
        if (ret && this.version != null) {
            if ("2.0".equals(this.version)) {
                ret &= cp.findResource("javax/persistence/criteria/JoinType.class") != null;
            } else if ("1.0".equals(this.version)) {
                ret &= cp.findResource("javax/persistence/Entity.class") != null && cp.findResource("javax/persistence/criteria/JoinType.class") == null;
            }
        }
        return ret;
    }

    protected String getVersion() {
        return this.version;
    }

    private Set initPropertyNames() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.getJdbcDriver());
        result.add(this.getJdbcUsername());
        result.add(this.getJdbcUrl());
        result.add(this.getJdbcPassword());
        result.add(this.getTableGenerationPropertyName());
        for (String propertyName : this.getUnresolvedVendorSpecificProperties().keySet()) {
            result.add(propertyName);
        }
        return result;
    }

    public Set getPropertyNames() {
        return this.vendorSpecificProperties;
    }

    public final Property getTableGenerationProperty(String strategy, String version) {
        if ("".equals(this.getTableGenerationPropertyName())) {
            return null;
        }
        Property result = (Property)("2.0".equals(version) ? new org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.Property() : new org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Property());
        result.setName(this.getTableGenerationPropertyName());
        if (TABLE_GENERATION_CREATE.equals(strategy)) {
            result.setValue(this.getTableGenerationCreateValue());
        } else if (TABLE_GENERATION_DROPCREATE.equals(strategy)) {
            result.setValue(this.getTableGenerationDropCreateValue());
        } else {
            return null;
        }
        return result;
    }

    public final String getDefaultJtaDatasource() {
        return "jdbc/__default";
    }

    public String getJdbcUrl() {
        return "javax.persistence.jdbc.url";
    }

    public String getJdbcDriver() {
        return "javax.persistence.jdbc.driver";
    }

    public String getJdbcUsername() {
        return "javax.persistence.jdbc.user";
    }

    public String getJdbcPassword() {
        return "javax.persistence.jdbc.password";
    }

    public String getAnnotationProcessor() {
        return null;
    }

    public String getAnnotationSubPackageProperty() {
        return null;
    }

    public abstract String getTableGenerationPropertyName();

    public abstract String getTableGenerationCreateValue();

    public abstract String getTableGenerationDropCreateValue();

    public abstract Map getUnresolvedVendorSpecificProperties();

    public abstract Map getDefaultVendorSpecificProperties();

    public final Map<String, String> getConnectionPropertiesMap(DatabaseConnection connection, String version) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(this.getJdbcDriver(), connection != null ? connection.getDriverClass() : "");
        result.put(this.getJdbcUrl(), connection != null ? connection.getDatabaseURL() : "");
        result.put(this.getJdbcUsername(), connection != null ? connection.getUser() : "");
        result.put(this.getJdbcPassword(), connection != null && connection.getPassword() != null ? connection.getPassword() : "");
        return result;
    }

    public final boolean supportsTableGeneration() {
        return this.getTableGenerationPropertyName() != null && !"".equals(this.getTableGenerationPropertyName().trim());
    }

    public String toString() {
        return this.getDisplayName();
    }

    public int hashCode() {
        return this.providerClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Provider)) {
            return false;
        }
        Provider that = (Provider)obj;
        boolean sameVersion = this.getVersion() != null && this.getVersion().equals(that.getVersion()) || this.getVersion() == null && that.getVersion() == null;
        return this.getClass().equals(that.getClass()) && this.providerClass.equals(that.providerClass) && sameVersion;
    }
}

