/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.jpqleditor.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.eclipse.persistence.jpa.jpql.ContentAssistProposals;
import org.eclipse.persistence.jpa.jpql.JPQLQueryHelper;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IQuery;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappings;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.editor.completion.JPACompletionItem;
import org.netbeans.modules.j2ee.persistence.jpqleditor.ui.JPQLEditorTopComponent;
import org.netbeans.modules.j2ee.persistence.spi.EntityClassScopeProvider;
import org.netbeans.modules.j2ee.persistence.spi.jpql.ManagedTypeProvider;
import org.netbeans.modules.j2ee.persistence.spi.jpql.Query;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JPQLEditorCodeCompletionProvider
implements CompletionProvider {
    public static final String MIME_JPQL = "text/x-jpql";

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType != 1 && queryType != 9) {
            return null;
        }
        return new AsyncCompletionTask((AsyncCompletionQuery)new JPACodeCompletionQuery(queryType, component, component.getSelectionStart(), true), component);
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    class JPACodeCompletionQuery
    extends AsyncCompletionQuery {
        private List<JPACompletionItem> results;
        private byte hasAdditionalItems = 0;
        private int anchorOffset;
        private JTextComponent component;
        private int queryType;
        private int caretOffset;
        private String filterPrefix;
        private boolean hasTask;

        public JPACodeCompletionQuery(int queryType, JTextComponent component, int caretOffset, boolean hasTask) {
            this.queryType = queryType;
            this.caretOffset = caretOffset;
            this.hasTask = hasTask;
            this.component = component;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            try {
                this.caretOffset = caretOffset;
                this.results = null;
                this.anchorOffset = -1;
                Source source = Source.create((Document)doc);
                if (source != null) {
                    JPQLEditorTopComponent tc = (JPQLEditorTopComponent)NbEditorUtilities.getTopComponent((JTextComponent)this.component);
                    PUDataObject puObject = tc.getDataObject();
                    final FileObject pXml = puObject.getPrimaryFile();
                    final Project project = FileOwnerQuery.getOwner((FileObject)pXml);
                    if (project == null) {
                        return;
                    }
                    SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
                    JavaSource js = JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)sourceGroups[0].getRootFolder()), (FileObject[])new FileObject[0]);
                    js.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController parameter) throws Exception {
                            JPACodeCompletionQuery.this.run(parameter, project, pXml);
                        }
                    }, false);
                    if ((this.queryType & 1) != 0) {
                        if (this.results != null) {
                            resultSet.addAllItems(this.results);
                        }
                        resultSet.setHasAdditionalItems(this.hasAdditionalItems > 0);
                        if (this.hasAdditionalItems == 1) {
                            resultSet.setHasAdditionalItemsText(NbBundle.getMessage(JPQLEditorCodeCompletionProvider.class, (String)"JCP-imported-items"));
                        }
                        if (this.hasAdditionalItems == 2) {
                            resultSet.setHasAdditionalItemsText(NbBundle.getMessage(JPQLEditorCodeCompletionProvider.class, (String)"JCP-instance-members"));
                        }
                    }
                    if (this.anchorOffset > -1) {
                        resultSet.setAnchorOffset(this.anchorOffset);
                    }
                }
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            finally {
                resultSet.finish();
            }
        }

        protected boolean canFilter(JTextComponent component) {
            return false;
        }

        protected void filter(CompletionResultSet resultSet) {
            try {
                if ((this.queryType & 1) != 0 && this.results != null) {
                    if (this.filterPrefix != null) {
                        resultSet.addAllItems(this.getFilteredData(this.results, this.filterPrefix));
                        resultSet.setHasAdditionalItems(this.hasAdditionalItems > 0);
                    } else {
                        Completion.get().hideDocumentation();
                        Completion.get().hideCompletion();
                    }
                }
                resultSet.setAnchorOffset(this.anchorOffset);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            resultSet.finish();
        }

        private Collection getFilteredData(Collection<JPACompletionItem> data, String prefix) {
            if (prefix.length() == 0) {
                return data;
            }
            ArrayList<CompletionItem> ret = new ArrayList<CompletionItem>();
            for (CompletionItem completionItem : data) {
                if (!((Object)completionItem.getInsertPrefix()).toString().startsWith(prefix)) continue;
                ret.add(completionItem);
            }
            return ret;
        }

        private void run(CompilationController controller, Project project, FileObject fo) throws MetadataModelException, IOException {
            if (this.hasTask && !this.isTaskCancelled()) {
                int startOffset = this.caretOffset;
                this.results = new ArrayList<JPACompletionItem>();
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                EntityClassScopeProvider provider = (EntityClassScopeProvider)project.getLookup().lookup(EntityClassScopeProvider.class);
                EntityClassScope ecs = null;
                if (provider != null) {
                    ecs = provider.findEntityClassScope(fo);
                }
                TaskUserAction task = new TaskUserAction(controller, this.component.getText(), fo, startOffset);
                EntityClassScope scope = ecs;
                MetadataModel entityMappingsModel = null;
                if (scope != null) {
                    entityMappingsModel = scope.getEntityMappingsModel(false);
                }
                if (entityMappingsModel != null) {
                    entityMappingsModel.runReadAction((MetadataModelAction)task);
                }
            }
        }

        private class TaskUserAction
        implements MetadataModelAction<EntityMappingsMetadata, Boolean> {
            private final CompilationController controller;
            private final int startOffset;
            private boolean valid;
            private final FileObject fo;
            private final String completedValue;

            private TaskUserAction(CompilationController controller, String value, FileObject fo, int startOffset) {
                this.controller = controller;
                this.fo = fo;
                this.startOffset = startOffset;
                this.completedValue = value;
                this.valid = false;
            }

            public boolean isValid() {
                return this.valid;
            }

            public Boolean run(EntityMappingsMetadata metadata) throws Exception {
                if (metadata.getRoot() == null) {
                    ErrorManager.getDefault().log(1, "No EnitityMappings defined.");
                } else {
                    this.completeJPQLContext(metadata.getRoot(), this.completedValue, JPACodeCompletionQuery.this.results);
                    this.valid = true;
                }
                return this.valid;
            }

            private List completeJPQLContext(EntityMappings mappings, String completedValue, List<JPACompletionItem> results) {
                JPQLQueryHelper helper = new JPQLQueryHelper();
                Project project = FileOwnerQuery.getOwner((FileObject)this.fo);
                helper.setQuery((IQuery)new Query(null, completedValue, new ManagedTypeProvider(project, mappings, this.controller.getElements())));
                int offset = this.startOffset;
                ContentAssistProposals buildContentAssistProposals = helper.buildContentAssistProposals(offset);
                if (buildContentAssistProposals != null && buildContentAssistProposals.hasProposals()) {
                    for (String var : buildContentAssistProposals.identificationVariables()) {
                        results.add(new JPACompletionItem.JPQLElementItem(var, false, false, 0, offset, completedValue, buildContentAssistProposals));
                    }
                    for (IMapping mapping : buildContentAssistProposals.mappings()) {
                        results.add(new JPACompletionItem.JPQLElementItem(mapping.getName(), false, false, 0, offset, completedValue, buildContentAssistProposals));
                    }
                    for (IEntity entity : buildContentAssistProposals.abstractSchemaTypes()) {
                        results.add(new JPACompletionItem.JPQLElementItem(entity.getName(), false, false, 0, offset, completedValue, buildContentAssistProposals));
                    }
                    for (String ids : buildContentAssistProposals.identifiers()) {
                        results.add(new JPACompletionItem.JPQLElementItem(ids, false, false, 0, offset, completedValue, buildContentAssistProposals));
                    }
                }
                return results;
            }
        }
    }
}

