/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.jpqleditor;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.persistence.api.PersistenceEnvironment;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class Utils {
    public static List<String> substitutePersistenceProperties(PersistenceEnvironment pe, PersistenceUnit pu, DatabaseConnection dbconn, Map<String, String> props) {
        boolean containerManaged = Util.isSupportedJavaEEVersion(pe.getProject());
        Provider provider = ProviderUtil.getProvider(pu.getProvider(), pe.getProject());
        ArrayList<String> problems = new ArrayList<String>();
        if (containerManaged) {
            props.put("javax.persistence.provider", provider.getProviderClass());
            props.put("javax.persistence.transactionType", "RESOURCE_LOCAL");
            if (dbconn != null) {
                props.put(provider.getJdbcUrl(), dbconn.getDatabaseURL());
                props.put(provider.getJdbcDriver(), dbconn.getDriverClass());
                props.put(provider.getJdbcUsername(), dbconn.getUser());
                props.put(provider.getJdbcPassword(), dbconn.getPassword());
            }
        }
        return problems;
    }

    public static List<String> collectClassPathURLs(PersistenceEnvironment pe, PersistenceUnit pu, DatabaseConnection dbconn, List<URL> localResourcesURLList) {
        boolean containerManaged = Util.isSupportedJavaEEVersion(pe.getProject());
        Provider provider = ProviderUtil.getProvider(pu.getProvider(), pe.getProject());
        ArrayList<String> problems = new ArrayList<String>();
        List projectURLs = pe.getProjectClassPath(pe.getLocation());
        int sources_count = 0;
        for (URL url : projectURLs) {
            if (!"file".equals(url.getProtocol()) || !new File(url.getFile()).exists()) continue;
            ++sources_count;
            break;
        }
        if (provider == null) {
            problems.add(NbBundle.getMessage(Utils.class, (String)"NoValidProvider"));
        } else if (sources_count == 0) {
            problems.add(NbBundle.getMessage(Utils.class, (String)"NoValidClasspath"));
        } else if (pe.getLocation() == null || pe.getLocation().getFileObject("persistence.xml") == null) {
            problems.add(NbBundle.getMessage(Utils.class, (String)"NoValidPersistenceXml"));
        } else {
            FileObject fob;
            String resourceName;
            localResourcesURLList.addAll(projectURLs);
            localResourcesURLList.add(pe.getLocation().getParent().toURL());
            localResourcesURLList.add(pe.getLocation().toURL());
            localResourcesURLList.add(pe.getLocation().getFileObject("persistence.xml").toURL());
            SourceGroup[] sgs = ProjectUtils.getSources((Project)pe.getProject()).getSourceGroups("java");
            FileObject sourceRoot = sgs[0].getRootFolder();
            ClassPathProvider cpProv = (ClassPathProvider)pe.getProject().getLookup().lookup(ClassPathProvider.class);
            ClassPath cp = cpProv.findClassPath(sourceRoot, "classpath/execute");
            if (cp == null) {
                cp = cpProv.findClassPath(sourceRoot, "classpath/compile");
            }
            if (containerManaged) {
                String providerClassName = provider.getProviderClass();
                resourceName = providerClassName.replace('.', '/') + ".class";
                if (cp != null && (fob = cp.findResource(resourceName)) == null) {
                    Library library = PersistenceLibrarySupport.getLibrary(provider);
                    if (library != null) {
                        localResourcesURLList.addAll(library.getContent("classpath"));
                    } else {
                        problems.add(NbBundle.getMessage(Utils.class, (String)"ProviderAbsent"));
                    }
                }
            }
            if (dbconn != null) {
                String driverClassName = dbconn.getDriverClass();
                resourceName = driverClassName.replace('.', '/') + ".class";
                if (cp != null && (fob = cp.findResource(resourceName)) == null) {
                    JDBCDriver[] driver = JDBCDriverManager.getDefault().getDrivers(driverClassName);
                    if (driver != null && driver.length > 0) {
                        localResourcesURLList.addAll(Arrays.asList(driver[0].getURLs()));
                    } else {
                        problems.add(NbBundle.getMessage(Utils.class, (String)"DriverAbsent"));
                    }
                }
            } else {
                problems.add(NbBundle.getMessage(Utils.class, (String)"DatabaseConnectionAbsent"));
            }
        }
        return problems;
    }
}

