/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.indexing;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.api.PersistenceLocation;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class CopyResourcesIndexer
extends CustomIndexer {
    private static final String NAME = "CopyResourcesIndexer";
    private static final int VERSION = 1;
    private static final String MIME_JAVA = "text/x-java";
    private static final String JAVA_NAME = "java";
    private static final String PATH_TEMPLATE = "%s/%d/classes/META-INF";
    private static final String PERSISTENCE_XML = "persistence.xml";
    private static final String ORM_XML = "orm.xml";
    private final Factory factory;

    private CopyResourcesIndexer(Factory factory) {
        this.factory = factory;
    }

    protected void index(Iterable<? extends Indexable> files, Context context) {
    }

    public static class Factory
    extends CustomIndexerFactory {
        private volatile String cachedPath;
        private FileObject activeRoot;
        private Date timestampPersistenceXml = null;
        private long lengthPersistenceXml = 0L;
        private Date timestampOrmXml = null;
        private long lengthOrmXml = 0L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean scanStarted(Context context) {
            FileObject persistenceXML;
            FileObject persistenceXmlLocation;
            URL[] tests;
            Project owner;
            FileObject root = context.getRoot();
            if (root != null && (owner = FileOwnerQuery.getOwner((FileObject)root)) != null && ((tests = UnitTestForSourceQuery.findSources((FileObject)root)) == null || tests.length == 0) && (persistenceXmlLocation = PersistenceLocation.getLocation((Project)owner)) != null && (persistenceXML = persistenceXmlLocation.getFileObject(CopyResourcesIndexer.PERSISTENCE_XML)) != null) {
                Date ctsPXml = persistenceXML.lastModified();
                long clPXml = persistenceXML.getSize();
                FileObject ormXML = persistenceXmlLocation.getFileObject(CopyResourcesIndexer.ORM_XML);
                Date ctsOXml = ormXML != null ? ormXML.lastModified() : null;
                long clOXml = ormXML != null ? ormXML.getSize() : 0L;
                boolean keepPersistenceXML = ctsPXml.equals(this.timestampPersistenceXml) && this.lengthPersistenceXml == clPXml;
                boolean keepOrmXML = clOXml == this.lengthOrmXml && (ctsOXml == this.timestampOrmXml || ctsOXml.equals(this.timestampOrmXml));
                Factory factory = this;
                synchronized (factory) {
                    if (root == this.activeRoot && keepPersistenceXML && keepOrmXML) {
                        return super.scanStarted(context);
                    }
                    this.activeRoot = root;
                    this.timestampPersistenceXml = ctsPXml;
                    this.lengthPersistenceXml = clPXml;
                    this.timestampOrmXml = ctsOXml;
                    this.lengthOrmXml = clOXml;
                }
                try {
                    FileObject cacheRoot;
                    FileObject cacheDir;
                    String path = this.getCachePath();
                    if (path != null && (cacheDir = FileUtil.createFolder((FileObject)(cacheRoot = context.getIndexFolder().getParent().getParent()), (String)path)) != null && !keepPersistenceXML) {
                        FileObject toDelete2 = cacheDir.getFileObject(persistenceXML.getName(), persistenceXML.getExt());
                        if (toDelete2 != null) {
                            toDelete2.delete();
                        }
                        FileUtil.copyFile((FileObject)persistenceXML, (FileObject)cacheDir, (String)persistenceXML.getName());
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger("global").log(Level.INFO, "persistebce.xml indexing problem: {0}", ex.getMessage());
                }
            }
            return super.scanStarted(context);
        }

        public CustomIndexer createIndexer() {
            return new CopyResourcesIndexer(this);
        }

        public boolean supportsEmbeddedIndexers() {
            return true;
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
        }

        public String getIndexerName() {
            return CopyResourcesIndexer.NAME;
        }

        public int getIndexVersion() {
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getCachePath() {
            String path = this.cachedPath;
            if (path != null) {
                return path;
            }
            CustomIndexerFactory jif = null;
            Collection factories = MimeLookup.getLookup((String)CopyResourcesIndexer.MIME_JAVA).lookupAll(CustomIndexerFactory.class);
            for (CustomIndexerFactory fact : factories) {
                if (!CopyResourcesIndexer.JAVA_NAME.equals(fact.getIndexerName())) continue;
                jif = fact;
                break;
            }
            if (jif == null) {
                return null;
            }
            Factory factory = this;
            synchronized (factory) {
                this.cachedPath = String.format(CopyResourcesIndexer.PATH_TEMPLATE, jif.getIndexerName(), jif.getIndexVersion());
                return this.cachedPath;
            }
        }
    }
}

