/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor.hyperlink;

import java.awt.Toolkit;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.NamedQuery;
import org.netbeans.modules.j2ee.persistence.spi.EntityClassScopeProvider;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Exceptions;

public class NamedQueryHyperlinkProvider
implements HyperlinkProviderExt {
    private static final Set<JavaTokenId> USABLE_TOKEN_IDS = EnumSet.of(JavaTokenId.STRING_LITERAL);

    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public boolean isHyperlinkPoint(Document doc, int offset, HyperlinkType type) {
        return this.getHyperlinkSpan(doc, offset, type) != null;
    }

    public int[] getHyperlinkSpan(Document doc, int offset, HyperlinkType type) {
        return NamedQueryHyperlinkProvider.getIdentifierSpan(doc, offset, null);
    }

    public void performClickAction(Document doc, int offset, HyperlinkType type) {
        Line ln = this.getLine(doc, offset);
        if (ln != null) {
            ln.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public String getTooltipText(Document doc, int offset, HyperlinkType type) {
        String name;
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = SourceUtils.getJavaTokenSequence((TokenHierarchy)th, (int)offset);
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        if (!ts.moveNext()) {
            return null;
        }
        Token t = ts.token();
        FileObject fo = NamedQueryHyperlinkProvider.getFileObject(doc);
        String query = this.findNq(fo, name = name.substring((name = ((Object)t.text()).toString()).startsWith("\"") ? 1 : 0, name.endsWith("\"") ? name.length() - 1 : name.length()));
        if (query != null) {
            return query;
        }
        return null;
    }

    private Line getLine(Document doc, int offset) {
        String name;
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = SourceUtils.getJavaTokenSequence((TokenHierarchy)th, (int)offset);
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        if (!ts.moveNext()) {
            return null;
        }
        Token t = ts.token();
        FileObject fo = NamedQueryHyperlinkProvider.getFileObject(doc);
        FileObject ent = this.findEntity(fo, name = name.substring((name = ((Object)t.text()).toString()).startsWith("\"") ? 1 : 0, name.endsWith("\"") ? name.length() - 1 : name.length()));
        if (ent != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)ent);
                EditorCookie ec = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
                try {
                    ec.openDocument();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                LineCookie lc = (LineCookie)dobj.getLookup().lookup(LineCookie.class);
                if (lc != null) {
                    Line.Set ls = lc.getLineSet();
                    for (Line line : ls.getLines()) {
                        if (!line.getText().contains("\"" + name + "\"")) continue;
                        return line;
                    }
                }
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    private FileObject findEntity(FileObject javaFile, String nqName) {
        Project prj = FileOwnerQuery.getOwner((FileObject)javaFile);
        if (prj == null) {
            return null;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)javaFile, (String)"classpath/source");
        if (cp == null) {
            return null;
        }
        EntityClassScopeProvider provider = (EntityClassScopeProvider)prj.getLookup().lookup(EntityClassScopeProvider.class);
        EntityClassScope ecs = null;
        Entity[] entities = null;
        if (provider != null) {
            ecs = provider.findEntityClassScope(javaFile);
        }
        if (ecs != null) {
            try {
                entities = (Entity[])ecs.getEntityMappingsModel(false).runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, Entity[]>(){

                    public Entity[] run(EntityMappingsMetadata metadata) throws Exception {
                        return metadata.getRoot().getEntity();
                    }
                });
            }
            catch (MetadataModelException ex) {
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (entities != null) {
            for (Entity entity : entities) {
                for (NamedQuery nq : entity.getNamedQuery()) {
                    if (!nqName.equals(nq.getName())) continue;
                    return cp.findResource(entity.getClass2().replace('.', '/') + ".java");
                }
            }
        }
        return null;
    }

    private String findNq(FileObject javaFile, String nqName) {
        Project prj = FileOwnerQuery.getOwner((FileObject)javaFile);
        if (prj == null) {
            return null;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)javaFile, (String)"classpath/source");
        if (cp == null) {
            return null;
        }
        EntityClassScopeProvider provider = (EntityClassScopeProvider)prj.getLookup().lookup(EntityClassScopeProvider.class);
        EntityClassScope ecs = null;
        Entity[] entities = null;
        if (provider != null) {
            ecs = provider.findEntityClassScope(javaFile);
        }
        if (ecs != null) {
            try {
                entities = (Entity[])ecs.getEntityMappingsModel(false).runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, Entity[]>(){

                    public Entity[] run(EntityMappingsMetadata metadata) throws Exception {
                        return metadata.getRoot().getEntity();
                    }
                });
            }
            catch (MetadataModelException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (entities != null) {
            for (Entity entity : entities) {
                for (NamedQuery nq : entity.getNamedQuery()) {
                    if (!nqName.equals(nq.getName())) continue;
                    return nq.getQuery();
                }
            }
        }
        return null;
    }

    public static int[] getIdentifierSpan(final Document doc, final int offset, Token<JavaTokenId>[] token) {
        FileObject fo = NamedQueryHyperlinkProvider.getFileObject(doc);
        if (fo == null) {
            return null;
        }
        Project prj = FileOwnerQuery.getOwner((FileObject)fo);
        if (prj == null) {
            return null;
        }
        EntityClassScopeProvider eCS = (EntityClassScopeProvider)prj.getLookup().lookup(EntityClassScopeProvider.class);
        if (eCS == null) {
            return null;
        }
        final int[] ret = new int[]{-1, -1};
        doc.render(new Runnable(){

            @Override
            public void run() {
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                TokenSequence ts = SourceUtils.getJavaTokenSequence((TokenHierarchy)th, (int)offset);
                if (ts == null) {
                    return;
                }
                ts.move(offset);
                if (!ts.moveNext()) {
                    return;
                }
                Token t = ts.token();
                boolean hasMessage = false;
                if (USABLE_TOKEN_IDS.contains(t.id())) {
                    for (int i = 0; i < 5 && ts.movePrevious(); ++i) {
                        Token tk = ts.token();
                        if (!TokenUtilities.equals((CharSequence)"createNamedQuery", (Object)tk.text())) continue;
                        hasMessage = true;
                    }
                    if (hasMessage) {
                        ts.move(offset);
                        ts.moveNext();
                        ret[0] = ts.offset();
                        ret[1] = ts.offset() + t.length();
                        return;
                    }
                }
            }
        });
        return ret[0] == -1 ? null : ret;
    }

    private static FileObject getFileObject(Document doc) {
        DataObject od = (DataObject)doc.getProperty("stream");
        return od != null ? od.getPrimaryFile() : null;
    }
}

