/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.eclipse.persistence.jpa.jpql.ContentAssistProposals;
import org.eclipse.persistence.jpa.jpql.JPQLQueryHelper;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.NamedQuery;
import org.netbeans.modules.j2ee.persistence.editor.completion.CCParser;
import org.netbeans.modules.j2ee.persistence.editor.completion.CompletionContextResolver;
import org.netbeans.modules.j2ee.persistence.editor.completion.JPACodeCompletionProvider;
import org.netbeans.modules.j2ee.persistence.editor.completion.JPACompletionItem;
import org.netbeans.modules.j2ee.persistence.editor.completion.Utils;
import org.netbeans.modules.j2ee.persistence.spi.EntityClassScopeProvider;
import org.netbeans.modules.j2ee.persistence.spi.jpql.ManagedTypeProvider;
import org.netbeans.modules.j2ee.persistence.spi.jpql.Query;
import org.openide.filesystems.FileObject;

public class ETCompletionContextResolver
implements CompletionContextResolver {
    private static final Logger LOGGER = Logger.getLogger(ETCompletionContextResolver.class.getName());
    private static final boolean DEBUG = Boolean.getBoolean("debug." + ETCompletionContextResolver.class.getName());

    public List resolve(JPACodeCompletionProvider.Context ctx) {
        List<Object> result = new ResultItemsFilterList(ctx);
        String methodName = ctx.getMethod() == null ? null : ctx.getMethod().getMethodName();
        String annotationName = null;
        CCParser.CC parsedNN = null;
        CCParser.NNAttr nnattr = null;
        if (methodName == null) {
            parsedNN = ctx.getParsedAnnotation();
            if (parsedNN == null) {
                return result;
            }
            nnattr = parsedNN.getAttributeForOffset(ctx.getCompletionOffset());
            if (nnattr == null) {
                return result;
            }
            annotationName = parsedNN.getName();
            if (annotationName == null) {
                return result;
            }
        }
        if ("createNamedQuery".equals(methodName)) {
            result = this.completecreateNamedQueryparameters(ctx, result);
        } else if ("createQuery".equals(methodName)) {
            this.completeJPQLContext(ctx, ctx.getMethod(), result);
        } else if ("NamedQuery".equals(annotationName)) {
            this.completeJPQLContext(ctx, parsedNN, nnattr, result);
        }
        return result;
    }

    private List<JPACompletionItem> completecreateNamedQueryparameters(JPACodeCompletionProvider.Context ctx, List<JPACompletionItem> results) {
        Project prj = FileOwnerQuery.getOwner((FileObject)ctx.getFileObject());
        EntityClassScopeProvider provider = (EntityClassScopeProvider)prj.getLookup().lookup(EntityClassScopeProvider.class);
        EntityClassScope ecs = null;
        Entity[] entities = null;
        if (provider != null) {
            ecs = provider.findEntityClassScope(ctx.getFileObject());
        }
        if (ecs != null) {
            try {
                entities = (Entity[])ecs.getEntityMappingsModel(false).runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, Entity[]>(){

                    public Entity[] run(EntityMappingsMetadata metadata) throws Exception {
                        return metadata.getRoot().getEntity();
                    }
                });
            }
            catch (MetadataModelException ex) {
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (entities != null) {
            for (Entity entity : entities) {
                for (NamedQuery nq : entity.getNamedQuery()) {
                    results.add(new JPACompletionItem.NamedQueryNameItem(nq.getName(), entity.getName(), nq.getQuery(), ctx.getMethod().isWithQ(), ctx.getMethod().getValueOffset()));
                }
            }
        }
        return results;
    }

    private List completeJPQLContext(JPACodeCompletionProvider.Context ctx, CCParser.CC nn, CCParser.NNAttr nnattr, List<JPACompletionItem> results) {
        String completedMember = nnattr.getName();
        if ("query".equals(completedMember)) {
            String completedValue = nnattr.getValue().toString() == null ? "" : nnattr.getValue().toString();
            JPQLQueryHelper helper = new JPQLQueryHelper();
            Project project = FileOwnerQuery.getOwner((FileObject)ctx.getFileObject());
            helper.setQuery((IQuery)new Query(null, completedValue, new ManagedTypeProvider(project, ctx.getEntityMappings(), ctx.getController().getElements())));
            int offset = ctx.getCompletionOffset() - nnattr.getValueOffset() - (nnattr.isValueQuoted() ? 1 : 0);
            ContentAssistProposals buildContentAssistProposals = null;
            try {
                buildContentAssistProposals = offset <= completedValue.length() ? helper.buildContentAssistProposals(offset) : null;
            }
            catch (NullPointerException ex) {
                LOGGER.log(Level.INFO, "exception in eclipsleink", ex);
            }
            if (buildContentAssistProposals != null && buildContentAssistProposals.hasProposals()) {
                for (String var : buildContentAssistProposals.identificationVariables()) {
                    results.add(new JPACompletionItem.JPQLElementItem(var, nnattr.isValueQuoted(), nnattr.getValueOffset(), offset, nnattr.getValue().toString(), buildContentAssistProposals));
                }
                for (IMapping mapping : buildContentAssistProposals.mappings()) {
                    results.add(new JPACompletionItem.JPQLElementItem(mapping.getName(), nnattr.isValueQuoted(), nnattr.getValueOffset(), offset, nnattr.getValue().toString(), buildContentAssistProposals));
                }
                for (IEntity entity : buildContentAssistProposals.abstractSchemaTypes()) {
                    results.add(new JPACompletionItem.JPQLElementItem(entity.getName(), nnattr.isValueQuoted(), nnattr.getValueOffset(), offset, nnattr.getValue().toString(), buildContentAssistProposals));
                }
                for (String ids : buildContentAssistProposals.identifiers()) {
                    results.add(new JPACompletionItem.JPQLElementItem(ids, nnattr.isValueQuoted(), nnattr.getValueOffset(), offset, nnattr.getValue().toString(), buildContentAssistProposals));
                }
            }
        }
        return results;
    }

    private List completeJPQLContext(JPACodeCompletionProvider.Context ctx, CCParser.MD method, List<JPACompletionItem> results) {
        String completedValue = method.getValue();
        if (completedValue == null) {
            return results;
        }
        JPQLQueryHelper helper = new JPQLQueryHelper();
        completedValue = Utils.unquote(completedValue);
        Project project = FileOwnerQuery.getOwner((FileObject)ctx.getFileObject());
        helper.setQuery((IQuery)new Query(null, completedValue, new ManagedTypeProvider(project, ctx.getEntityMappings(), ctx.getController().getElements())));
        int offset = ctx.getCompletionOffset() - method.getValueOffset() - (method.isWithQ() ? 1 : 0);
        ContentAssistProposals buildContentAssistProposals = helper.buildContentAssistProposals(offset);
        if (buildContentAssistProposals != null && buildContentAssistProposals.hasProposals()) {
            for (String var : buildContentAssistProposals.identificationVariables()) {
                if (var == null || var.length() <= 0) continue;
                results.add(new JPACompletionItem.JPQLElementItem(var, true, method.getValueOffset(), offset, completedValue, buildContentAssistProposals));
            }
            for (IMapping mapping : buildContentAssistProposals.mappings()) {
                if (mapping.getName() == null || mapping.getName().length() <= 0) continue;
                results.add(new JPACompletionItem.JPQLElementItem(mapping.getName(), true, method.getValueOffset(), offset, completedValue, buildContentAssistProposals));
            }
            for (IEntity entity : buildContentAssistProposals.abstractSchemaTypes()) {
                if (entity.getName() == null || entity.getName().length() <= 0) continue;
                results.add(new JPACompletionItem.JPQLElementItem(entity.getName(), true, method.getValueOffset(), offset, completedValue, buildContentAssistProposals));
            }
            for (String ids : buildContentAssistProposals.identifiers()) {
                if (ids == null || ids.length() <= 0) continue;
                results.add(new JPACompletionItem.JPQLElementItem(ids, true, method.getValueOffset(), offset, completedValue, buildContentAssistProposals));
            }
        }
        return results;
    }

    private static final class ResultItemsFilterList
    extends ArrayList {
        private JPACodeCompletionProvider.Context ctx;

        public ResultItemsFilterList(JPACodeCompletionProvider.Context ctx) {
            this.ctx = ctx;
        }

        @Override
        public boolean add(Object o) {
            if (!(o instanceof JPACompletionItem)) {
                return false;
            }
            JPACompletionItem ri = (JPACompletionItem)o;
            try {
                String preText = this.ctx.getBaseDocument().getText(ri.getSubstituteOffset(), this.ctx.getCompletionOffset() - ri.getSubstituteOffset());
                if (!ri.canFilter() || ri.getItemText().startsWith(preText)) {
                    return super.add(ri);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return false;
        }
    }
}

