/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.j2ee.persistence.editor.ContextUtilities;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.EndTag;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DocumentContext {
    private static final Logger LOGGER = Logger.getLogger(DocumentContext.class.getName());
    private Document document;
    private XMLSyntaxSupport syntaxSupport;
    private int caretOffset = -1;
    private SyntaxElement element;
    private TokenItem token;
    private boolean valid = false;
    private StartTag docRoot;
    private String defaultNamespace;
    private HashMap<String, String> declaredNamespaces = new HashMap();
    private String schemaLocation;
    private String noNamespaceSchemaLocation;

    DocumentContext(Document document) {
        this.document = document;
        try {
            this.syntaxSupport = (XMLSyntaxSupport)((BaseDocument)document).getSyntaxSupport();
        }
        catch (ClassCastException cce) {
            LOGGER.log(Level.FINE, cce.getMessage());
            this.syntaxSupport = new XMLSyntaxSupport((BaseDocument)document);
        }
    }

    public void reset(int caretOffset) {
        this.caretOffset = caretOffset;
        this.initialize();
    }

    private void initialize() {
        this.valid = true;
        this.declaredNamespaces.clear();
        try {
            this.element = this.syntaxSupport.getElementChain(this.caretOffset);
            this.token = this.syntaxSupport.getTokenChain(this.caretOffset, Math.min(this.document.getLength(), this.caretOffset + 1));
            this.docRoot = ContextUtilities.getRoot(this.element);
            this.populateNamespaces();
        }
        catch (BadLocationException ex) {
            this.valid = false;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public int getCurrentTokenId() {
        if (this.isValid()) {
            return this.token.getTokenID().getNumericID();
        }
        return -1;
    }

    public TokenItem getCurrentToken() {
        if (this.isValid()) {
            return this.token;
        }
        return null;
    }

    public String getCurrentTokenImage() {
        if (this.isValid()) {
            return this.token.getImage();
        }
        return null;
    }

    public SyntaxElement getCurrentElement() {
        return this.element;
    }

    public List<String> getPathFromRoot() {
        if (this.isValid()) {
            SyntaxElement elementRef = this.element;
            Stack<SyntaxElement> stack = new Stack<SyntaxElement>();
            while (elementRef != null) {
                if (elementRef instanceof EndTag || elementRef instanceof EmptyTag && stack.isEmpty() || elementRef instanceof StartTag && stack.isEmpty()) {
                    stack.push(elementRef);
                    elementRef = elementRef.getPrevious();
                    continue;
                }
                if (elementRef instanceof StartTag) {
                    StartTag start = (StartTag)elementRef;
                    if (stack.peek() instanceof EndTag) {
                        EndTag end = (EndTag)stack.peek();
                        if (end.getTagName().equals(start.getTagName())) {
                            stack.pop();
                        }
                    } else {
                        SyntaxElement e = stack.peek();
                        String tagAtTop = e instanceof StartTag ? ((StartTag)e).getTagName() : ((EmptyTag)e).getTagName();
                        stack.push(elementRef);
                    }
                }
                elementRef = elementRef.getPrevious();
            }
            return this.createPath(stack);
        }
        return Collections.emptyList();
    }

    private List<String> createPath(Stack<SyntaxElement> stack) {
        ArrayList<String> pathList = new ArrayList<String>();
        while (!stack.isEmpty()) {
            SyntaxElement top = stack.pop();
            String tagName = top instanceof StartTag ? ((StartTag)top).getTagName() : ((EmptyTag)top).getTagName();
            if (tagName == null) continue;
            pathList.add(tagName);
        }
        return Collections.unmodifiableList(pathList);
    }

    public Document getDocument() {
        return this.document;
    }

    public String lookupNamespacePrefix(String prefix) {
        return this.declaredNamespaces.get(prefix);
    }

    public String getNamespacePrefix(String namespace) {
        for (Map.Entry<String, String> entry : this.declaredNamespaces.entrySet()) {
            if (!entry.getValue().equals(namespace)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Collection<String> getDeclaredNamespaces() {
        return this.declaredNamespaces.values();
    }

    public StartTag getDocRoot() {
        return this.docRoot;
    }

    public int getCaretOffset() {
        return this.caretOffset;
    }

    private void populateNamespaces() {
        SyntaxElement element;
        for (element = this.element; element != null && !(element instanceof StartTag) && !(element instanceof EmptyTag); element = element.getPrevious()) {
        }
        if (element == null) {
            return;
        }
        for (Node node = (Node)element; node != null; node = node.getParentNode()) {
            if (!(node instanceof StartTag) && !(node instanceof EmptyTag)) continue;
            NamedNodeMap attributes = ((Tag)node).getAttributes();
            for (int index = 0; index < attributes.getLength(); ++index) {
                String prefix;
                Attr attr = (Attr)attributes.item(index);
                String attrName = attr.getName();
                String attrValue = attr.getValue();
                if (attrName == null || attrValue == null || (prefix = ContextUtilities.getPrefixFromNamespaceDeclaration(attrName)) == null || this.declaredNamespaces.containsKey(prefix)) continue;
                this.declaredNamespaces.put(prefix, attrValue);
            }
        }
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentContext other = (DocumentContext)obj;
        return this.document == other.document || this.document != null && this.document.equals(other.document);
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + (this.document != null ? this.document.hashCode() : 0);
        return hash;
    }
}

