/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.validation;

import java.util.ArrayList;
import java.util.List;

public final class ValidationResult {
    private final List<Message> errors = new ArrayList<Message>();
    private final List<Message> warnings = new ArrayList<Message>();

    public ValidationResult() {
    }

    public ValidationResult(ValidationResult anotherResult) {
        this.merge(anotherResult);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<Message> getErrors() {
        return new ArrayList<Message>(this.errors);
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public List<Message> getWarnings() {
        return new ArrayList<Message>(this.warnings);
    }

    public void addError(Message error) {
        this.errors.add(error);
    }

    public void addWarning(Message warning) {
        this.warnings.add(warning);
    }

    public void merge(ValidationResult otherResult) {
        this.errors.addAll(otherResult.errors);
        this.warnings.addAll(otherResult.warnings);
    }

    public static final class Message {
        private final String source;
        private final String message;

        public Message(String source, String message) {
            this.source = source;
            this.message = message;
        }

        public String getSource() {
            return this.source;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return "ValidationMessage{source=" + this.source + ", message=" + this.message + '}';
        }
    }
}

