/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.refactoring;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.refactoring.RefactoringUtil;
import org.netbeans.modules.web.refactoring.WebRefactoring;
import org.netbeans.modules.web.refactoring.WebRefactoringPlugin;
import org.netbeans.modules.web.refactoring.rename.TldFolderMove;
import org.netbeans.modules.web.refactoring.rename.TldMove;
import org.netbeans.modules.web.refactoring.rename.TldPackageRename;
import org.netbeans.modules.web.refactoring.rename.TldRename;
import org.netbeans.modules.web.refactoring.rename.WebXmlFolderMove;
import org.netbeans.modules.web.refactoring.rename.WebXmlMove;
import org.netbeans.modules.web.refactoring.rename.WebXmlPackageRename;
import org.netbeans.modules.web.refactoring.rename.WebXmlRename;
import org.netbeans.modules.web.refactoring.safedelete.TldSafeDelete;
import org.netbeans.modules.web.refactoring.safedelete.WebXmlSafeDelete;
import org.netbeans.modules.web.refactoring.whereused.TldWhereUsed;
import org.netbeans.modules.web.refactoring.whereused.WebXmlWhereUsed;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class WebRefactoringFactory
implements RefactoringPluginFactory {
    private static final Logger LOGGER = Logger.getLogger(WebRefactoringFactory.class.getName());

    public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
        boolean folder;
        NonRecursiveFolder pkg = (NonRecursiveFolder)refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class);
        FileObject sourceFO = (FileObject)refactoring.getRefactoringSource().lookup(FileObject.class);
        TreePathHandle handle = this.resolveTreePathHandle(refactoring);
        boolean javaPackage = pkg != null && RefactoringUtil.isOnSourceClasspath(pkg.getFolder());
        boolean bl = folder = sourceFO != null && sourceFO.isFolder();
        if (sourceFO == null) {
            if (handle != null) {
                sourceFO = handle.getFileObject();
            } else if (pkg != null) {
                sourceFO = pkg.getFolder();
            }
        }
        if (sourceFO == null) {
            return null;
        }
        boolean javaFile = sourceFO != null && RefactoringUtil.isJavaFile(sourceFO);
        WebModule wm = WebModule.getWebModule((FileObject)sourceFO);
        if (wm == null) {
            return null;
        }
        FileObject ddFile = wm.getDeploymentDescriptor();
        String clazz = this.resolveClass(handle);
        if (javaFile && clazz == null) {
            LOGGER.fine("Could not resolve the class for: " + sourceFO + ", possibly an empty Java file");
            return null;
        }
        ArrayList<WebRefactoring> refactorings = new ArrayList<WebRefactoring>();
        if (refactoring instanceof RenameRefactoring) {
            RenameRefactoring rename = (RenameRefactoring)refactoring;
            if (javaPackage || folder) {
                if (ddFile != null) {
                    refactorings.add(new WebXmlPackageRename(ddFile, sourceFO, rename));
                }
                refactorings.add(new TldPackageRename(rename, wm, sourceFO));
            } else if (javaFile) {
                if (ddFile != null) {
                    refactorings.add(new WebXmlRename(clazz, rename, ddFile));
                }
                refactorings.add(new TldRename(clazz, rename, wm));
            }
        }
        if (refactoring instanceof WhereUsedQuery && javaFile) {
            WhereUsedQuery whereUsedQuery = (WhereUsedQuery)refactoring;
            if (ddFile != null) {
                refactorings.add(new WebXmlWhereUsed(ddFile, clazz, whereUsedQuery));
            }
            refactorings.add(new TldWhereUsed(clazz, wm, whereUsedQuery));
        }
        if (refactoring instanceof SafeDeleteRefactoring && javaFile) {
            SafeDeleteRefactoring safeDelete = (SafeDeleteRefactoring)refactoring;
            if (ddFile != null) {
                refactorings.add(new WebXmlSafeDelete(ddFile, safeDelete));
            }
            refactorings.add(new TldSafeDelete(safeDelete, wm));
        }
        if (refactoring instanceof MoveRefactoring) {
            MoveRefactoring move = (MoveRefactoring)refactoring;
            if (javaFile) {
                if (ddFile != null) {
                    refactorings.add(new WebXmlMove(ddFile, move));
                }
                refactorings.add(new TldMove(move, wm));
            } else if (folder) {
                if (ddFile != null) {
                    refactorings.add(new WebXmlFolderMove(ddFile, sourceFO, move));
                }
                refactorings.add(new TldFolderMove(wm, sourceFO, move));
            }
        }
        return refactorings.isEmpty() ? null : new WebRefactoringPlugin(refactorings);
    }

    private TreePathHandle resolveTreePathHandle(AbstractRefactoring refactoring) {
        TreePathHandle tph = (TreePathHandle)refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (tph != null) {
            return tph;
        }
        FileObject sourceFO = (FileObject)refactoring.getRefactoringSource().lookup(FileObject.class);
        if (sourceFO == null || !RefactoringUtil.isJavaFile(sourceFO)) {
            return null;
        }
        final TreePathHandle[] result = new TreePathHandle[1];
        try {
            JavaSource source = JavaSource.forFileObject((FileObject)sourceFO);
            source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController co) throws Exception {
                    co.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationUnitTree cut = co.getCompilationUnit();
                    if (cut.getTypeDecls().isEmpty()) {
                        return;
                    }
                    result[0] = TreePathHandle.create((TreePath)TreePath.getPath(cut, cut.getTypeDecls().get(0)), (CompilationInfo)co);
                }
            }, true);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return result[0];
    }

    private String resolveClass(final TreePathHandle treePathHandle) {
        if (treePathHandle == null) {
            return null;
        }
        final String[] result = new String[1];
        try {
            JavaSource source = JavaSource.forFileObject((FileObject)treePathHandle.getFileObject());
            if (source == null) {
                return null;
            }
            source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController parameter) throws Exception {
                    parameter.toPhase(JavaSource.Phase.RESOLVED);
                    Element element = treePathHandle.resolveElement((CompilationInfo)parameter);
                    result[0] = element == null ? null : ((Object)element.asType()).toString();
                }
            }, true);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return result[0];
    }
}

