/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.refactoring;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public class RefactoringUtil {
    private static final String JAVA_MIME_TYPE = "text/x-java";

    private RefactoringUtil() {
    }

    public static Problem addToEnd(Problem toAdd, Problem existing) {
        if (existing == null) {
            return toAdd;
        }
        if (toAdd == null) {
            return existing;
        }
        Problem tail = existing;
        while (tail.getNext() != null) {
            tail = tail.getNext();
        }
        tail.setNext(toAdd);
        return tail;
    }

    public static boolean isJavaFile(FileObject fileObject) {
        return JAVA_MIME_TYPE.equals(fileObject.getMIMEType());
    }

    public static String renameClass(String originalFullyQualifiedName, String newName) {
        Parameters.notEmpty((CharSequence)"originalFullyQualifiedName", (CharSequence)originalFullyQualifiedName);
        Parameters.notEmpty((CharSequence)"newName", (CharSequence)newName);
        int lastDot = originalFullyQualifiedName.lastIndexOf(46);
        return lastDot <= 0 ? newName : originalFullyQualifiedName.substring(0, lastDot + 1) + newName;
    }

    public static boolean isOnSourceClasspath(FileObject fo) {
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        if (p == null) {
            return false;
        }
        if (OpenProjects.getDefault().isProjectOpen(p)) {
            SourceGroup[] gr = ProjectUtils.getSources((Project)p).getSourceGroups("java");
            for (int j = 0; j < gr.length; ++j) {
                if (fo == gr[j].getRootFolder()) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)gr[j].getRootFolder(), (FileObject)fo)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static void collectChildren(FileObject folder, List<FileObject> result) {
        for (FileObject child : folder.getChildren()) {
            if (RefactoringUtil.isJavaFile(child)) {
                result.add(child);
                continue;
            }
            if (!child.isFolder()) continue;
            RefactoringUtil.collectChildren(child, result);
        }
    }

    public static boolean isPackage(RenameRefactoring rename) {
        return rename.getRefactoringSource().lookup(NonRecursiveFolder.class) != null;
    }

    public static String constructNewName(FileObject javaFile, RenameRefactoring rename) {
        String fqn = JavaIdentifiers.getQualifiedName((FileObject)javaFile);
        if (RefactoringUtil.isPackage(rename)) {
            return rename.getNewName() + "." + JavaIdentifiers.unqualify((String)fqn);
        }
        FileObject folder = (FileObject)rename.getRefactoringSource().lookup(FileObject.class);
        ClassPath classPath = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
        if (classPath == null) {
            return "";
        }
        FileObject root = classPath.findOwnerRoot(folder);
        String prefix = FileUtil.getRelativePath((FileObject)root, (FileObject)folder.getParent()).replace('/', '.');
        String oldName = RefactoringUtil.buildName(prefix, folder.getName());
        String newName = RefactoringUtil.buildName(prefix, rename.getNewName());
        int oldNameIndex = fqn.lastIndexOf(oldName) + oldName.length();
        return newName + fqn.substring(oldNameIndex, fqn.length());
    }

    private static String buildName(String prefix, String name) {
        if (prefix.length() == 0) {
            return name;
        }
        return prefix + "." + name;
    }

    public static String getPackageName(URL url) {
        File f = null;
        try {
            f = FileUtil.normalizeFile((File)new File(url.toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Cannot create package name for url " + url);
        }
        String suffix = "";
        do {
            FileObject fo;
            if ((fo = FileUtil.toFileObject((File)f)) != null) {
                if ("".equals(suffix)) {
                    return RefactoringUtil.getPackageName(fo);
                }
                String prefix = RefactoringUtil.getPackageName(fo);
                return prefix + ("".equals(prefix) ? "" : ".") + suffix;
            }
            if (!"".equals(suffix)) {
                suffix = "." + suffix;
            }
            suffix = URLDecoder.decode(f.getPath().substring(f.getPath().lastIndexOf(File.separatorChar) + 1)) + suffix;
        } while ((f = f.getParentFile()) != null);
        throw new IllegalArgumentException("Cannot create package name for url " + url);
    }

    private static String getPackageName(FileObject folder) {
        assert (folder.isFolder()) : "argument must be folder";
        return ClassPath.getClassPath((FileObject)folder, (String)"classpath/source").getResourceName(folder, '.', false);
    }

    public static List<String> getRefactoredClasses(AbstractRefactoring refactoring) {
        HashSet<TreePathHandle> tphs = new HashSet<TreePathHandle>();
        tphs.addAll(refactoring.getRefactoringSource().lookupAll(TreePathHandle.class));
        if (tphs.isEmpty()) {
            Collection fos = refactoring.getRefactoringSource().lookupAll(FileObject.class);
            for (FileObject each : fos) {
                TreePathHandle handle = RefactoringUtil.resolveHandle(each);
                if (handle == null) continue;
                tphs.add(handle);
            }
        }
        final ArrayList<String> result = new ArrayList<String>();
        for (final TreePathHandle handle : tphs) {
            JavaSource source = JavaSource.forFileObject((FileObject)handle.getFileObject());
            try {
                source.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController parameter) throws Exception {
                        parameter.toPhase(JavaSource.Phase.RESOLVED);
                        Element element = handle.resolveElement((CompilationInfo)parameter);
                        result.add(RefactoringUtil.getTypeName(element, parameter));
                    }
                }, true);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return result;
    }

    private static String getTypeName(Element element, CompilationController controller) {
        if (element instanceof TypeElement) {
            try {
                return ((Object)controller.getTypes().erasure(element.asType())).toString();
            }
            catch (IllegalArgumentException e) {
                return ((Object)element.asType()).toString();
            }
        }
        return ((Object)element.asType()).toString();
    }

    private static TreePathHandle resolveHandle(FileObject fileObject) {
        final TreePathHandle[] result = new TreePathHandle[1];
        if (!RefactoringUtil.isJavaFile(fileObject)) {
            return null;
        }
        JavaSource source = JavaSource.forFileObject((FileObject)fileObject);
        try {
            source.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController co) throws Exception {
                    co.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationUnitTree cut = co.getCompilationUnit();
                    if (cut.getTypeDecls().isEmpty()) {
                        return;
                    }
                    result[0] = TreePathHandle.create((TreePath)TreePath.getPath(cut, cut.getTypeDecls().get(0)), (CompilationInfo)co);
                }
            }, true);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return result[0];
    }

    public static boolean isPackageInfo(FileObject fo) {
        return "package-info.java".equals(fo.getNameExt());
    }
}

