/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.java.hints.analysis.Bundle;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.spiimpl.batch.BatchSearch;
import org.netbeans.modules.java.hints.spiimpl.batch.ProgressHandleWrapper;
import org.netbeans.modules.java.hints.spiimpl.batch.Scopes;
import org.netbeans.modules.java.hints.spiimpl.options.HintsPanel;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.modules.java.hints.spiimpl.refactoring.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class AnalyzerImpl
implements Analyzer {
    public static final String ID_JAVA_HINTS_PREFIX = "text/x-java:";
    private final AtomicBoolean cancel = new AtomicBoolean();
    private final Analyzer.Context ctx;
    private final Utilities.ClassPathBasedHintWrapper cpHints;

    private AnalyzerImpl(Analyzer.Context ctx) {
        this.ctx = ctx;
        this.cpHints = new Utilities.ClassPathBasedHintWrapper();
    }

    public Iterable<? extends ErrorDescription> analyze() {
        String singleWarning;
        if (this.ctx.getSingleWarningId() != null) {
            if (!this.ctx.getSingleWarningId().startsWith(ID_JAVA_HINTS_PREFIX)) {
                return Collections.emptyList();
            }
            singleWarning = this.ctx.getSingleWarningId().substring(ID_JAVA_HINTS_PREFIX.length());
        } else {
            singleWarning = null;
        }
        final ArrayList result = new ArrayList();
        ProgressHandleWrapper w = new ProgressHandleWrapper(this.ctx, new int[]{10, 90});
        ArrayList<? extends HintDescription> hints = new ArrayList<HintDescription>();
        for (Map.Entry<? extends HintMetadata, ? extends Collection<? extends HintDescription>> e : Utilities.getBatchSupportedHints(new Utilities.ClassPathBasedHintWrapper()).entrySet()) {
            if (singleWarning != null ? !singleWarning.equals(e.getKey().id) : (this.ctx.getSettings() != null ? !HintsSettings.isEnabled((HintMetadata)e.getKey(), (Preferences)this.ctx.getSettings().node(e.getKey().id)) : !HintsSettings.isEnabled((HintMetadata)e.getKey()))) continue;
            hints.addAll(e.getValue());
        }
        ArrayList todo = new ArrayList();
        todo.addAll(this.ctx.getScope().getSourceRoots());
        todo.addAll(this.ctx.getScope().getFolders());
        todo.addAll(this.ctx.getScope().getFiles());
        BatchSearch.BatchResult candidates = BatchSearch.findOccurrences(hints, (BatchSearch.Scope)Scopes.specifiedFoldersScope((BatchSearch.Folder[])BatchSearch.Folder.convert(todo)), (ProgressHandleWrapper)w);
        LinkedList problems = new LinkedList(candidates.problems);
        BatchSearch.getVerifiedSpans((BatchSearch.BatchResult)candidates, (ProgressHandleWrapper)w, (BatchSearch.VerifiedSpansCallBack)new BatchSearch.VerifiedSpansCallBack(){

            public void groupStarted() {
            }

            public boolean spansVerified(CompilationController wc, BatchSearch.Resource r, Collection<? extends ErrorDescription> inHints) throws Exception {
                result.addAll(inHints);
                return true;
            }

            public void groupFinished() {
            }

            public void cannotVerifySpan(BatchSearch.Resource r) {
            }
        }, problems, (AtomicBoolean)this.cancel);
        w.finish();
        return result;
    }

    public boolean cancel() {
        this.cancel.set(true);
        return true;
    }

    public static final class AnalyzerFactoryImpl
    extends Analyzer.AnalyzerFactory {
        private static final String HINTS_FOLDER = "org-netbeans-modules-java-hints/rules/hints/";

        public AnalyzerFactoryImpl() {
            super("java.hints", Bundle.DN_JavaHints(), "org/netbeans/modules/java/hints/analyzer/ui/warning-glyph.gif");
        }

        public Iterable<? extends Analyzer.WarningDescription> getWarnings() {
            ArrayList<Analyzer.WarningDescription> result = new ArrayList<Analyzer.WarningDescription>();
            for (Map.Entry<? extends HintMetadata, ? extends Collection<? extends HintDescription>> e : Utilities.getBatchSupportedHints(new Utilities.ClassPathBasedHintWrapper()).entrySet()) {
                if (e.getKey().options.contains(HintMetadata.Options.NON_GUI)) continue;
                String displayName = e.getKey().displayName;
                String category = e.getKey().category;
                FileObject catFO = FileUtil.getConfigFile((String)(HINTS_FOLDER + category));
                String categoryDisplayName = catFO != null ? AnalyzerFactoryImpl.getFileObjectLocalizedName(catFO) : Bundle.DN_UnknownCategory();
                result.add(Analyzer.WarningDescription.create((String)(AnalyzerImpl.ID_JAVA_HINTS_PREFIX + e.getKey().id), (String)displayName, (String)category, (String)categoryDisplayName));
            }
            return result;
        }

        static String getFileObjectLocalizedName(FileObject fo) {
            Object o = fo.getAttribute("SystemFileSystem.localizingBundle");
            if (o instanceof String) {
                String bundleName = (String)o;
                try {
                    ResourceBundle rb = NbBundle.getBundle((String)bundleName);
                    String localizedName = rb.getString(fo.getPath());
                    return localizedName;
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            return fo.getPath();
        }

        public Analyzer.CustomizerProvider<Utilities.ClassPathBasedHintWrapper, HintsPanel> getCustomizerProvider() {
            return new Analyzer.CustomizerProvider<Utilities.ClassPathBasedHintWrapper, HintsPanel>(){

                public Utilities.ClassPathBasedHintWrapper initialize() {
                    Utilities.ClassPathBasedHintWrapper w = new Utilities.ClassPathBasedHintWrapper();
                    w.compute();
                    return w;
                }

                public HintsPanel createComponent(Analyzer.CustomizerContext<Utilities.ClassPathBasedHintWrapper, HintsPanel> context) {
                    HintsPanel prev;
                    if (context.getPreselectId() == null) {
                        HintsPanel prev2 = (HintsPanel)context.getPreviousComponent();
                        if (prev2 != null) {
                            prev2.setOverlayPreferences(context.getSettings());
                            return prev2;
                        }
                        return new HintsPanel(context.getSettings(), (Utilities.ClassPathBasedHintWrapper)context.getData());
                    }
                    HintMetadata toSelect = null;
                    for (HintMetadata hintMetadata : Utilities.getBatchSupportedHints((Utilities.ClassPathBasedHintWrapper)context.getData()).keySet()) {
                        if (!context.getPreselectId().equals(AnalyzerImpl.ID_JAVA_HINTS_PREFIX + hintMetadata.id)) continue;
                        toSelect = hintMetadata;
                        break;
                    }
                    for (HintMetadata hintMetadata : ((Utilities.ClassPathBasedHintWrapper)context.getData()).getHints().keySet()) {
                        if (!context.getPreselectId().equals(AnalyzerImpl.ID_JAVA_HINTS_PREFIX + hintMetadata.id)) continue;
                        toSelect = hintMetadata;
                        break;
                    }
                    if ((prev = (HintsPanel)context.getPreviousComponent()) != null) {
                        prev.select(toSelect);
                        return prev;
                    }
                    return new HintsPanel(toSelect, context, (Utilities.ClassPathBasedHintWrapper)context.getData());
                }
            };
        }

        public Analyzer createAnalyzer(Analyzer.Context context) {
            return new AnalyzerImpl(context);
        }
    }
}

