/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gotodeclaration.file;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.gotodeclaration.symbol.CppSymbolProvider;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.spi.jumpto.file.FileDescriptor;
import org.netbeans.spi.jumpto.file.FileProvider;
import org.netbeans.spi.jumpto.file.FileProviderFactory;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.filesystems.FileObject;

public final class LibraryFileProviderFactory
implements FileProviderFactory {
    public String name() {
        return "CND_LIBRARY_FILES";
    }

    public String getDisplayName() {
        return this.name();
    }

    public FileProvider createFileProvider() {
        return new FileProviderImpl();
    }

    private static final class LibraryFileFD
    extends FileDescriptor {
        private final CsmUID<CsmFile> file;
        private final CsmProject project;

        public LibraryFileFD(CsmUID<CsmFile> file, CsmProject project) {
            this.file = file;
            this.project = project;
        }

        public String getFileName() {
            return ((Object)CsmFileInfoQuery.getDefault().getName(this.file)).toString();
        }

        public String getOwnerPath() {
            int indx;
            String ownerPath = ((Object)CsmFileInfoQuery.getDefault().getAbsolutePath(this.file)).toString();
            if (ownerPath.startsWith(((Object)this.project.getName()).toString())) {
                ownerPath = ownerPath.substring(this.project.getName().length() + 1);
            }
            if ((indx = ownerPath.lastIndexOf(47)) < 0) {
                indx = ownerPath.lastIndexOf(92);
            }
            ownerPath = indx > 0 && indx < ownerPath.length() ? ownerPath.substring(0, indx) : "";
            return ownerPath;
        }

        public Icon getIcon() {
            CsmFile csmFile = (CsmFile)this.file.getObject();
            if (csmFile != null) {
                return CsmImageLoader.getIcon((CsmObject)csmFile);
            }
            return null;
        }

        public String getProjectName() {
            return ((Object)this.project.getName()).toString();
        }

        public Icon getProjectIcon() {
            return CsmImageLoader.getProjectIcon((CsmProject)this.project, (boolean)false);
        }

        public void open() {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    CsmUtilities.openSource((CsmObject)((CsmObject)LibraryFileFD.this.file.getObject()));
                }
            };
            CsmModelAccessor.getModel().enqueue(r, (CharSequence)("LibraryFileFD.open(" + this.getFileDisplayPath() + ")"));
        }

        public FileObject getFileObject() {
            return CsmUtilities.getFileObject((CsmFile)((CsmFile)this.file.getObject()));
        }

        public String getFileDisplayPath() {
            CharSequence path = CsmFileInfoQuery.getDefault().getAbsolutePath(this.file);
            return path == null ? "" : ((Object)path).toString();
        }
    }

    private static final class FileProviderImpl
    implements FileProvider {
        private final Map<CsmProject, Set<CsmUID<CsmFile>>> cache = new HashMap<CsmProject, Set<CsmUID<CsmFile>>>();
        private final AtomicBoolean cancel = new AtomicBoolean(false);
        private String cachedTextPrefix = null;
        private String lastText = null;
        private SearchType lastSearchType = null;
        private FileProvider.Context lastQueriedContext;

        private FileProviderImpl() {
        }

        public boolean computeFiles(FileProvider.Context context, FileProvider.Result result) {
            this.cancel.set(false);
            if (this.lastQueriedContext == context && context.getText().equals(this.lastText) && context.getSearchType().equals((Object)this.lastSearchType)) {
                return false;
            }
            this.lastQueriedContext = context;
            boolean validCache = this.cachedTextPrefix != null && this.lastText.startsWith(this.cachedTextPrefix) && context.getSearchType().equals((Object)this.lastSearchType);
            this.lastText = context.getText();
            this.lastSearchType = context.getSearchType();
            if (CsmModelAccessor.getModelState() == CsmModelState.ON) {
                CsmSelect.NameAcceptor nameAcceptor = CppSymbolProvider.createNameAcceptor(this.lastText, this.lastSearchType);
                if (nameAcceptor == null) {
                    if (CndUtils.isDebugMode()) {
                        Logger log = Logger.getLogger("org.netbeans.modules.cnd.gotodeclaration");
                        log.log(Level.SEVERE, "Can not create File Matcher for ''{0}'' search type {1}", new Object[]{this.lastText, this.lastSearchType});
                    }
                    return false;
                }
                if (!validCache) {
                    this.cache.clear();
                    HashSet libs = new HashSet();
                    for (CsmProject csmProject : CsmModelAccessor.getModel().projects()) {
                        if (this.cancel.get()) break;
                        libs.addAll(csmProject.getLibraries());
                    }
                    for (CsmProject csmProject : libs) {
                        if (this.cancel.get()) break;
                        Set<CsmUID<CsmFile>> libFiles = this.cache.get(csmProject);
                        if (libFiles == null) {
                            libFiles = new HashSet<CsmUID<CsmFile>>();
                            this.cache.put(csmProject, libFiles);
                        }
                        Iterator iterator = CsmSelect.getFileUIDs((CsmProject)csmProject, (CsmSelect.NameAcceptor)nameAcceptor);
                        while (iterator.hasNext() && !this.cancel.get()) {
                            CsmUID fileUID = (CsmUID)iterator.next();
                            libFiles.add((CsmUID<CsmFile>)fileUID);
                        }
                    }
                }
                CsmFileInfoQuery fiq = CsmFileInfoQuery.getDefault();
                for (Map.Entry<Object, Set<Object>> entry : this.cache.entrySet()) {
                    for (CsmUID csmUID : entry.getValue()) {
                        CharSequence name = fiq.getName(csmUID);
                        if (!nameAcceptor.accept(name)) continue;
                        result.addFileDescriptor((FileDescriptor)new LibraryFileFD((CsmUID<CsmFile>)csmUID, (CsmProject)entry.getKey()));
                    }
                }
            }
            return false;
        }

        public void cancel() {
            this.cancel.set(true);
        }
    }
}

