/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import jdk.nashorn.api.scripting.NashornException;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ErrorManager;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.options.Options;

public class Shell {
    private static final String MESSAGE_RESOURCE = "jdk.nashorn.tools.resources.Shell";
    private static ResourceBundle bundle = AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

        @Override
        public ResourceBundle run() {
            return ResourceBundle.getBundle(Shell.MESSAGE_RESOURCE, Locale.getDefault());
        }
    });
    public static final int SUCCESS = 0;
    public static final int COMMANDLINE_ERROR = 100;
    public static final int COMPILATION_ERROR = 101;
    public static final int RUNTIME_ERROR = 102;
    public static final int IO_ERROR = 103;
    public static final int INTERNAL_ERROR = 104;

    protected Shell() {
    }

    public static void main(String[] args) {
        try {
            System.exit(Shell.main(System.in, System.out, System.err, args));
        }
        catch (IOException e) {
            System.err.println(e);
            System.exit(103);
        }
    }

    public static int main(InputStream in, OutputStream out, OutputStream err, String[] args) throws IOException {
        return new Shell().run(in, out, err, args);
    }

    protected int run(InputStream in, OutputStream out, OutputStream err, String[] args) throws IOException {
        Context context = this.makeContext(in, out, err, args);
        if (context == null) {
            return 100;
        }
        ScriptObject global = context.createGlobal();
        List<String> files = context.getOptions().getFiles();
        if (files.isEmpty()) {
            return this.readEvalPrint(global);
        }
        if (context._compile_only) {
            return this.compileScripts(global, files);
        }
        return this.runScripts(global, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Context makeContext(InputStream in, OutputStream out, OutputStream err, String[] args) {
        PrintStream pout = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out);
        PrintStream perr = err instanceof PrintStream ? (PrintStream)err : new PrintStream(err);
        PrintWriter wout = new PrintWriter(pout, true);
        PrintWriter werr = new PrintWriter(perr, true);
        ErrorManager errors = new ErrorManager(werr);
        Options options = new Options("nashorn", werr);
        try {
            options.process(args);
        }
        catch (IllegalArgumentException e) {
            werr.println(bundle.getString("shell.usage"));
            options.displayHelp(e);
            return null;
        }
        if (!options.getBoolean("scripting")) {
            for (String fileName : options.getFiles()) {
                File firstFile = new File(fileName);
                if (!firstFile.isFile()) continue;
                try {
                    FileReader fr = new FileReader(firstFile);
                    try {
                        int firstChar = fr.read();
                        if (firstChar != 35) continue;
                        options.set("scripting", true);
                        break;
                    }
                    finally {
                        fr.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return new Context(options, errors, wout, werr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int compileScripts(ScriptObject global, List<String> files) throws IOException {
        Context context = global.getContext();
        ScriptObject oldGlobal = Context.getGlobal();
        boolean globalChanged = oldGlobal != global;
        try {
            if (globalChanged) {
                Context.setGlobal(global);
            }
            ErrorManager errors = context.getErrors();
            for (String fileName : files) {
                File file = new File(fileName);
                Source source = new Source(fileName, file);
                Compiler compiler = Compiler.compiler(source, context);
                compiler.compile();
                if (errors.getNumberOfErrors() == 0) continue;
                int n = 101;
                return n;
            }
        }
        finally {
            context.getOut().flush();
            context.getErr().flush();
            if (globalChanged) {
                Context.setGlobal(oldGlobal);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int runScripts(ScriptObject global, List<String> files) throws IOException {
        Context context = global.getContext();
        ScriptObject oldGlobal = Context.getGlobal();
        boolean globalChanged = oldGlobal != global;
        try {
            if (globalChanged) {
                Context.setGlobal(global);
            }
            ErrorManager errors = context.getErrors();
            for (String fileName : files) {
                File file;
                ScriptFunction script = context.compileScript(fileName, (file = new File(fileName)).toURI().toURL(), global, context._strict);
                if (script == null || errors.getNumberOfErrors() != 0) {
                    int n = 101;
                    return n;
                }
                try {
                    this.apply(script, global);
                }
                catch (NashornException e) {
                    errors.error(e.toString());
                    if (context._dump_on_error) {
                        e.printStackTrace(context.getErr());
                    }
                    int n = 102;
                    context.getOut().flush();
                    context.getErr().flush();
                    if (globalChanged) {
                        Context.setGlobal(oldGlobal);
                    }
                    return n;
                }
            }
        }
        finally {
            context.getOut().flush();
            context.getErr().flush();
            if (globalChanged) {
                Context.setGlobal(oldGlobal);
            }
        }
        return 0;
    }

    protected Object apply(ScriptFunction target, Object self) {
        return ScriptRuntime.apply(target, self, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readEvalPrint(ScriptObject global) {
        Context context = global.getContext();
        String prompt = bundle.getString("shell.prompt");
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        PrintWriter err = context.getErr();
        ScriptObject oldGlobal = Context.getGlobal();
        boolean globalChanged = oldGlobal != global;
        try {
            Object source;
            if (globalChanged) {
                Context.setGlobal(global);
            }
            try {
                source = new Source("<shell.js>", Shell.class.getResource("resources/shell.js"));
                context.eval(global, ((Source)source).getString(), global, "<shell.js>", false);
            }
            catch (Exception e) {
                err.println(e);
                if (context._dump_on_error) {
                    e.printStackTrace(err);
                }
                int n = 104;
                if (globalChanged) {
                    Context.setGlobal(global);
                }
                return n;
            }
            while (true) {
                Object res;
                err.print(prompt);
                err.flush();
                source = "";
                try {
                    source = in.readLine();
                }
                catch (IOException ioe) {
                    err.println(ioe.toString());
                }
                if (source == null) {
                    break;
                }
                try {
                    res = context.eval(global, (String)source, global, "<shell>", context._strict);
                }
                catch (Exception e) {
                    err.println(e);
                    if (!context._dump_on_error) continue;
                    e.printStackTrace(err);
                    continue;
                }
                if (res == null || res == ScriptRuntime.UNDEFINED) continue;
                err.println(ScriptRuntime.safeToString(res));
            }
        }
        finally {
            if (globalChanged) {
                Context.setGlobal(global);
            }
        }
        return 0;
    }
}

