/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.linker.NashornGuardedInvocation;
import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.linker.GuardedInvocation;
import org.dynalang.dynalink.support.CallSiteDescriptorFactory;
import org.dynalang.dynalink.support.Guards;

public class PrimitiveLookup {
    private PrimitiveLookup() {
    }

    public static GuardedInvocation lookupPrimitive(CallSiteDescriptor desc, Class<?> receiverClass, ScriptObject wrappedReceiver, MethodHandle wrapFilter) {
        return PrimitiveLookup.lookupPrimitive(desc, Guards.getInstanceOfGuard(receiverClass), wrappedReceiver, wrapFilter);
    }

    public static GuardedInvocation lookupPrimitive(CallSiteDescriptor desc, MethodHandle guard, ScriptObject wrappedReceiver, MethodHandle wrapFilter) {
        String name;
        String operator = (String)CallSiteDescriptorFactory.tokenizeOperators((CallSiteDescriptor)desc).get(0);
        if ("setProp".equals(operator) && desc.getNameTokenCount() > 2) {
            return new GuardedInvocation(Lookup.MH.asType(Lookup.EMPTY_SETTER, Lookup.MH.type(Void.TYPE, new Class[]{Object.class, desc.getMethodType().parameterType(1)})), guard);
        }
        if (desc.getNameTokenCount() > 2 && wrappedReceiver.findProperty(name = desc.getNameToken(2), true) == null) {
            return null;
        }
        GuardedInvocation link = wrappedReceiver.lookup(desc);
        if (link != null) {
            MethodHandle method = link.getInvocation();
            if (!NashornGuardedInvocation.isStrict(link)) {
                MethodType wrapType = wrapFilter.type();
                TypeDescriptor.OfField methodReceiverType = method.type().parameterType(0);
                assert (((Class)methodReceiverType).isAssignableFrom((Class<?>)wrapType.returnType()));
                method = Lookup.MH.filterArguments(method, 0, Lookup.MH.asType(wrapFilter, wrapType.changeReturnType((Class<?>)methodReceiverType)));
            }
            return new GuardedInvocation(method, guard, link.getSwitchPoint());
        }
        assert (desc.getNameTokenCount() <= 2);
        return null;
    }
}

