/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import jdk.nashorn.internal.runtime.ConsString;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.GlobalObject;
import jdk.nashorn.internal.runtime.linker.Bootstrap;
import jdk.nashorn.internal.runtime.linker.JavaAdapterFactory;
import jdk.nashorn.internal.runtime.linker.JavaArgumentConverters;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.linker.NashornCallSiteDescriptor;
import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.beans.BeansLinker;
import org.dynalang.dynalink.beans.StaticClass;
import org.dynalang.dynalink.linker.ConversionComparator;
import org.dynalang.dynalink.linker.GuardedInvocation;
import org.dynalang.dynalink.linker.GuardingDynamicLinker;
import org.dynalang.dynalink.linker.GuardingTypeConverterFactory;
import org.dynalang.dynalink.linker.LinkRequest;
import org.dynalang.dynalink.linker.LinkerServices;
import org.dynalang.dynalink.linker.TypeBasedGuardingDynamicLinker;
import org.dynalang.dynalink.support.Guards;
import org.dynalang.dynalink.support.TypeUtilities;

class NashornPrimitiveLinker
implements TypeBasedGuardingDynamicLinker,
GuardingTypeConverterFactory,
ConversionComparator {
    private static final GuardingDynamicLinker staticClassLinker = BeansLinker.getLinkerForClass(StaticClass.class);
    private static final MethodHandle GUARD_PRIMITIVE = NashornPrimitiveLinker.findOwnMH("isJavaScriptPrimitive", Boolean.TYPE, Object.class);

    NashornPrimitiveLinker() {
    }

    public boolean canLinkType(Class<?> type) {
        return NashornPrimitiveLinker.canLinkTypeStatic(type);
    }

    private static boolean canLinkTypeStatic(Class<?> type) {
        return type == String.class || type == Boolean.class || type == StaticClass.class || type == ConsString.class || Number.class.isAssignableFrom(type);
    }

    public GuardedInvocation getGuardedInvocation(LinkRequest origRequest, LinkerServices linkerServices) throws Exception {
        LinkRequest request = origRequest.withoutRuntimeContext();
        Object self = request.getReceiver();
        GlobalObject global = (GlobalObject)((Object)Context.getGlobal());
        NashornCallSiteDescriptor desc = (NashornCallSiteDescriptor)request.getCallSiteDescriptor();
        if (self instanceof Number) {
            return Bootstrap.asType(global.numberLookup(desc, (Number)self), linkerServices, (CallSiteDescriptor)desc);
        }
        if (self instanceof String || self instanceof ConsString) {
            return Bootstrap.asType(global.stringLookup(desc, (CharSequence)self), linkerServices, (CallSiteDescriptor)desc);
        }
        if (self instanceof Boolean) {
            return Bootstrap.asType(global.booleanLookup(desc, (Boolean)self), linkerServices, (CallSiteDescriptor)desc);
        }
        if (self instanceof StaticClass) {
            if ("new".equals(desc.getOperator())) {
                Class receiverClass = ((StaticClass)self).getRepresentedClass();
                if (JavaAdapterFactory.isAbstractClass(receiverClass)) {
                    Object[] args = request.getArguments();
                    args[0] = JavaAdapterFactory.getAdapterClassFor(receiverClass);
                    LinkRequest adapterRequest = request.replaceArguments(request.getCallSiteDescriptor(), args);
                    GuardedInvocation gi = NashornPrimitiveLinker.checkNullConstructor(staticClassLinker.getGuardedInvocation(adapterRequest, linkerServices), receiverClass);
                    return gi.replaceMethods(gi.getInvocation(), Guards.getIdentityGuard((Object)self));
                }
                return NashornPrimitiveLinker.checkNullConstructor(staticClassLinker.getGuardedInvocation(request, linkerServices), receiverClass);
            }
            return staticClassLinker.getGuardedInvocation(request, linkerServices);
        }
        throw new AssertionError();
    }

    private static GuardedInvocation checkNullConstructor(GuardedInvocation ctorInvocation, Class<?> receiverClass) {
        if (ctorInvocation == null) {
            ECMAErrors.typeError(Context.getGlobal(), "no.constructor.matches.args", receiverClass.getName());
        }
        return ctorInvocation;
    }

    public GuardedInvocation convertToType(Class<?> sourceType, Class<?> targetType) {
        MethodHandle mh = JavaArgumentConverters.getConverter(targetType);
        if (mh == null) {
            return null;
        }
        return new GuardedInvocation(mh, NashornPrimitiveLinker.canLinkTypeStatic(sourceType) ? null : GUARD_PRIMITIVE).asType(mh.type().changeParameterType(0, sourceType));
    }

    public ConversionComparator.Comparison compareConversion(Class<?> sourceType, Class<?> targetType1, Class<?> targetType2) {
        Class<?> wrapper1 = NashornPrimitiveLinker.getWrapperTypeOrSelf(targetType1);
        if (sourceType == wrapper1) {
            return ConversionComparator.Comparison.TYPE_1_BETTER;
        }
        Class<?> wrapper2 = NashornPrimitiveLinker.getWrapperTypeOrSelf(targetType2);
        if (sourceType == wrapper2) {
            return ConversionComparator.Comparison.TYPE_2_BETTER;
        }
        if (Number.class.isAssignableFrom(sourceType)) {
            if (Number.class.isAssignableFrom(wrapper1)) {
                if (!Number.class.isAssignableFrom(wrapper2)) {
                    return ConversionComparator.Comparison.TYPE_1_BETTER;
                }
            } else if (Number.class.isAssignableFrom(wrapper2)) {
                return ConversionComparator.Comparison.TYPE_2_BETTER;
            }
            if (Character.class == wrapper1) {
                return ConversionComparator.Comparison.TYPE_1_BETTER;
            }
            if (Character.class == wrapper2) {
                return ConversionComparator.Comparison.TYPE_2_BETTER;
            }
        }
        if (sourceType == String.class || sourceType == Boolean.class || Number.class.isAssignableFrom(sourceType)) {
            Class<?> primitiveType2;
            Class<?> primitiveType1 = NashornPrimitiveLinker.getPrimitiveTypeOrSelf(targetType1);
            if (TypeUtilities.isMethodInvocationConvertible(primitiveType1, primitiveType2 = NashornPrimitiveLinker.getPrimitiveTypeOrSelf(targetType2))) {
                return ConversionComparator.Comparison.TYPE_2_BETTER;
            }
            if (TypeUtilities.isMethodInvocationConvertible(primitiveType2, primitiveType1)) {
                return ConversionComparator.Comparison.TYPE_1_BETTER;
            }
            if (targetType1 == String.class) {
                return ConversionComparator.Comparison.TYPE_1_BETTER;
            }
            if (targetType2 == String.class) {
                return ConversionComparator.Comparison.TYPE_2_BETTER;
            }
        }
        return ConversionComparator.Comparison.INDETERMINATE;
    }

    private static Class<?> getPrimitiveTypeOrSelf(Class<?> type) {
        Class primitive = TypeUtilities.getPrimitiveType(type);
        return primitive == null ? type : primitive;
    }

    private static Class<?> getWrapperTypeOrSelf(Class<?> type) {
        Class wrapper = TypeUtilities.getWrapperType(type);
        return wrapper == null ? type : wrapper;
    }

    private static boolean isJavaScriptPrimitive(Object o) {
        return o instanceof String || o instanceof Boolean || o instanceof Number || o instanceof ConsString || o == null;
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(MethodHandles.lookup(), NashornPrimitiveLinker.class, name, Lookup.MH.type(rtype, types));
    }
}

