/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.linker.Lookup;

public final class NashornGuards {
    private static final MethodHandle IS_SCRIPTOBJECT = NashornGuards.findOwnMH("isScriptObject", Boolean.TYPE, Object.class);
    private static final MethodHandle IS_SCRIPTFUNCTION = NashornGuards.findOwnMH("isScriptFunction", Boolean.TYPE, Object.class);
    private static final MethodHandle IS_MAP = NashornGuards.findOwnMH("isMap", Boolean.TYPE, Object.class, PropertyMap.class);
    private static final MethodHandle IS_FUNCTION_MH = NashornGuards.findOwnMH("isFunctionMH", Boolean.TYPE, Object.class, MethodHandle.class);
    private static final MethodHandle IS_INSTANCEOF_2 = NashornGuards.findOwnMH("isInstanceOf2", Boolean.TYPE, Object.class, Class.class, Class.class);

    private NashornGuards() {
    }

    public static MethodHandle getScriptObjectGuard() {
        return IS_SCRIPTOBJECT;
    }

    public static MethodHandle getScriptFunctionGuard() {
        return IS_SCRIPTFUNCTION;
    }

    public static MethodHandle getMapGuard(PropertyMap map) {
        return Lookup.MH.insertArguments(IS_MAP, 1, map);
    }

    public static MethodHandle getInstanceOf2Guard(Class<?> class1, Class<?> class2) {
        return Lookup.MH.insertArguments(IS_INSTANCEOF_2, 1, class1, class2);
    }

    public static MethodHandle getFunctionGuard(ScriptFunction function) {
        assert (function.getInvokeHandle() != null);
        return Lookup.MH.insertArguments(IS_FUNCTION_MH, 1, function.getInvokeHandle());
    }

    private static boolean isScriptObject(Object self) {
        return self instanceof ScriptObject;
    }

    private static boolean isScriptFunction(Object self) {
        return self instanceof ScriptFunction;
    }

    private static boolean isMap(Object self, PropertyMap map) {
        return self instanceof ScriptObject && ((ScriptObject)self).getMap() == map;
    }

    private static boolean isFunctionMH(Object self, MethodHandle mh) {
        return self instanceof ScriptFunction && ((ScriptFunction)self).getInvokeHandle() == mh;
    }

    private static boolean isInstanceOf2(Object self, Class<?> class1, Class<?> class2) {
        return class1.isInstance(self) || class2.isInstance(self);
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(MethodHandles.lookup(), NashornGuards.class, name, Lookup.MH.type(rtype, types));
    }
}

