/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.lang.invoke.MethodHandle;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.linker.Bootstrap;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.linker.NashornCallSiteDescriptor;
import jdk.nashorn.internal.runtime.linker.NashornLinker;
import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.linker.GuardedInvocation;
import org.dynalang.dynalink.linker.GuardingDynamicLinker;
import org.dynalang.dynalink.linker.LinkRequest;
import org.dynalang.dynalink.linker.LinkerServices;
import org.dynalang.dynalink.support.Guards;

class NashornBottomLinker
implements GuardingDynamicLinker {
    private static final MethodHandle EMPTY_PROP_GETTER = Lookup.MH.dropArguments(Lookup.MH.constant(Object.class, ScriptRuntime.UNDEFINED), 0, Object.class);
    private static final MethodHandle EMPTY_ELEM_GETTER = Lookup.MH.dropArguments(EMPTY_PROP_GETTER, 0, Object.class);
    private static final MethodHandle EMPTY_PROP_SETTER = Lookup.MH.asType(EMPTY_ELEM_GETTER, EMPTY_ELEM_GETTER.type().changeReturnType(Void.TYPE));
    private static final MethodHandle EMPTY_ELEM_SETTER = Lookup.MH.dropArguments(EMPTY_PROP_SETTER, 0, Object.class);

    NashornBottomLinker() {
    }

    public GuardedInvocation getGuardedInvocation(LinkRequest linkRequest, LinkerServices linkerServices) throws Exception {
        Object self = linkRequest.getReceiver();
        if (self == null) {
            return NashornBottomLinker.linkNull(linkRequest);
        }
        assert (NashornBottomLinker.isExpectedObject(self)) : "Couldn't link " + linkRequest.getCallSiteDescriptor() + " for " + self.getClass().getName();
        return NashornBottomLinker.linkBean(linkRequest, linkerServices);
    }

    private static GuardedInvocation linkBean(LinkRequest linkRequest, LinkerServices linkerServices) {
        NashornCallSiteDescriptor desc = (NashornCallSiteDescriptor)linkRequest.getCallSiteDescriptor();
        Object self = linkRequest.getReceiver();
        String operator = desc.getFirstOperator();
        if ("new".equals(operator)) {
            if (NashornBottomLinker.isJavaDynamicMethod(self)) {
                ECMAErrors.typeError(Context.getGlobal(), "method.not.constructor", ScriptRuntime.safeToString(self));
            } else {
                ECMAErrors.typeError(Context.getGlobal(), "not.a.function", ScriptRuntime.safeToString(self));
            }
        } else if ("call".equals(operator)) {
            if (NashornBottomLinker.isJavaDynamicMethod(self)) {
                ECMAErrors.typeError(Context.getGlobal(), "no.method.matches.args", ScriptRuntime.safeToString(self));
            } else {
                ECMAErrors.typeError(Context.getGlobal(), "not.a.function", ScriptRuntime.safeToString(self));
            }
        } else if ("callMethod".equals(operator) || "getMethod".equals(operator)) {
            ECMAErrors.typeError(Context.getGlobal(), "no.such.function", NashornBottomLinker.getArgument(linkRequest), ScriptRuntime.safeToString(self));
        } else {
            if ("getProp".equals(operator) || "getElem".equals(operator)) {
                if (desc.getOperand() != null) {
                    return NashornBottomLinker.getInvocation(EMPTY_PROP_GETTER, self, linkerServices, (CallSiteDescriptor)desc);
                }
                return NashornBottomLinker.getInvocation(EMPTY_ELEM_GETTER, self, linkerServices, (CallSiteDescriptor)desc);
            }
            if ("setProp".equals(operator) || "setElem".equals(operator)) {
                if (desc.getOperand() != null) {
                    return NashornBottomLinker.getInvocation(EMPTY_PROP_SETTER, self, linkerServices, (CallSiteDescriptor)desc);
                }
                return NashornBottomLinker.getInvocation(EMPTY_ELEM_SETTER, self, linkerServices, (CallSiteDescriptor)desc);
            }
        }
        throw new AssertionError((Object)("unknown call type " + (Object)((Object)desc)));
    }

    private static boolean isJavaDynamicMethod(Object obj) {
        return obj.getClass().getName().endsWith("DynamicMethod");
    }

    private static GuardedInvocation getInvocation(MethodHandle handle, Object self, LinkerServices linkerServices, CallSiteDescriptor desc) {
        return Bootstrap.asType(new GuardedInvocation(handle, Guards.getClassGuard(self.getClass())), linkerServices, desc);
    }

    private static boolean isExpectedObject(Object obj) {
        return !NashornLinker.canLinkTypeStatic(obj.getClass());
    }

    private static GuardedInvocation linkNull(LinkRequest linkRequest) {
        ScriptObject global = Context.getGlobal();
        NashornCallSiteDescriptor desc = (NashornCallSiteDescriptor)linkRequest.getCallSiteDescriptor();
        String operator = desc.getFirstOperator();
        if ("new".equals(operator) || "call".equals(operator)) {
            ECMAErrors.typeError(global, "not.a.function", "null");
        } else if ("callMethod".equals(operator) || "getMethod".equals(operator)) {
            ECMAErrors.typeError(global, "no.such.function", NashornBottomLinker.getArgument(linkRequest), "null");
        } else if ("getProp".equals(operator) || "getElem".equals(operator)) {
            ECMAErrors.typeError(global, "cant.get.property", NashornBottomLinker.getArgument(linkRequest), "null");
        } else if ("setProp".equals(operator) || "setElem".equals(operator)) {
            ECMAErrors.typeError(global, "cant.set.property", NashornBottomLinker.getArgument(linkRequest), "null");
        }
        throw new AssertionError((Object)("unknown call type " + (Object)((Object)desc)));
    }

    private static String getArgument(LinkRequest linkRequest) {
        CallSiteDescriptor desc = linkRequest.getCallSiteDescriptor();
        if (desc.getNameTokenCount() > 2) {
            return desc.getNameToken(2);
        }
        return ScriptRuntime.safeToString(linkRequest.getArguments()[1]);
    }
}

