/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.util.Arrays;

public class Mangler {
    private static final char ESCAPE = '\u03bc';
    private static final char hexBase = 'A';
    private static final char[] hexCharacters = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private Mangler() {
    }

    public static String mangle(String name) {
        int length = name.length();
        char[] buffer = new char[length * 5];
        boolean mangled = false;
        int pos = 0;
        for (int i = 0; i < length; ++i) {
            char ch = name.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) {
                buffer[pos++] = 956;
                buffer[pos++] = hexCharacters[ch >>> 12 & 0xF];
                buffer[pos++] = hexCharacters[ch >>> 8 & 0xF];
                buffer[pos++] = hexCharacters[ch >>> 4 & 0xF];
                buffer[pos++] = hexCharacters[ch & 0xF];
                mangled = true;
                continue;
            }
            if (ch == '\u03bc') {
                buffer[pos++] = 956;
                buffer[pos++] = 956;
                mangled = true;
                continue;
            }
            buffer[pos++] = ch;
        }
        return mangled ? new String(Arrays.copyOf(buffer, pos)) : null;
    }

    private static int fromHex(char ch) {
        return ch >= 'A' ? ch - 65 + 10 : ch - 48;
    }

    public static String unmangle(String name) {
        int length = name.length();
        char[] buffer = new char[length];
        int pos = 0;
        int i = 0;
        while (i < length) {
            char ch0;
            char ch;
            if ((ch = name.charAt(i++)) == '\u03bc' && (ch0 = name.charAt(i++)) != '\u03bc') {
                char ch1 = name.charAt(i++);
                char ch2 = name.charAt(i++);
                char ch3 = name.charAt(i++);
                ch = (char)(Mangler.fromHex(ch0) << 12 | Mangler.fromHex(ch1) << 8 | Mangler.fromHex(ch2) << 4 | Mangler.fromHex(ch3));
            }
            buffer[pos++] = ch;
        }
        buffer = Arrays.copyOf(buffer, pos);
        return new String(buffer);
    }
}

