/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.Undefined;
import jdk.nashorn.internal.runtime.linker.Bootstrap;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.linker.NashornCallSiteDescriptor;
import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.beans.StaticClass;
import org.dynalang.dynalink.linker.LinkRequest;
import org.dynalang.dynalink.support.LinkRequestImpl;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;

public class JavaAdapterFactory {
    private static final Type SCRIPT_FUNCTION_TYPE = Type.getType(ScriptFunction.class);
    private static final Type SCRIPT_OBJECT_TYPE = Type.getType(ScriptObject.class);
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private static final Type STRING_TYPE = Type.getType(String.class);
    private static final Type CONTEXT_TYPE = Type.getType(Context.class);
    private static final Type METHOD_TYPE_TYPE = Type.getType(MethodType.class);
    private static final Type METHOD_HANDLE_TYPE = Type.getType(MethodHandle.class);
    private static final String GET_HANDLE_OBJECT_DESCRIPTOR = Type.getMethodDescriptor((Type)METHOD_HANDLE_TYPE, (Type[])new Type[]{SCRIPT_OBJECT_TYPE, STRING_TYPE, METHOD_TYPE_TYPE, Type.BOOLEAN_TYPE});
    private static final String GET_HANDLE_FUNCTION_DESCRIPTOR = Type.getMethodDescriptor((Type)METHOD_HANDLE_TYPE, (Type[])new Type[]{SCRIPT_FUNCTION_TYPE, METHOD_TYPE_TYPE, Type.BOOLEAN_TYPE});
    private static final Type RUNTIME_EXCEPTION_TYPE = Type.getType(RuntimeException.class);
    private static final Type THROWABLE_TYPE = Type.getType(Throwable.class);
    private static final Type PRIVILEGED_ACTION_TYPE = Type.getType(PrivilegedAction.class);
    private static final Type UNSUPPORTED_OPERATION_TYPE = Type.getType(UnsupportedOperationException.class);
    private static final String THIS_CLASS_TYPE_NAME = Type.getInternalName(JavaAdapterFactory.class);
    private static final String RUNTIME_EXCEPTION_TYPE_NAME = RUNTIME_EXCEPTION_TYPE.getInternalName();
    private static final String ERROR_TYPE_NAME = Type.getInternalName(Error.class);
    private static final String THROWABLE_TYPE_NAME = THROWABLE_TYPE.getInternalName();
    private static final String CONTEXT_TYPE_NAME = CONTEXT_TYPE.getInternalName();
    private static final String OBJECT_TYPE_NAME = OBJECT_TYPE.getInternalName();
    private static final String PRIVILEGED_ACTION_TYPE_NAME = PRIVILEGED_ACTION_TYPE.getInternalName();
    private static final String UNSUPPORTED_OPERATION_TYPE_NAME = UNSUPPORTED_OPERATION_TYPE.getInternalName();
    private static final String METHOD_HANDLE_TYPE_DESCRIPTOR = METHOD_HANDLE_TYPE.getDescriptor();
    private static final String SCRIPT_OBJECT_TYPE_DESCRIPTOR = SCRIPT_OBJECT_TYPE.getDescriptor();
    private static final String GET_GLOBAL_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)SCRIPT_OBJECT_TYPE, (Type[])new Type[0]);
    private static final String SET_GLOBAL_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{SCRIPT_OBJECT_TYPE});
    private static final String GET_CLASS_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[0]);
    private static final String PRIVILEGED_RUN_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[0]);
    private static final String ADAPTER_PACKAGE_PREFIX = "jdk/nashorn/internal/javaadapters/";
    private static final String ADAPTER_CLASS_NAME_SUFFIX = "$$NashornJavaAdapter";
    private static final String JAVA_PACKAGE_PREFIX = "java/";
    private static final String INIT = "<init>";
    private static final String VOID_NOARG = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]);
    private static final String GLOBAL_FIELD_NAME = "global";
    private static final Collection<MethodInfo> EXCLUDED = JavaAdapterFactory.getExcludedMethods();
    private static final ClassValue<AdapterInfo> ADAPTER_INFOS = new ClassValue<AdapterInfo>(){

        @Override
        protected AdapterInfo computeValue(Class<?> type) {
            return JavaAdapterFactory.createAdapterInfo(type);
        }
    };
    private static final Random random = new SecureRandom();
    private static final ProtectionDomain GENERATED_PROTECTION_DOMAIN = JavaAdapterFactory.createGeneratedProtectionDomain();
    private final Class<?> superType;
    private final ClassLoader commonLoader;
    private final String superTypeName;
    private final String generatedTypeName;
    private final String globalSetterClassName;
    private final Set<String> usedFieldNames = new HashSet<String>();
    private final Set<String> abstractMethodNames = new HashSet<String>();
    private final String samName;
    private final Set<MethodInfo> finalMethods = new HashSet<MethodInfo>(EXCLUDED);
    private final Set<MethodInfo> methodInfos = new HashSet<MethodInfo>();
    private boolean autoConvertibleFromFunction = false;
    private final ClassWriter cw;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaAdapterFactory(Class<?> originalType) throws AdaptationException {
        long l;
        String[] interfaces;
        this.commonLoader = JavaAdapterFactory.findCommonLoader(originalType);
        this.cw = new ClassWriter(3){

            protected String getCommonSuperClass(String type1, String type2) {
                return JavaAdapterFactory.this.getCommonSuperClass(type1, type2);
            }
        };
        String originalTypeName = Type.getInternalName(originalType);
        boolean isInterface = originalType.isInterface();
        if (isInterface) {
            this.superType = Object.class;
            interfaces = new String[]{originalTypeName};
        } else {
            this.superType = originalType;
            interfaces = null;
        }
        this.superTypeName = Type.getInternalName(this.superType);
        Package pkg = originalType.getPackage();
        this.generatedTypeName = originalTypeName.startsWith(JAVA_PACKAGE_PREFIX) || pkg == null || pkg.isSealed() ? ADAPTER_PACKAGE_PREFIX + originalTypeName : originalTypeName + ADAPTER_CLASS_NAME_SUFFIX;
        Random random = JavaAdapterFactory.random;
        synchronized (random) {
            l = JavaAdapterFactory.random.nextLong();
        }
        this.globalSetterClassName = this.generatedTypeName.concat("$" + Long.toHexString(l & Long.MAX_VALUE));
        this.cw.visit(51, 49, this.generatedTypeName, null, this.superTypeName, interfaces);
        this.cw.visitField(18, GLOBAL_FIELD_NAME, SCRIPT_OBJECT_TYPE_DESCRIPTOR, null, null).visitEnd();
        this.usedFieldNames.add(GLOBAL_FIELD_NAME);
        this.gatherMethods(originalType);
        if (isInterface) {
            this.gatherMethods(Object.class);
        }
        this.samName = this.abstractMethodNames.size() == 1 ? this.abstractMethodNames.iterator().next() : null;
        this.generateFields();
        this.generateConstructors();
        this.generateMethods();
        this.cw.visitEnd();
    }

    static boolean isAbstractClass(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers()) && !clazz.isArray();
    }

    public static StaticClass getAdapterClassFor(StaticClass originalClass) {
        return JavaAdapterFactory.getAdapterClassFor(originalClass.getRepresentedClass());
    }

    static StaticClass getAdapterClassFor(Class<?> originalClass) {
        AdapterInfo adapterInfo = ADAPTER_INFOS.get(originalClass);
        StaticClass clazz = adapterInfo.adapterClass;
        if (clazz != null) {
            return clazz;
        }
        assert (adapterInfo.adaptationOutcome != AdaptationOutcome.SUCCESS);
        ECMAErrors.typeError(Context.getGlobal(), "extend." + (Object)((Object)adapterInfo.adaptationOutcome), originalClass.getName());
        throw new AssertionError();
    }

    static boolean isAutoConvertibleFromFunction(Class<?> clazz) {
        return JavaAdapterFactory.ADAPTER_INFOS.get(clazz).autoConvertibleFromFunction;
    }

    public static MethodHandle getConstructor(Class<?> sourceType, Class<?> targetType) throws Exception {
        StaticClass adapterClass = JavaAdapterFactory.getAdapterClassFor(targetType);
        return Lookup.MH.bindTo(Bootstrap.getLinkerServices().getGuardedInvocation((LinkRequest)new LinkRequestImpl((CallSiteDescriptor)NashornCallSiteDescriptor.get("dyn:new", MethodType.methodType(targetType, StaticClass.class, sourceType), 0), false, new Object[]{adapterClass, null})).getInvocation(), adapterClass);
    }

    private Class<?> generateClass() {
        String binaryName = this.generatedTypeName.replace('/', '.');
        try {
            return Class.forName(binaryName, true, JavaAdapterFactory.createClassLoader(this.commonLoader, binaryName, this.cw.toByteArray(), this.globalSetterClassName.replace('/', '.')));
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static ClassLoader createClassLoader(ClassLoader parentLoader, final String className, final byte[] classBytes, final String privilegedActionClassName) {
        return new SecureClassLoader(parentLoader){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                if (name.equals(className)) {
                    byte[] bytes = classBytes;
                    return this.defineClass(name, bytes, 0, bytes.length, GENERATED_PROTECTION_DOMAIN);
                }
                if (name.equals(privilegedActionClassName)) {
                    byte[] bytes = JavaAdapterFactory.generatePrivilegedActionClassBytes(privilegedActionClassName.replace('.', '/'));
                    return this.defineClass(name, bytes, 0, bytes.length, this.getClass().getProtectionDomain());
                }
                throw new ClassNotFoundException(name);
            }
        };
    }

    private static byte[] generatePrivilegedActionClassBytes(String className) {
        ClassWriter w = new ClassWriter(3);
        w.visit(51, 48, className, null, OBJECT_TYPE_NAME, new String[]{PRIVILEGED_ACTION_TYPE_NAME});
        w.visitField(18, GLOBAL_FIELD_NAME, SCRIPT_OBJECT_TYPE_DESCRIPTOR, null, null).visitEnd();
        InstructionAdapter mv = new InstructionAdapter(w.visitMethod(2, INIT, SET_GLOBAL_METHOD_DESCRIPTOR, null, new String[0]));
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.invokespecial(OBJECT_TYPE_NAME, INIT, VOID_NOARG);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.putfield(className, GLOBAL_FIELD_NAME, SCRIPT_OBJECT_TYPE_DESCRIPTOR);
        mv.visitInsn(177);
        mv.visitEnd();
        mv.visitMaxs(0, 0);
        mv = new InstructionAdapter(w.visitMethod(1, "run", PRIVILEGED_RUN_METHOD_DESCRIPTOR, null, new String[0]));
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.getfield(className, GLOBAL_FIELD_NAME, SCRIPT_OBJECT_TYPE_DESCRIPTOR);
        mv.invokestatic(CONTEXT_TYPE_NAME, "setGlobal", SET_GLOBAL_METHOD_DESCRIPTOR);
        mv.visitInsn(1);
        mv.visitInsn(176);
        mv.visitEnd();
        mv.visitMaxs(0, 0);
        mv = new InstructionAdapter(w.visitMethod(8, "setGlobal", SET_GLOBAL_METHOD_DESCRIPTOR, null, new String[0]));
        mv.visitCode();
        mv.anew(Type.getType((String)("L" + className + ";")));
        mv.dup();
        mv.visitVarInsn(25, 0);
        mv.invokespecial(className, INIT, SET_GLOBAL_METHOD_DESCRIPTOR);
        mv.invokestatic(Type.getInternalName(AccessController.class), "doPrivileged", Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{PRIVILEGED_ACTION_TYPE}));
        mv.pop();
        mv.visitInsn(177);
        mv.visitEnd();
        mv.visitMaxs(0, 0);
        return w.toByteArray();
    }

    private void generateFields() {
        for (MethodInfo mi : this.methodInfos) {
            this.cw.visitField(18, mi.methodHandleFieldName, METHOD_HANDLE_TYPE_DESCRIPTOR, null, null).visitEnd();
        }
    }

    private void generateConstructors() throws AdaptationException {
        boolean gotCtor = false;
        for (Constructor<?> ctor : this.superType.getDeclaredConstructors()) {
            int modifier = ctor.getModifiers();
            if ((modifier & 5) == 0) continue;
            this.generateConstructor(ctor);
            gotCtor = true;
        }
        if (!gotCtor) {
            throw new AdaptationException(AdaptationOutcome.ERROR_NO_ACCESSIBLE_CONSTRUCTOR);
        }
    }

    boolean isAutoConvertibleFromFunction() {
        return this.autoConvertibleFromFunction;
    }

    private void generateConstructor(Constructor<?> ctor) {
        this.generateConstructor(ctor, false);
        if (this.samName != null) {
            if (!this.autoConvertibleFromFunction && ctor.getParameterTypes().length == 0) {
                this.autoConvertibleFromFunction = true;
            }
            this.generateConstructor(ctor, true);
        }
    }

    private void generateConstructor(Constructor<?> ctor, boolean fromFunction) {
        Type extraArgumentType;
        Type originalCtorType = Type.getType(ctor);
        Type[] originalArgTypes = originalCtorType.getArgumentTypes();
        int argLen = originalArgTypes.length;
        Type[] newArgTypes = new Type[argLen + 1];
        newArgTypes[0] = extraArgumentType = fromFunction ? SCRIPT_FUNCTION_TYPE : SCRIPT_OBJECT_TYPE;
        System.arraycopy(originalArgTypes, 0, newArgTypes, 1, argLen);
        InstructionAdapter mv = new InstructionAdapter(this.cw.visitMethod(1 | (ctor.isVarArgs() ? 128 : 0), INIT, Type.getMethodDescriptor((Type)originalCtorType.getReturnType(), (Type[])newArgTypes), null, null));
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        Class<?>[] argTypes = ctor.getParameterTypes();
        int offset = 2;
        for (int i = 0; i < argLen; ++i) {
            Type argType = Type.getType(argTypes[i]);
            mv.load(offset, argType);
            offset += argType.getSize();
        }
        mv.invokespecial(this.superTypeName, INIT, originalCtorType.getDescriptor());
        String getHandleDescriptor = fromFunction ? GET_HANDLE_FUNCTION_DESCRIPTOR : GET_HANDLE_OBJECT_DESCRIPTOR;
        for (MethodInfo mi : this.methodInfos) {
            mv.visitVarInsn(25, 0);
            if (fromFunction && !mi.getName().equals(this.samName)) {
                mv.visitInsn(1);
            } else {
                mv.visitVarInsn(25, 1);
                if (!fromFunction) {
                    mv.aconst((Object)mi.getName());
                }
                mv.aconst((Object)Type.getMethodType((String)mi.type.toMethodDescriptorString()));
                mv.iconst(mi.method.isVarArgs() ? 1 : 0);
                mv.invokestatic(THIS_CLASS_TYPE_NAME, "getHandle", getHandleDescriptor);
            }
            mv.putfield(this.generatedTypeName, mi.methodHandleFieldName, METHOD_HANDLE_TYPE_DESCRIPTOR);
        }
        mv.visitVarInsn(25, 0);
        JavaAdapterFactory.invokeGetGlobal(mv);
        mv.dup();
        mv.invokevirtual(OBJECT_TYPE_NAME, "getClass", GET_CLASS_METHOD_DESCRIPTOR);
        mv.pop();
        mv.putfield(this.generatedTypeName, GLOBAL_FIELD_NAME, SCRIPT_OBJECT_TYPE_DESCRIPTOR);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void invokeGetGlobal(InstructionAdapter mv) {
        mv.invokestatic(CONTEXT_TYPE_NAME, "getGlobal", GET_GLOBAL_METHOD_DESCRIPTOR);
    }

    private void invokeSetGlobal(InstructionAdapter mv) {
        mv.invokestatic(this.globalSetterClassName, "setGlobal", SET_GLOBAL_METHOD_DESCRIPTOR);
    }

    public static MethodHandle getHandle(ScriptFunction fn, MethodType type, boolean varArg) {
        return JavaAdapterFactory.adaptHandle(fn.getBoundInvokeHandle(null), type, varArg);
    }

    public static MethodHandle getHandle(ScriptObject obj, String name, MethodType type, boolean varArg) {
        if ("toString".equals(name) && !obj.hasOwnProperty("toString")) {
            return null;
        }
        Object fnObj = obj.get(name);
        if (fnObj instanceof ScriptFunction) {
            return JavaAdapterFactory.adaptHandle(((ScriptFunction)fnObj).getBoundInvokeHandle(obj), type, varArg);
        }
        if (fnObj == null || fnObj instanceof Undefined) {
            return null;
        }
        ECMAErrors.typeError(Context.getGlobal(), "not.a.function", name);
        throw new AssertionError();
    }

    private static MethodHandle adaptHandle(MethodHandle handle, MethodType type, boolean varArg) {
        return Bootstrap.getLinkerServices().asType(ScriptObject.pairArguments(handle, type, varArg), type);
    }

    private void generateMethods() {
        for (MethodInfo mi : this.methodInfos) {
            this.generateMethod(mi);
        }
    }

    private void generateMethod(MethodInfo mi) {
        Label throwableHandler;
        Method method = mi.method;
        int mod = method.getModifiers();
        int access = 1 | (method.isVarArgs() ? 128 : 0);
        Class<?>[] exceptions = method.getExceptionTypes();
        String[] exceptionNames = new String[exceptions.length];
        for (int i = 0; i < exceptions.length; ++i) {
            exceptionNames[i] = Type.getInternalName(exceptions[i]);
        }
        MethodType type = mi.type;
        String methodDesc = type.toMethodDescriptorString();
        String name = mi.getName();
        Type asmType = Type.getMethodType((String)methodDesc);
        Type[] asmArgTypes = asmType.getArgumentTypes();
        int nextLocalVar = 1;
        for (Type t : asmArgTypes) {
            nextLocalVar += t.getSize();
        }
        InstructionAdapter mv = new InstructionAdapter(this.cw.visitMethod(access, name, methodDesc, null, exceptionNames));
        mv.visitCode();
        Label methodHandleNotNull = new Label();
        Label methodEnd = new Label();
        Type returnType = Type.getType((Class)type.returnType());
        mv.visitVarInsn(25, 0);
        mv.getfield(this.generatedTypeName, mi.methodHandleFieldName, METHOD_HANDLE_TYPE_DESCRIPTOR);
        mv.visitInsn(89);
        mv.visitJumpInsn(199, methodHandleNotNull);
        if (Modifier.isAbstract(mod)) {
            mv.anew(UNSUPPORTED_OPERATION_TYPE);
            mv.dup();
            mv.invokespecial(UNSUPPORTED_OPERATION_TYPE_NAME, INIT, VOID_NOARG);
            mv.athrow();
        } else {
            mv.visitVarInsn(25, 0);
            int nextParam = 1;
            for (Type t : asmArgTypes) {
                mv.load(nextParam, t);
                nextParam += t.getSize();
            }
            mv.invokespecial(this.superTypeName, name, methodDesc);
            mv.areturn(returnType);
        }
        mv.visitLabel(methodHandleNotNull);
        int currentGlobalVar = nextLocalVar++;
        int globalsDifferVar = nextLocalVar++;
        JavaAdapterFactory.invokeGetGlobal(mv);
        mv.dup();
        mv.visitVarInsn(58, currentGlobalVar);
        this.loadGlobalOnStack(mv);
        Label globalsDiffer = new Label();
        mv.ifacmpne(globalsDiffer);
        mv.iconst(0);
        Label proceed = new Label();
        mv.goTo(proceed);
        mv.visitLabel(globalsDiffer);
        this.loadGlobalOnStack(mv);
        this.invokeSetGlobal(mv);
        mv.iconst(1);
        mv.visitLabel(proceed);
        mv.visitVarInsn(54, globalsDifferVar);
        int varOffset = 1;
        for (Type t : asmArgTypes) {
            mv.load(varOffset, t);
            varOffset += t.getSize();
        }
        Label tryBlockStart = new Label();
        mv.visitLabel(tryBlockStart);
        mv.invokevirtual(METHOD_HANDLE_TYPE.getInternalName(), "invokeExact", type.toMethodDescriptorString());
        Label tryBlockEnd = new Label();
        mv.visitLabel(tryBlockEnd);
        this.emitFinally(mv, currentGlobalVar, globalsDifferVar);
        mv.areturn(returnType);
        boolean throwableDeclared = JavaAdapterFactory.isThrowableDeclared(exceptions);
        if (!throwableDeclared) {
            throwableHandler = new Label();
            mv.visitLabel(throwableHandler);
            mv.anew(RUNTIME_EXCEPTION_TYPE);
            mv.dupX1();
            mv.swap();
            mv.invokespecial(RUNTIME_EXCEPTION_TYPE_NAME, INIT, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{THROWABLE_TYPE}));
        } else {
            throwableHandler = null;
        }
        Label rethrowHandler = new Label();
        mv.visitLabel(rethrowHandler);
        this.emitFinally(mv, currentGlobalVar, globalsDifferVar);
        mv.athrow();
        mv.visitLabel(methodEnd);
        mv.visitLocalVariable("currentGlobal", SCRIPT_OBJECT_TYPE_DESCRIPTOR, null, methodHandleNotNull, methodEnd, currentGlobalVar);
        mv.visitLocalVariable("globalsDiffer", Type.INT_TYPE.getDescriptor(), null, methodHandleNotNull, methodEnd, globalsDifferVar);
        if (throwableDeclared) {
            mv.visitTryCatchBlock(tryBlockStart, tryBlockEnd, rethrowHandler, THROWABLE_TYPE_NAME);
            assert (throwableHandler == null);
        } else {
            mv.visitTryCatchBlock(tryBlockStart, tryBlockEnd, rethrowHandler, RUNTIME_EXCEPTION_TYPE_NAME);
            mv.visitTryCatchBlock(tryBlockStart, tryBlockEnd, rethrowHandler, ERROR_TYPE_NAME);
            for (String excName : exceptionNames) {
                mv.visitTryCatchBlock(tryBlockStart, tryBlockEnd, rethrowHandler, excName);
            }
            mv.visitTryCatchBlock(tryBlockStart, tryBlockEnd, throwableHandler, THROWABLE_TYPE_NAME);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void emitFinally(InstructionAdapter mv, int currentGlobalVar, int globalsDifferVar) {
        mv.visitVarInsn(21, globalsDifferVar);
        Label skip = new Label();
        mv.ifeq(skip);
        mv.visitVarInsn(25, currentGlobalVar);
        this.invokeSetGlobal(mv);
        mv.visitLabel(skip);
    }

    private void loadGlobalOnStack(InstructionAdapter mv) {
        mv.visitVarInsn(25, 0);
        mv.getfield(this.generatedTypeName, GLOBAL_FIELD_NAME, SCRIPT_OBJECT_TYPE_DESCRIPTOR);
    }

    private static boolean isThrowableDeclared(Class<?>[] exceptions) {
        for (Class<?> exception : exceptions) {
            if (exception != Throwable.class) continue;
            return true;
        }
        return false;
    }

    private void gatherMethods(Class<?> type) {
        if (Modifier.isPublic(type.getModifiers())) {
            Method[] typeMethods = type.isInterface() ? type.getMethods() : type.getDeclaredMethods();
            for (GenericDeclaration genericDeclaration : typeMethods) {
                int m = ((Method)genericDeclaration).getModifiers();
                if (Modifier.isStatic(m) || !Modifier.isPublic(m) && !Modifier.isProtected(m)) continue;
                MethodInfo mi = new MethodInfo((Method)genericDeclaration);
                if (Modifier.isFinal(m)) {
                    this.finalMethods.add(mi);
                    continue;
                }
                if (this.finalMethods.contains(mi) || !this.methodInfos.add(mi)) continue;
                if (Modifier.isAbstract(m)) {
                    this.abstractMethodNames.add(mi.getName());
                }
                mi.setIsCanonical(this.usedFieldNames);
            }
        }
        if (!type.isInterface()) {
            Class<?> superClass = type.getSuperclass();
            if (superClass != null) {
                this.gatherMethods(superClass);
            }
            for (GenericDeclaration genericDeclaration : type.getInterfaces()) {
                this.gatherMethods((Class<?>)genericDeclaration);
            }
        }
    }

    private static Collection<MethodInfo> getExcludedMethods() {
        return AccessController.doPrivileged(new PrivilegedAction<Collection<MethodInfo>>(){

            @Override
            public Collection<MethodInfo> run() {
                try {
                    return Arrays.asList(new MethodInfo((Class)Object.class, "finalize", new Class[0]), new MethodInfo((Class)Object.class, "clone", new Class[0]));
                }
                catch (NoSuchMethodException e) {
                    throw new AssertionError((Object)e);
                }
            }
        });
    }

    private static ProtectionDomain createGeneratedProtectionDomain() {
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        return new ProtectionDomain(new CodeSource(null, (CodeSigner[])null), permissions);
    }

    private static AdapterInfo createAdapterInfo(final Class<?> type) {
        int mod = type.getModifiers();
        if (Modifier.isFinal(mod)) {
            return new AdapterInfo(AdaptationOutcome.ERROR_FINAL_CLASS);
        }
        if (!Modifier.isPublic(mod)) {
            return new AdapterInfo(AdaptationOutcome.ERROR_NON_PUBLIC_CLASS);
        }
        return AccessController.doPrivileged(new PrivilegedAction<AdapterInfo>(){

            @Override
            public AdapterInfo run() {
                try {
                    JavaAdapterFactory factory = new JavaAdapterFactory(type);
                    return new AdapterInfo(StaticClass.forClass((Class)factory.generateClass()), factory.isAutoConvertibleFromFunction());
                }
                catch (AdaptationException e) {
                    return new AdapterInfo(e.outcome);
                }
            }
        });
    }

    private String getCommonSuperClass(String type1, String type2) {
        try {
            Class<?> c1 = Class.forName(type1.replace('/', '.'), false, this.commonLoader);
            Class<?> c2 = Class.forName(type2.replace('/', '.'), false, this.commonLoader);
            if (c1.isAssignableFrom(c2)) {
                return type1;
            }
            if (c2.isAssignableFrom(c1)) {
                return type2;
            }
            if (c1.isInterface() || c2.isInterface()) {
                return "java/lang/Object";
            }
            return JavaAdapterFactory.assignableSuperClass(c1, c2).getName().replace('.', '/');
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> assignableSuperClass(Class<?> c1, Class<?> c2) {
        Class<?> superClass = c1.getSuperclass();
        return superClass.isAssignableFrom(c2) ? superClass : JavaAdapterFactory.assignableSuperClass(superClass, c2);
    }

    private static ClassLoader findCommonLoader(Class<?> clazz) {
        ClassLoader clazzLoader = clazz.getClassLoader();
        if (JavaAdapterFactory.canSeeClass(clazzLoader, ScriptObject.class)) {
            return clazzLoader;
        }
        ClassLoader nashornLoader = ScriptObject.class.getClassLoader();
        if (JavaAdapterFactory.canSeeClass(nashornLoader, clazz)) {
            return nashornLoader;
        }
        throw new IllegalStateException("Can't find a common class loader for ScriptObject and " + clazz.getName());
    }

    private static boolean canSeeClass(ClassLoader cl, Class<?> clazz) {
        try {
            return Class.forName(clazz.getName(), false, cl) == clazz;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static class AdaptationException
    extends Exception {
        private final AdaptationOutcome outcome;

        AdaptationException(AdaptationOutcome outcome) {
            this.outcome = outcome;
        }
    }

    private static class AdapterInfo {
        final StaticClass adapterClass;
        final boolean autoConvertibleFromFunction;
        final AdaptationOutcome adaptationOutcome;

        AdapterInfo(StaticClass adapterClass, boolean autoConvertibleFromFunction) {
            this.adapterClass = adapterClass;
            this.autoConvertibleFromFunction = autoConvertibleFromFunction;
            this.adaptationOutcome = AdaptationOutcome.SUCCESS;
        }

        AdapterInfo(AdaptationOutcome outcome) {
            this.adapterClass = null;
            this.autoConvertibleFromFunction = false;
            this.adaptationOutcome = outcome;
        }
    }

    private static class MethodInfo {
        private final Method method;
        private final MethodType type;
        private String methodHandleFieldName;

        private MethodInfo(Class<?> clazz, String name, Class<?> ... argTypes) throws NoSuchMethodException {
            this(clazz.getDeclaredMethod(name, argTypes));
        }

        private MethodInfo(Method method) {
            this.method = method;
            this.type = Lookup.MH.type(method.getReturnType(), method.getParameterTypes());
        }

        public boolean equals(Object obj) {
            return obj instanceof MethodInfo && this.equals((MethodInfo)obj);
        }

        private boolean equals(MethodInfo other) {
            return this.getName().equals(other.getName()) && ((Object)this.type).equals(other.type);
        }

        String getName() {
            return this.method.getName();
        }

        public int hashCode() {
            return this.getName().hashCode() ^ ((Object)this.type).hashCode();
        }

        void setIsCanonical(Set<String> usedFieldNames) {
            int i = 0;
            String fieldName = this.getName();
            while (!usedFieldNames.add(fieldName)) {
                fieldName = this.getName() + i++;
            }
            this.methodHandleFieldName = fieldName;
        }
    }

    private static enum AdaptationOutcome {
        SUCCESS,
        ERROR_FINAL_CLASS,
        ERROR_NON_PUBLIC_CLASS,
        ERROR_NO_ACCESSIBLE_CONSTRUCTOR;

    }
}

