/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import jdk.nashorn.internal.compat.Objects;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.linker.Bootstrap;
import jdk.nashorn.internal.runtime.linker.MethodHandleFactory;
import jdk.nashorn.internal.runtime.linker.MethodHandleFunctionality;
import netscape.javascript.JSObject;
import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.linker.GuardedInvocation;
import org.dynalang.dynalink.linker.LinkRequest;
import org.dynalang.dynalink.linker.LinkerServices;
import org.dynalang.dynalink.linker.TypeBasedGuardingDynamicLinker;
import org.dynalang.dynalink.support.CallSiteDescriptorFactory;

public final class JSObjectLinker
implements TypeBasedGuardingDynamicLinker {
    private static final MethodHandleFunctionality MH = MethodHandleFactory.getFunctionality();
    private static final MethodHandle IS_JSOBJECTMETHOD_GUARD = JSObjectLinker.findOwnMH("isJSObjectMethod", Boolean.TYPE, Object.class);
    private static final MethodHandle IS_JSOBJECT_GUARD = JSObjectLinker.findOwnMH("isJSObject", Boolean.TYPE, Object.class);
    private static final MethodHandle JSOBJECT_GETMETHOD = JSObjectLinker.findOwnMH("getMethod", Object.class, Object.class, Object.class);
    private static final MethodHandle JSOBJECT_GET = JSObjectLinker.findOwnMH("get", Object.class, Object.class, Object.class);
    private static final MethodHandle JSOBJECT_PUT = JSObjectLinker.findOwnMH("put", Void.TYPE, Object.class, Object.class, Object.class);
    private static final MethodHandle JSOBJECT_CALL = JSObjectLinker.findOwnMH("call", Object.class, Object.class, Object.class, Object[].class);
    private static final MethodHandle JSOBJECTMETHOD_CALL = JSObjectLinker.findOwnMH("jsObjectMethodCall", Object.class, Object.class, Object.class, Object[].class);

    public boolean canLinkType(Class<?> type) {
        return JSObjectLinker.canLinkTypeStatic(type);
    }

    static boolean canLinkTypeStatic(Class<?> type) {
        return JSObject.class.isAssignableFrom(type) || JSObjectMethod.class.isAssignableFrom(type);
    }

    public GuardedInvocation getGuardedInvocation(LinkRequest request, LinkerServices linkerServices) throws Exception {
        GuardedInvocation inv;
        LinkRequest requestWithoutContext = request.withoutRuntimeContext();
        Object self = requestWithoutContext.getReceiver();
        CallSiteDescriptor desc = requestWithoutContext.getCallSiteDescriptor();
        if (desc.getNameTokenCount() < 2 || !"dyn".equals(desc.getNameToken(0))) {
            return null;
        }
        if (self instanceof JSObject) {
            inv = JSObjectLinker.lookup(desc);
        } else if (self instanceof JSObjectMethod) {
            inv = JSObjectMethod.lookup(desc);
        } else {
            throw new AssertionError();
        }
        return Bootstrap.asType(inv, linkerServices, desc);
    }

    private static GuardedInvocation lookup(CallSiteDescriptor desc) {
        String operator = (String)CallSiteDescriptorFactory.tokenizeOperators((CallSiteDescriptor)desc).get(0);
        int c = desc.getNameTokenCount();
        if ("getProp".equals(operator) || "getElem".equals(operator) || "getMethod".equals(operator)) {
            return c > 2 ? JSObjectLinker.findGetMethod(desc, operator) : JSObjectLinker.findGetIndexMethod();
        }
        if ("setProp".equals(operator) || "setElem".equals(operator)) {
            return c > 2 ? JSObjectLinker.findSetMethod(desc) : JSObjectLinker.findSetIndexMethod();
        }
        if ("call".equals(operator) || "callMethod".equals(operator)) {
            return JSObjectLinker.findCallMethod(desc, operator);
        }
        if ("new".equals(operator)) {
            return null;
        }
        return null;
    }

    private static GuardedInvocation findGetMethod(CallSiteDescriptor desc, String operator) {
        MethodHandle getter = MH.insertArguments("getMethod".equals(operator) ? JSOBJECT_GETMETHOD : JSOBJECT_GET, 1, desc.getNameToken(2));
        return new GuardedInvocation(getter, null, IS_JSOBJECT_GUARD);
    }

    private static GuardedInvocation findGetIndexMethod() {
        return new GuardedInvocation(JSOBJECT_GET, null, IS_JSOBJECT_GUARD);
    }

    private static GuardedInvocation findSetMethod(CallSiteDescriptor desc) {
        MethodHandle getter = MH.insertArguments(JSOBJECT_PUT, 1, desc.getNameToken(2));
        return new GuardedInvocation(getter, null, IS_JSOBJECT_GUARD);
    }

    private static GuardedInvocation findSetIndexMethod() {
        return new GuardedInvocation(JSOBJECT_PUT, null, IS_JSOBJECT_GUARD);
    }

    private static GuardedInvocation findCallMethod(CallSiteDescriptor desc, String operator) {
        String methodName = "callMethod".equals(operator) ? desc.getNameToken(2) : "call";
        MethodHandle func = MH.insertArguments(JSOBJECT_CALL, 1, methodName);
        func = MH.asCollector(func, Object[].class, desc.getMethodType().parameterCount() - 1);
        return new GuardedInvocation(func, null, IS_JSOBJECT_GUARD);
    }

    private static boolean isJSObjectMethod(Object self) {
        return self instanceof JSObjectMethod;
    }

    private static boolean isJSObject(Object self) {
        return self instanceof JSObject;
    }

    private static Object getMethod(Object jsobj, Object key) {
        return new JSObjectMethod(Objects.toString(key));
    }

    private static Object get(Object jsobj, Object key) {
        int index;
        if (key instanceof String) {
            return ((JSObject)jsobj).getMember((String)key);
        }
        if (key instanceof Number && (index = JSObjectLinker.getIndex((Number)key)) > -1) {
            return ((JSObject)jsobj).getSlot(index);
        }
        return null;
    }

    private static void put(Object jsobj, Object key, Object value) {
        if (key instanceof String) {
            ((JSObject)jsobj).setMember((String)key, value);
        } else if (key instanceof Number) {
            ((JSObject)jsobj).setSlot(JSObjectLinker.getIndex((Number)key), value);
        }
    }

    private static Object call(Object jsobj, Object method, Object ... args) {
        return ((JSObject)jsobj).call(Objects.toString(method), args);
    }

    private static Object jsObjectMethodCall(Object jsObjMethod, Object jsobj, Object ... args) {
        String methodName = ((JSObjectMethod)jsObjMethod).getName();
        return ((JSObject)jsobj).call(methodName, args);
    }

    private static int getIndex(Number n) {
        double value = n.doubleValue();
        return JSType.isRepresentableAsInt(value) ? (int)value : -1;
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        Class<JSObjectLinker> own = JSObjectLinker.class;
        MethodType mt = MH.type(rtype, types);
        try {
            return MH.findStatic(MethodHandles.lookup(), own, name, mt);
        }
        catch (MethodHandleFactory.LookupException e) {
            return MH.findVirtual(MethodHandles.lookup(), own, name, mt);
        }
    }

    private static final class JSObjectMethod {
        private final String name;

        JSObjectMethod(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        static GuardedInvocation lookup(CallSiteDescriptor desc) {
            String operator = (String)CallSiteDescriptorFactory.tokenizeOperators((CallSiteDescriptor)desc).get(0);
            if ("call".equals(operator)) {
                int paramCount = desc.getMethodType().parameterCount();
                MethodHandle caller = MH.asCollector(JSOBJECTMETHOD_CALL, Object[].class, paramCount - 2);
                return new GuardedInvocation(caller, null, IS_JSOBJECTMETHOD_GUARD);
            }
            return null;
        }
    }
}

