/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.arrays;

import java.util.Arrays;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.arrays.ArrayData;
import jdk.nashorn.internal.runtime.arrays.DeletedRangeArrayFilter;
import jdk.nashorn.internal.runtime.arrays.NumberArrayData;
import jdk.nashorn.internal.runtime.arrays.ObjectArrayData;
import jdk.nashorn.internal.runtime.arrays.SparseArrayData;
import jdk.nashorn.internal.runtime.arrays.UndefinedArrayFilter;

final class LongArrayData
extends ArrayData {
    private long[] array;

    LongArrayData(long[] array, int length) {
        super(length);
        this.array = array;
    }

    @Override
    public Object[] asObjectArray() {
        return LongArrayData.toObjectArray(this.array, (int)this.length());
    }

    private static Object[] toObjectArray(long[] array, int length) {
        Object[] oarray = new Object[length];
        for (int index = 0; index < length; ++index) {
            oarray[index] = array[index];
        }
        return oarray;
    }

    @Override
    public Object asArrayOfType(Class<?> componentType) {
        if (componentType == Long.TYPE) {
            return (long)this.array.length == this.length() ? (long[])this.array.clone() : Arrays.copyOf(this.array, (int)this.length());
        }
        return super.asArrayOfType(componentType);
    }

    private static double[] toDoubleArray(long[] array) {
        double[] darray = new double[array.length];
        for (int index = 0; index < array.length; ++index) {
            darray[index] = array[index];
        }
        return darray;
    }

    @Override
    public ArrayData convert(Class<?> type) {
        if (type == Long.class) {
            return this;
        }
        if (type == Double.class) {
            return new NumberArrayData(LongArrayData.toDoubleArray(this.array), (int)this.length());
        }
        return new ObjectArrayData(LongArrayData.toObjectArray(this.array, this.array.length), (int)this.length());
    }

    @Override
    public void shiftLeft(int by) {
        System.arraycopy(this.array, by, this.array, 0, this.array.length - by);
    }

    @Override
    public ArrayData shiftRight(int by) {
        ArrayData newData = this.ensure((long)by + this.length() - 1L);
        if (newData != this) {
            newData.shiftRight(by);
            return newData;
        }
        System.arraycopy(this.array, 0, this.array, by, this.array.length - by);
        return this;
    }

    @Override
    public ArrayData ensure(long safeIndex) {
        if (safeIndex >= 524288L && safeIndex >= (long)this.array.length) {
            return new SparseArrayData(this, safeIndex + 1L);
        }
        int newLength = this.array.length;
        while ((long)newLength <= safeIndex) {
            newLength = ArrayData.nextSize(newLength);
        }
        if ((long)this.array.length <= safeIndex) {
            this.array = Arrays.copyOf(this.array, newLength);
        }
        this.setLength(safeIndex + 1L);
        return this;
    }

    @Override
    public ArrayData shrink(long newLength) {
        Arrays.fill(this.array, (int)newLength, this.array.length, 0L);
        return this;
    }

    @Override
    public ArrayData set(int index, Object value, boolean strict) {
        block4: {
            try {
                long longValue;
                this.array[index] = longValue = ((Long)value).longValue();
                this.setLength(Math.max((long)(index + 1), this.length()));
                return this;
            }
            catch (NullPointerException e) {
                if (value == ScriptRuntime.UNDEFINED) {
                    return new UndefinedArrayFilter(this).set(index, value, strict);
                }
            }
            catch (ClassCastException e) {
                if (value != ScriptRuntime.UNDEFINED) break block4;
                return new UndefinedArrayFilter(this).set(index, value, strict);
            }
        }
        ArrayData newData = this.convert(value == null ? Object.class : value.getClass());
        return newData.set(index, value, strict);
    }

    @Override
    public ArrayData set(int index, int value, boolean strict) {
        this.array[index] = value;
        this.setLength(Math.max((long)(index + 1), this.length()));
        return this;
    }

    @Override
    public ArrayData set(int index, long value, boolean strict) {
        this.array[index] = value;
        this.setLength(Math.max((long)(index + 1), this.length()));
        return this;
    }

    @Override
    public ArrayData set(int index, double value, boolean strict) {
        if (JSType.isRepresentableAsLong(value)) {
            this.array[index] = (long)value;
            this.setLength(Math.max((long)(index + 1), this.length()));
            return this;
        }
        return this.convert(Double.class).set(index, value, strict);
    }

    @Override
    public int getInt(int index) {
        return (int)this.array[index];
    }

    @Override
    public long getLong(int index) {
        return this.array[index];
    }

    @Override
    public double getDouble(int index) {
        return this.array[index];
    }

    @Override
    public Object getObject(int index) {
        return this.array[index];
    }

    @Override
    public boolean has(int index) {
        return 0 <= index && (long)index < this.length();
    }

    @Override
    public ArrayData delete(int index) {
        return new DeletedRangeArrayFilter(this, index, index);
    }

    @Override
    public ArrayData delete(long fromIndex, long toIndex) {
        return new DeletedRangeArrayFilter(this, fromIndex, toIndex);
    }

    @Override
    public Object pop() {
        if (this.length() == 0L) {
            return ScriptRuntime.UNDEFINED;
        }
        int newLength = (int)(this.length() - 1L);
        long elem = this.array[newLength];
        this.array[newLength] = 0L;
        this.setLength(newLength);
        return elem;
    }

    @Override
    public ArrayData slice(long from, long to) {
        long start = from < 0L ? from + this.length() : from;
        long newLength = to - start;
        return new LongArrayData(Arrays.copyOfRange(this.array, (int)from, (int)to), (int)newLength);
    }
}

