/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.arrays;

import jdk.nashorn.internal.runtime.ConsString;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.arrays.InvalidArrayIndexException;

public final class ArrayIndex {
    private static final int INVALID_ARRAY_INDEX = -1;
    private static final long MAX_ARRAY_INDEX = 0xFFFFFFFEL;

    private ArrayIndex() {
    }

    private static long fromString(String key) {
        long value = 0L;
        int length = key.length();
        if (length == 0 || length > 1 && key.charAt(0) == '0') {
            return -1L;
        }
        for (int i = 0; i < length; ++i) {
            char digit = key.charAt(i);
            if (digit < '0' || digit > '9') {
                return -1L;
            }
            if ((value = value * 10L + (long)digit - 48L) <= 0xFFFFFFFEL) continue;
            return -1L;
        }
        return value;
    }

    public static int getArrayIndexNoThrow(Object key) {
        if (key instanceof Number) {
            return ArrayIndex.getArrayIndexNoThrow(((Number)key).doubleValue());
        }
        if (key instanceof String) {
            return (int)ArrayIndex.fromString((String)key);
        }
        if (key instanceof ConsString) {
            return (int)ArrayIndex.fromString(key.toString());
        }
        return -1;
    }

    public static int getArrayIndex(Object key) throws InvalidArrayIndexException {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (index != -1) {
            return index;
        }
        throw new InvalidArrayIndexException(key);
    }

    public static int getArrayIndexNoThrow(long key) {
        if (key >= 0L && key <= 0xFFFFFFFEL) {
            return (int)key;
        }
        return -1;
    }

    public static int getArrayIndex(long key) throws InvalidArrayIndexException {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (index != -1) {
            return index;
        }
        throw new InvalidArrayIndexException(key);
    }

    public static int getArrayIndexNoThrow(double key) {
        if (JSType.isRepresentableAsInt(key)) {
            int intKey = (int)key;
            if (intKey >= 0) {
                return intKey;
            }
        } else if (JSType.isRepresentableAsLong(key)) {
            return ArrayIndex.getArrayIndexNoThrow((long)key);
        }
        return -1;
    }

    public static int getArrayIndex(double key) throws InvalidArrayIndexException {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (index != -1) {
            return index;
        }
        throw new InvalidArrayIndexException(key);
    }

    public static int getArrayIndexNoThrow(String key) {
        return (int)ArrayIndex.fromString(key);
    }

    public static int getArrayIndex(String key) throws InvalidArrayIndexException {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (index != -1) {
            return index;
        }
        throw new InvalidArrayIndexException((Object)key);
    }

    public static boolean isValidArrayIndex(int index) {
        return index != -1;
    }

    public static long toLongIndex(int index) {
        return (long)index & 0xFFFFFFFFL;
    }

    public static boolean isIndexKey(String key) {
        return ArrayIndex.getArrayIndexNoThrow(key) >= 0;
    }
}

