/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.arrays;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Array;
import jdk.nashorn.internal.runtime.GlobalObject;
import jdk.nashorn.internal.runtime.PropertyDescriptor;
import jdk.nashorn.internal.runtime.arrays.DeletedRangeArrayFilter;
import jdk.nashorn.internal.runtime.arrays.FrozenArrayFilter;
import jdk.nashorn.internal.runtime.arrays.IntArrayData;
import jdk.nashorn.internal.runtime.arrays.LongArrayData;
import jdk.nashorn.internal.runtime.arrays.NoTypeArrayData;
import jdk.nashorn.internal.runtime.arrays.NumberArrayData;
import jdk.nashorn.internal.runtime.arrays.ObjectArrayData;
import jdk.nashorn.internal.runtime.arrays.SealedArrayFilter;
import jdk.nashorn.internal.runtime.linker.Bootstrap;

public abstract class ArrayData {
    protected static final int CHUNK_SIZE = 16;
    protected static final int CHUNK_MASK = 15;
    public static final ArrayData EMPTY_ARRAY = new NoTypeArrayData();
    private long length;

    public ArrayData(long length) {
        this.length = length;
    }

    public static ArrayData initialArray() {
        return new IntArrayData();
    }

    public static ArrayData allocate(int length) {
        IntArrayData arrayData = new IntArrayData(length);
        return length == 0 ? arrayData : new DeletedRangeArrayFilter(arrayData, 0L, length - 1);
    }

    public static ArrayData allocate(Object array) {
        Class<?> clazz = array.getClass();
        if (clazz == int[].class) {
            return new IntArrayData((int[])array, ((int[])array).length);
        }
        if (clazz == long[].class) {
            return new LongArrayData((long[])array, ((long[])array).length);
        }
        if (clazz == double[].class) {
            return new NumberArrayData((double[])array, ((double[])array).length);
        }
        return new ObjectArrayData((Object[])array, ((Object[])array).length);
    }

    public static ArrayData allocate(int[] array) {
        return new IntArrayData(array, array.length);
    }

    public static ArrayData allocate(long[] array) {
        return new LongArrayData(array, array.length);
    }

    public static ArrayData allocate(double[] array) {
        return new NumberArrayData(array, array.length);
    }

    public static ArrayData allocate(Object[] array) {
        return new ObjectArrayData(array, array.length);
    }

    public static ArrayData freeze(ArrayData underlying) {
        return new FrozenArrayFilter(underlying);
    }

    public static ArrayData seal(ArrayData underlying) {
        return new SealedArrayFilter(underlying);
    }

    public final long length() {
        return this.length;
    }

    public abstract Object[] asObjectArray();

    public Object asArrayOfType(Class<?> componentType) {
        Object[] src = this.asObjectArray();
        int l = src.length;
        Object dst = Array.newInstance(componentType, l);
        MethodHandle converter = Bootstrap.getLinkerServices().getTypeConverter(Object.class, componentType);
        try {
            for (int i = 0; i < src.length; ++i) {
                Array.set(dst, i, ArrayData.invoke(converter, src[i]));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return dst;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public abstract void shiftLeft(int var1);

    public abstract ArrayData shiftRight(int var1);

    public abstract ArrayData ensure(long var1);

    public abstract ArrayData shrink(long var1);

    public abstract ArrayData set(int var1, Object var2, boolean var3);

    public abstract ArrayData set(int var1, int var2, boolean var3);

    public abstract ArrayData set(int var1, long var2, boolean var4);

    public abstract ArrayData set(int var1, double var2, boolean var4);

    public abstract int getInt(int var1);

    public abstract long getLong(int var1);

    public abstract double getDouble(int var1);

    public abstract Object getObject(int var1);

    public abstract boolean has(int var1);

    public boolean canDelete(int index, boolean strict) {
        return true;
    }

    public boolean canDelete(long fromIndex, long toIndex, boolean strict) {
        return true;
    }

    public PropertyDescriptor getDescriptor(GlobalObject global, int index) {
        return global.newDataDescriptor(this.getObject(index), true, true, true);
    }

    public abstract ArrayData delete(int var1);

    public abstract ArrayData delete(long var1, long var3);

    protected abstract ArrayData convert(Class<?> var1);

    public ArrayData push(boolean strict, Object ... items) {
        if (items.length == 0) {
            return this;
        }
        Class<?> widest = ArrayData.widestType(items);
        ArrayData newData = this.convert(widest);
        long pos = newData.length();
        for (Object item : items) {
            newData = newData.ensure(pos);
            newData.set((int)pos++, item, strict);
        }
        return newData;
    }

    public abstract Object pop();

    public abstract ArrayData slice(long var1, long var3);

    private static Class<?> widestType(Object ... items) {
        assert (items.length > 0);
        Class widest = Integer.class;
        for (Object item : items) {
            Class<?> itemClass;
            Class<?> clazz = itemClass = item == null ? null : item.getClass();
            if (itemClass == Long.class) {
                if (widest != Integer.class) continue;
                widest = Long.class;
                continue;
            }
            if (itemClass == Double.class) {
                if (widest != Integer.class && widest != Long.class) continue;
                widest = Double.class;
                continue;
            }
            if (item instanceof Number) continue;
            widest = Object.class;
            break;
        }
        return widest;
    }

    protected static int nextSize(int size) {
        if (size == 0) {
            return 16;
        }
        int i = size;
        while ((i & 0xF) != 0) {
            ++i;
        }
        return i << 1;
    }

    public long nextIndex(long index) {
        return index + 1L;
    }

    static Object invoke(MethodHandle mh, Object arg) {
        try {
            return mh.invoke(arg);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

