/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import jdk.nashorn.internal.runtime.FindProperty;
import jdk.nashorn.internal.runtime.Scope;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.linker.NashornCallSiteDescriptor;
import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.linker.GuardedInvocation;
import org.dynalang.dynalink.support.CallSiteDescriptorFactory;

public class WithObject
extends ScriptObject
implements Scope {
    private static final MethodHandle WITHEXPRESSIONFILTER = WithObject.findOwnMH("withFilterExpression", Object.class, Object.class);
    private static final MethodHandle WITHSCOPEFILTER = WithObject.findOwnMH("withFilterScope", Object.class, Object.class);
    private static final MethodHandle BIND_TO_EXPRESSION = WithObject.findOwnMH("bindToExpression", Object.class, Object.class, Object.class);
    private final Object expression;

    public WithObject(ScriptObject scope, Object expression) {
        this.setIsScope();
        this.setProto(scope);
        this.expression = expression;
    }

    @Override
    public boolean delete(Object key, boolean strict) {
        String propName;
        ScriptObject self;
        FindProperty find;
        if (this.expression instanceof ScriptObject && (find = (self = (ScriptObject)this.expression).findProperty(propName = ScriptObject.convertKey(key), true)) != null) {
            return self.delete(propName, strict);
        }
        return false;
    }

    @Override
    public GuardedInvocation lookup(CallSiteDescriptor desc, boolean megaMorphic) {
        String name;
        boolean isNamedOperation;
        NashornCallSiteDescriptor ndesc = (NashornCallSiteDescriptor)desc;
        FindProperty find = null;
        GuardedInvocation link = null;
        ScriptObject self = null;
        if (desc.getNameTokenCount() > 2) {
            isNamedOperation = true;
            name = desc.getNameToken(2);
        } else {
            isNamedOperation = false;
            name = null;
        }
        if (this.expression instanceof ScriptObject) {
            self = (ScriptObject)this.expression;
            if (isNamedOperation) {
                find = self.findProperty(name, true);
            }
            if (find != null && (link = self.lookup(desc)) != null) {
                return WithObject.fixExpressionCallSite(ndesc, link);
            }
        }
        ScriptObject scope = this.getProto();
        if (isNamedOperation) {
            find = scope.findProperty(name, true);
        }
        if (find != null) {
            return WithObject.fixScopeCallSite(scope.lookup(desc));
        }
        if (self != null) {
            String operator = (String)CallSiteDescriptorFactory.tokenizeOperators((CallSiteDescriptor)desc).get(0);
            String fallBack = "callMethod".equals(operator) || "getMethod".equals(operator) ? "__noSuchMethod__" : ("getProp".equals(operator) || "getElem".equals(operator) ? "__noSuchProperty__" : null);
            if (fallBack != null && (find = self.findProperty(fallBack, true)) != null) {
                if ("callMethod".equals(operator)) {
                    link = self.createNoSuchMethodInvocation(desc);
                } else if ("getMethod".equals(operator)) {
                    link = self.noSuchMethod(desc);
                } else if ("getProp".equals(operator) || "getElem".equals(operator)) {
                    link = self.noSuchProperty(desc);
                }
            }
            if (link != null) {
                return WithObject.fixExpressionCallSite(ndesc, link);
            }
        }
        if ((link = scope.lookup(desc)) != null) {
            return WithObject.fixScopeCallSite(link);
        }
        return null;
    }

    @Override
    public void setSplitState(int state) {
        this.getNonWithParent().setSplitState(state);
    }

    @Override
    public int getSplitState() {
        return this.getNonWithParent().getSplitState();
    }

    private Scope getNonWithParent() {
        ScriptObject proto;
        for (proto = this.getProto(); proto != null && proto instanceof WithObject; proto = proto.getProto()) {
        }
        assert (proto instanceof Scope) : "with scope without parent scope";
        return (Scope)((Object)proto);
    }

    private static GuardedInvocation fixExpressionCallSite(NashornCallSiteDescriptor desc, GuardedInvocation link) {
        if (!"getMethod".equals(desc.getFirstOperator())) {
            return link.filterArguments(0, new MethodHandle[]{WITHEXPRESSIONFILTER});
        }
        return link.replaceMethods(Lookup.MH.foldArguments(BIND_TO_EXPRESSION, WithObject.filter(link.getInvocation(), WITHEXPRESSIONFILTER)), WithObject.filterGuard(link, WITHEXPRESSIONFILTER));
    }

    private static GuardedInvocation fixScopeCallSite(GuardedInvocation link) {
        return link.replaceMethods(WithObject.filter(link.getInvocation(), WITHSCOPEFILTER), WithObject.filterGuard(link, WITHSCOPEFILTER));
    }

    private static MethodHandle filterGuard(GuardedInvocation link, MethodHandle filter) {
        MethodHandle test = link.getGuard();
        return test == null ? null : WithObject.filter(test, filter);
    }

    private static MethodHandle filter(MethodHandle mh, MethodHandle filter) {
        return Lookup.MH.filterArguments(mh, 0, filter);
    }

    public static Object withFilterExpression(Object receiver) {
        return ((WithObject)receiver).expression;
    }

    private static Object bindToExpression(Object fn, Object receiver) {
        return fn instanceof ScriptFunction ? ((ScriptFunction)fn).makeBoundFunction(WithObject.withFilterExpression(receiver), new Object[0]) : fn;
    }

    public static Object withFilterScope(Object receiver) {
        return ((WithObject)receiver).getProto();
    }

    public Object getExpression() {
        return this.expression;
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(MethodHandles.lookup(), WithObject.class, name, Lookup.MH.type(rtype, types));
    }
}

