/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.objects.ObjectClassGenerator;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.NashornLoader;
import jdk.nashorn.internal.runtime.Source;
import sun.misc.Unsafe;

final class StructureLoader
extends NashornLoader {
    private static final String JS_OBJECT_PREFIX_EXTERNAL = Compiler.binaryName("jdk/nashorn/internal/scripts") + '.' + CompilerConstants.JS_OBJECT_PREFIX.tag();
    private static final String OBJECTS_PACKAGE_EXTERNAL = Compiler.binaryName("jdk/nashorn/internal/objects");
    private static final boolean IS_JAVA_7 = System.getProperty("java.version").indexOf("1.7") != -1;

    StructureLoader(ClassLoader parent, Context context) {
        super(parent, context);
    }

    @Override
    protected synchronized Class<?> loadClass(final String name, final boolean resolve) throws ClassNotFoundException {
        StructureLoader.checkPackageAccess(name);
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass != null) {
            if (resolve) {
                this.resolveClass(loadedClass);
            }
            return loadedClass;
        }
        if (name.startsWith(Compiler.binaryName(OBJECTS_PACKAGE_EXTERNAL))) {
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Class<?> run() throws ClassNotFoundException {
                        String source = name.replace('.', '/') + ".clazz";
                        URL url = StructureLoader.this.getResource(source);
                        InputStream is = StructureLoader.this.getResourceAsStream(source);
                        try {
                            byte[] code;
                            if (is == null) {
                                throw new ClassNotFoundException(name);
                            }
                            try {
                                code = Source.readBytes(is);
                            }
                            catch (IOException e) {
                                Context.printStackTrace(e);
                                throw new ClassNotFoundException(name, e);
                            }
                            Class cl = StructureLoader.this.defineClass(name, code, 0, code.length, new CodeSource(url, (CodeSigner[])null));
                            if (resolve) {
                                StructureLoader.this.resolveClass(cl);
                            }
                            Class clazz = cl;
                            return clazz;
                        }
                        finally {
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new ClassNotFoundException(name, e);
            }
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (name.startsWith(JS_OBJECT_PREFIX_EXTERNAL)) {
            int start = name.indexOf(CompilerConstants.JS_OBJECT_PREFIX.tag()) + CompilerConstants.JS_OBJECT_PREFIX.tag().length();
            return this.generateClass(name, name.substring(start, name.length()));
        }
        return super.findClass(name);
    }

    private Class<?> generateClass(String name, String descriptor) {
        Context context = this.getContext();
        if (context == null) {
            context = Context.getContext();
        }
        byte[] code = new ObjectClassGenerator(context).generate(descriptor);
        try {
            return IS_JAVA_7 ? Unsafe.getUnsafe().defineClass(name, code, 0, code.length) : this.defineClass(name, code, 0, code.length);
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)"Nashorn needs to run in the bootclasspath when using Java7, or the NoClassDefFoundError bug in Java7 will trigger.(This may not be enough - it has been known to happen anyway. Please use Java8)");
        }
    }
}

