/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.linker.Lookup;

public class ScriptingFunctions {
    public static final MethodHandle READLINE = ScriptingFunctions.findOwnMH("readLine", Object.class, Object.class);
    public static final MethodHandle READ = ScriptingFunctions.findOwnMH("read", Object.class, Object.class, Object.class);
    public static final MethodHandle QUIT = ScriptingFunctions.findOwnMH("quit", Object.class, Object.class, Object.class);

    private ScriptingFunctions() {
    }

    public static Object readLine(Object self) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        return reader.readLine();
    }

    public static Object read(Object self, Object file) throws IOException {
        File f = null;
        if (file instanceof File) {
            f = (File)file;
        } else if (file instanceof String) {
            f = new File((String)file);
        }
        if (f == null || !f.isFile()) {
            ECMAErrors.typeError(Context.getGlobal(), "not.a.file", ScriptRuntime.safeToString(file));
            return ScriptRuntime.UNDEFINED;
        }
        return new String(Source.readFully(f));
    }

    public static Object quit(Object self, Object code) {
        System.exit(JSType.toInt32(code));
        return ScriptRuntime.UNDEFINED;
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(MethodHandles.lookup(), ScriptingFunctions.class, name, Lookup.MH.type(rtype, types));
    }
}

