/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.objects.ObjectClassGenerator;
import jdk.nashorn.internal.runtime.AccessorProperty;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.FindProperty;
import jdk.nashorn.internal.runtime.GlobalObject;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyAccess;
import jdk.nashorn.internal.runtime.PropertyDescriptor;
import jdk.nashorn.internal.runtime.PropertyListenerManager;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.SpillProperty;
import jdk.nashorn.internal.runtime.Undefined;
import jdk.nashorn.internal.runtime.UserAccessorProperty;
import jdk.nashorn.internal.runtime.arrays.ArrayData;
import jdk.nashorn.internal.runtime.arrays.ArrayIndex;
import jdk.nashorn.internal.runtime.linker.Bootstrap;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.linker.MethodHandleFactory;
import jdk.nashorn.internal.runtime.linker.NashornCallSiteDescriptor;
import jdk.nashorn.internal.runtime.linker.NashornGuardedInvocation;
import jdk.nashorn.internal.runtime.linker.NashornGuards;
import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.linker.GuardedInvocation;
import org.dynalang.dynalink.support.CallSiteDescriptorFactory;
import org.dynalang.dynalink.support.Guards;

public abstract class ScriptObject
extends PropertyListenerManager
implements PropertyAccess,
Map<Object, Object> {
    static final String NO_SUCH_METHOD_NAME = "__noSuchMethod__";
    static final String NO_SUCH_PROPERTY_NAME = "__noSuchProperty__";
    public static final int IS_SCOPE = 1;
    public static final int IS_ARRAY = 2;
    public static final int IS_ARGUMENTS = 4;
    public static final int SPILL_RATE = 8;
    private PropertyMap map;
    private int flags;
    public Object[] spill;
    public Object embed0;
    public Object embed1;
    public Object embed2;
    public Object embed3;
    private ArrayData arrayData;
    private static final MethodHandle SETEMBED = ScriptObject.findOwnMH("setEmbed", Void.TYPE, CallSiteDescriptor.class, PropertyMap.class, PropertyMap.class, MethodHandle.class, Integer.TYPE, Object.class, Object.class);
    private static final MethodHandle SETSPILL = ScriptObject.findOwnMH("setSpill", Void.TYPE, CallSiteDescriptor.class, PropertyMap.class, PropertyMap.class, Integer.TYPE, Object.class, Object.class);
    private static final MethodHandle SETSPILLWITHNEW = ScriptObject.findOwnMH("setSpillWithNew", Void.TYPE, CallSiteDescriptor.class, PropertyMap.class, PropertyMap.class, Integer.TYPE, Object.class, Object.class);
    private static final MethodHandle SETSPILLWITHGROW = ScriptObject.findOwnMH("setSpillWithGrow", Void.TYPE, CallSiteDescriptor.class, PropertyMap.class, PropertyMap.class, Integer.TYPE, Integer.TYPE, Object.class, Object.class);
    private static final MethodHandle TRUNCATINGFILTER = ScriptObject.findOwnMH("truncatingFilter", Object[].class, Integer.TYPE, Object[].class);
    private static final MethodHandle KNOWNFUNCPROPGUARD = ScriptObject.findOwnMH("knownFunctionPropertyGuard", Boolean.TYPE, Object.class, PropertyMap.class, MethodHandle.class, Object.class, ScriptFunction.class);
    public static final CompilerConstants.Call GET_ARGUMENT = CompilerConstants.virtualCall(ScriptObject.class, "getArgument", Object.class, Integer.TYPE);
    public static final CompilerConstants.Call SET_ARGUMENT = CompilerConstants.virtualCall(ScriptObject.class, "setArgument", Void.TYPE, Integer.TYPE, Object.class);
    public static final CompilerConstants.Call GET_PROTO = CompilerConstants.virtualCallNoLookup(ScriptObject.class, "getProto", ScriptObject.class, new Class[0]);
    public static final CompilerConstants.Call SET_PROTO = CompilerConstants.virtualCallNoLookup(ScriptObject.class, "setProto", Void.TYPE, ScriptObject.class);
    public static final CompilerConstants.Call SET_USER_ACCESSORS = CompilerConstants.virtualCall(ScriptObject.class, "setUserAccessors", Void.TYPE, String.class, ScriptFunction.class, ScriptFunction.class);
    static final CompilerConstants.Call USER_ACCESSOR_GETTER = CompilerConstants.staticCall(MethodHandles.lookup(), ScriptObject.class, "userAccessorGetter", Object.class, ScriptObject.class, Integer.TYPE, Object.class);
    static final CompilerConstants.Call USER_ACCESSOR_SETTER = CompilerConstants.staticCall(MethodHandles.lookup(), ScriptObject.class, "userAccessorSetter", Void.TYPE, ScriptObject.class, Integer.TYPE, String.class, Object.class, Object.class);
    private static final MethodHandle INVOKE_UA_GETTER = Bootstrap.createDynamicInvoker("dyn:call", Object.class, Object.class, Object.class);
    private static final MethodHandle INVOKE_UA_SETTER = Bootstrap.createDynamicInvoker("dyn:call", Void.TYPE, Object.class, Object.class, Object.class);
    public static final int EMBED_SIZE = 4;
    public static final int EMBED_OFFSET = 28;
    private static final MethodHandle[] GET_EMBED = new MethodHandle[4];
    private static final MethodHandle[] SET_EMBED = new MethodHandle[4];
    protected static int count;
    protected static int scopeCount;

    public ScriptObject() {
        this(null);
    }

    public ScriptObject(PropertyMap map) {
        if (Context.DEBUG) {
            ++count;
        }
        this.arrayData = ArrayData.EMPTY_ARRAY;
        if (map == null) {
            this.setMap(PropertyMap.newMap(this.getClass()));
            return;
        }
        this.setMap(map);
    }

    public void addBoundProperties(ScriptObject source) {
        PropertyMap newMap = this.getMap();
        for (Property property : source.getMap().getProperties()) {
            String key = property.getKey();
            if (newMap.findProperty(key) != null) continue;
            if (property instanceof UserAccessorProperty) {
                UserAccessorProperty prop = this.newUserAccessors(key, property.getFlags(), property.getGetterFunction(source), property.getSetterFunction(source));
                newMap = newMap.addProperty(prop);
                continue;
            }
            newMap = newMap.newPropertyBind((AccessorProperty)property, source);
        }
        this.setMap(newMap);
    }

    private static MethodHandle bindTo(MethodHandle methodHandle, Object receiver) {
        return Lookup.MH.dropArguments(Lookup.MH.bindTo(methodHandle, receiver), 0, Object.class);
    }

    public Iterator<String> propertyIterator() {
        return new KeyIterator(this);
    }

    public Iterator<Object> valueIterator() {
        return new ValueIterator(this);
    }

    public final boolean isAccessorDescriptor() {
        return this.has("get") || this.has("set");
    }

    public final boolean isDataDescriptor() {
        return this.has("value") || this.has("writable");
    }

    public final boolean isGenericDescriptor() {
        return this.isAccessorDescriptor() || this.isDataDescriptor();
    }

    public final PropertyDescriptor toPropertyDescriptor() {
        PropertyDescriptor desc;
        GlobalObject global = (GlobalObject)((Object)Context.getGlobal());
        if (this.isDataDescriptor()) {
            if (this.has("set") || this.has("get")) {
                ECMAErrors.typeError((ScriptObject)((Object)global), "inconsistent.property.descriptor", new String[0]);
            }
            desc = global.newDataDescriptor(ScriptRuntime.UNDEFINED, false, false, false);
        } else if (this.isAccessorDescriptor()) {
            if (this.has("value") || this.has("writable")) {
                ECMAErrors.typeError((ScriptObject)((Object)global), "inconsistent.property.descriptor", new String[0]);
            }
            desc = global.newAccessorDescriptor(ScriptRuntime.UNDEFINED, ScriptRuntime.UNDEFINED, false, false);
        } else {
            desc = global.newGenericDescriptor(false, false);
        }
        return desc.fillFrom(this);
    }

    public static PropertyDescriptor toPropertyDescriptor(ScriptObject global, Object obj) {
        if (obj instanceof ScriptObject) {
            return ((ScriptObject)obj).toPropertyDescriptor();
        }
        ECMAErrors.typeError(global, "not.an.object", ScriptRuntime.safeToString(obj));
        return null;
    }

    public Object getOwnPropertyDescriptor(String key) {
        Property property = this.getMap().findProperty(key);
        GlobalObject global = (GlobalObject)((Object)Context.getGlobal());
        if (property != null) {
            ScriptFunction get = property.getGetterFunction(this);
            ScriptFunction set = property.getSetterFunction(this);
            boolean configurable = property.isConfigurable();
            boolean enumerable = property.isEnumerable();
            boolean writable = property.isWritable();
            if (property instanceof UserAccessorProperty) {
                return global.newAccessorDescriptor(get != null ? get : ScriptRuntime.UNDEFINED, set != null ? set : ScriptRuntime.UNDEFINED, configurable, enumerable);
            }
            return global.newDataDescriptor(this.getWithProperty(property), configurable, enumerable, writable);
        }
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        ArrayData array = this.getArray();
        if (array.has(index)) {
            return array.getDescriptor(global, index);
        }
        return ScriptRuntime.UNDEFINED;
    }

    public Object getPropertyDescriptor(String key) {
        Object res = this.getOwnPropertyDescriptor(key);
        if (res != ScriptRuntime.UNDEFINED) {
            return res;
        }
        if (this.getProto() != null) {
            return this.getProto().getOwnPropertyDescriptor(key);
        }
        return ScriptRuntime.UNDEFINED;
    }

    public boolean defineOwnProperty(String key, Object propertyDesc, boolean reject) {
        ScriptObject global = Context.getGlobal();
        PropertyDescriptor desc = ScriptObject.toPropertyDescriptor(global, propertyDesc);
        Object current = this.getOwnPropertyDescriptor(key);
        String name = JSType.toString(key);
        if (current == ScriptRuntime.UNDEFINED) {
            if (this.isExtensible()) {
                this.addOwnProperty(key, desc);
                return true;
            }
            if (reject) {
                ECMAErrors.typeError(global, "object.non.extensible", name, ScriptRuntime.safeToString(this));
            }
            return false;
        }
        PropertyDescriptor currentDesc = (PropertyDescriptor)current;
        PropertyDescriptor newDesc = desc;
        if (newDesc.type() == 0 && !newDesc.has("configurable") && !newDesc.has("enumerable")) {
            return true;
        }
        if (currentDesc.equals(newDesc)) {
            return true;
        }
        if (!currentDesc.isConfigurable()) {
            if (newDesc.has("configurable") && newDesc.isConfigurable()) {
                if (reject) {
                    ECMAErrors.typeError(global, "cant.redefine.property", name, ScriptRuntime.safeToString(this));
                }
                return false;
            }
            if (newDesc.has("enumerable") && currentDesc.isEnumerable() != newDesc.isEnumerable()) {
                if (reject) {
                    ECMAErrors.typeError(global, "cant.redefine.property", name, ScriptRuntime.safeToString(this));
                }
                return false;
            }
        }
        int propFlags = Property.mergeFlags(currentDesc, newDesc);
        Property property = this.getMap().findProperty(key);
        if (currentDesc.type() == 1 && (newDesc.type() == 1 || newDesc.type() == 0)) {
            Object value;
            if (!currentDesc.isConfigurable() && !currentDesc.isWritable() && (newDesc.has("writable") && newDesc.isWritable() || newDesc.has("value") && !ScriptRuntime.sameValue(currentDesc.getValue(), newDesc.getValue()))) {
                if (reject) {
                    ECMAErrors.typeError(global, "cant.redefine.property", name, ScriptRuntime.safeToString(this));
                }
                return false;
            }
            boolean newValue = newDesc.has("value");
            Object object = value = newValue ? newDesc.getValue() : currentDesc.getValue();
            if (newValue && property != null) {
                property = this.modifyOwnProperty(property, 0);
                this.set((Object)key, value, this.getContext()._strict);
            }
            if (property == null) {
                this.addOwnProperty(key, propFlags, value);
                this.removeArraySlot(key);
            } else {
                this.modifyOwnProperty(property, propFlags);
            }
        } else if (currentDesc.type() == 2 && (newDesc.type() == 2 || newDesc.type() == 0)) {
            if (!currentDesc.isConfigurable() && (newDesc.has("get") && !ScriptRuntime.sameValue(currentDesc.getGetter(), newDesc.getGetter()) || newDesc.has("set") && !ScriptRuntime.sameValue(currentDesc.getSetter(), newDesc.getSetter()))) {
                if (reject) {
                    ECMAErrors.typeError(global, "cant.redefine.property", name, ScriptRuntime.safeToString(this));
                }
                return false;
            }
            this.modifyOwnProperty(property, propFlags, newDesc.has("get") ? newDesc.getGetter() : currentDesc.getGetter(), newDesc.has("set") ? newDesc.getSetter() : currentDesc.getSetter());
        } else {
            int type;
            boolean value;
            if (!currentDesc.isConfigurable()) {
                if (reject) {
                    ECMAErrors.typeError(global, "cant.redefine.property", name, ScriptRuntime.safeToString(this));
                }
                return false;
            }
            propFlags = 0;
            boolean bl = value = newDesc.has("configurable") ? newDesc.isConfigurable() : currentDesc.isConfigurable();
            if (!value) {
                propFlags |= 4;
            }
            boolean bl2 = value = newDesc.has("enumerable") ? newDesc.isEnumerable() : currentDesc.isEnumerable();
            if (!value) {
                propFlags |= 2;
            }
            if ((type = newDesc.type()) == 1) {
                boolean bl3 = value = newDesc.has("writable") && newDesc.isWritable();
                if (!value) {
                    propFlags |= 1;
                }
                this.deleteOwnProperty(property);
                this.addOwnProperty(key, propFlags, newDesc.getValue());
            } else if (type == 2) {
                if (property == null) {
                    this.addOwnProperty(key, propFlags, newDesc.has("get") ? newDesc.getGetter() : null, newDesc.has("set") ? newDesc.getSetter() : null);
                } else {
                    this.modifyOwnProperty(property, propFlags, newDesc.has("get") ? newDesc.getGetter() : null, newDesc.has("set") ? newDesc.getSetter() : null);
                }
            }
        }
        this.checkIntegerKey(key);
        return true;
    }

    protected final void defineOwnProperty(int index, Object value) {
        if ((long)index >= this.getArray().length()) {
            this.setArray(this.getArray().ensure(index));
        }
        this.setArray(this.getArray().set(index, value, false));
    }

    private void checkIntegerKey(String key) {
        ArrayData data;
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index) && (data = this.getArray()).has(index)) {
            this.setArray(data.delete(index));
        }
    }

    private void removeArraySlot(String key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        ArrayData array = this.getArray();
        if (array.has(index)) {
            this.setArray(array.delete(index));
        }
    }

    public final void addOwnProperty(String key, PropertyDescriptor propertyDesc) {
        int type;
        PropertyDescriptor pdesc = propertyDesc;
        int propFlags = Property.toFlags(pdesc);
        if (pdesc.type() == 0) {
            GlobalObject global = (GlobalObject)((Object)Context.getGlobal());
            PropertyDescriptor dDesc = global.newDataDescriptor(ScriptRuntime.UNDEFINED, false, false, false);
            dDesc.fillFrom((ScriptObject)((Object)pdesc));
            pdesc = dDesc;
        }
        if ((type = pdesc.type()) == 1) {
            this.addOwnProperty(key, propFlags, pdesc.getValue());
        } else if (type == 2) {
            this.addOwnProperty(key, propFlags, pdesc.has("get") ? pdesc.getGetter() : null, pdesc.has("set") ? pdesc.getSetter() : null);
        }
        this.checkIntegerKey(key);
    }

    public final FindProperty findProperty(String key, boolean deep) {
        int depth = 0;
        for (ScriptObject self = this; self != null; self = self.getProto()) {
            PropertyMap selfMap = self.getMap();
            Property property = selfMap.findProperty(key);
            if (property != null) {
                return new FindProperty(this, self, selfMap, property, depth);
            }
            if (!deep) {
                return null;
            }
            ++depth;
        }
        return null;
    }

    public final Property addOwnProperty(String key, int propertyFlags, ScriptFunction getter, ScriptFunction setter) {
        return this.addOwnProperty(this.newUserAccessors(key, propertyFlags, getter, setter));
    }

    public final Property addOwnProperty(String key, int propertyFlags, Object value) {
        MethodHandle setter = this.addSpill(key, propertyFlags);
        try {
            setter.invokeExact(this, value);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return this.getMap().findProperty(key);
    }

    public final Property addOwnProperty(Property newProperty) {
        PropertyMap newMap;
        PropertyMap oldMap = this.getMap();
        while (!this.compareAndSetMap(oldMap, newMap = oldMap.addProperty(newProperty))) {
            oldMap = this.getMap();
            Property oldProperty = oldMap.findProperty(newProperty.getKey());
            if (oldProperty == null) continue;
            return oldProperty;
        }
        return newProperty;
    }

    private void erasePropertyValue(Property property) {
        if (!(property instanceof UserAccessorProperty)) {
            try {
                property.getSetter(Object.class, this.getMap()).invokeExact(this, ScriptRuntime.UNDEFINED);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public final boolean deleteOwnProperty(Property property) {
        this.erasePropertyValue(property);
        PropertyMap oldMap = this.getMap();
        while (true) {
            PropertyMap newMap;
            if ((newMap = oldMap.deleteProperty(property)) == null) {
                return false;
            }
            if (this.compareAndSetMap(oldMap, newMap)) break;
            oldMap = this.getMap();
        }
        if (property instanceof UserAccessorProperty) {
            UserAccessorProperty uc = (UserAccessorProperty)property;
            this.setEmbedOrSpill(uc.getGetterSlot(), null);
            this.setEmbedOrSpill(uc.getSetterSlot(), null);
        }
        return true;
    }

    public final Property modifyOwnProperty(Property oldProperty, int propertyFlags, ScriptFunction getter, ScriptFunction setter) {
        UserAccessorProperty newProperty;
        if (oldProperty instanceof UserAccessorProperty) {
            UserAccessorProperty uc = (UserAccessorProperty)oldProperty;
            int getterSlot = uc.getGetterSlot();
            this.setEmbedOrSpill(getterSlot, getter);
            if (getter == null) {
                getterSlot = -getterSlot - 1;
            }
            int setterSlot = uc.getSetterSlot();
            this.setEmbedOrSpill(setterSlot, setter);
            if (setter == null) {
                setterSlot = -setterSlot - 1;
            }
            if (oldProperty.equals(newProperty = new UserAccessorProperty(oldProperty.getKey(), propertyFlags, getterSlot, setterSlot))) {
                return oldProperty;
            }
        } else {
            this.erasePropertyValue(oldProperty);
            newProperty = this.newUserAccessors(oldProperty.getKey(), propertyFlags, getter, setter);
        }
        this.notifyPropertyModified(this, oldProperty, newProperty);
        return this.modifyOwnProperty(oldProperty, newProperty);
    }

    public final Property modifyOwnProperty(Property oldProperty, int propertyFlags) {
        return this.modifyOwnProperty(oldProperty, oldProperty.setFlags(propertyFlags));
    }

    private Property modifyOwnProperty(Property oldProperty, Property newProperty) {
        PropertyMap newMap;
        assert (newProperty.getKey().equals(oldProperty.getKey())) : "replacing property with different key";
        PropertyMap oldMap = this.getMap();
        while (!this.compareAndSetMap(oldMap, newMap = oldMap.replaceProperty(oldProperty, newProperty))) {
            oldMap = this.getMap();
            Property oldPropertyLookup = oldMap.findProperty(oldProperty.getKey());
            if (oldPropertyLookup == null || !oldPropertyLookup.equals(newProperty)) continue;
            return oldPropertyLookup;
        }
        return newProperty;
    }

    public final void setUserAccessors(String key, ScriptFunction getter, ScriptFunction setter) {
        Property oldProperty = this.getMap().findProperty(key);
        if (oldProperty != null) {
            UserAccessorProperty newProperty = this.newUserAccessors(oldProperty.getKey(), oldProperty.getFlags(), getter, setter);
            this.modifyOwnProperty(oldProperty, newProperty);
        } else {
            UserAccessorProperty newProperty = this.newUserAccessors(key, 0, getter, setter);
            this.addOwnProperty(newProperty);
        }
    }

    private static int getIntValue(FindProperty find) {
        MethodHandle getter = find.getGetter(Integer.TYPE);
        if (getter != null) {
            try {
                return (Integer)getter.invokeExact(find.getOwner());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return 0;
    }

    private static long getLongValue(FindProperty find) {
        MethodHandle getter = find.getGetter(Long.TYPE);
        if (getter != null) {
            try {
                return (Long)getter.invokeExact(find.getOwner());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return 0L;
    }

    private static double getDoubleValue(FindProperty find) {
        MethodHandle getter = find.getGetter(Double.TYPE);
        if (getter != null) {
            try {
                return (Double)getter.invokeExact(find.getOwner());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return Double.NaN;
    }

    protected static Object getObjectValue(FindProperty find) {
        MethodHandle getter = find.getGetter(Object.class);
        if (getter != null) {
            try {
                return getter.invokeExact(find.getOwner());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return ScriptRuntime.UNDEFINED;
    }

    protected MethodHandle getCallMethodHandle(FindProperty find, MethodType type, String bindName) {
        return ScriptObject.getCallMethodHandle(ScriptObject.getObjectValue(find), type, bindName);
    }

    protected static MethodHandle getCallMethodHandle(Object value, MethodType type, String bindName) {
        return value instanceof ScriptFunction ? ((ScriptFunction)value).getCallMethodHandle(type, bindName) : null;
    }

    public final Object getWithProperty(Property property) {
        return ScriptObject.getObjectValue(new FindProperty(this, this, this.getMap(), property, 0));
    }

    public final Property getProperty(String key) {
        return this.getMap().findProperty(key);
    }

    static String convertKey(Object key) {
        return key instanceof String ? (String)key : JSType.toString(key);
    }

    public Object getArgument(int key) {
        return this.get(key);
    }

    public void setArgument(int key, Object value) {
        this.set(key, value, this.getContext()._strict);
    }

    public final Context getContext() {
        return this.getMap().getContext();
    }

    public final PropertyMap getMap() {
        return this.map;
    }

    public final void setMap(PropertyMap map) {
        this.map = map;
    }

    protected final synchronized boolean compareAndSetMap(PropertyMap oldMap, PropertyMap newMap) {
        boolean update;
        boolean bl = update = oldMap == this.map;
        if (update) {
            this.map = newMap;
        }
        return update;
    }

    public final ScriptObject getProto() {
        return this.getMap().getProto();
    }

    public final boolean isPrototype() {
        return this.getMap().isPrototype();
    }

    public final void setProto(ScriptObject newProto) {
        PropertyMap oldMap = this.getMap();
        ScriptObject oldProto = this.getProto();
        while (oldProto != newProto) {
            PropertyMap newMap = oldMap.setProto(newProto);
            if (!this.compareAndSetMap(oldMap, newMap)) {
                oldMap = this.getMap();
                oldProto = this.getProto();
                continue;
            }
            if (this.isPrototype()) {
                if (oldProto != null) {
                    oldProto.removePropertyListener(this);
                }
                if (newProto != null) {
                    newProto.addPropertyListener(this);
                }
            }
            return;
        }
    }

    public final void setProtoCheck(Object newProto) {
        if (newProto == null || newProto instanceof ScriptObject) {
            this.setProto((ScriptObject)newProto);
        } else {
            ScriptObject global = Context.getGlobal();
            Object newProtoObject = JSType.toObject(global, newProto);
            if (newProtoObject instanceof ScriptObject) {
                this.setProto((ScriptObject)newProtoObject);
            } else {
                ECMAErrors.typeError(global, "cant.set.proto.to.non.object", ScriptRuntime.safeToString(this), ScriptRuntime.safeToString(newProto));
            }
        }
    }

    public String[] getOwnKeys(boolean all) {
        ArrayList<String> keys = new ArrayList<String>();
        PropertyMap selfMap = this.getMap();
        ArrayData array = this.getArray();
        long length = array.length();
        long i = 0L;
        while (i < length) {
            if (array.has((int)i)) {
                keys.add(JSType.toString(i));
            }
            i = array.nextIndex(i);
        }
        for (Property property : selfMap.getProperties()) {
            if (!all && !property.isEnumerable()) continue;
            keys.add(property.getKey());
        }
        return keys.toArray(new String[keys.size()]);
    }

    public boolean hasArrayEntries() {
        ArrayData array = this.getArray();
        long length = array.length();
        for (long i = 0L; i < length; ++i) {
            if (!array.has((int)i)) continue;
            return true;
        }
        return false;
    }

    public String getClassName() {
        return "Object";
    }

    public Object getLength() {
        return this.get("length");
    }

    public String safeToString() {
        return "[object " + this.getClassName() + "]";
    }

    public Object getDefaultValue(Class<?> typeHint) {
        return ((GlobalObject)((Object)Context.getGlobal())).getDefaultValue(this, typeHint);
    }

    public boolean isInstance(ScriptObject instance) {
        return false;
    }

    public ScriptObject preventExtensions() {
        PropertyMap newMap;
        PropertyMap oldMap = this.getMap();
        while (!this.compareAndSetMap(oldMap, newMap = this.getMap().preventExtensions())) {
            oldMap = this.getMap();
        }
        return this;
    }

    public static boolean isArray(Object obj) {
        return obj instanceof ScriptObject && ((ScriptObject)obj).isArray();
    }

    public final boolean isArray() {
        return (this.flags & 2) != 0;
    }

    public final void setIsArray() {
        this.flags |= 2;
    }

    public final boolean isArguments() {
        return (this.flags & 4) != 0;
    }

    public final void setIsArguments() {
        this.flags |= 4;
    }

    public final ArrayData getArray() {
        return this.arrayData;
    }

    public final void setArray(ArrayData arrayData) {
        this.arrayData = arrayData;
    }

    public boolean isExtensible() {
        return this.getMap().isExtensible();
    }

    public ScriptObject seal() {
        PropertyMap newMap;
        PropertyMap oldMap = this.getMap();
        while (!this.compareAndSetMap(oldMap, newMap = this.getMap().seal())) {
            oldMap = this.getMap();
        }
        this.setArray(ArrayData.seal(this.getArray()));
        return this;
    }

    public boolean isSealed() {
        return this.getMap().isSealed();
    }

    public ScriptObject freeze() {
        PropertyMap newMap;
        PropertyMap oldMap = this.getMap();
        while (!this.compareAndSetMap(oldMap, newMap = this.getMap().freeze())) {
            oldMap = this.getMap();
        }
        this.setArray(ArrayData.freeze(this.getArray()));
        return this;
    }

    public boolean isFrozen() {
        return this.getMap().isFrozen();
    }

    public final void setIsScope() {
        if (Context.DEBUG) {
            ++scopeCount;
        }
        this.flags |= 1;
    }

    public final boolean isScope() {
        return (this.flags & 1) != 0;
    }

    @Override
    public void clear() {
        boolean strict = this.getContext()._strict;
        Iterator<String> iter = this.propertyIterator();
        while (iter.hasNext()) {
            this.delete(iter.next(), strict);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.has(key);
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator<Object> iter = this.valueIterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        Iterator<String> iter = this.propertyIterator();
        HashSet<AbstractMap.SimpleImmutableEntry<String, Object>> entries = new HashSet<AbstractMap.SimpleImmutableEntry<String, Object>>();
        while (iter.hasNext()) {
            String key = iter.next();
            entries.add(new AbstractMap.SimpleImmutableEntry<String, Object>(key, this.get(key)));
        }
        return Collections.unmodifiableSet(entries);
    }

    @Override
    public boolean isEmpty() {
        return !this.propertyIterator().hasNext();
    }

    @Override
    public Set<Object> keySet() {
        Iterator<String> iter = this.propertyIterator();
        HashSet<String> keySet = new HashSet<String>();
        while (iter.hasNext()) {
            keySet.add(iter.next());
        }
        return Collections.unmodifiableSet(keySet);
    }

    @Override
    public Object put(Object key, Object value) {
        Object oldValue = this.get(key);
        this.set(key, value, this.getContext()._strict);
        return oldValue;
    }

    @Override
    public void putAll(Map<?, ?> otherMap) {
        boolean strict = this.getContext()._strict;
        for (Map.Entry<?, ?> entry : otherMap.entrySet()) {
            this.set(entry.getKey(), entry.getValue(), strict);
        }
    }

    @Override
    public Object remove(Object key) {
        Object oldValue = this.get(key);
        this.delete(key, this.getContext()._strict);
        return oldValue;
    }

    @Override
    public int size() {
        int n = 0;
        Iterator<String> iter = this.propertyIterator();
        while (iter.hasNext()) {
            ++n;
            iter.next();
        }
        return n;
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>(this.size());
        Iterator<Object> iter = this.valueIterator();
        while (iter.hasNext()) {
            values.add(iter.next());
        }
        return Collections.unmodifiableList(values);
    }

    public final GuardedInvocation lookup(CallSiteDescriptor desc) {
        return this.lookup(desc, false);
    }

    public GuardedInvocation lookup(CallSiteDescriptor desc, boolean megaMorphic) {
        int c = desc.getNameTokenCount();
        String operator = (String)CallSiteDescriptorFactory.tokenizeOperators((CallSiteDescriptor)desc).get(0);
        if ("getProp".equals(operator) || "getElem".equals(operator) || "getMethod".equals(operator)) {
            return c > 2 ? this.findGetMethod(desc, megaMorphic, operator) : ScriptObject.findGetIndexMethod(desc);
        }
        if ("setProp".equals(operator) || "setElem".equals(operator)) {
            return c > 2 ? this.findSetMethod(desc, megaMorphic) : ScriptObject.findSetIndexMethod(desc);
        }
        if ("call".equals(operator)) {
            return this.findCallMethod(desc, megaMorphic);
        }
        if ("new".equals(operator)) {
            return this.findNewMethod(desc);
        }
        if ("callMethod".equals(operator)) {
            return this.findCallMethodMethod(desc, megaMorphic);
        }
        return null;
    }

    protected GuardedInvocation findNewMethod(CallSiteDescriptor desc) {
        return this.notAFunction();
    }

    protected GuardedInvocation findCallMethod(CallSiteDescriptor desc, boolean megaMorphic) {
        return this.notAFunction();
    }

    private GuardedInvocation notAFunction() {
        ECMAErrors.typeError(Context.getGlobal(), "not.a.function", ScriptRuntime.safeToString(this));
        return null;
    }

    protected GuardedInvocation findCallMethodMethod(CallSiteDescriptor desc, boolean megaMorphic) {
        String name = desc.getNameToken(2);
        MethodType callType = desc.getMethodType();
        FindProperty find = this.findProperty(name, true);
        if (find == null) {
            return this.createNoSuchMethodInvocation(desc);
        }
        if (find.getProperty().hasGetterFunction()) {
            GuardedInvocation link = this.findGetMethod(CallSiteDescriptorFactory.changeReturnType((CallSiteDescriptor)desc, Object.class), megaMorphic, "getMethod");
            MethodHandle getter = link.getInvocation();
            MethodHandle invoker = ScriptFunction.INVOKEHELPER;
            invoker = Lookup.MH.asCollector(invoker, Object[].class, callType.parameterCount() - 1);
            invoker = Lookup.MH.foldArguments(invoker, Lookup.MH.asType(getter, getter.type().changeReturnType(Object.class)));
            return new GuardedInvocation(invoker, link.getSwitchPoint(), link.getGuard());
        }
        Object value = ScriptObject.getObjectValue(find);
        MethodHandle methodHandle = ScriptObject.getCallMethodHandle(value, callType, null);
        if (methodHandle != null) {
            if (find.isScope()) {
                boolean strictCallee = ((ScriptFunction)value).isStrict();
                methodHandle = strictCallee && NashornCallSiteDescriptor.isScope(desc) ? ScriptObject.bindTo(methodHandle, ScriptRuntime.UNDEFINED) : ScriptObject.bindTo(methodHandle, Context.getGlobal());
            }
            MethodHandle guard = find.isSelf() ? Guards.getIdentityGuard((Object)this) : NashornGuards.getMapGuard(this.getMap());
            int invokeFlags = ((ScriptFunction)value).isStrict() ? 2 : 0;
            return new NashornGuardedInvocation(methodHandle, null, guard, invokeFlags);
        }
        ECMAErrors.typeError(Context.getGlobal(), "no.such.function", name, ScriptRuntime.safeToString(this));
        throw new AssertionError((Object)"should not reach here");
    }

    protected GuardedInvocation findGetMethod(CallSiteDescriptor desc, boolean megaMorphic, String operator) {
        String name = desc.getNameToken(2);
        if (megaMorphic) {
            return ScriptObject.findMegaMorphicGetMethod(desc, name);
        }
        FindProperty find = this.findProperty(name, true);
        if (find == null) {
            if ("getProp".equals(operator)) {
                return this.noSuchProperty(desc);
            }
            if ("getMethod".equals(operator)) {
                return this.noSuchMethod(desc);
            }
            if ("getElem".equals(operator)) {
                return this.createEmptyGetter(desc, name);
            }
            throw new AssertionError();
        }
        TypeDescriptor.OfField returnType = desc.getMethodType().returnType();
        Property property = find.getProperty();
        MethodHandle methodHandle = find.getGetter((Class<?>)returnType);
        MethodHandle guard = NashornGuards.getMapGuard(this.getMap());
        int invokeFlags = 0;
        if (methodHandle != null) {
            assert (methodHandle.type().returnType().equals(returnType));
            ScriptFunction getter = find.getGetterFunction();
            int n = invokeFlags = getter != null && getter.isStrict() ? 2 : 0;
            if (find.isSelf()) {
                return new NashornGuardedInvocation(methodHandle, null, (MethodHandle)(ObjectClassGenerator.OBJECT_FIELDS_ONLY && NashornCallSiteDescriptor.isFastScope(desc) && !property.canChangeType() ? null : guard), invokeFlags);
            }
            ScriptObject prototype = find.getOwner();
            if (!property.hasGetterFunction()) {
                methodHandle = ScriptObject.bindTo(methodHandle, prototype);
            }
            return new NashornGuardedInvocation(methodHandle, this.getMap().getProtoGetSwitchPoint(name), guard, invokeFlags);
        }
        assert (!NashornCallSiteDescriptor.isFastScope(desc));
        return new NashornGuardedInvocation(Lookup.emptyGetter(returnType), this.getMap().getProtoGetSwitchPoint(name), guard, invokeFlags);
    }

    private static GuardedInvocation findMegaMorphicGetMethod(CallSiteDescriptor desc, String name) {
        GuardedInvocation inv = ScriptObject.findGetIndexMethod(desc.getMethodType().insertParameterTypes(1, Object.class));
        return inv.replaceMethods(Lookup.MH.insertArguments(inv.getInvocation(), 1, name), inv.getGuard());
    }

    private static GuardedInvocation findGetIndexMethod(CallSiteDescriptor desc) {
        return ScriptObject.findGetIndexMethod(desc.getMethodType());
    }

    private static GuardedInvocation findGetIndexMethod(MethodType callType) {
        TypeDescriptor.OfField returnClass = callType.returnType();
        TypeDescriptor.OfField keyClass = callType.parameterType(1);
        String name = "get";
        if (((Class)returnClass).isPrimitive()) {
            String returnTypeName = ((Class)returnClass).getName();
            name = name + Character.toUpperCase(returnTypeName.charAt(0)) + returnTypeName.substring(1, returnTypeName.length());
        }
        return new GuardedInvocation(ScriptObject.findOwnMH(name, returnClass, new Class[]{keyClass}), ScriptObject.getScriptObjectGuard(callType));
    }

    private static MethodHandle getScriptObjectGuard(MethodType type) {
        return ScriptObject.class.isAssignableFrom((Class<?>)type.parameterType(0)) ? null : NashornGuards.getScriptObjectGuard();
    }

    protected GuardedInvocation findSetMethod(CallSiteDescriptor desc, boolean megaMorphic) {
        Property inherited;
        String name = desc.getNameToken(2);
        if (megaMorphic) {
            return ScriptObject.findMegaMorphicSetMethod(desc, name);
        }
        MethodType callType = desc.getMethodType();
        PropertyMap oldMap = this.getMap();
        TypeDescriptor.OfField type = callType.parameterType(1);
        FindProperty find = this.findProperty(name, true);
        if (!this.isScope() && find != null && find.isInherited() && !((inherited = find.getProperty()) instanceof UserAccessorProperty)) {
            find = null;
            if (this.isExtensible() && !inherited.isWritable()) {
                if (NashornCallSiteDescriptor.isStrict(desc)) {
                    ECMAErrors.typeError(Context.getGlobal(), "property.not.writable", name, ScriptRuntime.safeToString(this));
                }
                assert (!NashornCallSiteDescriptor.isFastScope(desc));
                return new GuardedInvocation(Lookup.EMPTY_SETTER, oldMap.getProtoGetSwitchPoint(name), NashornGuards.getMapGuard(oldMap));
            }
        }
        MethodHandle methodHandle = null;
        Property property = null;
        int invokeFlags = 0;
        if (find != null) {
            if (!find.isWritable()) {
                if (NashornCallSiteDescriptor.isStrict(desc)) {
                    ECMAErrors.typeError(Context.getGlobal(), "property.not.writable", name, ScriptRuntime.safeToString(this));
                }
                return new GuardedInvocation(Lookup.EMPTY_SETTER, oldMap.getProtoGetSwitchPoint(name), NashornGuards.getMapGuard(oldMap));
            }
            property = find.getProperty();
            methodHandle = find.getSetter((Class<?>)type, NashornCallSiteDescriptor.isStrict(desc));
            assert (methodHandle != null);
            assert (property != null);
            ScriptFunction setter = find.getSetterFunction();
            invokeFlags = 0;
            if (setter != null && setter.isStrict()) {
                invokeFlags = 2;
            }
            if (!property.hasSetterFunction() && find.isInherited()) {
                methodHandle = ScriptObject.bindTo(methodHandle, find.getOwner());
            }
        } else if (!this.isExtensible()) {
            if (NashornCallSiteDescriptor.isStrict(desc)) {
                ECMAErrors.typeError(Context.getGlobal(), "object.non.extensible", name, ScriptRuntime.safeToString(this));
            }
            assert (!NashornCallSiteDescriptor.isFastScope(desc));
            return new GuardedInvocation(Lookup.EMPTY_SETTER, oldMap.getProtoGetSwitchPoint(name), NashornGuards.getMapGuard(oldMap));
        }
        if (methodHandle == null) {
            if (NashornCallSiteDescriptor.isScope(desc) && NashornCallSiteDescriptor.isStrict(desc)) {
                ECMAErrors.referenceError(Context.getGlobal(), "not.defined", name);
            }
            if (this.isScope()) {
                ScriptObject global = Context.getGlobal();
                methodHandle = global.addSpill(name);
                methodHandle = ScriptObject.bindTo(methodHandle, global);
            } else {
                int i = this.findEmbed();
                if (i >= 4) {
                    i = oldMap.getSpillLength();
                    MethodHandle getter = Lookup.MH.asType(Lookup.MH.insertArguments(Lookup.MH.arrayElementGetter(Object[].class), 1, i), Lookup.GET_OBJECT_TYPE);
                    MethodHandle setter = Lookup.MH.asType(Lookup.MH.insertArguments(Lookup.MH.arrayElementSetter(Object[].class), 1, i), Lookup.SET_OBJECT_TYPE);
                    property = new SpillProperty(name, 16, i, getter, setter);
                    PropertyMap newMap = oldMap.addProperty(property);
                    i = property.getSlot();
                    if (this.spill == null) {
                        methodHandle = Lookup.MH.insertArguments(SETSPILLWITHNEW, 0, desc, oldMap, newMap, i);
                    } else if (i < this.spill.length) {
                        methodHandle = Lookup.MH.insertArguments(SETSPILL, 0, desc, oldMap, newMap, i);
                    } else {
                        int newLength = (i + 8) / 8 * 8;
                        methodHandle = Lookup.MH.insertArguments(SETSPILLWITHGROW, 0, desc, oldMap, newMap, i, newLength);
                    }
                } else {
                    this.useEmbed(i);
                    property = new SpillProperty(name, 0, i, GET_EMBED[i], SET_EMBED[i]);
                    PropertyMap newMap = oldMap.addProperty(property);
                    methodHandle = Lookup.MH.insertArguments(SETEMBED, 0, desc, oldMap, newMap, property.getSetter(Object.class, this.getMap()), i);
                }
                this.notifyPropertyAdded(this, property);
            }
        }
        return new NashornGuardedInvocation(methodHandle, null, (MethodHandle)(ObjectClassGenerator.OBJECT_FIELDS_ONLY && NashornCallSiteDescriptor.isFastScope(desc) && (property == null || !property.canChangeType()) ? null : NashornGuards.getMapGuard(oldMap)), invokeFlags);
    }

    private static void setEmbed(CallSiteDescriptor desc, PropertyMap oldMap, PropertyMap newMap, MethodHandle setter, int i, Object self, Object value) throws Throwable {
        ScriptObject obj = (ScriptObject)self;
        if (obj.trySetEmbedOrSpill(desc, oldMap, newMap, value)) {
            obj.useEmbed(i);
            setter.invokeExact(self, value);
        }
    }

    private static void setSpill(CallSiteDescriptor desc, PropertyMap oldMap, PropertyMap newMap, int index, Object self, Object value) {
        ScriptObject obj = (ScriptObject)self;
        if (obj.trySetEmbedOrSpill(desc, oldMap, newMap, value)) {
            obj.spill[index] = value;
        }
    }

    private boolean trySetEmbedOrSpill(CallSiteDescriptor desc, PropertyMap oldMap, PropertyMap newMap, Object value) {
        boolean isStrict = NashornCallSiteDescriptor.isStrict(desc);
        if (!this.isExtensible() && isStrict) {
            ECMAErrors.typeError(Context.getGlobal(), "object.non.extensible", desc.getNameToken(2), ScriptRuntime.safeToString(this));
            throw new AssertionError();
        }
        if (this.compareAndSetMap(oldMap, newMap)) {
            return true;
        }
        this.set((Object)desc.getNameToken(2), value, isStrict);
        return false;
    }

    private static void setSpillWithNew(CallSiteDescriptor desc, PropertyMap oldMap, PropertyMap newMap, int index, Object self, Object value) {
        ScriptObject obj = (ScriptObject)self;
        boolean isStrict = NashornCallSiteDescriptor.isStrict(desc);
        if (!obj.isExtensible()) {
            if (isStrict) {
                ECMAErrors.typeError(Context.getGlobal(), "object.non.extensible", desc.getNameToken(2), ScriptRuntime.safeToString(obj));
            }
        } else if (obj.compareAndSetMap(oldMap, newMap)) {
            obj.spill = new Object[8];
            obj.spill[index] = value;
        } else {
            obj.set((Object)desc.getNameToken(2), value, isStrict);
        }
    }

    private static void setSpillWithGrow(CallSiteDescriptor desc, PropertyMap oldMap, PropertyMap newMap, int index, int newLength, Object self, Object value) {
        ScriptObject obj = (ScriptObject)self;
        boolean isStrict = NashornCallSiteDescriptor.isStrict(desc);
        if (!obj.isExtensible()) {
            if (isStrict) {
                ECMAErrors.typeError(Context.getGlobal(), "object.non.extensible", desc.getNameToken(2), ScriptRuntime.safeToString(obj));
            }
        } else if (obj.compareAndSetMap(oldMap, newMap)) {
            int oldLength = obj.spill.length;
            Object[] newSpill = new Object[newLength];
            System.arraycopy(obj.spill, 0, newSpill, 0, oldLength);
            obj.spill = newSpill;
            obj.spill[index] = value;
        } else {
            obj.set((Object)desc.getNameToken(2), value, isStrict);
        }
    }

    private static GuardedInvocation findMegaMorphicSetMethod(CallSiteDescriptor desc, String name) {
        GuardedInvocation inv = ScriptObject.findSetIndexMethod(desc.getMethodType().insertParameterTypes(1, Object.class), NashornCallSiteDescriptor.isStrict(desc));
        return inv.replaceMethods(Lookup.MH.insertArguments(inv.getInvocation(), 1, name), inv.getGuard());
    }

    private static GuardedInvocation findSetIndexMethod(CallSiteDescriptor desc) {
        return ScriptObject.findSetIndexMethod(desc.getMethodType(), NashornCallSiteDescriptor.isStrict(desc));
    }

    private static GuardedInvocation findSetIndexMethod(MethodType callType, boolean isStrict) {
        assert (callType.parameterCount() == 3);
        TypeDescriptor.OfField keyClass = callType.parameterType(1);
        TypeDescriptor.OfField valueClass = callType.parameterType(2);
        MethodHandle methodHandle = ScriptObject.findOwnMH("set", Void.TYPE, new Class[]{keyClass, valueClass, Boolean.TYPE});
        methodHandle = Lookup.MH.asType(methodHandle, methodHandle.type().changeParameterType(0, Object.class));
        methodHandle = Lookup.MH.insertArguments(methodHandle, 3, isStrict);
        return new GuardedInvocation(methodHandle, ScriptObject.getScriptObjectGuard(callType));
    }

    public GuardedInvocation noSuchMethod(CallSiteDescriptor desc) {
        boolean scopeCall;
        String name = desc.getNameToken(2);
        FindProperty find = this.findProperty(NO_SUCH_METHOD_NAME, true);
        boolean bl = scopeCall = this.isScope() && NashornCallSiteDescriptor.isScope(desc);
        if (find == null) {
            if (scopeCall) {
                ECMAErrors.referenceError(Context.getGlobal(), "not.defined", name);
                throw new AssertionError();
            }
            return this.createEmptyGetter(desc, name);
        }
        ScriptFunction func = (ScriptFunction)ScriptObject.getObjectValue(find);
        ScriptObject thiz = scopeCall && func.isStrict() ? ScriptRuntime.UNDEFINED : this;
        return new GuardedInvocation(Lookup.MH.dropArguments(Lookup.MH.constant(ScriptFunction.class, func.makeBoundFunction(thiz, new Object[]{name})), 0, Object.class), null, NashornGuards.getMapGuard(this.getMap()));
    }

    public GuardedInvocation createNoSuchMethodInvocation(CallSiteDescriptor desc) {
        ScriptFunction func;
        MethodHandle methodHandle;
        boolean scopeCall;
        String name = desc.getNameToken(2);
        FindProperty find = this.findProperty(NO_SUCH_METHOD_NAME, true);
        boolean bl = scopeCall = this.isScope() && NashornCallSiteDescriptor.isScope(desc);
        if (find != null && (methodHandle = ScriptObject.getCallMethodHandle(func = (ScriptFunction)ScriptObject.getObjectValue(find), desc.getMethodType(), name)) != null) {
            if (scopeCall && func.isStrict()) {
                methodHandle = ScriptObject.bindTo(methodHandle, ScriptRuntime.UNDEFINED);
            }
            return new GuardedInvocation(methodHandle, find.isInherited() ? this.getMap().getProtoGetSwitchPoint(NO_SUCH_PROPERTY_NAME) : null, ScriptObject.getKnownFunctionPropertyGuard(this.getMap(), find.getGetter(Object.class), find.getOwner(), func));
        }
        if (scopeCall) {
            ECMAErrors.referenceError(Context.getGlobal(), "not.defined", name);
        } else {
            ECMAErrors.typeError(Context.getGlobal(), "no.such.function", name, ScriptRuntime.safeToString(this));
        }
        return null;
    }

    public GuardedInvocation noSuchProperty(CallSiteDescriptor desc) {
        ScriptFunction func;
        MethodHandle methodHandle;
        boolean scopeAccess;
        String name = desc.getNameToken(2);
        FindProperty find = this.findProperty(NO_SUCH_PROPERTY_NAME, true);
        boolean bl = scopeAccess = this.isScope() && NashornCallSiteDescriptor.isScope(desc);
        if (find != null && (methodHandle = ScriptObject.getCallMethodHandle(func = (ScriptFunction)ScriptObject.getObjectValue(find), desc.getMethodType(), name)) != null) {
            if (scopeAccess && func.isStrict()) {
                methodHandle = ScriptObject.bindTo(methodHandle, ScriptRuntime.UNDEFINED);
            }
            return new GuardedInvocation(methodHandle, find.isInherited() ? this.getMap().getProtoGetSwitchPoint(NO_SUCH_PROPERTY_NAME) : null, ScriptObject.getKnownFunctionPropertyGuard(this.getMap(), find.getGetter(Object.class), find.getOwner(), func));
        }
        if (scopeAccess) {
            ECMAErrors.referenceError(Context.getGlobal(), "not.defined", name);
        }
        return this.createEmptyGetter(desc, name);
    }

    private GuardedInvocation createEmptyGetter(CallSiteDescriptor desc, String name) {
        return new GuardedInvocation(Lookup.emptyGetter(desc.getMethodType().returnType()), this.getMap().getProtoGetSwitchPoint(name), NashornGuards.getMapGuard(this.getMap()));
    }

    private Property addSpillProperty(String key, int propertyFlags) {
        Property spillProperty;
        int i = this.findEmbed();
        if (i >= 4) {
            i = this.getMap().getSpillLength();
            MethodHandle getter = Lookup.MH.arrayElementGetter(Object[].class);
            MethodHandle setter = Lookup.MH.arrayElementSetter(Object[].class);
            getter = Lookup.MH.asType(Lookup.MH.insertArguments(getter, 1, i), Lookup.GET_OBJECT_TYPE);
            setter = Lookup.MH.asType(Lookup.MH.insertArguments(setter, 1, i), Lookup.SET_OBJECT_TYPE);
            spillProperty = new SpillProperty(key, propertyFlags | 0x10, i, getter, setter);
            this.notifyPropertyAdded(this, spillProperty);
            spillProperty = this.addOwnProperty(spillProperty);
            i = spillProperty.getSlot();
            int newLength = (i + 8) / 8 * 8;
            Object[] newSpill = new Object[newLength];
            if (this.spill != null) {
                System.arraycopy(this.spill, 0, newSpill, 0, this.spill.length);
            }
            this.spill = newSpill;
        } else {
            this.useEmbed(i);
            spillProperty = new SpillProperty(key, propertyFlags, i, GET_EMBED[i], SET_EMBED[i]);
            this.notifyPropertyAdded(this, spillProperty);
            spillProperty = this.addOwnProperty(spillProperty);
        }
        return spillProperty;
    }

    private MethodHandle addSpill(String key, int propertyFlags) {
        Property spillProperty = this.addSpillProperty(key, propertyFlags);
        Class<Object> type = Object.class;
        return spillProperty.getSetter(type, this.getMap());
    }

    private MethodHandle addSpill(String key) {
        return this.addSpill(key, 0);
    }

    protected static MethodHandle pairArguments(MethodHandle methodHandle, MethodType callType) {
        return ScriptObject.pairArguments(methodHandle, callType, null);
    }

    public static MethodHandle pairArguments(MethodHandle methodHandle, MethodType callType, Boolean callerVarArg) {
        boolean isCallerVarArg;
        boolean isCalleeVarArg;
        MethodType methodType = methodHandle.type();
        if (((Object)methodType).equals(callType)) {
            return methodHandle;
        }
        int parameterCount = methodType.parameterCount();
        int callCount = callType.parameterCount();
        boolean bl = isCalleeVarArg = parameterCount > 1 && ((Class)methodType.parameterType(parameterCount - 1)).isArray();
        boolean bl2 = callerVarArg != null ? callerVarArg : (isCallerVarArg = callCount > 1 && ((Class)callType.parameterType(callCount - 1)).isArray());
        if (callCount < parameterCount) {
            int missingArgs = parameterCount - callCount;
            Object[] fillers = new Object[missingArgs];
            Arrays.fill(fillers, ScriptRuntime.UNDEFINED);
            if (isCalleeVarArg) {
                fillers[missingArgs - 1] = new Object[0];
            }
            return Lookup.MH.insertArguments(methodHandle, parameterCount - missingArgs, fillers);
        }
        if (isCalleeVarArg) {
            return isCallerVarArg ? methodHandle : Lookup.MH.asCollector(methodHandle, Object[].class, callCount - parameterCount + 1);
        }
        if (isCallerVarArg) {
            int spreadArgs = parameterCount - callCount + 1;
            return Lookup.MH.filterArguments(Lookup.MH.asSpreader(methodHandle, Object[].class, spreadArgs), callCount - 1, Lookup.MH.insertArguments(TRUNCATINGFILTER, 0, spreadArgs));
        }
        if (callCount > parameterCount) {
            int discardedArgs = callCount - parameterCount;
            Object[] discards = new Class[discardedArgs];
            Arrays.fill(discards, Object.class);
            return Lookup.MH.dropArguments(methodHandle, callCount - discardedArgs, (Class<?>[])discards);
        }
        return methodHandle;
    }

    private static Object[] truncatingFilter(int n, Object[] array) {
        int length;
        int n2 = length = array == null ? 0 : array.length;
        if (n == length) {
            return array == null ? new Object[]{} : array;
        }
        Object[] newArray = new Object[n];
        if (array != null) {
            for (int i = 0; i < n && i < length; ++i) {
                newArray[i] = array[i];
            }
        }
        if (length < n) {
            Undefined fill = ScriptRuntime.UNDEFINED;
            for (int i = length; i < n; ++i) {
                newArray[i] = fill;
            }
        }
        return newArray;
    }

    public final void setLength(long newLength) {
        long arrayLength = this.getArray().length();
        if (newLength == arrayLength) {
            return;
        }
        boolean isStrict = this.getContext()._strict;
        if (newLength > arrayLength) {
            this.setArray(this.getArray().ensure(newLength - 1L));
            if (this.getArray().canDelete(arrayLength, newLength - 1L, isStrict)) {
                this.setArray(this.getArray().delete(arrayLength, newLength - 1L));
            }
            return;
        }
        if (newLength < arrayLength) {
            this.setArray(this.getArray().shrink(newLength));
            this.getArray().setLength(newLength);
        }
    }

    @Override
    public int getInt(Object key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (this.getArray().has(index)) {
            return this.getArray().getInt(index);
        }
        FindProperty find = this.findProperty(ScriptObject.convertKey(key), false);
        if (find != null) {
            return ScriptObject.getIntValue(find);
        }
        ScriptObject proto = this.getProto();
        return proto != null ? proto.getInt(key) : 0;
    }

    @Override
    public int getInt(double key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (this.getArray().has(index)) {
            return this.getArray().getInt(index);
        }
        FindProperty find = this.findProperty(ScriptObject.convertKey(key), false);
        if (find != null) {
            return ScriptObject.getIntValue(find);
        }
        ScriptObject proto = this.getProto();
        return proto != null ? proto.getInt(key) : 0;
    }

    @Override
    public int getInt(long key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (this.getArray().has(index)) {
            return this.getArray().getInt(index);
        }
        FindProperty find = this.findProperty(ScriptObject.convertKey(key), false);
        if (find != null) {
            return ScriptObject.getIntValue(find);
        }
        ScriptObject proto = this.getProto();
        return proto != null ? proto.getInt(key) : 0;
    }

    @Override
    public int getInt(int key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (this.getArray().has(index)) {
            return this.getArray().getInt(index);
        }
        FindProperty find = this.findProperty(ScriptObject.convertKey(key), false);
        if (find != null) {
            return ScriptObject.getIntValue(find);
        }
        ScriptObject proto = this.getProto();
        return proto != null ? proto.getInt(key) : 0;
    }

    @Override
    public long getLong(Object key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (this.getArray().has(index)) {
            return this.getArray().getLong(index);
        }
        FindProperty find = this.findProperty(ScriptObject.convertKey(key), false);
        if (find != null) {
            return ScriptObject.getLongValue(find);
        }
        ScriptObject proto = this.getProto();
        return proto != null ? proto.getLong(key) : 0L;
    }

    @Override
    public long getLong(double key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (this.getArray().has(index)) {
            return this.getArray().getLong(index);
        }
        FindProperty find = this.findProperty(ScriptObject.convertKey(key), false);
        if (find != null) {
            return ScriptObject.getLongValue(find);
        }
        ScriptObject proto = this.getProto();
        return proto != null ? proto.getLong(key) : 0L;
    }

    @Override
    public long getLong(long key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (this.getArray().has(index)) {
            return this.getArray().getLong(index);
        }
        FindProperty find = this.findProperty(ScriptObject.convertKey(key), false);
        if (find != null) {
            return ScriptObject.getLongValue(find);
        }
        ScriptObject proto = this.getProto();
        return proto != null ? proto.getLong(key) : 0L;
    }

    @Override
    public long getLong(int key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (this.getArray().has(index)) {
            return this.getArray().getLong(index);
        }
        FindProperty find = this.findProperty(ScriptObject.convertKey(key), false);
        if (find != null) {
            return ScriptObject.getLongValue(find);
        }
        ScriptObject proto = this.getProto();
        return proto != null ? proto.getLong(key) : 0L;
    }

    @Override
    public double getDouble(Object key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (this.getArray().has(index)) {
            return this.getArray().getDouble(index);
        }
        FindProperty find = this.findProperty(ScriptObject.convertKey(key), false);
        if (find != null) {
            return ScriptObject.getDoubleValue(find);
        }
        ScriptObject proto = this.getProto();
        return proto != null ? proto.getDouble(key) : Double.NaN;
    }

    @Override
    public double getDouble(double key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (this.getArray().has(index)) {
            return this.getArray().getDouble(index);
        }
        FindProperty find = this.findProperty(ScriptObject.convertKey(key), false);
        if (find != null) {
            return ScriptObject.getDoubleValue(find);
        }
        ScriptObject proto = this.getProto();
        return proto != null ? proto.getDouble(key) : Double.NaN;
    }

    @Override
    public double getDouble(long key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (this.getArray().has(index)) {
            return this.getArray().getDouble(index);
        }
        FindProperty find = this.findProperty(ScriptObject.convertKey(key), false);
        if (find != null) {
            return ScriptObject.getDoubleValue(find);
        }
        ScriptObject proto = this.getProto();
        return proto != null ? proto.getDouble(key) : Double.NaN;
    }

    @Override
    public double getDouble(int key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (this.getArray().has(index)) {
            return this.getArray().getDouble(index);
        }
        FindProperty find = this.findProperty(ScriptObject.convertKey(key), false);
        if (find != null) {
            return ScriptObject.getDoubleValue(find);
        }
        ScriptObject proto = this.getProto();
        return proto != null ? proto.getDouble(key) : Double.NaN;
    }

    @Override
    public Object get(Object key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (this.getArray().has(index)) {
            return this.getArray().getObject(index);
        }
        FindProperty find = this.findProperty(ScriptObject.convertKey(key), false);
        if (find != null) {
            return ScriptObject.getObjectValue(find);
        }
        ScriptObject proto = this.getProto();
        return proto != null ? proto.get(key) : ScriptRuntime.UNDEFINED;
    }

    @Override
    public Object get(double key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (this.getArray().has(index)) {
            return this.getArray().getObject(index);
        }
        FindProperty find = this.findProperty(ScriptObject.convertKey(key), false);
        if (find != null) {
            return ScriptObject.getObjectValue(find);
        }
        ScriptObject proto = this.getProto();
        return proto != null ? proto.get(key) : ScriptRuntime.UNDEFINED;
    }

    @Override
    public Object get(long key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (this.getArray().has(index)) {
            return this.getArray().getObject(index);
        }
        FindProperty find = this.findProperty(ScriptObject.convertKey(key), false);
        if (find != null) {
            return ScriptObject.getObjectValue(find);
        }
        ScriptObject proto = this.getProto();
        return proto != null ? proto.get(key) : ScriptRuntime.UNDEFINED;
    }

    @Override
    public Object get(int key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (this.getArray().has(index)) {
            return this.getArray().getObject(index);
        }
        FindProperty find = this.findProperty(ScriptObject.convertKey(key), false);
        if (find != null) {
            return ScriptObject.getObjectValue(find);
        }
        ScriptObject proto = this.getProto();
        return proto != null ? proto.get(key) : ScriptRuntime.UNDEFINED;
    }

    private void doesNotHave(int index, Object value, boolean strict) {
        String key;
        FindProperty find;
        long oldLength = this.getArray().length();
        long longIndex = (long)index & 0xFFFFFFFFL;
        if (!this.getArray().has(index) && (find = this.findProperty(key = ScriptObject.convertKey(longIndex), true)) != null) {
            this.setObject(find, strict, key, value);
            return;
        }
        if (longIndex >= oldLength) {
            if (!this.isExtensible()) {
                if (strict) {
                    ECMAErrors.typeError(Context.getGlobal(), "object.non.extensible", JSType.toString(index), ScriptRuntime.safeToString(this));
                }
                return;
            }
            this.setArray(this.getArray().ensure(longIndex));
        }
        if (value instanceof Integer) {
            this.setArray(this.getArray().set(index, (Integer)value, strict));
        } else if (value instanceof Long) {
            this.setArray(this.getArray().set(index, (Long)value, strict));
        } else if (value instanceof Double) {
            this.setArray(this.getArray().set(index, (Double)value, strict));
        } else {
            this.setArray(this.getArray().set(index, value, strict));
        }
        if (longIndex > oldLength) {
            ArrayData array = this.getArray();
            if (array.canDelete(oldLength, longIndex - 1L, strict)) {
                array = array.delete(oldLength, longIndex - 1L);
            }
            this.setArray(array);
        }
    }

    public final void setObject(FindProperty find, boolean strict, String key, Object value) {
        FindProperty f = find;
        if (f != null && f.isInherited() && !(f.getProperty() instanceof UserAccessorProperty)) {
            f = null;
        }
        if (f != null) {
            if (!f.isWritable()) {
                if (strict) {
                    ECMAErrors.typeError(Context.getGlobal(), "property.not.writable", key, ScriptRuntime.safeToString(this));
                }
                return;
            }
            MethodHandle setter = f.getSetter(Object.class, strict);
            try {
                setter.invokeExact(f.getOwner(), value);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        } else if (!this.isExtensible()) {
            if (strict) {
                ECMAErrors.typeError(Context.getGlobal(), "object.non.extensible", key, ScriptRuntime.safeToString(this));
            }
        } else {
            this.spill(key, value);
        }
    }

    private void spill(String key, Object value) {
        try {
            this.addSpill(key).invokeExact(this, value);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void set(Object key, int value, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index)) {
            if (this.getArray().has(index)) {
                this.setArray(this.getArray().set(index, value, strict));
            } else {
                this.doesNotHave(index, value, strict);
            }
            return;
        }
        this.set(key, JSType.toObject(value), strict);
    }

    @Override
    public void set(Object key, long value, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index)) {
            if (this.getArray().has(index)) {
                this.setArray(this.getArray().set(index, value, strict));
            } else {
                this.doesNotHave(index, value, strict);
            }
            return;
        }
        this.set(key, JSType.toObject(value), strict);
    }

    @Override
    public void set(Object key, double value, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index)) {
            if (this.getArray().has(index)) {
                this.setArray(this.getArray().set(index, value, strict));
            } else {
                this.doesNotHave(index, value, strict);
            }
            return;
        }
        this.set(key, JSType.toObject(value), strict);
    }

    @Override
    public void set(Object key, Object value, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index)) {
            if (this.getArray().has(index)) {
                this.setArray(this.getArray().set(index, value, strict));
            } else {
                this.doesNotHave(index, value, strict);
            }
            return;
        }
        String propName = ScriptObject.convertKey(key);
        FindProperty find = this.findProperty(propName, true);
        this.setObject(find, strict, propName, value);
    }

    @Override
    public void set(double key, int value, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index)) {
            if (this.getArray().has(index)) {
                this.setArray(this.getArray().set(index, value, strict));
            } else {
                this.doesNotHave(index, value, strict);
            }
            return;
        }
        this.set(JSType.toObject(key), JSType.toObject(value), strict);
    }

    @Override
    public void set(double key, long value, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index)) {
            if (this.getArray().has(index)) {
                this.setArray(this.getArray().set(index, value, strict));
            } else {
                this.doesNotHave(index, value, strict);
            }
            return;
        }
        this.set(JSType.toObject(key), JSType.toObject(value), strict);
    }

    @Override
    public void set(double key, double value, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index)) {
            if (this.getArray().has(index)) {
                this.setArray(this.getArray().set(index, value, strict));
            } else {
                this.doesNotHave(index, value, strict);
            }
            return;
        }
        this.set(JSType.toObject(key), JSType.toObject(value), strict);
    }

    @Override
    public void set(double key, Object value, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index)) {
            if (this.getArray().has(index)) {
                this.setArray(this.getArray().set(index, value, strict));
            } else {
                this.doesNotHave(index, value, strict);
            }
            return;
        }
        this.set(JSType.toObject(key), value, strict);
    }

    @Override
    public void set(long key, int value, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index)) {
            if (this.getArray().has(index)) {
                this.setArray(this.getArray().set(index, value, strict));
            } else {
                this.doesNotHave(index, value, strict);
            }
            return;
        }
        this.set(JSType.toObject(key), JSType.toObject(value), strict);
    }

    @Override
    public void set(long key, long value, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index)) {
            if (this.getArray().has(index)) {
                this.setArray(this.getArray().set(index, value, strict));
            } else {
                this.doesNotHave(index, value, strict);
            }
            return;
        }
        this.set(JSType.toObject(key), JSType.toObject(value), strict);
    }

    @Override
    public void set(long key, double value, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index)) {
            if (this.getArray().has(index)) {
                this.setArray(this.getArray().set(index, value, strict));
            } else {
                this.doesNotHave(index, value, strict);
            }
            return;
        }
        this.set(JSType.toObject(key), JSType.toObject(value), strict);
    }

    @Override
    public void set(long key, Object value, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index)) {
            if (this.getArray().has(index)) {
                this.setArray(this.getArray().set(index, value, strict));
            } else {
                this.doesNotHave(index, value, strict);
            }
            return;
        }
        this.set(JSType.toObject(key), value, strict);
    }

    @Override
    public void set(int key, int value, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index)) {
            if (this.getArray().has(index)) {
                this.setArray(this.getArray().set(index, value, strict));
            } else {
                this.doesNotHave(index, value, strict);
            }
            return;
        }
        this.set(JSType.toObject(key), JSType.toObject(value), strict);
    }

    @Override
    public void set(int key, long value, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index)) {
            if (this.getArray().has(index)) {
                this.setArray(this.getArray().set(index, value, strict));
            } else {
                this.doesNotHave(index, value, strict);
            }
            return;
        }
        this.set(JSType.toObject(key), JSType.toObject(value), strict);
    }

    @Override
    public void set(int key, double value, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index)) {
            if (this.getArray().has(index)) {
                this.setArray(this.getArray().set(index, value, strict));
            } else {
                this.doesNotHave(index, value, strict);
            }
            return;
        }
        this.set(JSType.toObject(key), JSType.toObject(value), strict);
    }

    @Override
    public void set(int key, Object value, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index)) {
            if (this.getArray().has(index)) {
                this.setArray(this.getArray().set(index, value, strict));
            } else {
                this.doesNotHave(index, value, strict);
            }
            return;
        }
        this.set(JSType.toObject(key), value, strict);
    }

    @Override
    public boolean has(Object key) {
        FindProperty find;
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index)) {
            for (ScriptObject self = this; self != null; self = self.getProto()) {
                if (!self.getArray().has(index)) continue;
                return true;
            }
        }
        return (find = this.findProperty(ScriptObject.convertKey(key), true)) != null;
    }

    @Override
    public boolean has(double key) {
        FindProperty find;
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index)) {
            for (ScriptObject self = this; self != null; self = self.getProto()) {
                if (!self.getArray().has(index)) continue;
                return true;
            }
        }
        return (find = this.findProperty(ScriptObject.convertKey(key), true)) != null;
    }

    @Override
    public boolean has(long key) {
        FindProperty find;
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index)) {
            for (ScriptObject self = this; self != null; self = self.getProto()) {
                if (!self.getArray().has(index)) continue;
                return true;
            }
        }
        return (find = this.findProperty(ScriptObject.convertKey(key), true)) != null;
    }

    @Override
    public boolean has(int key) {
        FindProperty find;
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (ArrayIndex.isValidArrayIndex(index)) {
            for (ScriptObject self = this; self != null; self = self.getProto()) {
                if (!self.getArray().has(index)) continue;
                return true;
            }
        }
        return (find = this.findProperty(ScriptObject.convertKey(key), true)) != null;
    }

    @Override
    public boolean hasOwnProperty(Object key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (this.getArray().has(index)) {
            return true;
        }
        FindProperty find = this.findProperty(ScriptObject.convertKey(key), false);
        return find != null;
    }

    @Override
    public boolean hasOwnProperty(int key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (this.getArray().has(index)) {
            return true;
        }
        FindProperty find = this.findProperty(ScriptObject.convertKey(key), false);
        return find != null;
    }

    @Override
    public boolean hasOwnProperty(long key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (this.getArray().has(index)) {
            return true;
        }
        FindProperty find = this.findProperty(ScriptObject.convertKey(key), false);
        return find != null;
    }

    @Override
    public boolean hasOwnProperty(double key) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        if (this.getArray().has(index)) {
            return true;
        }
        FindProperty find = this.findProperty(ScriptObject.convertKey(key), false);
        return find != null;
    }

    @Override
    public boolean delete(int key, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        ArrayData array = this.getArray();
        if (array.has(index)) {
            if (array.canDelete(index, strict)) {
                this.setArray(array.delete(index));
                return true;
            }
            return false;
        }
        return this.deleteObject(JSType.toObject(key), strict);
    }

    @Override
    public boolean delete(long key, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        ArrayData array = this.getArray();
        if (array.has(index)) {
            if (array.canDelete(index, strict)) {
                this.setArray(array.delete(index));
                return true;
            }
            return false;
        }
        return this.deleteObject(JSType.toObject(key), strict);
    }

    @Override
    public boolean delete(double key, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        ArrayData array = this.getArray();
        if (array.has(index)) {
            if (array.canDelete(index, strict)) {
                this.setArray(array.delete(index));
                return true;
            }
            return false;
        }
        return this.deleteObject(JSType.toObject(key), strict);
    }

    @Override
    public boolean delete(Object key, boolean strict) {
        int index = ArrayIndex.getArrayIndexNoThrow(key);
        ArrayData array = this.getArray();
        if (array.has(index)) {
            if (array.canDelete(index, strict)) {
                this.setArray(array.delete(index));
                return true;
            }
            return false;
        }
        return this.deleteObject(key, strict);
    }

    private boolean deleteObject(Object key, boolean strict) {
        String propName = ScriptObject.convertKey(key);
        FindProperty find = this.findProperty(propName, false);
        if (find == null) {
            return true;
        }
        if (!find.isConfigurable()) {
            if (strict) {
                ECMAErrors.typeError(Context.getGlobal(), "cant.delete.property", propName, ScriptRuntime.safeToString(this));
            }
            return false;
        }
        Property prop = find.getProperty();
        this.notifyPropertyDeleted(this, prop);
        this.deleteOwnProperty(prop);
        return true;
    }

    private void useEmbed(int i) {
        this.flags |= 1 << 28 + i;
    }

    private int findEmbed() {
        int bits = ~(this.flags >>> 28);
        int least = bits ^ -bits;
        int index = Integer.numberOfTrailingZeros(least) - 1;
        return index;
    }

    private UserAccessorProperty newUserAccessors(String key, int propertyFlags, ScriptFunction getter, ScriptFunction setter) {
        int setterSlot;
        int oldSpillLength = this.getMap().getSpillLength();
        int getterSlot = this.findEmbed();
        if (getterSlot >= 4) {
            getterSlot = oldSpillLength + 4;
            ++oldSpillLength;
        } else {
            this.useEmbed(getterSlot);
        }
        this.setEmbedOrSpill(getterSlot, getter);
        if (getter == null) {
            getterSlot = -getterSlot - 1;
        }
        if ((setterSlot = this.findEmbed()) >= 4) {
            setterSlot = oldSpillLength + 4;
        } else {
            this.useEmbed(setterSlot);
        }
        this.setEmbedOrSpill(setterSlot, setter);
        if (setter == null) {
            setterSlot = -setterSlot - 1;
        }
        return new UserAccessorProperty(key, propertyFlags, getterSlot, setterSlot);
    }

    private void setEmbedOrSpill(int slot, Object value) {
        switch (slot) {
            case 0: {
                this.embed0 = value;
                break;
            }
            case 1: {
                this.embed1 = value;
                break;
            }
            case 2: {
                this.embed2 = value;
                break;
            }
            case 3: {
                this.embed3 = value;
                break;
            }
            default: {
                if (slot < 0) break;
                int index = slot - 4;
                if (this.spill == null) {
                    this.spill = new Object[Math.max(index + 1, 8)];
                } else if (index >= this.spill.length) {
                    Object[] newSpill = new Object[index + 1];
                    System.arraycopy(this.spill, 0, newSpill, 0, this.spill.length);
                    this.spill = newSpill;
                }
                this.spill[index] = value;
            }
        }
    }

    Object getEmbedOrSpill(int slot) {
        switch (slot) {
            case 0: {
                return this.embed0;
            }
            case 1: {
                return this.embed1;
            }
            case 2: {
                return this.embed2;
            }
            case 3: {
                return this.embed3;
            }
        }
        int index = slot - 4;
        return index < 0 || index >= this.spill.length ? null : this.spill[index];
    }

    private static Object userAccessorGetter(ScriptObject proto, int slot, Object self) {
        ScriptObject container = proto != null ? proto : (ScriptObject)self;
        Object func = container.getEmbedOrSpill(slot);
        if (func instanceof ScriptFunction) {
            try {
                return INVOKE_UA_GETTER.invokeExact(func, self);
            }
            catch (RuntimeException t) {
                throw t;
            }
            catch (Error t) {
                throw t;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return ScriptRuntime.UNDEFINED;
    }

    private static void userAccessorSetter(ScriptObject proto, int slot, String name, Object self, Object value) {
        ScriptObject container = proto != null ? proto : (ScriptObject)self;
        Object func = container.getEmbedOrSpill(slot);
        if (func instanceof ScriptFunction) {
            try {
                INVOKE_UA_SETTER.invokeExact(func, self, value);
            }
            catch (RuntimeException t) {
                throw t;
            }
            catch (Error t) {
                throw t;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        } else if (name != null) {
            ECMAErrors.typeError(Context.getGlobal(), "property.has.no.setter", name, ScriptRuntime.safeToString(self));
        }
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        Class<ScriptObject> own = ScriptObject.class;
        MethodType mt = Lookup.MH.type(rtype, types);
        try {
            return Lookup.MH.findStatic(MethodHandles.lookup(), own, name, mt);
        }
        catch (MethodHandleFactory.LookupException e) {
            return Lookup.MH.findVirtual(MethodHandles.lookup(), own, name, mt);
        }
    }

    private static MethodHandle getKnownFunctionPropertyGuard(PropertyMap map, MethodHandle getter, Object where, ScriptFunction func) {
        return Lookup.MH.insertArguments(KNOWNFUNCPROPGUARD, 1, map, getter, where, func);
    }

    private static boolean knownFunctionPropertyGuard(Object self, PropertyMap map, MethodHandle getter, Object where, ScriptFunction func) {
        if (self instanceof ScriptObject && ((ScriptObject)self).getMap() == map) {
            try {
                return getter.invokeExact(where) == func;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return false;
    }

    public static int getCount() {
        return count;
    }

    public static int getScopeCount() {
        return scopeCount;
    }

    static {
        for (int i = 0; i < 4; ++i) {
            String name = "embed" + i;
            ScriptObject.GET_EMBED[i] = Lookup.MH.asType(Lookup.MH.getter(MethodHandles.lookup(), ScriptObject.class, name, Object.class), Lookup.GET_OBJECT_TYPE);
            ScriptObject.SET_EMBED[i] = Lookup.MH.asType(Lookup.MH.setter(MethodHandles.lookup(), ScriptObject.class, name, Object.class), Lookup.SET_OBJECT_TYPE);
        }
    }

    private static class ValueIterator
    extends ScriptObjectIterator<Object> {
        ValueIterator(ScriptObject object) {
            super(object);
        }

        @Override
        protected void init() {
            ArrayList<Object> valueList = new ArrayList<Object>();
            for (ScriptObject self = this.object; self != null; self = self.getProto()) {
                for (String key : self.getOwnKeys(false)) {
                    valueList.add(self.get(key));
                }
            }
            this.values = valueList.toArray(new Object[valueList.size()]);
        }
    }

    private static class KeyIterator
    extends ScriptObjectIterator<String> {
        KeyIterator(ScriptObject object) {
            super(object);
        }

        @Override
        protected void init() {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (ScriptObject self = this.object; self != null; self = self.getProto()) {
                keys.addAll(Arrays.asList(self.getOwnKeys(false)));
            }
            this.values = keys.toArray(new String[keys.size()]);
        }
    }

    private static abstract class ScriptObjectIterator<T>
    implements Iterator<T> {
        protected T[] values;
        protected final ScriptObject object;
        private int index;

        ScriptObjectIterator(ScriptObject object) {
            this.object = object;
        }

        protected abstract void init();

        @Override
        public boolean hasNext() {
            if (this.values == null) {
                this.init();
            }
            return this.index < this.values.length;
        }

        @Override
        public T next() {
            if (this.values == null) {
                this.init();
            }
            return this.values[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

