/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.linker.MethodHandleFactory;
import jdk.nashorn.internal.runtime.linker.NashornCallSiteDescriptor;
import jdk.nashorn.internal.runtime.linker.NashornGuards;
import jdk.nashorn.internal.runtime.options.Options;
import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.linker.GuardedInvocation;

public abstract class ScriptFunction
extends ScriptObject {
    public static final MethodHandle G$PROTOTYPE = ScriptFunction.findOwnMH("G$prototype", Object.class, Object.class);
    public static final MethodHandle S$PROTOTYPE = ScriptFunction.findOwnMH("S$prototype", Void.TYPE, Object.class, Object.class);
    public static final MethodHandle G$LENGTH = ScriptFunction.findOwnMH("G$length", Integer.TYPE, Object.class);
    public static final MethodHandle G$NAME = ScriptFunction.findOwnMH("G$name", Object.class, Object.class);
    public static final MethodHandle INVOKEHELPER = ScriptFunction.findOwnMH("invokeHelper", Object.class, Object.class, Object.class, Object[].class);
    public static final MethodHandle ALLOCATE = ScriptFunction.findOwnMH("allocate", Object.class, new Class[0]);
    private static final MethodHandle NEWFILTER = ScriptFunction.findOwnMH("newFilter", Object.class, Object.class, Object.class);
    public static final CompilerConstants.Call SET_ARITY = CompilerConstants.virtualCallNoLookup(ScriptFunction.class, "setArity", Void.TYPE, Integer.TYPE);
    public static final CompilerConstants.Call GET_SCOPE = CompilerConstants.virtualCallNoLookup(ScriptFunction.class, "getScope", ScriptObject.class, new Class[0]);
    private static final boolean DISABLE_SPECIALIZATION = Options.getBooleanProperty("nashorn.scriptfunction.specialization.disable");
    private final String name;
    private final Source source;
    private final long token;
    private final MethodHandle invokeHandle;
    protected MethodHandle constructHandle;
    protected Object prototype;
    private MethodHandle allocator;
    private PropertyMap allocatorMap;
    private final ScriptObject scope;
    private MethodHandle[] invokeSpecializations;
    private MethodHandle[] constructSpecializations;
    private int arity;
    private static int constructorCount;
    private static int invokes;
    private static int allocations;

    protected ScriptFunction(String name, MethodHandle methodHandle, PropertyMap map, ScriptObject scope, MethodHandle[] specs) {
        this(name, methodHandle, map, scope, null, 0L, false, specs);
    }

    protected ScriptFunction(String name, MethodHandle methodHandle, PropertyMap map, ScriptObject scope, Source source, long token, MethodHandle allocator, PropertyMap allocatorMap, boolean needsCallee, MethodHandle[] specs) {
        this(name, methodHandle, map, scope, source, token, needsCallee, specs);
        this.allocator = allocator;
        this.allocatorMap = allocatorMap;
    }

    protected ScriptFunction(String name, MethodHandle methodHandle, PropertyMap map, ScriptObject scope, Source source, long token, boolean needsCallee, MethodHandle[] specs) {
        super(map);
        if (Context.DEBUG) {
            ++constructorCount;
        }
        assert (!needsCallee || scope != null);
        this.name = name;
        this.source = source;
        this.token = token;
        this.scope = scope;
        MethodType type = methodHandle.type();
        int paramCount = type.parameterCount();
        boolean isVarArg = ((Class)type.parameterType(paramCount - 1)).isArray();
        MethodHandle mh = Lookup.MH.asType(methodHandle, ScriptFunction.adaptType(type, scope != null, isVarArg));
        int n = this.arity = isVarArg ? -1 : paramCount - 1;
        if (scope != null) {
            if (needsCallee && !isVarArg) {
                --this.arity;
            }
            this.invokeHandle = mh;
            this.constructHandle = mh;
        } else if (ScriptFunction.isConstructor(mh)) {
            if (!isVarArg) {
                --this.arity;
            }
            this.invokeHandle = Lookup.MH.insertArguments(mh, 0, false);
            this.constructHandle = Lookup.MH.insertArguments(mh, 0, true);
            if (specs != null) {
                this.invokeSpecializations = new MethodHandle[specs.length];
                this.constructSpecializations = new MethodHandle[specs.length];
                for (int i = 0; i < specs.length; ++i) {
                    this.invokeSpecializations[i] = Lookup.MH.insertArguments(specs[i], 0, false);
                    this.constructSpecializations[i] = Lookup.MH.insertArguments(specs[i], 0, true);
                }
            }
        } else {
            this.invokeHandle = mh;
            this.constructHandle = mh;
            this.invokeSpecializations = specs;
            this.constructSpecializations = specs;
        }
    }

    private static MethodType adaptType(MethodType type, boolean hasCallee, boolean isVarArg) {
        boolean hasBoolean;
        MethodType newType = type.generic().changeReturnType(Object.class);
        if (isVarArg) {
            newType = newType.changeParameterType(type.parameterCount() - 1, Object[].class);
        }
        boolean bl = hasBoolean = type.parameterType(0) == Boolean.TYPE;
        if (hasBoolean) {
            newType = newType.changeParameterType(0, Boolean.TYPE);
        }
        if (hasCallee) {
            newType = newType.changeParameterType(hasBoolean ? 2 : 1, ScriptFunction.class);
        }
        return newType;
    }

    @Override
    public String getClassName() {
        return "Function";
    }

    @Override
    public boolean isInstance(ScriptObject instance) {
        if (!(this.prototype instanceof ScriptObject)) {
            ECMAErrors.typeError(Context.getGlobal(), "prototype.not.an.object", ScriptRuntime.safeToString(this), ScriptRuntime.safeToString(this.prototype));
        }
        for (ScriptObject proto = instance.getProto(); proto != null; proto = proto.getProto()) {
            if (proto != this.prototype) continue;
            return true;
        }
        return false;
    }

    public final int getArity() {
        return this.arity;
    }

    public final void setArity(int arity) {
        this.arity = arity;
    }

    public abstract boolean isStrict();

    public abstract boolean isBuiltin();

    public Object invoke(Object self, Object ... arguments) throws Throwable {
        Object[] args;
        if (Context.DEBUG) {
            ++invokes;
        }
        Object[] objectArray = args = arguments == null ? ScriptRuntime.EMPTY_ARRAY : arguments;
        if (this.isVarArg(this.invokeHandle)) {
            if (this.hasCalleeParameter()) {
                return this.invokeHandle.invokeExact(self, this, args);
            }
            return this.invokeHandle.invokeExact(self, args);
        }
        int paramCount = this.invokeHandle.type().parameterCount();
        if (this.hasCalleeParameter()) {
            switch (paramCount) {
                case 2: {
                    return this.invokeHandle.invokeExact(self, this);
                }
                case 3: {
                    return this.invokeHandle.invokeExact(self, this, ScriptFunction.getArg(args, 0));
                }
                case 4: {
                    return this.invokeHandle.invokeExact(self, this, ScriptFunction.getArg(args, 0), ScriptFunction.getArg(args, 1));
                }
                case 5: {
                    return this.invokeHandle.invokeExact(self, this, ScriptFunction.getArg(args, 0), ScriptFunction.getArg(args, 1), ScriptFunction.getArg(args, 2));
                }
            }
            return this.invokeHandle.invokeWithArguments(ScriptFunction.withArguments(self, this, paramCount, args));
        }
        switch (paramCount) {
            case 1: {
                return this.invokeHandle.invokeExact(self);
            }
            case 2: {
                return this.invokeHandle.invokeExact(self, ScriptFunction.getArg(args, 0));
            }
            case 3: {
                return this.invokeHandle.invokeExact(self, ScriptFunction.getArg(args, 0), ScriptFunction.getArg(args, 1));
            }
            case 4: {
                return this.invokeHandle.invokeExact(self, ScriptFunction.getArg(args, 0), ScriptFunction.getArg(args, 1), ScriptFunction.getArg(args, 2));
            }
        }
        return this.invokeHandle.invokeWithArguments(ScriptFunction.withArguments(self, null, paramCount, args));
    }

    private static Object getArg(Object[] args, int i) {
        return i < args.length ? args[i] : ScriptRuntime.UNDEFINED;
    }

    public static Object invokeHelper(Object func, Object self, Object ... args) throws Throwable {
        if (func instanceof ScriptFunction) {
            return ((ScriptFunction)func).invoke(self, args);
        }
        ECMAErrors.typeError(Context.getGlobal(), "not.a.function", ScriptRuntime.safeToString(func));
        return ScriptRuntime.UNDEFINED;
    }

    public Object construct(Object self, Object ... args) throws Throwable {
        if (this.constructHandle == null) {
            ECMAErrors.typeError(Context.getGlobal(), "not.a.constructor", ScriptRuntime.safeToString(this));
        }
        if (this.isVarArg(this.constructHandle)) {
            if (this.hasCalleeParameter()) {
                return this.constructHandle.invokeExact(self, this, args);
            }
            return this.constructHandle.invokeExact(self, args);
        }
        int paramCount = this.constructHandle.type().parameterCount();
        if (this.hasCalleeParameter()) {
            switch (paramCount) {
                case 2: {
                    return this.constructHandle.invokeExact(self, this);
                }
                case 3: {
                    return this.constructHandle.invokeExact(self, this, ScriptFunction.getArg(args, 0));
                }
                case 4: {
                    return this.constructHandle.invokeExact(self, this, ScriptFunction.getArg(args, 0), ScriptFunction.getArg(args, 1));
                }
                case 5: {
                    return this.constructHandle.invokeExact(self, this, ScriptFunction.getArg(args, 0), ScriptFunction.getArg(args, 1), ScriptFunction.getArg(args, 2));
                }
            }
            return this.constructHandle.invokeWithArguments(ScriptFunction.withArguments(self, this, args));
        }
        switch (paramCount) {
            case 1: {
                return this.constructHandle.invokeExact(self);
            }
            case 2: {
                return this.constructHandle.invokeExact(self, ScriptFunction.getArg(args, 0));
            }
            case 3: {
                return this.constructHandle.invokeExact(self, ScriptFunction.getArg(args, 0), ScriptFunction.getArg(args, 1));
            }
            case 4: {
                return this.constructHandle.invokeExact(self, ScriptFunction.getArg(args, 0), ScriptFunction.getArg(args, 1), ScriptFunction.getArg(args, 2));
            }
        }
        return this.constructHandle.invokeWithArguments(ScriptFunction.withArguments(self, null, args));
    }

    private static Object[] withArguments(Object self, ScriptFunction function, Object ... args) {
        return ScriptFunction.withArguments(self, function, args.length + (function == null ? 1 : 2), args);
    }

    private static Object[] withArguments(Object self, ScriptFunction function, int paramCount, Object ... args) {
        Object[] finalArgs = new Object[paramCount];
        finalArgs[0] = self;
        int nextArg = 1;
        if (function != null) {
            finalArgs[nextArg++] = function;
        }
        int maxArgs = Math.min(args.length, paramCount - (function == null ? 1 : 2));
        int i = 0;
        while (i < maxArgs) {
            finalArgs[nextArg++] = args[i++];
        }
        while (nextArg < paramCount) {
            finalArgs[nextArg++] = ScriptRuntime.UNDEFINED;
        }
        return finalArgs;
    }

    public Object allocate() {
        if (Context.DEBUG) {
            ++allocations;
        }
        if (this.getConstructHandle() == null) {
            ECMAErrors.typeError(Context.getGlobal(), "not.a.constructor", ScriptRuntime.safeToString(this));
        }
        ScriptObject object = null;
        if (this.allocator != null) {
            try {
                object = (ScriptObject)this.allocator.invokeExact(this.allocatorMap);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        if (object != null) {
            if (this.prototype instanceof ScriptObject) {
                object.setProto((ScriptObject)this.prototype);
            }
            if (object.getProto() == null) {
                object.setProto(this.getObjectPrototype());
            }
        }
        return object;
    }

    protected abstract ScriptObject getObjectPrototype();

    public abstract ScriptFunction makeBoundFunction(Object var1, Object[] var2);

    private static boolean isConstructor(MethodHandle methodHandle) {
        return methodHandle.type().parameterCount() >= 1 && methodHandle.type().parameterType(0) == Boolean.TYPE;
    }

    public boolean isVarArg(MethodHandle methodHandle) {
        return this.hasCalleeParameter() ? methodHandle.type().parameterCount() == 3 && ((Class)methodHandle.type().parameterType(2)).isArray() : methodHandle.type().parameterCount() == 2 && ((Class)methodHandle.type().parameterType(1)).isArray();
    }

    @Override
    public final String safeToString() {
        return this.toSource();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(" [ ").append(this.invokeHandle).append(", ").append(this.name == null || this.name.isEmpty() ? "<anonymous>" : this.name);
        if (this.source != null) {
            sb.append(" @ ").append(this.source.getName()).append(':').append(this.source.getLine(Token.descPosition(this.token)));
        }
        sb.append(" ]");
        return sb.toString();
    }

    public final String toSource() {
        if (this.source != null && this.token != 0L) {
            return this.source.getString(Token.descPosition(this.token), Token.descLength(this.token));
        }
        return "function " + (this.name == null ? "" : this.name) + "() { [native code] }";
    }

    public final Object getPrototype() {
        return this.prototype;
    }

    public final Object setPrototype(Object prototype) {
        this.prototype = prototype;
        return prototype;
    }

    private static int weigh(MethodType t) {
        int weight = Type.typeFor(t.returnType()).getWeight();
        for (Class<?> paramType : t.parameterArray()) {
            int pweight = Type.typeFor(paramType).getWeight();
            weight += pweight;
        }
        return weight;
    }

    private static boolean typeCompatible(MethodType desc, MethodType spec) {
        Class<?>[] sparray;
        Class<?>[] dparray = desc.parameterArray();
        if (dparray.length != (sparray = spec.parameterArray()).length) {
            return false;
        }
        for (int i = 0; i < dparray.length; ++i) {
            Type dp = Type.typeFor(dparray[i]);
            Type sp = Type.typeFor(sparray[i]);
            if (dp.isBoolean()) {
                return false;
            }
            if (Type.widest(dp, sp) == sp) continue;
            return false;
        }
        return true;
    }

    private MethodHandle candidateWithLowestWeight(MethodType descType, MethodHandle initialCandidate, MethodHandle[] specs) {
        if (DISABLE_SPECIALIZATION || specs == null) {
            return initialCandidate;
        }
        int minimumWeight = Integer.MAX_VALUE;
        MethodHandle candidate = initialCandidate;
        for (MethodHandle spec : specs) {
            int specWeight;
            MethodType specType = spec.type();
            if (!ScriptFunction.typeCompatible(descType, specType) || (specWeight = ScriptFunction.weigh(specType)) >= minimumWeight) continue;
            candidate = spec;
            minimumWeight = specWeight;
        }
        if (DISABLE_SPECIALIZATION && candidate != initialCandidate) {
            Context.err("### Specializing builtin " + this.getName() + " -> " + candidate + "?");
        }
        return candidate;
    }

    public final MethodHandle getBestSpecializedInvokeHandle(MethodType type) {
        return this.candidateWithLowestWeight(type, this.getInvokeHandle(), this.invokeSpecializations);
    }

    public final MethodHandle getInvokeHandle() {
        return this.invokeHandle;
    }

    public final MethodHandle getBoundInvokeHandle(ScriptObject self) {
        MethodHandle bound = Lookup.MH.bindTo(this.getInvokeHandle(), self);
        return this.hasCalleeParameter() ? Lookup.MH.bindTo(bound, this) : bound;
    }

    private boolean hasCalleeParameter() {
        return this.scope != null;
    }

    public final MethodHandle getConstructHandle(MethodType type) {
        return this.candidateWithLowestWeight(type, this.getConstructHandle(), this.constructSpecializations);
    }

    public final MethodHandle getConstructHandle() {
        return this.constructHandle;
    }

    public final void setConstructHandle(MethodHandle constructHandle) {
        this.constructHandle = constructHandle;
        this.constructSpecializations = null;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean needsCompilation() {
        return this.invokeHandle == null;
    }

    public final long getToken() {
        return this.token;
    }

    public final ScriptObject getScope() {
        return this.scope;
    }

    public static Object G$prototype(Object self) {
        return self instanceof ScriptFunction ? ((ScriptFunction)self).getPrototype() : ScriptRuntime.UNDEFINED;
    }

    public static void S$prototype(Object self, Object prototype) {
        if (self instanceof ScriptFunction) {
            ((ScriptFunction)self).setPrototype(prototype);
        }
    }

    public static int G$length(Object self) {
        if (self instanceof ScriptFunction) {
            return ((ScriptFunction)self).getArity();
        }
        return 0;
    }

    public static Object G$name(Object self) {
        if (self instanceof ScriptFunction) {
            return ((ScriptFunction)self).getName();
        }
        return ScriptRuntime.UNDEFINED;
    }

    public static ScriptObject getPrototype(Object constructor) {
        Object proto;
        if (constructor instanceof ScriptFunction && (proto = ((ScriptFunction)constructor).getPrototype()) instanceof ScriptObject) {
            return (ScriptObject)proto;
        }
        return null;
    }

    public static int getConstructorCount() {
        return constructorCount;
    }

    public static int getInvokes() {
        return invokes;
    }

    public static int getAllocations() {
        return allocations;
    }

    @Override
    protected GuardedInvocation findNewMethod(CallSiteDescriptor desc) {
        MethodHandle allocate;
        MethodType type = desc.getMethodType();
        MethodHandle constructor = this.getConstructHandle(type);
        if (constructor == null) {
            ECMAErrors.typeError(Context.getGlobal(), "not.a.constructor", ScriptRuntime.safeToString(this));
            return null;
        }
        MethodType ctorType = constructor.type();
        constructor = Lookup.MH.asType(constructor, constructor.type().changeReturnType(Object.class));
        Class<?>[] ctorArgs = ctorType.dropParameterTypes(0, 1).parameterArray();
        MethodHandle handle = Lookup.MH.foldArguments(Lookup.MH.dropArguments(NEWFILTER, 2, ctorArgs), constructor);
        if (this.hasCalleeParameter()) {
            allocate = Lookup.MH.bindTo(MethodHandles.exactInvoker(ALLOCATE.type()), ALLOCATE);
            handle = Lookup.MH.foldArguments(handle, allocate);
            handle = Lookup.MH.asType(handle, handle.type().changeParameterType(0, Object.class));
        } else {
            allocate = Lookup.MH.dropArguments(Lookup.MH.bindTo(ALLOCATE, this), 0, Object.class);
            handle = Lookup.MH.filterArguments(handle, 0, allocate);
        }
        MethodHandle filterIn = Lookup.MH.asType(ScriptFunction.pairArguments(handle, type), type);
        return new GuardedInvocation(filterIn, null, NashornGuards.getFunctionGuard(this));
    }

    private static Object newFilter(Object result, Object allocation) {
        return result instanceof ScriptObject ? result : allocation;
    }

    @Override
    protected GuardedInvocation findCallMethod(CallSiteDescriptor desc, boolean megaMorphic) {
        MethodHandle boundHandle;
        MethodType type = desc.getMethodType();
        if (megaMorphic) {
            MethodHandle collector = Lookup.MH.asCollector(ScriptRuntime.APPLY.methodHandle(), Object[].class, type.parameterCount() - 2);
            return new GuardedInvocation(collector, desc.getMethodType().parameterType(0) == ScriptFunction.class ? null : NashornGuards.getScriptFunctionGuard());
        }
        if (this.hasCalleeParameter()) {
            MethodHandle callHandle = this.getBestSpecializedInvokeHandle(type);
            if (NashornCallSiteDescriptor.isScope(desc)) {
                boundHandle = Lookup.MH.bindTo(callHandle, this.isStrict() || this.isBuiltin() ? ScriptRuntime.UNDEFINED : Context.getGlobal());
                boundHandle = Lookup.MH.dropArguments(boundHandle, 1, Object.class);
            } else {
                MethodType oldType = callHandle.type();
                int[] reorder = new int[oldType.parameterCount()];
                for (int i = 2; i < reorder.length; ++i) {
                    reorder[i] = i;
                }
                reorder[0] = 1;
                assert (reorder[1] == 0);
                MethodType newType = oldType.changeParameterType(0, (Class<?>)oldType.parameterType(1)).changeParameterType(1, (Class<?>)oldType.parameterType(0));
                boundHandle = MethodHandles.permuteArguments(callHandle, newType, reorder);
            }
        } else {
            MethodHandle callHandle = this.getBestSpecializedInvokeHandle(type.dropParameterTypes(0, 1));
            if (NashornCallSiteDescriptor.isScope(desc)) {
                boundHandle = Lookup.MH.bindTo(callHandle, this.isStrict() || this.isBuiltin() ? ScriptRuntime.UNDEFINED : Context.getGlobal());
                boundHandle = Lookup.MH.dropArguments(boundHandle, 0, Object.class, Object.class);
            } else {
                boundHandle = Lookup.MH.dropArguments(callHandle, 0, Object.class);
            }
        }
        boundHandle = ScriptFunction.pairArguments(boundHandle, type);
        return new GuardedInvocation(boundHandle, NashornGuards.getFunctionGuard(this));
    }

    MethodHandle getCallMethodHandle(MethodType type, String bindName) {
        MethodHandle methodHandle = this.getBestSpecializedInvokeHandle(type);
        if (bindName != null) {
            methodHandle = this.hasCalleeParameter() ? Lookup.MH.insertArguments(methodHandle, 1, this, bindName) : Lookup.MH.insertArguments(methodHandle, 1, bindName);
        } else if (this.hasCalleeParameter()) {
            methodHandle = Lookup.MH.insertArguments(methodHandle, 1, this);
        }
        return ScriptFunction.pairArguments(methodHandle, type);
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        Class<ScriptFunction> own = ScriptFunction.class;
        MethodType mt = Lookup.MH.type(rtype, types);
        try {
            return Lookup.MH.findStatic(MethodHandles.lookup(), own, name, mt);
        }
        catch (MethodHandleFactory.LookupException e) {
            return Lookup.MH.findVirtual(MethodHandles.lookup(), own, name, mt);
        }
    }
}

