/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import jdk.nashorn.api.scripting.NashornException;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.JSErrorType;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.Source;

public final class ParserException
extends NashornException {
    private Source source;
    private long token;
    private JSErrorType errorType;

    public ParserException(String msg) {
        this(msg, null, -1, -1, -1L);
    }

    public ParserException(String msg, Source source, int line, int column, long token) {
        super(msg);
        this.setSource(source);
        if (source != null) {
            this.setFileName(source.getName());
        }
        this.setLineNumber(line);
        this.setColumnNumber(column);
        this.setToken(token);
        this.setErrorType(JSErrorType.SYNTAX_ERROR);
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public long getToken() {
        return this.token;
    }

    public void setToken(long token) {
        this.token = token;
    }

    public int getPosition() {
        return Token.descPosition(this.token);
    }

    public JSErrorType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(JSErrorType errorType) {
        this.errorType = errorType;
    }

    public void throwAsEcmaException(ScriptObject global) {
        ECMAErrors.throwAsEcmaException(global, this);
    }
}

