/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Logging {
    private static final Logger disabledLogger = Logger.getLogger("disabled");
    private static final Map<String, Logger> loggers;

    private Logging() {
    }

    private static String lastPart(String packageName) {
        String[] parts = packageName.split("\\.");
        if (parts.length == 0) {
            return packageName;
        }
        return parts[parts.length - 1];
    }

    public static Logger getLogger(String name) {
        Logger logger = loggers.get(name);
        if (logger != null) {
            return logger;
        }
        return disabledLogger;
    }

    public static Logger getOrCreateLogger(String name, Level level) {
        Logger logger = loggers.get(name);
        if (logger == null) {
            return Logging.instantiateLogger(name, level);
        }
        logger.setLevel(level);
        return logger;
    }

    public static void initialize(Map<String, String> map) throws IllegalArgumentException {
        try {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                Level level = "".equals(value) ? Level.INFO : Level.parse(value.toUpperCase());
                String name = Logging.lastPart(key);
                Logger logger = Logging.instantiateLogger(name, level);
                loggers.put(name, logger);
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (SecurityException e) {
            throw e;
        }
    }

    private static Logger instantiateLogger(String name, Level level) {
        Logger logger = Logger.getLogger(name);
        for (Handler h : logger.getHandlers()) {
            logger.removeHandler(h);
        }
        logger.setLevel(level);
        logger.setUseParentHandlers(false);
        ConsoleHandler c = new ConsoleHandler();
        c.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                StringBuilder sb = new StringBuilder();
                sb.append('[').append(record.getLoggerName()).append("] ").append(record.getMessage()).append('\n');
                return sb.toString();
            }
        });
        logger.addHandler(c);
        c.setLevel(level);
        return logger;
    }

    static {
        try {
            disabledLogger.setLevel(Level.OFF);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        loggers = new HashMap<String, Logger>();
    }
}

