/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jdk.nashorn.internal.runtime.ECMAException;
import jdk.nashorn.internal.runtime.GlobalObject;
import jdk.nashorn.internal.runtime.JSErrorType;
import jdk.nashorn.internal.runtime.ParserException;
import jdk.nashorn.internal.runtime.ScriptObject;

public final class ECMAErrors {
    private static final String MESSAGES_RESOURCE = "jdk.nashorn.internal.runtime.resources.Messages";
    private static final ResourceBundle MESSAGES_BUNDLE = AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

        @Override
        public ResourceBundle run() {
            return ResourceBundle.getBundle(ECMAErrors.MESSAGES_RESOURCE, Locale.getDefault());
        }
    });

    private ECMAErrors() {
    }

    private static void throwError(Object thrown, Throwable cause) {
        throw new ECMAException(thrown, cause);
    }

    public static void throwAsEcmaException(ScriptObject global, ParserException e) {
        JSErrorType errorType = e.getErrorType();
        if (errorType == null) {
            throw e;
        }
        GlobalObject globalObj = (GlobalObject)((Object)global);
        String msg = e.getMessage();
        switch (errorType) {
            case ERROR: {
                ECMAErrors.throwError(globalObj.newError(msg), e);
                break;
            }
            case EVAL_ERROR: {
                ECMAErrors.throwError(globalObj.newEvalError(msg), e);
                break;
            }
            case RANGE_ERROR: {
                ECMAErrors.throwError(globalObj.newRangeError(msg), e);
                break;
            }
            case REFERENCE_ERROR: {
                ECMAErrors.throwError(globalObj.newReferenceError(msg), e);
                break;
            }
            case SYNTAX_ERROR: {
                ECMAErrors.throwError(globalObj.newSyntaxError(msg), e);
                break;
            }
            case TYPE_ERROR: {
                ECMAErrors.throwError(globalObj.newTypeError(msg), e);
                break;
            }
            case URI_ERROR: {
                ECMAErrors.throwError(globalObj.newURIError(msg), e);
                break;
            }
        }
        throw e;
    }

    public static void syntaxError(ScriptObject global, String msgId, String ... args) {
        ECMAErrors.syntaxError(global, null, msgId, args);
    }

    public static void syntaxError(ScriptObject global, Throwable cause, String msgId, String ... args) {
        String msg = ECMAErrors.getMessage("syntax.error." + msgId, args);
        ECMAErrors.throwError(((GlobalObject)((Object)global)).newSyntaxError(msg), cause);
    }

    public static void typeError(ScriptObject global, String msgId, String ... args) {
        ECMAErrors.typeError(global, null, msgId, args);
    }

    public static void typeError(ScriptObject global, Throwable cause, String msgId, String ... args) {
        String msg = ECMAErrors.getMessage("type.error." + msgId, args);
        ECMAErrors.throwError(((GlobalObject)((Object)global)).newTypeError(msg), cause);
    }

    public static void rangeError(ScriptObject global, String msgId, String ... args) {
        ECMAErrors.rangeError(global, null, msgId, args);
    }

    public static void rangeError(ScriptObject global, Throwable cause, String msgId, String ... args) {
        String msg = ECMAErrors.getMessage("range.error." + msgId, args);
        ECMAErrors.throwError(((GlobalObject)((Object)global)).newRangeError(msg), cause);
    }

    public static void referenceError(ScriptObject global, String msgId, String ... args) {
        ECMAErrors.referenceError(global, null, msgId, args);
    }

    public static void referenceError(ScriptObject global, Throwable cause, String msgId, String ... args) {
        String msg = ECMAErrors.getMessage("reference.error." + msgId, args);
        ECMAErrors.throwError(((GlobalObject)((Object)global)).newReferenceError(msg), cause);
    }

    public static void uriError(ScriptObject global, String msgId, String ... args) {
        ECMAErrors.uriError(global, null, msgId, args);
    }

    public static void uriError(ScriptObject global, Throwable cause, String msgId, String ... args) {
        String msg = ECMAErrors.getMessage("uri.error." + msgId, args);
        ECMAErrors.throwError(((GlobalObject)((Object)global)).newURIError(msg), cause);
    }

    public static String getMessage(String msgId, String ... args) {
        try {
            return new MessageFormat(MESSAGES_BUNDLE.getString(msgId)).format(args);
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("no message resource found for message id: " + msgId);
        }
    }
}

